<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_expenses_d_view = new t_expenses_d_view();

// Run the page
$t_expenses_d_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_expenses_d_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_expenses_d->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_expenses_dview = currentForm = new ew.Form("ft_expenses_dview", "view");

// Form_CustomValidate event
ft_expenses_dview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_expenses_dview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_expenses_dview.lists["x_trip"] = <?php echo $t_expenses_d_view->trip->Lookup->toClientList() ?>;
ft_expenses_dview.lists["x_trip"].options = <?php echo JsonEncode($t_expenses_d_view->trip->lookupOptions()) ?>;
ft_expenses_dview.lists["x_expense_type"] = <?php echo $t_expenses_d_view->expense_type->Lookup->toClientList() ?>;
ft_expenses_dview.lists["x_expense_type"].options = <?php echo JsonEncode($t_expenses_d_view->expense_type->lookupOptions()) ?>;
ft_expenses_dview.lists["x_expense_sub_type"] = <?php echo $t_expenses_d_view->expense_sub_type->Lookup->toClientList() ?>;
ft_expenses_dview.lists["x_expense_sub_type"].options = <?php echo JsonEncode($t_expenses_d_view->expense_sub_type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_expenses_d->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_expenses_d_view->ExportOptions->render("body") ?>
<?php $t_expenses_d_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_expenses_d_view->showPageHeader(); ?>
<?php
$t_expenses_d_view->showMessage();
?>
<form name="ft_expenses_dview" id="ft_expenses_dview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_expenses_d_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_expenses_d_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_expenses_d">
<input type="hidden" name="modal" value="<?php echo (int)$t_expenses_d_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_expenses_d->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_expenses_d_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_d_id"><?php echo $t_expenses_d->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_expenses_d->id->cellAttributes() ?>>
<span id="el_t_expenses_d_id">
<span<?php echo $t_expenses_d->id->viewAttributes() ?>>
<?php echo $t_expenses_d->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses_d->trip->Visible) { // trip ?>
	<tr id="r_trip">
		<td class="<?php echo $t_expenses_d_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_d_trip"><?php echo $t_expenses_d->trip->caption() ?></span></td>
		<td data-name="trip"<?php echo $t_expenses_d->trip->cellAttributes() ?>>
<span id="el_t_expenses_d_trip">
<span<?php echo $t_expenses_d->trip->viewAttributes() ?>>
<?php echo $t_expenses_d->trip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses_d->r_from->Visible) { // r_from ?>
	<tr id="r_r_from">
		<td class="<?php echo $t_expenses_d_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_d_r_from"><?php echo $t_expenses_d->r_from->caption() ?></span></td>
		<td data-name="r_from"<?php echo $t_expenses_d->r_from->cellAttributes() ?>>
<span id="el_t_expenses_d_r_from">
<span<?php echo $t_expenses_d->r_from->viewAttributes() ?>>
<?php echo $t_expenses_d->r_from->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses_d->expense_type->Visible) { // expense_type ?>
	<tr id="r_expense_type">
		<td class="<?php echo $t_expenses_d_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_d_expense_type"><?php echo $t_expenses_d->expense_type->caption() ?></span></td>
		<td data-name="expense_type"<?php echo $t_expenses_d->expense_type->cellAttributes() ?>>
<span id="el_t_expenses_d_expense_type">
<span<?php echo $t_expenses_d->expense_type->viewAttributes() ?>>
<?php echo $t_expenses_d->expense_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses_d->expense_sub_type->Visible) { // expense_sub_type ?>
	<tr id="r_expense_sub_type">
		<td class="<?php echo $t_expenses_d_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_d_expense_sub_type"><?php echo $t_expenses_d->expense_sub_type->caption() ?></span></td>
		<td data-name="expense_sub_type"<?php echo $t_expenses_d->expense_sub_type->cellAttributes() ?>>
<span id="el_t_expenses_d_expense_sub_type">
<span>
<?php echo GetImageViewTag($t_expenses_d->expense_sub_type, $t_expenses_d->expense_sub_type->getViewValue()) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses_d->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $t_expenses_d_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_d_amount"><?php echo $t_expenses_d->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $t_expenses_d->amount->cellAttributes() ?>>
<span id="el_t_expenses_d_amount">
<span<?php echo $t_expenses_d->amount->viewAttributes() ?>>
<?php echo $t_expenses_d->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses_d->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $t_expenses_d_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_d_remarks"><?php echo $t_expenses_d->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $t_expenses_d->remarks->cellAttributes() ?>>
<span id="el_t_expenses_d_remarks">
<span<?php echo $t_expenses_d->remarks->viewAttributes() ?>>
<?php echo $t_expenses_d->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses_d->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $t_expenses_d_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_d_uploads"><?php echo $t_expenses_d->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $t_expenses_d->uploads->cellAttributes() ?>>
<span id="el_t_expenses_d_uploads">
<span<?php echo $t_expenses_d->uploads->viewAttributes() ?>>
<?php echo GetFileViewTag($t_expenses_d->uploads, $t_expenses_d->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses_d->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_expenses_d_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_d_operator"><?php echo $t_expenses_d->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_expenses_d->operator->cellAttributes() ?>>
<span id="el_t_expenses_d_operator">
<span<?php echo $t_expenses_d->operator->viewAttributes() ?>>
<?php echo $t_expenses_d->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses_d->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_expenses_d_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_d_datetime"><?php echo $t_expenses_d->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_expenses_d->datetime->cellAttributes() ?>>
<span id="el_t_expenses_d_datetime">
<span<?php echo $t_expenses_d->datetime->viewAttributes() ?>>
<?php echo $t_expenses_d->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_expenses_d_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_expenses_d->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_expenses_d_view->terminate();
?>