<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_expenses_o_edit = new t_expenses_o_edit();

// Run the page
$t_expenses_o_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_expenses_o_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var ft_expenses_oedit = currentForm = new ew.Form("ft_expenses_oedit", "edit");

// Validate form
ft_expenses_oedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_expenses_o_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_o->id->caption(), $t_expenses_o->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_o_edit->trip->Required) { ?>
			elm = this.getElements("x" + infix + "_trip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_o->trip->caption(), $t_expenses_o->trip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_o_edit->r_from->Required) { ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_o->r_from->caption(), $t_expenses_o->r_from->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses_o->r_from->errorMessage()) ?>");
		<?php if ($t_expenses_o_edit->expense_type->Required) { ?>
			elm = this.getElements("x" + infix + "_expense_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_o->expense_type->caption(), $t_expenses_o->expense_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_o_edit->expense_sub_type->Required) { ?>
			elm = this.getElements("x" + infix + "_expense_sub_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_o->expense_sub_type->caption(), $t_expenses_o->expense_sub_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_o_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_o->dated->caption(), $t_expenses_o->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses_o->dated->errorMessage()) ?>");
		<?php if ($t_expenses_o_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_o->amount->caption(), $t_expenses_o->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses_o->amount->errorMessage()) ?>");
		<?php if ($t_expenses_o_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_o->remarks->caption(), $t_expenses_o->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_o_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $t_expenses_o->uploads->caption(), $t_expenses_o->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_o_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_o->operator->caption(), $t_expenses_o->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_o_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_o->datetime->caption(), $t_expenses_o->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_expenses_oedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_expenses_oedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_expenses_oedit.lists["x_trip"] = <?php echo $t_expenses_o_edit->trip->Lookup->toClientList() ?>;
ft_expenses_oedit.lists["x_trip"].options = <?php echo JsonEncode($t_expenses_o_edit->trip->lookupOptions()) ?>;
ft_expenses_oedit.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_expenses_oedit.lists["x_r_from"] = <?php echo $t_expenses_o_edit->r_from->Lookup->toClientList() ?>;
ft_expenses_oedit.lists["x_r_from"].options = <?php echo JsonEncode($t_expenses_o_edit->r_from->lookupOptions()) ?>;
ft_expenses_oedit.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_expenses_oedit.lists["x_expense_type"] = <?php echo $t_expenses_o_edit->expense_type->Lookup->toClientList() ?>;
ft_expenses_oedit.lists["x_expense_type"].options = <?php echo JsonEncode($t_expenses_o_edit->expense_type->lookupOptions()) ?>;
ft_expenses_oedit.lists["x_expense_sub_type"] = <?php echo $t_expenses_o_edit->expense_sub_type->Lookup->toClientList() ?>;
ft_expenses_oedit.lists["x_expense_sub_type"].options = <?php echo JsonEncode($t_expenses_o_edit->expense_sub_type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_expenses_o_edit->showPageHeader(); ?>
<?php
$t_expenses_o_edit->showMessage();
?>
<form name="ft_expenses_oedit" id="ft_expenses_oedit" class="<?php echo $t_expenses_o_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_expenses_o_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_expenses_o_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_expenses_o">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$t_expenses_o_edit->IsModal ?>">
<?php if ($t_expenses_o->getCurrentMasterTable() == "t_trip_info") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="t_trip_info">
<input type="hidden" name="fk_id" value="<?php echo $t_expenses_o->trip->getSessionValue() ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_expenses_o->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_t_expenses_o_id" class="<?php echo $t_expenses_o_edit->LeftColumnClass ?>"><?php echo $t_expenses_o->id->caption() ?><?php echo ($t_expenses_o->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_o_edit->RightColumnClass ?>"><div<?php echo $t_expenses_o->id->cellAttributes() ?>>
<span id="el_t_expenses_o_id">
<span<?php echo $t_expenses_o->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses_o->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses_o" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($t_expenses_o->id->CurrentValue) ?>">
<?php echo $t_expenses_o->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_o->trip->Visible) { // trip ?>
	<div id="r_trip" class="form-group row">
		<label id="elh_t_expenses_o_trip" class="<?php echo $t_expenses_o_edit->LeftColumnClass ?>"><?php echo $t_expenses_o->trip->caption() ?><?php echo ($t_expenses_o->trip->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_o_edit->RightColumnClass ?>"><div<?php echo $t_expenses_o->trip->cellAttributes() ?>>
<span id="el_t_expenses_o_trip">
<span<?php echo $t_expenses_o->trip->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses_o->trip->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses_o" data-field="x_trip" name="x_trip" id="x_trip" value="<?php echo HtmlEncode($t_expenses_o->trip->CurrentValue) ?>">
<?php echo $t_expenses_o->trip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_o->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label id="elh_t_expenses_o_r_from" class="<?php echo $t_expenses_o_edit->LeftColumnClass ?>"><?php echo $t_expenses_o->r_from->caption() ?><?php echo ($t_expenses_o->r_from->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_o_edit->RightColumnClass ?>"><div<?php echo $t_expenses_o->r_from->cellAttributes() ?>>
<span id="el_t_expenses_o_r_from">
<?php
$wrkonchange = "" . trim(@$t_expenses_o->r_from->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_expenses_o->r_from->EditAttrs["onchange"] = "";
?>
<span id="as_x_r_from" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_r_from" id="sv_x_r_from" value="<?php echo RemoveHtml($t_expenses_o->r_from->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_expenses_o->r_from->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_expenses_o->r_from->getPlaceHolder()) ?>"<?php echo $t_expenses_o->r_from->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_expenses_o->r_from->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_r_from',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_expenses_o->r_from->ReadOnly || $t_expenses_o->r_from->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_expenses_o" data-field="x_r_from" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_expenses_o->r_from->displayValueSeparatorAttribute() ?>" name="x_r_from" id="x_r_from" value="<?php echo HtmlEncode($t_expenses_o->r_from->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_expenses_oedit.createAutoSuggest({"id":"x_r_from","forceSelect":true});
</script>
<?php echo $t_expenses_o->r_from->Lookup->getParamTag("p_x_r_from") ?>
</span>
<?php echo $t_expenses_o->r_from->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_o->expense_type->Visible) { // expense_type ?>
	<div id="r_expense_type" class="form-group row">
		<label id="elh_t_expenses_o_expense_type" for="x_expense_type" class="<?php echo $t_expenses_o_edit->LeftColumnClass ?>"><?php echo $t_expenses_o->expense_type->caption() ?><?php echo ($t_expenses_o->expense_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_o_edit->RightColumnClass ?>"><div<?php echo $t_expenses_o->expense_type->cellAttributes() ?>>
<span id="el_t_expenses_o_expense_type">
<?php $t_expenses_o->expense_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$t_expenses_o->expense_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_expenses_o" data-field="x_expense_type" data-value-separator="<?php echo $t_expenses_o->expense_type->displayValueSeparatorAttribute() ?>" id="x_expense_type" name="x_expense_type"<?php echo $t_expenses_o->expense_type->editAttributes() ?>>
		<?php echo $t_expenses_o->expense_type->selectOptionListHtml("x_expense_type") ?>
	</select>
</div>
<?php echo $t_expenses_o->expense_type->Lookup->getParamTag("p_x_expense_type") ?>
</span>
<?php echo $t_expenses_o->expense_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_o->expense_sub_type->Visible) { // expense_sub_type ?>
	<div id="r_expense_sub_type" class="form-group row">
		<label id="elh_t_expenses_o_expense_sub_type" for="x_expense_sub_type" class="<?php echo $t_expenses_o_edit->LeftColumnClass ?>"><?php echo $t_expenses_o->expense_sub_type->caption() ?><?php echo ($t_expenses_o->expense_sub_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_o_edit->RightColumnClass ?>"><div<?php echo $t_expenses_o->expense_sub_type->cellAttributes() ?>>
<span id="el_t_expenses_o_expense_sub_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_expenses_o" data-field="x_expense_sub_type" data-value-separator="<?php echo $t_expenses_o->expense_sub_type->displayValueSeparatorAttribute() ?>" id="x_expense_sub_type" name="x_expense_sub_type"<?php echo $t_expenses_o->expense_sub_type->editAttributes() ?>>
		<?php echo $t_expenses_o->expense_sub_type->selectOptionListHtml("x_expense_sub_type") ?>
	</select>
</div>
<?php echo $t_expenses_o->expense_sub_type->Lookup->getParamTag("p_x_expense_sub_type") ?>
</span>
<?php echo $t_expenses_o->expense_sub_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_o->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_t_expenses_o_dated" for="x_dated" class="<?php echo $t_expenses_o_edit->LeftColumnClass ?>"><?php echo $t_expenses_o->dated->caption() ?><?php echo ($t_expenses_o->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_o_edit->RightColumnClass ?>"><div<?php echo $t_expenses_o->dated->cellAttributes() ?>>
<span id="el_t_expenses_o_dated">
<input type="text" data-table="t_expenses_o" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_expenses_o->dated->getPlaceHolder()) ?>" value="<?php echo $t_expenses_o->dated->EditValue ?>"<?php echo $t_expenses_o->dated->editAttributes() ?>>
<?php if (!$t_expenses_o->dated->ReadOnly && !$t_expenses_o->dated->Disabled && !isset($t_expenses_o->dated->EditAttrs["readonly"]) && !isset($t_expenses_o->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_expenses_oedit", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $t_expenses_o->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_o->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_t_expenses_o_amount" for="x_amount" class="<?php echo $t_expenses_o_edit->LeftColumnClass ?>"><?php echo $t_expenses_o->amount->caption() ?><?php echo ($t_expenses_o->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_o_edit->RightColumnClass ?>"><div<?php echo $t_expenses_o->amount->cellAttributes() ?>>
<span id="el_t_expenses_o_amount">
<input type="text" data-table="t_expenses_o" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($t_expenses_o->amount->getPlaceHolder()) ?>" value="<?php echo $t_expenses_o->amount->EditValue ?>"<?php echo $t_expenses_o->amount->editAttributes() ?>>
</span>
<?php echo $t_expenses_o->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_o->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_t_expenses_o_remarks" for="x_remarks" class="<?php echo $t_expenses_o_edit->LeftColumnClass ?>"><?php echo $t_expenses_o->remarks->caption() ?><?php echo ($t_expenses_o->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_o_edit->RightColumnClass ?>"><div<?php echo $t_expenses_o->remarks->cellAttributes() ?>>
<span id="el_t_expenses_o_remarks">
<input type="text" data-table="t_expenses_o" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_expenses_o->remarks->getPlaceHolder()) ?>" value="<?php echo $t_expenses_o->remarks->EditValue ?>"<?php echo $t_expenses_o->remarks->editAttributes() ?>>
</span>
<?php echo $t_expenses_o->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_o->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_t_expenses_o_uploads" class="<?php echo $t_expenses_o_edit->LeftColumnClass ?>"><?php echo $t_expenses_o->uploads->caption() ?><?php echo ($t_expenses_o->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_o_edit->RightColumnClass ?>"><div<?php echo $t_expenses_o->uploads->cellAttributes() ?>>
<span id="el_t_expenses_o_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $t_expenses_o->uploads->title() ? $t_expenses_o->uploads->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($t_expenses_o->uploads->ReadOnly || $t_expenses_o->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="t_expenses_o" data-field="x_uploads" name="x_uploads" id="x_uploads"<?php echo $t_expenses_o->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $t_expenses_o->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="255">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $t_expenses_o->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $t_expenses_o->uploads->UploadMaxFileSize ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $t_expenses_o->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_expenses_o_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_expenses_o_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_expenses_o_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_expenses_o_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_expenses_o_edit->terminate();
?>