<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_expenses_o_list = new t_expenses_o_list();

// Run the page
$t_expenses_o_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_expenses_o_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_expenses_o->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_expenses_olist = currentForm = new ew.Form("ft_expenses_olist", "list");
ft_expenses_olist.formKeyCountName = '<?php echo $t_expenses_o_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_expenses_olist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_expenses_olist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_expenses_olist.lists["x_trip"] = <?php echo $t_expenses_o_list->trip->Lookup->toClientList() ?>;
ft_expenses_olist.lists["x_trip"].options = <?php echo JsonEncode($t_expenses_o_list->trip->lookupOptions()) ?>;
ft_expenses_olist.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_expenses_olist.lists["x_r_from"] = <?php echo $t_expenses_o_list->r_from->Lookup->toClientList() ?>;
ft_expenses_olist.lists["x_r_from"].options = <?php echo JsonEncode($t_expenses_o_list->r_from->lookupOptions()) ?>;
ft_expenses_olist.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_expenses_olist.lists["x_expense_type"] = <?php echo $t_expenses_o_list->expense_type->Lookup->toClientList() ?>;
ft_expenses_olist.lists["x_expense_type"].options = <?php echo JsonEncode($t_expenses_o_list->expense_type->lookupOptions()) ?>;
ft_expenses_olist.lists["x_expense_sub_type"] = <?php echo $t_expenses_o_list->expense_sub_type->Lookup->toClientList() ?>;
ft_expenses_olist.lists["x_expense_sub_type"].options = <?php echo JsonEncode($t_expenses_o_list->expense_sub_type->lookupOptions()) ?>;

// Form object for search
var ft_expenses_olistsrch = currentSearchForm = new ew.Form("ft_expenses_olistsrch");

// Filters
ft_expenses_olistsrch.filterList = <?php echo $t_expenses_o_list->getFilterList() ?>;

// Init search panel as collapsed
ft_expenses_olistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_expenses_o->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_expenses_o_list->TotalRecs > 0 && $t_expenses_o_list->ExportOptions->visible()) { ?>
<?php $t_expenses_o_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_expenses_o_list->ImportOptions->visible()) { ?>
<?php $t_expenses_o_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_expenses_o_list->SearchOptions->visible()) { ?>
<?php $t_expenses_o_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_expenses_o_list->FilterOptions->visible()) { ?>
<?php $t_expenses_o_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$t_expenses_o->isExport() || EXPORT_MASTER_RECORD && $t_expenses_o->isExport("print")) { ?>
<?php
if ($t_expenses_o_list->DbMasterFilter <> "" && $t_expenses_o->getCurrentMasterTable() == "t_trip_info") {
	if ($t_expenses_o_list->MasterRecordExists) {
		include_once "t_trip_infomaster.php";
	}
}
?>
<?php } ?>
<?php
$t_expenses_o_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_expenses_o->isExport() && !$t_expenses_o->CurrentAction) { ?>
<form name="ft_expenses_olistsrch" id="ft_expenses_olistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_expenses_o_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_expenses_olistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_expenses_o">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_expenses_o_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_expenses_o_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_expenses_o_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_expenses_o_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_expenses_o_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_expenses_o_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_expenses_o_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_expenses_o_list->showPageHeader(); ?>
<?php
$t_expenses_o_list->showMessage();
?>
<?php if ($t_expenses_o_list->TotalRecs > 0 || $t_expenses_o->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_expenses_o_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_expenses_o">
<?php if (!$t_expenses_o->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_expenses_o->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_expenses_o_list->Pager)) $t_expenses_o_list->Pager = new PrevNextPager($t_expenses_o_list->StartRec, $t_expenses_o_list->DisplayRecs, $t_expenses_o_list->TotalRecs, $t_expenses_o_list->AutoHidePager) ?>
<?php if ($t_expenses_o_list->Pager->RecordCount > 0 && $t_expenses_o_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_expenses_o_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_expenses_o_list->pageUrl() ?>start=<?php echo $t_expenses_o_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_expenses_o_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_expenses_o_list->pageUrl() ?>start=<?php echo $t_expenses_o_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_expenses_o_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_expenses_o_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_expenses_o_list->pageUrl() ?>start=<?php echo $t_expenses_o_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_expenses_o_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_expenses_o_list->pageUrl() ?>start=<?php echo $t_expenses_o_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_expenses_o_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_expenses_o_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_expenses_o_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_expenses_o_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_expenses_o_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_expenses_o_list->TotalRecs > 0 && (!$t_expenses_o_list->AutoHidePageSizeSelector || $t_expenses_o_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_expenses_o">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_expenses_o_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_expenses_o_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_expenses_o_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_expenses_o_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_expenses_o_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_expenses_o->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_expenses_o_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_expenses_olist" id="ft_expenses_olist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_expenses_o_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_expenses_o_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_expenses_o">
<?php if ($t_expenses_o->getCurrentMasterTable() == "t_trip_info" && $t_expenses_o->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="t_trip_info">
<input type="hidden" name="fk_id" value="<?php echo $t_expenses_o->trip->getSessionValue() ?>">
<?php } ?>
<div id="gmp_t_expenses_o" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_expenses_o_list->TotalRecs > 0 || $t_expenses_o->isGridEdit()) { ?>
<table id="tbl_t_expenses_olist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_expenses_o_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_expenses_o_list->renderListOptions();

// Render list options (header, left)
$t_expenses_o_list->ListOptions->render("header", "left");
?>
<?php if ($t_expenses_o->id->Visible) { // id ?>
	<?php if ($t_expenses_o->sortUrl($t_expenses_o->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_expenses_o->id->headerCellClass() ?>"><div id="elh_t_expenses_o_id" class="t_expenses_o_id"><div class="ew-table-header-caption"><?php echo $t_expenses_o->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_expenses_o->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_expenses_o->SortUrl($t_expenses_o->id) ?>',2);"><div id="elh_t_expenses_o_id" class="t_expenses_o_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->trip->Visible) { // trip ?>
	<?php if ($t_expenses_o->sortUrl($t_expenses_o->trip) == "") { ?>
		<th data-name="trip" class="<?php echo $t_expenses_o->trip->headerCellClass() ?>"><div id="elh_t_expenses_o_trip" class="t_expenses_o_trip"><div class="ew-table-header-caption"><?php echo $t_expenses_o->trip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="trip" class="<?php echo $t_expenses_o->trip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_expenses_o->SortUrl($t_expenses_o->trip) ?>',2);"><div id="elh_t_expenses_o_trip" class="t_expenses_o_trip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->trip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o->trip->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o->trip->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->r_from->Visible) { // r_from ?>
	<?php if ($t_expenses_o->sortUrl($t_expenses_o->r_from) == "") { ?>
		<th data-name="r_from" class="<?php echo $t_expenses_o->r_from->headerCellClass() ?>"><div id="elh_t_expenses_o_r_from" class="t_expenses_o_r_from"><div class="ew-table-header-caption"><?php echo $t_expenses_o->r_from->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_from" class="<?php echo $t_expenses_o->r_from->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_expenses_o->SortUrl($t_expenses_o->r_from) ?>',2);"><div id="elh_t_expenses_o_r_from" class="t_expenses_o_r_from">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->r_from->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o->r_from->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o->r_from->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->expense_type->Visible) { // expense_type ?>
	<?php if ($t_expenses_o->sortUrl($t_expenses_o->expense_type) == "") { ?>
		<th data-name="expense_type" class="<?php echo $t_expenses_o->expense_type->headerCellClass() ?>"><div id="elh_t_expenses_o_expense_type" class="t_expenses_o_expense_type"><div class="ew-table-header-caption"><?php echo $t_expenses_o->expense_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="expense_type" class="<?php echo $t_expenses_o->expense_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_expenses_o->SortUrl($t_expenses_o->expense_type) ?>',2);"><div id="elh_t_expenses_o_expense_type" class="t_expenses_o_expense_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->expense_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o->expense_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o->expense_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->expense_sub_type->Visible) { // expense_sub_type ?>
	<?php if ($t_expenses_o->sortUrl($t_expenses_o->expense_sub_type) == "") { ?>
		<th data-name="expense_sub_type" class="<?php echo $t_expenses_o->expense_sub_type->headerCellClass() ?>"><div id="elh_t_expenses_o_expense_sub_type" class="t_expenses_o_expense_sub_type"><div class="ew-table-header-caption"><?php echo $t_expenses_o->expense_sub_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="expense_sub_type" class="<?php echo $t_expenses_o->expense_sub_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_expenses_o->SortUrl($t_expenses_o->expense_sub_type) ?>',2);"><div id="elh_t_expenses_o_expense_sub_type" class="t_expenses_o_expense_sub_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->expense_sub_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o->expense_sub_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o->expense_sub_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->dated->Visible) { // dated ?>
	<?php if ($t_expenses_o->sortUrl($t_expenses_o->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $t_expenses_o->dated->headerCellClass() ?>"><div id="elh_t_expenses_o_dated" class="t_expenses_o_dated"><div class="ew-table-header-caption"><?php echo $t_expenses_o->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $t_expenses_o->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_expenses_o->SortUrl($t_expenses_o->dated) ?>',2);"><div id="elh_t_expenses_o_dated" class="t_expenses_o_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->amount->Visible) { // amount ?>
	<?php if ($t_expenses_o->sortUrl($t_expenses_o->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $t_expenses_o->amount->headerCellClass() ?>"><div id="elh_t_expenses_o_amount" class="t_expenses_o_amount"><div class="ew-table-header-caption"><?php echo $t_expenses_o->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $t_expenses_o->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_expenses_o->SortUrl($t_expenses_o->amount) ?>',2);"><div id="elh_t_expenses_o_amount" class="t_expenses_o_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->remarks->Visible) { // remarks ?>
	<?php if ($t_expenses_o->sortUrl($t_expenses_o->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $t_expenses_o->remarks->headerCellClass() ?>"><div id="elh_t_expenses_o_remarks" class="t_expenses_o_remarks"><div class="ew-table-header-caption"><?php echo $t_expenses_o->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $t_expenses_o->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_expenses_o->SortUrl($t_expenses_o->remarks) ?>',2);"><div id="elh_t_expenses_o_remarks" class="t_expenses_o_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->uploads->Visible) { // uploads ?>
	<?php if ($t_expenses_o->sortUrl($t_expenses_o->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $t_expenses_o->uploads->headerCellClass() ?>"><div id="elh_t_expenses_o_uploads" class="t_expenses_o_uploads"><div class="ew-table-header-caption"><?php echo $t_expenses_o->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $t_expenses_o->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_expenses_o->SortUrl($t_expenses_o->uploads) ?>',2);"><div id="elh_t_expenses_o_uploads" class="t_expenses_o_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->operator->Visible) { // operator ?>
	<?php if ($t_expenses_o->sortUrl($t_expenses_o->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $t_expenses_o->operator->headerCellClass() ?>"><div id="elh_t_expenses_o_operator" class="t_expenses_o_operator"><div class="ew-table-header-caption"><?php echo $t_expenses_o->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $t_expenses_o->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_expenses_o->SortUrl($t_expenses_o->operator) ?>',2);"><div id="elh_t_expenses_o_operator" class="t_expenses_o_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->operator->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->datetime->Visible) { // datetime ?>
	<?php if ($t_expenses_o->sortUrl($t_expenses_o->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $t_expenses_o->datetime->headerCellClass() ?>"><div id="elh_t_expenses_o_datetime" class="t_expenses_o_datetime"><div class="ew-table-header-caption"><?php echo $t_expenses_o->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $t_expenses_o->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_expenses_o->SortUrl($t_expenses_o->datetime) ?>',2);"><div id="elh_t_expenses_o_datetime" class="t_expenses_o_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_expenses_o_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_expenses_o->ExportAll && $t_expenses_o->isExport()) {
	$t_expenses_o_list->StopRec = $t_expenses_o_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_expenses_o_list->TotalRecs > $t_expenses_o_list->StartRec + $t_expenses_o_list->DisplayRecs - 1)
		$t_expenses_o_list->StopRec = $t_expenses_o_list->StartRec + $t_expenses_o_list->DisplayRecs - 1;
	else
		$t_expenses_o_list->StopRec = $t_expenses_o_list->TotalRecs;
}
$t_expenses_o_list->RecCnt = $t_expenses_o_list->StartRec - 1;
if ($t_expenses_o_list->Recordset && !$t_expenses_o_list->Recordset->EOF) {
	$t_expenses_o_list->Recordset->moveFirst();
	$selectLimit = $t_expenses_o_list->UseSelectLimit;
	if (!$selectLimit && $t_expenses_o_list->StartRec > 1)
		$t_expenses_o_list->Recordset->move($t_expenses_o_list->StartRec - 1);
} elseif (!$t_expenses_o->AllowAddDeleteRow && $t_expenses_o_list->StopRec == 0) {
	$t_expenses_o_list->StopRec = $t_expenses_o->GridAddRowCount;
}

// Initialize aggregate
$t_expenses_o->RowType = ROWTYPE_AGGREGATEINIT;
$t_expenses_o->resetAttributes();
$t_expenses_o_list->renderRow();
while ($t_expenses_o_list->RecCnt < $t_expenses_o_list->StopRec) {
	$t_expenses_o_list->RecCnt++;
	if ($t_expenses_o_list->RecCnt >= $t_expenses_o_list->StartRec) {
		$t_expenses_o_list->RowCnt++;

		// Set up key count
		$t_expenses_o_list->KeyCount = $t_expenses_o_list->RowIndex;

		// Init row class and style
		$t_expenses_o->resetAttributes();
		$t_expenses_o->CssClass = "";
		if ($t_expenses_o->isGridAdd()) {
		} else {
			$t_expenses_o_list->loadRowValues($t_expenses_o_list->Recordset); // Load row values
		}
		$t_expenses_o->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_expenses_o->RowAttrs = array_merge($t_expenses_o->RowAttrs, array('data-rowindex'=>$t_expenses_o_list->RowCnt, 'id'=>'r' . $t_expenses_o_list->RowCnt . '_t_expenses_o', 'data-rowtype'=>$t_expenses_o->RowType));

		// Render row
		$t_expenses_o_list->renderRow();

		// Render list options
		$t_expenses_o_list->renderListOptions();
?>
	<tr<?php echo $t_expenses_o->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_expenses_o_list->ListOptions->render("body", "left", $t_expenses_o_list->RowCnt);
?>
	<?php if ($t_expenses_o->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_expenses_o->id->cellAttributes() ?>>
<span id="el<?php echo $t_expenses_o_list->RowCnt ?>_t_expenses_o_id" class="t_expenses_o_id">
<span<?php echo $t_expenses_o->id->viewAttributes() ?>>
<?php echo $t_expenses_o->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_expenses_o->trip->Visible) { // trip ?>
		<td data-name="trip"<?php echo $t_expenses_o->trip->cellAttributes() ?>>
<span id="el<?php echo $t_expenses_o_list->RowCnt ?>_t_expenses_o_trip" class="t_expenses_o_trip">
<span<?php echo $t_expenses_o->trip->viewAttributes() ?>>
<?php echo $t_expenses_o->trip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_expenses_o->r_from->Visible) { // r_from ?>
		<td data-name="r_from"<?php echo $t_expenses_o->r_from->cellAttributes() ?>>
<span id="el<?php echo $t_expenses_o_list->RowCnt ?>_t_expenses_o_r_from" class="t_expenses_o_r_from">
<span<?php echo $t_expenses_o->r_from->viewAttributes() ?>>
<?php echo $t_expenses_o->r_from->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_expenses_o->expense_type->Visible) { // expense_type ?>
		<td data-name="expense_type"<?php echo $t_expenses_o->expense_type->cellAttributes() ?>>
<span id="el<?php echo $t_expenses_o_list->RowCnt ?>_t_expenses_o_expense_type" class="t_expenses_o_expense_type">
<span<?php echo $t_expenses_o->expense_type->viewAttributes() ?>>
<?php echo $t_expenses_o->expense_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_expenses_o->expense_sub_type->Visible) { // expense_sub_type ?>
		<td data-name="expense_sub_type"<?php echo $t_expenses_o->expense_sub_type->cellAttributes() ?>>
<span id="el<?php echo $t_expenses_o_list->RowCnt ?>_t_expenses_o_expense_sub_type" class="t_expenses_o_expense_sub_type">
<span>
<?php echo GetImageViewTag($t_expenses_o->expense_sub_type, $t_expenses_o->expense_sub_type->getViewValue()) ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_expenses_o->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $t_expenses_o->dated->cellAttributes() ?>>
<span id="el<?php echo $t_expenses_o_list->RowCnt ?>_t_expenses_o_dated" class="t_expenses_o_dated">
<span<?php echo $t_expenses_o->dated->viewAttributes() ?>>
<?php echo $t_expenses_o->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_expenses_o->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $t_expenses_o->amount->cellAttributes() ?>>
<span id="el<?php echo $t_expenses_o_list->RowCnt ?>_t_expenses_o_amount" class="t_expenses_o_amount">
<span<?php echo $t_expenses_o->amount->viewAttributes() ?>>
<?php echo $t_expenses_o->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_expenses_o->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $t_expenses_o->remarks->cellAttributes() ?>>
<span id="el<?php echo $t_expenses_o_list->RowCnt ?>_t_expenses_o_remarks" class="t_expenses_o_remarks">
<span<?php echo $t_expenses_o->remarks->viewAttributes() ?>>
<?php echo $t_expenses_o->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_expenses_o->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $t_expenses_o->uploads->cellAttributes() ?>>
<span id="el<?php echo $t_expenses_o_list->RowCnt ?>_t_expenses_o_uploads" class="t_expenses_o_uploads">
<span>
<?php echo GetFileViewTag($t_expenses_o->uploads, $t_expenses_o->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_expenses_o->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $t_expenses_o->operator->cellAttributes() ?>>
<span id="el<?php echo $t_expenses_o_list->RowCnt ?>_t_expenses_o_operator" class="t_expenses_o_operator">
<span<?php echo $t_expenses_o->operator->viewAttributes() ?>>
<?php echo $t_expenses_o->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_expenses_o->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $t_expenses_o->datetime->cellAttributes() ?>>
<span id="el<?php echo $t_expenses_o_list->RowCnt ?>_t_expenses_o_datetime" class="t_expenses_o_datetime">
<span<?php echo $t_expenses_o->datetime->viewAttributes() ?>>
<?php echo $t_expenses_o->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_expenses_o_list->ListOptions->render("body", "right", $t_expenses_o_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_expenses_o->isGridAdd())
		$t_expenses_o_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_expenses_o->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_expenses_o_list->Recordset)
	$t_expenses_o_list->Recordset->Close();
?>
<?php if (!$t_expenses_o->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_expenses_o->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_expenses_o_list->Pager)) $t_expenses_o_list->Pager = new PrevNextPager($t_expenses_o_list->StartRec, $t_expenses_o_list->DisplayRecs, $t_expenses_o_list->TotalRecs, $t_expenses_o_list->AutoHidePager) ?>
<?php if ($t_expenses_o_list->Pager->RecordCount > 0 && $t_expenses_o_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_expenses_o_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_expenses_o_list->pageUrl() ?>start=<?php echo $t_expenses_o_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_expenses_o_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_expenses_o_list->pageUrl() ?>start=<?php echo $t_expenses_o_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_expenses_o_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_expenses_o_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_expenses_o_list->pageUrl() ?>start=<?php echo $t_expenses_o_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_expenses_o_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_expenses_o_list->pageUrl() ?>start=<?php echo $t_expenses_o_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_expenses_o_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_expenses_o_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_expenses_o_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_expenses_o_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_expenses_o_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_expenses_o_list->TotalRecs > 0 && (!$t_expenses_o_list->AutoHidePageSizeSelector || $t_expenses_o_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_expenses_o">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_expenses_o_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_expenses_o_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_expenses_o_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_expenses_o_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_expenses_o_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_expenses_o->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_expenses_o_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_expenses_o_list->TotalRecs == 0 && !$t_expenses_o->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_expenses_o_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_expenses_o_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_expenses_o->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_expenses_o->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_expenses_o", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_expenses_o_list->terminate();
?>