<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$t_expenses_o_preview = new t_expenses_o_preview();

// Run the page
$t_expenses_o_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_expenses_o_preview->Page_Render();
?>
<?php $t_expenses_o_preview->showPageHeader(); ?>
<div class="card ew-grid t_expenses_o"><!-- .card -->
<?php if ($t_expenses_o_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$t_expenses_o_preview->renderListOptions();

// Render list options (header, left)
$t_expenses_o_preview->ListOptions->render("header", "left");
?>
<?php if ($t_expenses_o->id->Visible) { // id ?>
	<?php if ($t_expenses_o->SortUrl($t_expenses_o->id) == "") { ?>
		<th class="<?php echo $t_expenses_o->id->headerCellClass() ?>"><?php echo $t_expenses_o->id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses_o->id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses_o->id->Name) ?>" data-sort-order="<?php echo $t_expenses_o_preview->SortField == $t_expenses_o->id->Name && $t_expenses_o_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o_preview->SortField == $t_expenses_o->id->Name) { ?><?php if ($t_expenses_o_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->trip->Visible) { // trip ?>
	<?php if ($t_expenses_o->SortUrl($t_expenses_o->trip) == "") { ?>
		<th class="<?php echo $t_expenses_o->trip->headerCellClass() ?>"><?php echo $t_expenses_o->trip->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses_o->trip->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses_o->trip->Name) ?>" data-sort-order="<?php echo $t_expenses_o_preview->SortField == $t_expenses_o->trip->Name && $t_expenses_o_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->trip->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o_preview->SortField == $t_expenses_o->trip->Name) { ?><?php if ($t_expenses_o_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->r_from->Visible) { // r_from ?>
	<?php if ($t_expenses_o->SortUrl($t_expenses_o->r_from) == "") { ?>
		<th class="<?php echo $t_expenses_o->r_from->headerCellClass() ?>"><?php echo $t_expenses_o->r_from->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses_o->r_from->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses_o->r_from->Name) ?>" data-sort-order="<?php echo $t_expenses_o_preview->SortField == $t_expenses_o->r_from->Name && $t_expenses_o_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->r_from->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o_preview->SortField == $t_expenses_o->r_from->Name) { ?><?php if ($t_expenses_o_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->expense_type->Visible) { // expense_type ?>
	<?php if ($t_expenses_o->SortUrl($t_expenses_o->expense_type) == "") { ?>
		<th class="<?php echo $t_expenses_o->expense_type->headerCellClass() ?>"><?php echo $t_expenses_o->expense_type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses_o->expense_type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses_o->expense_type->Name) ?>" data-sort-order="<?php echo $t_expenses_o_preview->SortField == $t_expenses_o->expense_type->Name && $t_expenses_o_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->expense_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o_preview->SortField == $t_expenses_o->expense_type->Name) { ?><?php if ($t_expenses_o_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->expense_sub_type->Visible) { // expense_sub_type ?>
	<?php if ($t_expenses_o->SortUrl($t_expenses_o->expense_sub_type) == "") { ?>
		<th class="<?php echo $t_expenses_o->expense_sub_type->headerCellClass() ?>"><?php echo $t_expenses_o->expense_sub_type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses_o->expense_sub_type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses_o->expense_sub_type->Name) ?>" data-sort-order="<?php echo $t_expenses_o_preview->SortField == $t_expenses_o->expense_sub_type->Name && $t_expenses_o_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->expense_sub_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o_preview->SortField == $t_expenses_o->expense_sub_type->Name) { ?><?php if ($t_expenses_o_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->dated->Visible) { // dated ?>
	<?php if ($t_expenses_o->SortUrl($t_expenses_o->dated) == "") { ?>
		<th class="<?php echo $t_expenses_o->dated->headerCellClass() ?>"><?php echo $t_expenses_o->dated->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses_o->dated->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses_o->dated->Name) ?>" data-sort-order="<?php echo $t_expenses_o_preview->SortField == $t_expenses_o->dated->Name && $t_expenses_o_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o_preview->SortField == $t_expenses_o->dated->Name) { ?><?php if ($t_expenses_o_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->amount->Visible) { // amount ?>
	<?php if ($t_expenses_o->SortUrl($t_expenses_o->amount) == "") { ?>
		<th class="<?php echo $t_expenses_o->amount->headerCellClass() ?>"><?php echo $t_expenses_o->amount->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses_o->amount->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses_o->amount->Name) ?>" data-sort-order="<?php echo $t_expenses_o_preview->SortField == $t_expenses_o->amount->Name && $t_expenses_o_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o_preview->SortField == $t_expenses_o->amount->Name) { ?><?php if ($t_expenses_o_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->remarks->Visible) { // remarks ?>
	<?php if ($t_expenses_o->SortUrl($t_expenses_o->remarks) == "") { ?>
		<th class="<?php echo $t_expenses_o->remarks->headerCellClass() ?>"><?php echo $t_expenses_o->remarks->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses_o->remarks->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses_o->remarks->Name) ?>" data-sort-order="<?php echo $t_expenses_o_preview->SortField == $t_expenses_o->remarks->Name && $t_expenses_o_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->remarks->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o_preview->SortField == $t_expenses_o->remarks->Name) { ?><?php if ($t_expenses_o_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->uploads->Visible) { // uploads ?>
	<?php if ($t_expenses_o->SortUrl($t_expenses_o->uploads) == "") { ?>
		<th class="<?php echo $t_expenses_o->uploads->headerCellClass() ?>"><?php echo $t_expenses_o->uploads->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses_o->uploads->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses_o->uploads->Name) ?>" data-sort-order="<?php echo $t_expenses_o_preview->SortField == $t_expenses_o->uploads->Name && $t_expenses_o_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->uploads->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o_preview->SortField == $t_expenses_o->uploads->Name) { ?><?php if ($t_expenses_o_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->operator->Visible) { // operator ?>
	<?php if ($t_expenses_o->SortUrl($t_expenses_o->operator) == "") { ?>
		<th class="<?php echo $t_expenses_o->operator->headerCellClass() ?>"><?php echo $t_expenses_o->operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses_o->operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses_o->operator->Name) ?>" data-sort-order="<?php echo $t_expenses_o_preview->SortField == $t_expenses_o->operator->Name && $t_expenses_o_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o_preview->SortField == $t_expenses_o->operator->Name) { ?><?php if ($t_expenses_o_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses_o->datetime->Visible) { // datetime ?>
	<?php if ($t_expenses_o->SortUrl($t_expenses_o->datetime) == "") { ?>
		<th class="<?php echo $t_expenses_o->datetime->headerCellClass() ?>"><?php echo $t_expenses_o->datetime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses_o->datetime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses_o->datetime->Name) ?>" data-sort-order="<?php echo $t_expenses_o_preview->SortField == $t_expenses_o->datetime->Name && $t_expenses_o_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses_o->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_o_preview->SortField == $t_expenses_o->datetime->Name) { ?><?php if ($t_expenses_o_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_o_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_expenses_o_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$t_expenses_o_preview->RecCount = 0;
$t_expenses_o_preview->RowCnt = 0;
while ($t_expenses_o_preview->Recordset && !$t_expenses_o_preview->Recordset->EOF) {

	// Init row class and style
	$t_expenses_o_preview->RecCount++;
	$t_expenses_o_preview->RowCnt++;
	$t_expenses_o_preview->CssStyle = "";
	$t_expenses_o_preview->loadListRowValues($t_expenses_o_preview->Recordset);

	// Render row
	$t_expenses_o_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$t_expenses_o_preview->resetAttributes();
	$t_expenses_o_preview->renderListRow();

	// Render list options
	$t_expenses_o_preview->renderListOptions();
?>
	<tr<?php echo $t_expenses_o_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_expenses_o_preview->ListOptions->render("body", "left", $t_expenses_o_preview->RowCnt);
?>
<?php if ($t_expenses_o->id->Visible) { // id ?>
		<!-- id -->
		<td<?php echo $t_expenses_o->id->cellAttributes() ?>>
<span<?php echo $t_expenses_o->id->viewAttributes() ?>>
<?php echo $t_expenses_o->id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses_o->trip->Visible) { // trip ?>
		<!-- trip -->
		<td<?php echo $t_expenses_o->trip->cellAttributes() ?>>
<span<?php echo $t_expenses_o->trip->viewAttributes() ?>>
<?php echo $t_expenses_o->trip->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses_o->r_from->Visible) { // r_from ?>
		<!-- r_from -->
		<td<?php echo $t_expenses_o->r_from->cellAttributes() ?>>
<span<?php echo $t_expenses_o->r_from->viewAttributes() ?>>
<?php echo $t_expenses_o->r_from->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses_o->expense_type->Visible) { // expense_type ?>
		<!-- expense_type -->
		<td<?php echo $t_expenses_o->expense_type->cellAttributes() ?>>
<span<?php echo $t_expenses_o->expense_type->viewAttributes() ?>>
<?php echo $t_expenses_o->expense_type->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses_o->expense_sub_type->Visible) { // expense_sub_type ?>
		<!-- expense_sub_type -->
		<td<?php echo $t_expenses_o->expense_sub_type->cellAttributes() ?>>
<span>
<?php echo GetImageViewTag($t_expenses_o->expense_sub_type, $t_expenses_o->expense_sub_type->getViewValue()) ?></span>
</td>
<?php } ?>
<?php if ($t_expenses_o->dated->Visible) { // dated ?>
		<!-- dated -->
		<td<?php echo $t_expenses_o->dated->cellAttributes() ?>>
<span<?php echo $t_expenses_o->dated->viewAttributes() ?>>
<?php echo $t_expenses_o->dated->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses_o->amount->Visible) { // amount ?>
		<!-- amount -->
		<td<?php echo $t_expenses_o->amount->cellAttributes() ?>>
<span<?php echo $t_expenses_o->amount->viewAttributes() ?>>
<?php echo $t_expenses_o->amount->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses_o->remarks->Visible) { // remarks ?>
		<!-- remarks -->
		<td<?php echo $t_expenses_o->remarks->cellAttributes() ?>>
<span<?php echo $t_expenses_o->remarks->viewAttributes() ?>>
<?php echo $t_expenses_o->remarks->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses_o->uploads->Visible) { // uploads ?>
		<!-- uploads -->
		<td<?php echo $t_expenses_o->uploads->cellAttributes() ?>>
<span>
<?php echo GetFileViewTag($t_expenses_o->uploads, $t_expenses_o->uploads->getViewValue()) ?>
</span>
</td>
<?php } ?>
<?php if ($t_expenses_o->operator->Visible) { // operator ?>
		<!-- operator -->
		<td<?php echo $t_expenses_o->operator->cellAttributes() ?>>
<span<?php echo $t_expenses_o->operator->viewAttributes() ?>>
<?php echo $t_expenses_o->operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses_o->datetime->Visible) { // datetime ?>
		<!-- datetime -->
		<td<?php echo $t_expenses_o->datetime->cellAttributes() ?>>
<span<?php echo $t_expenses_o->datetime->viewAttributes() ?>>
<?php echo $t_expenses_o->datetime->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$t_expenses_o_preview->ListOptions->render("body", "right", $t_expenses_o_preview->RowCnt);
?>
	</tr>
<?php
	$t_expenses_o_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($t_expenses_o_preview->TotalRecs > 0) { ?>
<?php if (!isset($t_expenses_o_preview->Pager)) $t_expenses_o_preview->Pager = new PrevNextPager($t_expenses_o_preview->StartRec, $t_expenses_o_preview->DisplayRecs, $t_expenses_o_preview->TotalRecs) ?>
<?php if ($t_expenses_o_preview->Pager->RecordCount > 0 && $t_expenses_o_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($t_expenses_o_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $t_expenses_o_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($t_expenses_o_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $t_expenses_o_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($t_expenses_o_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $t_expenses_o_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($t_expenses_o_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $t_expenses_o_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $t_expenses_o_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $t_expenses_o_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $t_expenses_o_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($t_expenses_o_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$t_expenses_o_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($t_expenses_o_preview->Recordset)
	$t_expenses_o_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$t_expenses_o_preview->terminate();
?>