<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_expenses_edit = new t_expenses_edit();

// Run the page
$t_expenses_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_expenses_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var ft_expensesedit = currentForm = new ew.Form("ft_expensesedit", "edit");

// Validate form
ft_expensesedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_expenses_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->id->caption(), $t_expenses->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_edit->trip->Required) { ?>
			elm = this.getElements("x" + infix + "_trip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->trip->caption(), $t_expenses->trip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_edit->diesal->Required) { ?>
			elm = this.getElements("x" + infix + "_diesal");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->diesal->caption(), $t_expenses->diesal->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_diesal");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->diesal->errorMessage()) ?>");
		<?php if ($t_expenses_edit->border->Required) { ?>
			elm = this.getElements("x" + infix + "_border");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->border->caption(), $t_expenses->border->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_border");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->border->errorMessage()) ?>");
		<?php if ($t_expenses_edit->rto->Required) { ?>
			elm = this.getElements("x" + infix + "_rto");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->rto->caption(), $t_expenses->rto->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_rto");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->rto->errorMessage()) ?>");
		<?php if ($t_expenses_edit->da->Required) { ?>
			elm = this.getElements("x" + infix + "_da");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->da->caption(), $t_expenses->da->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_da");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->da->errorMessage()) ?>");
		<?php if ($t_expenses_edit->repairing->Required) { ?>
			elm = this.getElements("x" + infix + "_repairing");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->repairing->caption(), $t_expenses->repairing->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_repairing");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->repairing->errorMessage()) ?>");
		<?php if ($t_expenses_edit->toll->Required) { ?>
			elm = this.getElements("x" + infix + "_toll");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->toll->caption(), $t_expenses->toll->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_toll");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->toll->errorMessage()) ?>");
		<?php if ($t_expenses_edit->other->Required) { ?>
			elm = this.getElements("x" + infix + "_other");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->other->caption(), $t_expenses->other->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_other");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->other->errorMessage()) ?>");
		<?php if ($t_expenses_edit->cash_paid->Required) { ?>
			elm = this.getElements("x" + infix + "_cash_paid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->cash_paid->caption(), $t_expenses->cash_paid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_cash_paid");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->cash_paid->errorMessage()) ?>");
		<?php if ($t_expenses_edit->total->Required) { ?>
			elm = this.getElements("x" + infix + "_total");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->total->caption(), $t_expenses->total->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_total");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->total->errorMessage()) ?>");
		<?php if ($t_expenses_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->remarks->caption(), $t_expenses->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->dated->caption(), $t_expenses->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->dated->errorMessage()) ?>");
		<?php if ($t_expenses_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $t_expenses->uploads->caption(), $t_expenses->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->operator->caption(), $t_expenses->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->datetime->caption(), $t_expenses->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_edit->diesal_lt->Required) { ?>
			elm = this.getElements("x" + infix + "_diesal_lt");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->diesal_lt->caption(), $t_expenses->diesal_lt->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_diesal_lt");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->diesal_lt->errorMessage()) ?>");
		<?php if ($t_expenses_edit->def->Required) { ?>
			elm = this.getElements("x" + infix + "_def");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->def->caption(), $t_expenses->def->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_def");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->def->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_expensesedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_expensesedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_expensesedit.lists["x_trip"] = <?php echo $t_expenses_edit->trip->Lookup->toClientList() ?>;
ft_expensesedit.lists["x_trip"].options = <?php echo JsonEncode($t_expenses_edit->trip->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_expenses_edit->showPageHeader(); ?>
<?php
$t_expenses_edit->showMessage();
?>
<form name="ft_expensesedit" id="ft_expensesedit" class="<?php echo $t_expenses_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_expenses_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_expenses_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_expenses">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$t_expenses_edit->IsModal ?>">
<?php if ($t_expenses->getCurrentMasterTable() == "t_trip_expenses_report") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="t_trip_expenses_report">
<input type="hidden" name="fk_trip" value="<?php echo $t_expenses->trip->getSessionValue() ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_expenses->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_t_expenses_id" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->id->caption() ?><?php echo ($t_expenses->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->id->cellAttributes() ?>>
<span id="el_t_expenses_id">
<span<?php echo $t_expenses->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($t_expenses->id->CurrentValue) ?>">
<?php echo $t_expenses->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->trip->Visible) { // trip ?>
	<div id="r_trip" class="form-group row">
		<label id="elh_t_expenses_trip" for="x_trip" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->trip->caption() ?><?php echo ($t_expenses->trip->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->trip->cellAttributes() ?>>
<span id="el_t_expenses_trip">
<span<?php echo $t_expenses->trip->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->trip->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_trip" name="x_trip" id="x_trip" value="<?php echo HtmlEncode($t_expenses->trip->CurrentValue) ?>">
<?php echo $t_expenses->trip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->diesal->Visible) { // diesal ?>
	<div id="r_diesal" class="form-group row">
		<label id="elh_t_expenses_diesal" for="x_diesal" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->diesal->caption() ?><?php echo ($t_expenses->diesal->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->diesal->cellAttributes() ?>>
<span id="el_t_expenses_diesal">
<input type="text" data-table="t_expenses" data-field="x_diesal" name="x_diesal" id="x_diesal" size="30" placeholder="<?php echo HtmlEncode($t_expenses->diesal->getPlaceHolder()) ?>" value="<?php echo $t_expenses->diesal->EditValue ?>"<?php echo $t_expenses->diesal->editAttributes() ?>>
</span>
<?php echo $t_expenses->diesal->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->border->Visible) { // border ?>
	<div id="r_border" class="form-group row">
		<label id="elh_t_expenses_border" for="x_border" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->border->caption() ?><?php echo ($t_expenses->border->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->border->cellAttributes() ?>>
<span id="el_t_expenses_border">
<input type="text" data-table="t_expenses" data-field="x_border" name="x_border" id="x_border" size="30" placeholder="<?php echo HtmlEncode($t_expenses->border->getPlaceHolder()) ?>" value="<?php echo $t_expenses->border->EditValue ?>"<?php echo $t_expenses->border->editAttributes() ?>>
</span>
<?php echo $t_expenses->border->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->rto->Visible) { // rto ?>
	<div id="r_rto" class="form-group row">
		<label id="elh_t_expenses_rto" for="x_rto" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->rto->caption() ?><?php echo ($t_expenses->rto->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->rto->cellAttributes() ?>>
<span id="el_t_expenses_rto">
<input type="text" data-table="t_expenses" data-field="x_rto" name="x_rto" id="x_rto" size="30" placeholder="<?php echo HtmlEncode($t_expenses->rto->getPlaceHolder()) ?>" value="<?php echo $t_expenses->rto->EditValue ?>"<?php echo $t_expenses->rto->editAttributes() ?>>
</span>
<?php echo $t_expenses->rto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->da->Visible) { // da ?>
	<div id="r_da" class="form-group row">
		<label id="elh_t_expenses_da" for="x_da" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->da->caption() ?><?php echo ($t_expenses->da->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->da->cellAttributes() ?>>
<span id="el_t_expenses_da">
<input type="text" data-table="t_expenses" data-field="x_da" name="x_da" id="x_da" size="30" placeholder="<?php echo HtmlEncode($t_expenses->da->getPlaceHolder()) ?>" value="<?php echo $t_expenses->da->EditValue ?>"<?php echo $t_expenses->da->editAttributes() ?>>
</span>
<?php echo $t_expenses->da->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->repairing->Visible) { // repairing ?>
	<div id="r_repairing" class="form-group row">
		<label id="elh_t_expenses_repairing" for="x_repairing" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->repairing->caption() ?><?php echo ($t_expenses->repairing->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->repairing->cellAttributes() ?>>
<span id="el_t_expenses_repairing">
<input type="text" data-table="t_expenses" data-field="x_repairing" name="x_repairing" id="x_repairing" size="30" placeholder="<?php echo HtmlEncode($t_expenses->repairing->getPlaceHolder()) ?>" value="<?php echo $t_expenses->repairing->EditValue ?>"<?php echo $t_expenses->repairing->editAttributes() ?>>
</span>
<?php echo $t_expenses->repairing->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->toll->Visible) { // toll ?>
	<div id="r_toll" class="form-group row">
		<label id="elh_t_expenses_toll" for="x_toll" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->toll->caption() ?><?php echo ($t_expenses->toll->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->toll->cellAttributes() ?>>
<span id="el_t_expenses_toll">
<input type="text" data-table="t_expenses" data-field="x_toll" name="x_toll" id="x_toll" size="30" placeholder="<?php echo HtmlEncode($t_expenses->toll->getPlaceHolder()) ?>" value="<?php echo $t_expenses->toll->EditValue ?>"<?php echo $t_expenses->toll->editAttributes() ?>>
</span>
<?php echo $t_expenses->toll->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->other->Visible) { // other ?>
	<div id="r_other" class="form-group row">
		<label id="elh_t_expenses_other" for="x_other" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->other->caption() ?><?php echo ($t_expenses->other->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->other->cellAttributes() ?>>
<span id="el_t_expenses_other">
<input type="text" data-table="t_expenses" data-field="x_other" name="x_other" id="x_other" size="30" placeholder="<?php echo HtmlEncode($t_expenses->other->getPlaceHolder()) ?>" value="<?php echo $t_expenses->other->EditValue ?>"<?php echo $t_expenses->other->editAttributes() ?>>
</span>
<?php echo $t_expenses->other->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->cash_paid->Visible) { // cash_paid ?>
	<div id="r_cash_paid" class="form-group row">
		<label id="elh_t_expenses_cash_paid" for="x_cash_paid" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->cash_paid->caption() ?><?php echo ($t_expenses->cash_paid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->cash_paid->cellAttributes() ?>>
<span id="el_t_expenses_cash_paid">
<input type="text" data-table="t_expenses" data-field="x_cash_paid" name="x_cash_paid" id="x_cash_paid" size="30" placeholder="<?php echo HtmlEncode($t_expenses->cash_paid->getPlaceHolder()) ?>" value="<?php echo $t_expenses->cash_paid->EditValue ?>"<?php echo $t_expenses->cash_paid->editAttributes() ?>>
</span>
<?php echo $t_expenses->cash_paid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->total->Visible) { // total ?>
	<div id="r_total" class="form-group row">
		<label id="elh_t_expenses_total" for="x_total" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->total->caption() ?><?php echo ($t_expenses->total->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->total->cellAttributes() ?>>
<span id="el_t_expenses_total">
<input type="text" data-table="t_expenses" data-field="x_total" name="x_total" id="x_total" size="30" placeholder="<?php echo HtmlEncode($t_expenses->total->getPlaceHolder()) ?>" value="<?php echo $t_expenses->total->EditValue ?>"<?php echo $t_expenses->total->editAttributes() ?>>
</span>
<?php echo $t_expenses->total->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_t_expenses_remarks" for="x_remarks" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->remarks->caption() ?><?php echo ($t_expenses->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->remarks->cellAttributes() ?>>
<span id="el_t_expenses_remarks">
<input type="text" data-table="t_expenses" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_expenses->remarks->getPlaceHolder()) ?>" value="<?php echo $t_expenses->remarks->EditValue ?>"<?php echo $t_expenses->remarks->editAttributes() ?>>
</span>
<?php echo $t_expenses->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_t_expenses_dated" for="x_dated" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->dated->caption() ?><?php echo ($t_expenses->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->dated->cellAttributes() ?>>
<span id="el_t_expenses_dated">
<input type="text" data-table="t_expenses" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_expenses->dated->getPlaceHolder()) ?>" value="<?php echo $t_expenses->dated->EditValue ?>"<?php echo $t_expenses->dated->editAttributes() ?>>
<?php if (!$t_expenses->dated->ReadOnly && !$t_expenses->dated->Disabled && !isset($t_expenses->dated->EditAttrs["readonly"]) && !isset($t_expenses->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_expensesedit", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $t_expenses->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_t_expenses_uploads" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->uploads->caption() ?><?php echo ($t_expenses->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->uploads->cellAttributes() ?>>
<span id="el_t_expenses_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $t_expenses->uploads->title() ? $t_expenses->uploads->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($t_expenses->uploads->ReadOnly || $t_expenses->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="t_expenses" data-field="x_uploads" name="x_uploads" id="x_uploads" multiple="multiple"<?php echo $t_expenses->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $t_expenses->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="255">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $t_expenses->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $t_expenses->uploads->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_uploads" id= "fc_x_uploads" value="<?php echo $t_expenses->uploads->UploadMaxFileCount ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $t_expenses->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->diesal_lt->Visible) { // diesal_lt ?>
	<div id="r_diesal_lt" class="form-group row">
		<label id="elh_t_expenses_diesal_lt" for="x_diesal_lt" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->diesal_lt->caption() ?><?php echo ($t_expenses->diesal_lt->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->diesal_lt->cellAttributes() ?>>
<span id="el_t_expenses_diesal_lt">
<input type="text" data-table="t_expenses" data-field="x_diesal_lt" name="x_diesal_lt" id="x_diesal_lt" size="30" placeholder="<?php echo HtmlEncode($t_expenses->diesal_lt->getPlaceHolder()) ?>" value="<?php echo $t_expenses->diesal_lt->EditValue ?>"<?php echo $t_expenses->diesal_lt->editAttributes() ?>>
</span>
<?php echo $t_expenses->diesal_lt->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses->def->Visible) { // def ?>
	<div id="r_def" class="form-group row">
		<label id="elh_t_expenses_def" for="x_def" class="<?php echo $t_expenses_edit->LeftColumnClass ?>"><?php echo $t_expenses->def->caption() ?><?php echo ($t_expenses->def->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_edit->RightColumnClass ?>"><div<?php echo $t_expenses->def->cellAttributes() ?>>
<span id="el_t_expenses_def">
<input type="text" data-table="t_expenses" data-field="x_def" name="x_def" id="x_def" size="30" placeholder="<?php echo HtmlEncode($t_expenses->def->getPlaceHolder()) ?>" value="<?php echo $t_expenses->def->EditValue ?>"<?php echo $t_expenses->def->editAttributes() ?>>
</span>
<?php echo $t_expenses->def->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_expenses_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_expenses_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_expenses_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_expenses_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_expenses_edit->terminate();
?>