<?php
namespace PHPMaker2019\fibre;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($t_expenses_grid))
	$t_expenses_grid = new t_expenses_grid();

// Run the page
$t_expenses_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_expenses_grid->Page_Render();
?>
<?php if (!$t_expenses->isExport()) { ?>
<script>

// Form object
var ft_expensesgrid = new ew.Form("ft_expensesgrid", "grid");
ft_expensesgrid.formKeyCountName = '<?php echo $t_expenses_grid->FormKeyCountName ?>';

// Validate form
ft_expensesgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($t_expenses_grid->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->id->caption(), $t_expenses->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_grid->trip->Required) { ?>
			elm = this.getElements("x" + infix + "_trip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->trip->caption(), $t_expenses->trip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_grid->diesal->Required) { ?>
			elm = this.getElements("x" + infix + "_diesal");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->diesal->caption(), $t_expenses->diesal->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_diesal");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->diesal->errorMessage()) ?>");
		<?php if ($t_expenses_grid->border->Required) { ?>
			elm = this.getElements("x" + infix + "_border");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->border->caption(), $t_expenses->border->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_border");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->border->errorMessage()) ?>");
		<?php if ($t_expenses_grid->rto->Required) { ?>
			elm = this.getElements("x" + infix + "_rto");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->rto->caption(), $t_expenses->rto->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_rto");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->rto->errorMessage()) ?>");
		<?php if ($t_expenses_grid->da->Required) { ?>
			elm = this.getElements("x" + infix + "_da");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->da->caption(), $t_expenses->da->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_da");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->da->errorMessage()) ?>");
		<?php if ($t_expenses_grid->repairing->Required) { ?>
			elm = this.getElements("x" + infix + "_repairing");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->repairing->caption(), $t_expenses->repairing->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_repairing");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->repairing->errorMessage()) ?>");
		<?php if ($t_expenses_grid->toll->Required) { ?>
			elm = this.getElements("x" + infix + "_toll");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->toll->caption(), $t_expenses->toll->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_toll");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->toll->errorMessage()) ?>");
		<?php if ($t_expenses_grid->other->Required) { ?>
			elm = this.getElements("x" + infix + "_other");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->other->caption(), $t_expenses->other->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_other");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->other->errorMessage()) ?>");
		<?php if ($t_expenses_grid->cash_paid->Required) { ?>
			elm = this.getElements("x" + infix + "_cash_paid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->cash_paid->caption(), $t_expenses->cash_paid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_cash_paid");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->cash_paid->errorMessage()) ?>");
		<?php if ($t_expenses_grid->total->Required) { ?>
			elm = this.getElements("x" + infix + "_total");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->total->caption(), $t_expenses->total->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_total");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->total->errorMessage()) ?>");
		<?php if ($t_expenses_grid->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->remarks->caption(), $t_expenses->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_grid->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->dated->caption(), $t_expenses->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->dated->errorMessage()) ?>");
		<?php if ($t_expenses_grid->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $t_expenses->uploads->caption(), $t_expenses->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_grid->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->operator->caption(), $t_expenses->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_grid->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->datetime->caption(), $t_expenses->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_grid->diesal_lt->Required) { ?>
			elm = this.getElements("x" + infix + "_diesal_lt");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->diesal_lt->caption(), $t_expenses->diesal_lt->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_diesal_lt");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->diesal_lt->errorMessage()) ?>");
		<?php if ($t_expenses_grid->def->Required) { ?>
			elm = this.getElements("x" + infix + "_def");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses->def->caption(), $t_expenses->def->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_def");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses->def->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
ft_expensesgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "trip", false)) return false;
	if (ew.valueChanged(fobj, infix, "diesal", false)) return false;
	if (ew.valueChanged(fobj, infix, "border", false)) return false;
	if (ew.valueChanged(fobj, infix, "rto", false)) return false;
	if (ew.valueChanged(fobj, infix, "da", false)) return false;
	if (ew.valueChanged(fobj, infix, "repairing", false)) return false;
	if (ew.valueChanged(fobj, infix, "toll", false)) return false;
	if (ew.valueChanged(fobj, infix, "other", false)) return false;
	if (ew.valueChanged(fobj, infix, "cash_paid", false)) return false;
	if (ew.valueChanged(fobj, infix, "total", false)) return false;
	if (ew.valueChanged(fobj, infix, "remarks", false)) return false;
	if (ew.valueChanged(fobj, infix, "dated", false)) return false;
	if (ew.valueChanged(fobj, infix, "uploads", false)) return false;
	if (ew.valueChanged(fobj, infix, "diesal_lt", false)) return false;
	if (ew.valueChanged(fobj, infix, "def", false)) return false;
	return true;
}

// Form_CustomValidate event
ft_expensesgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_expensesgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_expensesgrid.lists["x_trip"] = <?php echo $t_expenses_grid->trip->Lookup->toClientList() ?>;
ft_expensesgrid.lists["x_trip"].options = <?php echo JsonEncode($t_expenses_grid->trip->lookupOptions()) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$t_expenses_grid->renderOtherOptions();
?>
<?php $t_expenses_grid->showPageHeader(); ?>
<?php
$t_expenses_grid->showMessage();
?>
<?php if ($t_expenses_grid->TotalRecs > 0 || $t_expenses->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_expenses_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_expenses">
<?php if ($t_expenses_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $t_expenses_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="ft_expensesgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_t_expenses" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_t_expensesgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_expenses_grid->RowType = ROWTYPE_HEADER;

// Render list options
$t_expenses_grid->renderListOptions();

// Render list options (header, left)
$t_expenses_grid->ListOptions->render("header", "left");
?>
<?php if ($t_expenses->id->Visible) { // id ?>
	<?php if ($t_expenses->sortUrl($t_expenses->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_expenses->id->headerCellClass() ?>"><div id="elh_t_expenses_id" class="t_expenses_id"><div class="ew-table-header-caption"><?php echo $t_expenses->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_expenses->id->headerCellClass() ?>"><div><div id="elh_t_expenses_id" class="t_expenses_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->trip->Visible) { // trip ?>
	<?php if ($t_expenses->sortUrl($t_expenses->trip) == "") { ?>
		<th data-name="trip" class="<?php echo $t_expenses->trip->headerCellClass() ?>"><div id="elh_t_expenses_trip" class="t_expenses_trip"><div class="ew-table-header-caption"><?php echo $t_expenses->trip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="trip" class="<?php echo $t_expenses->trip->headerCellClass() ?>"><div><div id="elh_t_expenses_trip" class="t_expenses_trip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->trip->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->trip->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->trip->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->diesal->Visible) { // diesal ?>
	<?php if ($t_expenses->sortUrl($t_expenses->diesal) == "") { ?>
		<th data-name="diesal" class="<?php echo $t_expenses->diesal->headerCellClass() ?>"><div id="elh_t_expenses_diesal" class="t_expenses_diesal"><div class="ew-table-header-caption"><?php echo $t_expenses->diesal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="diesal" class="<?php echo $t_expenses->diesal->headerCellClass() ?>"><div><div id="elh_t_expenses_diesal" class="t_expenses_diesal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->diesal->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->diesal->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->diesal->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->border->Visible) { // border ?>
	<?php if ($t_expenses->sortUrl($t_expenses->border) == "") { ?>
		<th data-name="border" class="<?php echo $t_expenses->border->headerCellClass() ?>"><div id="elh_t_expenses_border" class="t_expenses_border"><div class="ew-table-header-caption"><?php echo $t_expenses->border->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="border" class="<?php echo $t_expenses->border->headerCellClass() ?>"><div><div id="elh_t_expenses_border" class="t_expenses_border">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->border->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->border->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->border->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->rto->Visible) { // rto ?>
	<?php if ($t_expenses->sortUrl($t_expenses->rto) == "") { ?>
		<th data-name="rto" class="<?php echo $t_expenses->rto->headerCellClass() ?>"><div id="elh_t_expenses_rto" class="t_expenses_rto"><div class="ew-table-header-caption"><?php echo $t_expenses->rto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rto" class="<?php echo $t_expenses->rto->headerCellClass() ?>"><div><div id="elh_t_expenses_rto" class="t_expenses_rto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->rto->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->rto->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->rto->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->da->Visible) { // da ?>
	<?php if ($t_expenses->sortUrl($t_expenses->da) == "") { ?>
		<th data-name="da" class="<?php echo $t_expenses->da->headerCellClass() ?>"><div id="elh_t_expenses_da" class="t_expenses_da"><div class="ew-table-header-caption"><?php echo $t_expenses->da->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="da" class="<?php echo $t_expenses->da->headerCellClass() ?>"><div><div id="elh_t_expenses_da" class="t_expenses_da">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->da->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->da->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->da->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->repairing->Visible) { // repairing ?>
	<?php if ($t_expenses->sortUrl($t_expenses->repairing) == "") { ?>
		<th data-name="repairing" class="<?php echo $t_expenses->repairing->headerCellClass() ?>"><div id="elh_t_expenses_repairing" class="t_expenses_repairing"><div class="ew-table-header-caption"><?php echo $t_expenses->repairing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="repairing" class="<?php echo $t_expenses->repairing->headerCellClass() ?>"><div><div id="elh_t_expenses_repairing" class="t_expenses_repairing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->repairing->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->repairing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->repairing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->toll->Visible) { // toll ?>
	<?php if ($t_expenses->sortUrl($t_expenses->toll) == "") { ?>
		<th data-name="toll" class="<?php echo $t_expenses->toll->headerCellClass() ?>"><div id="elh_t_expenses_toll" class="t_expenses_toll"><div class="ew-table-header-caption"><?php echo $t_expenses->toll->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="toll" class="<?php echo $t_expenses->toll->headerCellClass() ?>"><div><div id="elh_t_expenses_toll" class="t_expenses_toll">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->toll->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->toll->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->toll->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->other->Visible) { // other ?>
	<?php if ($t_expenses->sortUrl($t_expenses->other) == "") { ?>
		<th data-name="other" class="<?php echo $t_expenses->other->headerCellClass() ?>"><div id="elh_t_expenses_other" class="t_expenses_other"><div class="ew-table-header-caption"><?php echo $t_expenses->other->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="other" class="<?php echo $t_expenses->other->headerCellClass() ?>"><div><div id="elh_t_expenses_other" class="t_expenses_other">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->other->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->other->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->other->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->cash_paid->Visible) { // cash_paid ?>
	<?php if ($t_expenses->sortUrl($t_expenses->cash_paid) == "") { ?>
		<th data-name="cash_paid" class="<?php echo $t_expenses->cash_paid->headerCellClass() ?>"><div id="elh_t_expenses_cash_paid" class="t_expenses_cash_paid"><div class="ew-table-header-caption"><?php echo $t_expenses->cash_paid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cash_paid" class="<?php echo $t_expenses->cash_paid->headerCellClass() ?>"><div><div id="elh_t_expenses_cash_paid" class="t_expenses_cash_paid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->cash_paid->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->cash_paid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->cash_paid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->total->Visible) { // total ?>
	<?php if ($t_expenses->sortUrl($t_expenses->total) == "") { ?>
		<th data-name="total" class="<?php echo $t_expenses->total->headerCellClass() ?>"><div id="elh_t_expenses_total" class="t_expenses_total"><div class="ew-table-header-caption"><?php echo $t_expenses->total->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total" class="<?php echo $t_expenses->total->headerCellClass() ?>"><div><div id="elh_t_expenses_total" class="t_expenses_total">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->total->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->total->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->total->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->remarks->Visible) { // remarks ?>
	<?php if ($t_expenses->sortUrl($t_expenses->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $t_expenses->remarks->headerCellClass() ?>"><div id="elh_t_expenses_remarks" class="t_expenses_remarks"><div class="ew-table-header-caption"><?php echo $t_expenses->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $t_expenses->remarks->headerCellClass() ?>"><div><div id="elh_t_expenses_remarks" class="t_expenses_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->remarks->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->dated->Visible) { // dated ?>
	<?php if ($t_expenses->sortUrl($t_expenses->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $t_expenses->dated->headerCellClass() ?>"><div id="elh_t_expenses_dated" class="t_expenses_dated"><div class="ew-table-header-caption"><?php echo $t_expenses->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $t_expenses->dated->headerCellClass() ?>"><div><div id="elh_t_expenses_dated" class="t_expenses_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->uploads->Visible) { // uploads ?>
	<?php if ($t_expenses->sortUrl($t_expenses->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $t_expenses->uploads->headerCellClass() ?>"><div id="elh_t_expenses_uploads" class="t_expenses_uploads"><div class="ew-table-header-caption"><?php echo $t_expenses->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $t_expenses->uploads->headerCellClass() ?>"><div><div id="elh_t_expenses_uploads" class="t_expenses_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->uploads->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->operator->Visible) { // operator ?>
	<?php if ($t_expenses->sortUrl($t_expenses->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $t_expenses->operator->headerCellClass() ?>"><div id="elh_t_expenses_operator" class="t_expenses_operator"><div class="ew-table-header-caption"><?php echo $t_expenses->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $t_expenses->operator->headerCellClass() ?>"><div><div id="elh_t_expenses_operator" class="t_expenses_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->datetime->Visible) { // datetime ?>
	<?php if ($t_expenses->sortUrl($t_expenses->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $t_expenses->datetime->headerCellClass() ?>"><div id="elh_t_expenses_datetime" class="t_expenses_datetime"><div class="ew-table-header-caption"><?php echo $t_expenses->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $t_expenses->datetime->headerCellClass() ?>"><div><div id="elh_t_expenses_datetime" class="t_expenses_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->diesal_lt->Visible) { // diesal_lt ?>
	<?php if ($t_expenses->sortUrl($t_expenses->diesal_lt) == "") { ?>
		<th data-name="diesal_lt" class="<?php echo $t_expenses->diesal_lt->headerCellClass() ?>"><div id="elh_t_expenses_diesal_lt" class="t_expenses_diesal_lt"><div class="ew-table-header-caption"><?php echo $t_expenses->diesal_lt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="diesal_lt" class="<?php echo $t_expenses->diesal_lt->headerCellClass() ?>"><div><div id="elh_t_expenses_diesal_lt" class="t_expenses_diesal_lt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->diesal_lt->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->diesal_lt->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->diesal_lt->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->def->Visible) { // def ?>
	<?php if ($t_expenses->sortUrl($t_expenses->def) == "") { ?>
		<th data-name="def" class="<?php echo $t_expenses->def->headerCellClass() ?>"><div id="elh_t_expenses_def" class="t_expenses_def"><div class="ew-table-header-caption"><?php echo $t_expenses->def->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="def" class="<?php echo $t_expenses->def->headerCellClass() ?>"><div><div id="elh_t_expenses_def" class="t_expenses_def">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->def->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses->def->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses->def->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_expenses_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$t_expenses_grid->StartRec = 1;
$t_expenses_grid->StopRec = $t_expenses_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $t_expenses_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($t_expenses_grid->FormKeyCountName) && ($t_expenses->isGridAdd() || $t_expenses->isGridEdit() || $t_expenses->isConfirm())) {
		$t_expenses_grid->KeyCount = $CurrentForm->getValue($t_expenses_grid->FormKeyCountName);
		$t_expenses_grid->StopRec = $t_expenses_grid->StartRec + $t_expenses_grid->KeyCount - 1;
	}
}
$t_expenses_grid->RecCnt = $t_expenses_grid->StartRec - 1;
if ($t_expenses_grid->Recordset && !$t_expenses_grid->Recordset->EOF) {
	$t_expenses_grid->Recordset->moveFirst();
	$selectLimit = $t_expenses_grid->UseSelectLimit;
	if (!$selectLimit && $t_expenses_grid->StartRec > 1)
		$t_expenses_grid->Recordset->move($t_expenses_grid->StartRec - 1);
} elseif (!$t_expenses->AllowAddDeleteRow && $t_expenses_grid->StopRec == 0) {
	$t_expenses_grid->StopRec = $t_expenses->GridAddRowCount;
}

// Initialize aggregate
$t_expenses->RowType = ROWTYPE_AGGREGATEINIT;
$t_expenses->resetAttributes();
$t_expenses_grid->renderRow();
if ($t_expenses->isGridAdd())
	$t_expenses_grid->RowIndex = 0;
if ($t_expenses->isGridEdit())
	$t_expenses_grid->RowIndex = 0;
while ($t_expenses_grid->RecCnt < $t_expenses_grid->StopRec) {
	$t_expenses_grid->RecCnt++;
	if ($t_expenses_grid->RecCnt >= $t_expenses_grid->StartRec) {
		$t_expenses_grid->RowCnt++;
		if ($t_expenses->isGridAdd() || $t_expenses->isGridEdit() || $t_expenses->isConfirm()) {
			$t_expenses_grid->RowIndex++;
			$CurrentForm->Index = $t_expenses_grid->RowIndex;
			if ($CurrentForm->hasValue($t_expenses_grid->FormActionName) && $t_expenses_grid->EventCancelled)
				$t_expenses_grid->RowAction = strval($CurrentForm->getValue($t_expenses_grid->FormActionName));
			elseif ($t_expenses->isGridAdd())
				$t_expenses_grid->RowAction = "insert";
			else
				$t_expenses_grid->RowAction = "";
		}

		// Set up key count
		$t_expenses_grid->KeyCount = $t_expenses_grid->RowIndex;

		// Init row class and style
		$t_expenses->resetAttributes();
		$t_expenses->CssClass = "";
		if ($t_expenses->isGridAdd()) {
			if ($t_expenses->CurrentMode == "copy") {
				$t_expenses_grid->loadRowValues($t_expenses_grid->Recordset); // Load row values
				$t_expenses_grid->setRecordKey($t_expenses_grid->RowOldKey, $t_expenses_grid->Recordset); // Set old record key
			} else {
				$t_expenses_grid->loadRowValues(); // Load default values
				$t_expenses_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$t_expenses_grid->loadRowValues($t_expenses_grid->Recordset); // Load row values
		}
		$t_expenses->RowType = ROWTYPE_VIEW; // Render view
		if ($t_expenses->isGridAdd()) // Grid add
			$t_expenses->RowType = ROWTYPE_ADD; // Render add
		if ($t_expenses->isGridAdd() && $t_expenses->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$t_expenses_grid->restoreCurrentRowFormValues($t_expenses_grid->RowIndex); // Restore form values
		if ($t_expenses->isGridEdit()) { // Grid edit
			if ($t_expenses->EventCancelled)
				$t_expenses_grid->restoreCurrentRowFormValues($t_expenses_grid->RowIndex); // Restore form values
			if ($t_expenses_grid->RowAction == "insert")
				$t_expenses->RowType = ROWTYPE_ADD; // Render add
			else
				$t_expenses->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($t_expenses->isGridEdit() && ($t_expenses->RowType == ROWTYPE_EDIT || $t_expenses->RowType == ROWTYPE_ADD) && $t_expenses->EventCancelled) // Update failed
			$t_expenses_grid->restoreCurrentRowFormValues($t_expenses_grid->RowIndex); // Restore form values
		if ($t_expenses->RowType == ROWTYPE_EDIT) // Edit row
			$t_expenses_grid->EditRowCnt++;
		if ($t_expenses->isConfirm()) // Confirm row
			$t_expenses_grid->restoreCurrentRowFormValues($t_expenses_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$t_expenses->RowAttrs = array_merge($t_expenses->RowAttrs, array('data-rowindex'=>$t_expenses_grid->RowCnt, 'id'=>'r' . $t_expenses_grid->RowCnt . '_t_expenses', 'data-rowtype'=>$t_expenses->RowType));

		// Render row
		$t_expenses_grid->renderRow();

		// Render list options
		$t_expenses_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($t_expenses_grid->RowAction <> "delete" && $t_expenses_grid->RowAction <> "insertdelete" && !($t_expenses_grid->RowAction == "insert" && $t_expenses->isConfirm() && $t_expenses_grid->emptyRow())) {
?>
	<tr<?php echo $t_expenses->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_expenses_grid->ListOptions->render("body", "left", $t_expenses_grid->RowCnt);
?>
	<?php if ($t_expenses->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_expenses->id->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="t_expenses" data-field="x_id" name="o<?php echo $t_expenses_grid->RowIndex ?>_id" id="o<?php echo $t_expenses_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_expenses->id->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_id" class="form-group t_expenses_id">
<span<?php echo $t_expenses->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_id" name="x<?php echo $t_expenses_grid->RowIndex ?>_id" id="x<?php echo $t_expenses_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_expenses->id->CurrentValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_id" class="t_expenses_id">
<span<?php echo $t_expenses->id->viewAttributes() ?>>
<?php echo $t_expenses->id->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_id" name="x<?php echo $t_expenses_grid->RowIndex ?>_id" id="x<?php echo $t_expenses_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_expenses->id->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_id" name="o<?php echo $t_expenses_grid->RowIndex ?>_id" id="o<?php echo $t_expenses_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_expenses->id->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_id" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_id" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_expenses->id->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_id" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_id" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_expenses->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->trip->Visible) { // trip ?>
		<td data-name="trip"<?php echo $t_expenses->trip->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($t_expenses->trip->getSessionValue() <> "") { ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_trip" class="form-group t_expenses_trip">
<span<?php echo $t_expenses->trip->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->trip->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $t_expenses_grid->RowIndex ?>_trip" name="x<?php echo $t_expenses_grid->RowIndex ?>_trip" value="<?php echo HtmlEncode($t_expenses->trip->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_trip" class="form-group t_expenses_trip">
<?php $t_expenses->trip->EditAttrs["onchange"] = "ew.autoFill(this);" . @$t_expenses->trip->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_expenses" data-field="x_trip" data-value-separator="<?php echo $t_expenses->trip->displayValueSeparatorAttribute() ?>" id="x<?php echo $t_expenses_grid->RowIndex ?>_trip" name="x<?php echo $t_expenses_grid->RowIndex ?>_trip"<?php echo $t_expenses->trip->editAttributes() ?>>
		<?php echo $t_expenses->trip->selectOptionListHtml("x<?php echo $t_expenses_grid->RowIndex ?>_trip") ?>
	</select>
</div>
<?php echo $t_expenses->trip->Lookup->getParamTag("p_x" . $t_expenses_grid->RowIndex . "_trip") ?>
</span>
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_trip" name="o<?php echo $t_expenses_grid->RowIndex ?>_trip" id="o<?php echo $t_expenses_grid->RowIndex ?>_trip" value="<?php echo HtmlEncode($t_expenses->trip->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_trip" class="form-group t_expenses_trip">
<span<?php echo $t_expenses->trip->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->trip->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_trip" name="x<?php echo $t_expenses_grid->RowIndex ?>_trip" id="x<?php echo $t_expenses_grid->RowIndex ?>_trip" value="<?php echo HtmlEncode($t_expenses->trip->CurrentValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_trip" class="t_expenses_trip">
<span<?php echo $t_expenses->trip->viewAttributes() ?>>
<?php echo $t_expenses->trip->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_trip" name="x<?php echo $t_expenses_grid->RowIndex ?>_trip" id="x<?php echo $t_expenses_grid->RowIndex ?>_trip" value="<?php echo HtmlEncode($t_expenses->trip->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_trip" name="o<?php echo $t_expenses_grid->RowIndex ?>_trip" id="o<?php echo $t_expenses_grid->RowIndex ?>_trip" value="<?php echo HtmlEncode($t_expenses->trip->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_trip" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_trip" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_trip" value="<?php echo HtmlEncode($t_expenses->trip->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_trip" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_trip" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_trip" value="<?php echo HtmlEncode($t_expenses->trip->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->diesal->Visible) { // diesal ?>
		<td data-name="diesal"<?php echo $t_expenses->diesal->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_diesal" class="form-group t_expenses_diesal">
<input type="text" data-table="t_expenses" data-field="x_diesal" name="x<?php echo $t_expenses_grid->RowIndex ?>_diesal" id="x<?php echo $t_expenses_grid->RowIndex ?>_diesal" size="30" placeholder="<?php echo HtmlEncode($t_expenses->diesal->getPlaceHolder()) ?>" value="<?php echo $t_expenses->diesal->EditValue ?>"<?php echo $t_expenses->diesal->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_diesal" name="o<?php echo $t_expenses_grid->RowIndex ?>_diesal" id="o<?php echo $t_expenses_grid->RowIndex ?>_diesal" value="<?php echo HtmlEncode($t_expenses->diesal->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_diesal" class="form-group t_expenses_diesal">
<input type="text" data-table="t_expenses" data-field="x_diesal" name="x<?php echo $t_expenses_grid->RowIndex ?>_diesal" id="x<?php echo $t_expenses_grid->RowIndex ?>_diesal" size="30" placeholder="<?php echo HtmlEncode($t_expenses->diesal->getPlaceHolder()) ?>" value="<?php echo $t_expenses->diesal->EditValue ?>"<?php echo $t_expenses->diesal->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_diesal" class="t_expenses_diesal">
<span<?php echo $t_expenses->diesal->viewAttributes() ?>>
<?php echo $t_expenses->diesal->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_diesal" name="x<?php echo $t_expenses_grid->RowIndex ?>_diesal" id="x<?php echo $t_expenses_grid->RowIndex ?>_diesal" value="<?php echo HtmlEncode($t_expenses->diesal->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_diesal" name="o<?php echo $t_expenses_grid->RowIndex ?>_diesal" id="o<?php echo $t_expenses_grid->RowIndex ?>_diesal" value="<?php echo HtmlEncode($t_expenses->diesal->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_diesal" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_diesal" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_diesal" value="<?php echo HtmlEncode($t_expenses->diesal->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_diesal" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_diesal" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_diesal" value="<?php echo HtmlEncode($t_expenses->diesal->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->border->Visible) { // border ?>
		<td data-name="border"<?php echo $t_expenses->border->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_border" class="form-group t_expenses_border">
<input type="text" data-table="t_expenses" data-field="x_border" name="x<?php echo $t_expenses_grid->RowIndex ?>_border" id="x<?php echo $t_expenses_grid->RowIndex ?>_border" size="30" placeholder="<?php echo HtmlEncode($t_expenses->border->getPlaceHolder()) ?>" value="<?php echo $t_expenses->border->EditValue ?>"<?php echo $t_expenses->border->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_border" name="o<?php echo $t_expenses_grid->RowIndex ?>_border" id="o<?php echo $t_expenses_grid->RowIndex ?>_border" value="<?php echo HtmlEncode($t_expenses->border->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_border" class="form-group t_expenses_border">
<input type="text" data-table="t_expenses" data-field="x_border" name="x<?php echo $t_expenses_grid->RowIndex ?>_border" id="x<?php echo $t_expenses_grid->RowIndex ?>_border" size="30" placeholder="<?php echo HtmlEncode($t_expenses->border->getPlaceHolder()) ?>" value="<?php echo $t_expenses->border->EditValue ?>"<?php echo $t_expenses->border->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_border" class="t_expenses_border">
<span<?php echo $t_expenses->border->viewAttributes() ?>>
<?php echo $t_expenses->border->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_border" name="x<?php echo $t_expenses_grid->RowIndex ?>_border" id="x<?php echo $t_expenses_grid->RowIndex ?>_border" value="<?php echo HtmlEncode($t_expenses->border->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_border" name="o<?php echo $t_expenses_grid->RowIndex ?>_border" id="o<?php echo $t_expenses_grid->RowIndex ?>_border" value="<?php echo HtmlEncode($t_expenses->border->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_border" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_border" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_border" value="<?php echo HtmlEncode($t_expenses->border->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_border" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_border" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_border" value="<?php echo HtmlEncode($t_expenses->border->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->rto->Visible) { // rto ?>
		<td data-name="rto"<?php echo $t_expenses->rto->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_rto" class="form-group t_expenses_rto">
<input type="text" data-table="t_expenses" data-field="x_rto" name="x<?php echo $t_expenses_grid->RowIndex ?>_rto" id="x<?php echo $t_expenses_grid->RowIndex ?>_rto" size="30" placeholder="<?php echo HtmlEncode($t_expenses->rto->getPlaceHolder()) ?>" value="<?php echo $t_expenses->rto->EditValue ?>"<?php echo $t_expenses->rto->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_rto" name="o<?php echo $t_expenses_grid->RowIndex ?>_rto" id="o<?php echo $t_expenses_grid->RowIndex ?>_rto" value="<?php echo HtmlEncode($t_expenses->rto->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_rto" class="form-group t_expenses_rto">
<input type="text" data-table="t_expenses" data-field="x_rto" name="x<?php echo $t_expenses_grid->RowIndex ?>_rto" id="x<?php echo $t_expenses_grid->RowIndex ?>_rto" size="30" placeholder="<?php echo HtmlEncode($t_expenses->rto->getPlaceHolder()) ?>" value="<?php echo $t_expenses->rto->EditValue ?>"<?php echo $t_expenses->rto->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_rto" class="t_expenses_rto">
<span<?php echo $t_expenses->rto->viewAttributes() ?>>
<?php echo $t_expenses->rto->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_rto" name="x<?php echo $t_expenses_grid->RowIndex ?>_rto" id="x<?php echo $t_expenses_grid->RowIndex ?>_rto" value="<?php echo HtmlEncode($t_expenses->rto->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_rto" name="o<?php echo $t_expenses_grid->RowIndex ?>_rto" id="o<?php echo $t_expenses_grid->RowIndex ?>_rto" value="<?php echo HtmlEncode($t_expenses->rto->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_rto" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_rto" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_rto" value="<?php echo HtmlEncode($t_expenses->rto->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_rto" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_rto" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_rto" value="<?php echo HtmlEncode($t_expenses->rto->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->da->Visible) { // da ?>
		<td data-name="da"<?php echo $t_expenses->da->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_da" class="form-group t_expenses_da">
<input type="text" data-table="t_expenses" data-field="x_da" name="x<?php echo $t_expenses_grid->RowIndex ?>_da" id="x<?php echo $t_expenses_grid->RowIndex ?>_da" size="30" placeholder="<?php echo HtmlEncode($t_expenses->da->getPlaceHolder()) ?>" value="<?php echo $t_expenses->da->EditValue ?>"<?php echo $t_expenses->da->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_da" name="o<?php echo $t_expenses_grid->RowIndex ?>_da" id="o<?php echo $t_expenses_grid->RowIndex ?>_da" value="<?php echo HtmlEncode($t_expenses->da->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_da" class="form-group t_expenses_da">
<input type="text" data-table="t_expenses" data-field="x_da" name="x<?php echo $t_expenses_grid->RowIndex ?>_da" id="x<?php echo $t_expenses_grid->RowIndex ?>_da" size="30" placeholder="<?php echo HtmlEncode($t_expenses->da->getPlaceHolder()) ?>" value="<?php echo $t_expenses->da->EditValue ?>"<?php echo $t_expenses->da->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_da" class="t_expenses_da">
<span<?php echo $t_expenses->da->viewAttributes() ?>>
<?php echo $t_expenses->da->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_da" name="x<?php echo $t_expenses_grid->RowIndex ?>_da" id="x<?php echo $t_expenses_grid->RowIndex ?>_da" value="<?php echo HtmlEncode($t_expenses->da->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_da" name="o<?php echo $t_expenses_grid->RowIndex ?>_da" id="o<?php echo $t_expenses_grid->RowIndex ?>_da" value="<?php echo HtmlEncode($t_expenses->da->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_da" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_da" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_da" value="<?php echo HtmlEncode($t_expenses->da->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_da" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_da" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_da" value="<?php echo HtmlEncode($t_expenses->da->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->repairing->Visible) { // repairing ?>
		<td data-name="repairing"<?php echo $t_expenses->repairing->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_repairing" class="form-group t_expenses_repairing">
<input type="text" data-table="t_expenses" data-field="x_repairing" name="x<?php echo $t_expenses_grid->RowIndex ?>_repairing" id="x<?php echo $t_expenses_grid->RowIndex ?>_repairing" size="30" placeholder="<?php echo HtmlEncode($t_expenses->repairing->getPlaceHolder()) ?>" value="<?php echo $t_expenses->repairing->EditValue ?>"<?php echo $t_expenses->repairing->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_repairing" name="o<?php echo $t_expenses_grid->RowIndex ?>_repairing" id="o<?php echo $t_expenses_grid->RowIndex ?>_repairing" value="<?php echo HtmlEncode($t_expenses->repairing->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_repairing" class="form-group t_expenses_repairing">
<input type="text" data-table="t_expenses" data-field="x_repairing" name="x<?php echo $t_expenses_grid->RowIndex ?>_repairing" id="x<?php echo $t_expenses_grid->RowIndex ?>_repairing" size="30" placeholder="<?php echo HtmlEncode($t_expenses->repairing->getPlaceHolder()) ?>" value="<?php echo $t_expenses->repairing->EditValue ?>"<?php echo $t_expenses->repairing->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_repairing" class="t_expenses_repairing">
<span<?php echo $t_expenses->repairing->viewAttributes() ?>>
<?php echo $t_expenses->repairing->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_repairing" name="x<?php echo $t_expenses_grid->RowIndex ?>_repairing" id="x<?php echo $t_expenses_grid->RowIndex ?>_repairing" value="<?php echo HtmlEncode($t_expenses->repairing->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_repairing" name="o<?php echo $t_expenses_grid->RowIndex ?>_repairing" id="o<?php echo $t_expenses_grid->RowIndex ?>_repairing" value="<?php echo HtmlEncode($t_expenses->repairing->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_repairing" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_repairing" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_repairing" value="<?php echo HtmlEncode($t_expenses->repairing->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_repairing" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_repairing" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_repairing" value="<?php echo HtmlEncode($t_expenses->repairing->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->toll->Visible) { // toll ?>
		<td data-name="toll"<?php echo $t_expenses->toll->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_toll" class="form-group t_expenses_toll">
<input type="text" data-table="t_expenses" data-field="x_toll" name="x<?php echo $t_expenses_grid->RowIndex ?>_toll" id="x<?php echo $t_expenses_grid->RowIndex ?>_toll" size="30" placeholder="<?php echo HtmlEncode($t_expenses->toll->getPlaceHolder()) ?>" value="<?php echo $t_expenses->toll->EditValue ?>"<?php echo $t_expenses->toll->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_toll" name="o<?php echo $t_expenses_grid->RowIndex ?>_toll" id="o<?php echo $t_expenses_grid->RowIndex ?>_toll" value="<?php echo HtmlEncode($t_expenses->toll->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_toll" class="form-group t_expenses_toll">
<input type="text" data-table="t_expenses" data-field="x_toll" name="x<?php echo $t_expenses_grid->RowIndex ?>_toll" id="x<?php echo $t_expenses_grid->RowIndex ?>_toll" size="30" placeholder="<?php echo HtmlEncode($t_expenses->toll->getPlaceHolder()) ?>" value="<?php echo $t_expenses->toll->EditValue ?>"<?php echo $t_expenses->toll->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_toll" class="t_expenses_toll">
<span<?php echo $t_expenses->toll->viewAttributes() ?>>
<?php echo $t_expenses->toll->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_toll" name="x<?php echo $t_expenses_grid->RowIndex ?>_toll" id="x<?php echo $t_expenses_grid->RowIndex ?>_toll" value="<?php echo HtmlEncode($t_expenses->toll->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_toll" name="o<?php echo $t_expenses_grid->RowIndex ?>_toll" id="o<?php echo $t_expenses_grid->RowIndex ?>_toll" value="<?php echo HtmlEncode($t_expenses->toll->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_toll" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_toll" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_toll" value="<?php echo HtmlEncode($t_expenses->toll->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_toll" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_toll" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_toll" value="<?php echo HtmlEncode($t_expenses->toll->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->other->Visible) { // other ?>
		<td data-name="other"<?php echo $t_expenses->other->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_other" class="form-group t_expenses_other">
<input type="text" data-table="t_expenses" data-field="x_other" name="x<?php echo $t_expenses_grid->RowIndex ?>_other" id="x<?php echo $t_expenses_grid->RowIndex ?>_other" size="30" placeholder="<?php echo HtmlEncode($t_expenses->other->getPlaceHolder()) ?>" value="<?php echo $t_expenses->other->EditValue ?>"<?php echo $t_expenses->other->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_other" name="o<?php echo $t_expenses_grid->RowIndex ?>_other" id="o<?php echo $t_expenses_grid->RowIndex ?>_other" value="<?php echo HtmlEncode($t_expenses->other->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_other" class="form-group t_expenses_other">
<input type="text" data-table="t_expenses" data-field="x_other" name="x<?php echo $t_expenses_grid->RowIndex ?>_other" id="x<?php echo $t_expenses_grid->RowIndex ?>_other" size="30" placeholder="<?php echo HtmlEncode($t_expenses->other->getPlaceHolder()) ?>" value="<?php echo $t_expenses->other->EditValue ?>"<?php echo $t_expenses->other->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_other" class="t_expenses_other">
<span<?php echo $t_expenses->other->viewAttributes() ?>>
<?php echo $t_expenses->other->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_other" name="x<?php echo $t_expenses_grid->RowIndex ?>_other" id="x<?php echo $t_expenses_grid->RowIndex ?>_other" value="<?php echo HtmlEncode($t_expenses->other->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_other" name="o<?php echo $t_expenses_grid->RowIndex ?>_other" id="o<?php echo $t_expenses_grid->RowIndex ?>_other" value="<?php echo HtmlEncode($t_expenses->other->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_other" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_other" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_other" value="<?php echo HtmlEncode($t_expenses->other->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_other" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_other" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_other" value="<?php echo HtmlEncode($t_expenses->other->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->cash_paid->Visible) { // cash_paid ?>
		<td data-name="cash_paid"<?php echo $t_expenses->cash_paid->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_cash_paid" class="form-group t_expenses_cash_paid">
<input type="text" data-table="t_expenses" data-field="x_cash_paid" name="x<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" id="x<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" size="30" placeholder="<?php echo HtmlEncode($t_expenses->cash_paid->getPlaceHolder()) ?>" value="<?php echo $t_expenses->cash_paid->EditValue ?>"<?php echo $t_expenses->cash_paid->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_cash_paid" name="o<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" id="o<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" value="<?php echo HtmlEncode($t_expenses->cash_paid->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_cash_paid" class="form-group t_expenses_cash_paid">
<input type="text" data-table="t_expenses" data-field="x_cash_paid" name="x<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" id="x<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" size="30" placeholder="<?php echo HtmlEncode($t_expenses->cash_paid->getPlaceHolder()) ?>" value="<?php echo $t_expenses->cash_paid->EditValue ?>"<?php echo $t_expenses->cash_paid->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_cash_paid" class="t_expenses_cash_paid">
<span<?php echo $t_expenses->cash_paid->viewAttributes() ?>>
<?php echo $t_expenses->cash_paid->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_cash_paid" name="x<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" id="x<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" value="<?php echo HtmlEncode($t_expenses->cash_paid->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_cash_paid" name="o<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" id="o<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" value="<?php echo HtmlEncode($t_expenses->cash_paid->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_cash_paid" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" value="<?php echo HtmlEncode($t_expenses->cash_paid->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_cash_paid" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" value="<?php echo HtmlEncode($t_expenses->cash_paid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->total->Visible) { // total ?>
		<td data-name="total"<?php echo $t_expenses->total->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_total" class="form-group t_expenses_total">
<input type="text" data-table="t_expenses" data-field="x_total" name="x<?php echo $t_expenses_grid->RowIndex ?>_total" id="x<?php echo $t_expenses_grid->RowIndex ?>_total" size="30" placeholder="<?php echo HtmlEncode($t_expenses->total->getPlaceHolder()) ?>" value="<?php echo $t_expenses->total->EditValue ?>"<?php echo $t_expenses->total->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_total" name="o<?php echo $t_expenses_grid->RowIndex ?>_total" id="o<?php echo $t_expenses_grid->RowIndex ?>_total" value="<?php echo HtmlEncode($t_expenses->total->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_total" class="form-group t_expenses_total">
<input type="text" data-table="t_expenses" data-field="x_total" name="x<?php echo $t_expenses_grid->RowIndex ?>_total" id="x<?php echo $t_expenses_grid->RowIndex ?>_total" size="30" placeholder="<?php echo HtmlEncode($t_expenses->total->getPlaceHolder()) ?>" value="<?php echo $t_expenses->total->EditValue ?>"<?php echo $t_expenses->total->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_total" class="t_expenses_total">
<span<?php echo $t_expenses->total->viewAttributes() ?>>
<?php echo $t_expenses->total->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_total" name="x<?php echo $t_expenses_grid->RowIndex ?>_total" id="x<?php echo $t_expenses_grid->RowIndex ?>_total" value="<?php echo HtmlEncode($t_expenses->total->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_total" name="o<?php echo $t_expenses_grid->RowIndex ?>_total" id="o<?php echo $t_expenses_grid->RowIndex ?>_total" value="<?php echo HtmlEncode($t_expenses->total->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_total" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_total" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_total" value="<?php echo HtmlEncode($t_expenses->total->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_total" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_total" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_total" value="<?php echo HtmlEncode($t_expenses->total->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $t_expenses->remarks->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_remarks" class="form-group t_expenses_remarks">
<input type="text" data-table="t_expenses" data-field="x_remarks" name="x<?php echo $t_expenses_grid->RowIndex ?>_remarks" id="x<?php echo $t_expenses_grid->RowIndex ?>_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_expenses->remarks->getPlaceHolder()) ?>" value="<?php echo $t_expenses->remarks->EditValue ?>"<?php echo $t_expenses->remarks->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_remarks" name="o<?php echo $t_expenses_grid->RowIndex ?>_remarks" id="o<?php echo $t_expenses_grid->RowIndex ?>_remarks" value="<?php echo HtmlEncode($t_expenses->remarks->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_remarks" class="form-group t_expenses_remarks">
<input type="text" data-table="t_expenses" data-field="x_remarks" name="x<?php echo $t_expenses_grid->RowIndex ?>_remarks" id="x<?php echo $t_expenses_grid->RowIndex ?>_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_expenses->remarks->getPlaceHolder()) ?>" value="<?php echo $t_expenses->remarks->EditValue ?>"<?php echo $t_expenses->remarks->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_remarks" class="t_expenses_remarks">
<span<?php echo $t_expenses->remarks->viewAttributes() ?>>
<?php echo $t_expenses->remarks->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_remarks" name="x<?php echo $t_expenses_grid->RowIndex ?>_remarks" id="x<?php echo $t_expenses_grid->RowIndex ?>_remarks" value="<?php echo HtmlEncode($t_expenses->remarks->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_remarks" name="o<?php echo $t_expenses_grid->RowIndex ?>_remarks" id="o<?php echo $t_expenses_grid->RowIndex ?>_remarks" value="<?php echo HtmlEncode($t_expenses->remarks->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_remarks" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_remarks" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_remarks" value="<?php echo HtmlEncode($t_expenses->remarks->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_remarks" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_remarks" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_remarks" value="<?php echo HtmlEncode($t_expenses->remarks->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $t_expenses->dated->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_dated" class="form-group t_expenses_dated">
<input type="text" data-table="t_expenses" data-field="x_dated" name="x<?php echo $t_expenses_grid->RowIndex ?>_dated" id="x<?php echo $t_expenses_grid->RowIndex ?>_dated" placeholder="<?php echo HtmlEncode($t_expenses->dated->getPlaceHolder()) ?>" value="<?php echo $t_expenses->dated->EditValue ?>"<?php echo $t_expenses->dated->editAttributes() ?>>
<?php if (!$t_expenses->dated->ReadOnly && !$t_expenses->dated->Disabled && !isset($t_expenses->dated->EditAttrs["readonly"]) && !isset($t_expenses->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_expensesgrid", "x<?php echo $t_expenses_grid->RowIndex ?>_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_dated" name="o<?php echo $t_expenses_grid->RowIndex ?>_dated" id="o<?php echo $t_expenses_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($t_expenses->dated->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_dated" class="form-group t_expenses_dated">
<input type="text" data-table="t_expenses" data-field="x_dated" name="x<?php echo $t_expenses_grid->RowIndex ?>_dated" id="x<?php echo $t_expenses_grid->RowIndex ?>_dated" placeholder="<?php echo HtmlEncode($t_expenses->dated->getPlaceHolder()) ?>" value="<?php echo $t_expenses->dated->EditValue ?>"<?php echo $t_expenses->dated->editAttributes() ?>>
<?php if (!$t_expenses->dated->ReadOnly && !$t_expenses->dated->Disabled && !isset($t_expenses->dated->EditAttrs["readonly"]) && !isset($t_expenses->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_expensesgrid", "x<?php echo $t_expenses_grid->RowIndex ?>_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_dated" class="t_expenses_dated">
<span<?php echo $t_expenses->dated->viewAttributes() ?>>
<?php echo $t_expenses->dated->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_dated" name="x<?php echo $t_expenses_grid->RowIndex ?>_dated" id="x<?php echo $t_expenses_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($t_expenses->dated->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_dated" name="o<?php echo $t_expenses_grid->RowIndex ?>_dated" id="o<?php echo $t_expenses_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($t_expenses->dated->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_dated" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_dated" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($t_expenses->dated->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_dated" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_dated" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($t_expenses->dated->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $t_expenses->uploads->cellAttributes() ?>>
<?php if ($t_expenses_grid->RowAction == "insert") { // Add record ?>
<span id="el$rowindex$_t_expenses_uploads" class="form-group t_expenses_uploads">
<div id="fd_x<?php echo $t_expenses_grid->RowIndex ?>_uploads">
<span title="<?php echo $t_expenses->uploads->title() ? $t_expenses->uploads->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($t_expenses->uploads->ReadOnly || $t_expenses->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="t_expenses" data-field="x_uploads" name="x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id="x<?php echo $t_expenses_grid->RowIndex ?>_uploads" multiple="multiple"<?php echo $t_expenses->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fn_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="<?php echo $t_expenses->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fa_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="0">
<input type="hidden" name="fs_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fs_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="255">
<input type="hidden" name="fx_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fx_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="<?php echo $t_expenses->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fm_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="<?php echo $t_expenses->uploads->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fc_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="<?php echo $t_expenses->uploads->UploadMaxFileCount ?>">
</div>
<table id="ft_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_uploads" name="o<?php echo $t_expenses_grid->RowIndex ?>_uploads" id="o<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="<?php echo HtmlEncode($t_expenses->uploads->OldValue) ?>">
<?php } elseif ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_uploads" class="t_expenses_uploads">
<span>
<?php echo GetFileViewTag($t_expenses->uploads, $t_expenses->uploads->getViewValue()) ?>
</span>
</span>
<?php } else  { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_uploads" class="form-group t_expenses_uploads">
<div id="fd_x<?php echo $t_expenses_grid->RowIndex ?>_uploads">
<span title="<?php echo $t_expenses->uploads->title() ? $t_expenses->uploads->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($t_expenses->uploads->ReadOnly || $t_expenses->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="t_expenses" data-field="x_uploads" name="x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id="x<?php echo $t_expenses_grid->RowIndex ?>_uploads" multiple="multiple"<?php echo $t_expenses->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fn_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="<?php echo $t_expenses->uploads->Upload->FileName ?>">
<?php if (Post("fa_x<?php echo $t_expenses_grid->RowIndex ?>_uploads") == "0") { ?>
<input type="hidden" name="fa_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fa_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fa_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fs_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="255">
<input type="hidden" name="fx_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fx_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="<?php echo $t_expenses->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fm_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="<?php echo $t_expenses->uploads->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fc_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="<?php echo $t_expenses->uploads->UploadMaxFileCount ?>">
</div>
<table id="ft_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $t_expenses->operator->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="t_expenses" data-field="x_operator" name="o<?php echo $t_expenses_grid->RowIndex ?>_operator" id="o<?php echo $t_expenses_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_expenses->operator->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_operator" class="t_expenses_operator">
<span<?php echo $t_expenses->operator->viewAttributes() ?>>
<?php echo $t_expenses->operator->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_operator" name="x<?php echo $t_expenses_grid->RowIndex ?>_operator" id="x<?php echo $t_expenses_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_expenses->operator->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_operator" name="o<?php echo $t_expenses_grid->RowIndex ?>_operator" id="o<?php echo $t_expenses_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_expenses->operator->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_operator" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_operator" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_expenses->operator->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_operator" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_operator" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_expenses->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $t_expenses->datetime->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="t_expenses" data-field="x_datetime" name="o<?php echo $t_expenses_grid->RowIndex ?>_datetime" id="o<?php echo $t_expenses_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_expenses->datetime->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_datetime" class="t_expenses_datetime">
<span<?php echo $t_expenses->datetime->viewAttributes() ?>>
<?php echo $t_expenses->datetime->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_datetime" name="x<?php echo $t_expenses_grid->RowIndex ?>_datetime" id="x<?php echo $t_expenses_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_expenses->datetime->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_datetime" name="o<?php echo $t_expenses_grid->RowIndex ?>_datetime" id="o<?php echo $t_expenses_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_expenses->datetime->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_datetime" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_datetime" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_expenses->datetime->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_datetime" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_datetime" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_expenses->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->diesal_lt->Visible) { // diesal_lt ?>
		<td data-name="diesal_lt"<?php echo $t_expenses->diesal_lt->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_diesal_lt" class="form-group t_expenses_diesal_lt">
<input type="text" data-table="t_expenses" data-field="x_diesal_lt" name="x<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" id="x<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" size="30" placeholder="<?php echo HtmlEncode($t_expenses->diesal_lt->getPlaceHolder()) ?>" value="<?php echo $t_expenses->diesal_lt->EditValue ?>"<?php echo $t_expenses->diesal_lt->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_diesal_lt" name="o<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" id="o<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" value="<?php echo HtmlEncode($t_expenses->diesal_lt->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_diesal_lt" class="form-group t_expenses_diesal_lt">
<input type="text" data-table="t_expenses" data-field="x_diesal_lt" name="x<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" id="x<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" size="30" placeholder="<?php echo HtmlEncode($t_expenses->diesal_lt->getPlaceHolder()) ?>" value="<?php echo $t_expenses->diesal_lt->EditValue ?>"<?php echo $t_expenses->diesal_lt->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_diesal_lt" class="t_expenses_diesal_lt">
<span<?php echo $t_expenses->diesal_lt->viewAttributes() ?>>
<?php echo $t_expenses->diesal_lt->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_diesal_lt" name="x<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" id="x<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" value="<?php echo HtmlEncode($t_expenses->diesal_lt->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_diesal_lt" name="o<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" id="o<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" value="<?php echo HtmlEncode($t_expenses->diesal_lt->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_diesal_lt" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" value="<?php echo HtmlEncode($t_expenses->diesal_lt->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_diesal_lt" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" value="<?php echo HtmlEncode($t_expenses->diesal_lt->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_expenses->def->Visible) { // def ?>
		<td data-name="def"<?php echo $t_expenses->def->cellAttributes() ?>>
<?php if ($t_expenses->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_def" class="form-group t_expenses_def">
<input type="text" data-table="t_expenses" data-field="x_def" name="x<?php echo $t_expenses_grid->RowIndex ?>_def" id="x<?php echo $t_expenses_grid->RowIndex ?>_def" size="30" placeholder="<?php echo HtmlEncode($t_expenses->def->getPlaceHolder()) ?>" value="<?php echo $t_expenses->def->EditValue ?>"<?php echo $t_expenses->def->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_def" name="o<?php echo $t_expenses_grid->RowIndex ?>_def" id="o<?php echo $t_expenses_grid->RowIndex ?>_def" value="<?php echo HtmlEncode($t_expenses->def->OldValue) ?>">
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_def" class="form-group t_expenses_def">
<input type="text" data-table="t_expenses" data-field="x_def" name="x<?php echo $t_expenses_grid->RowIndex ?>_def" id="x<?php echo $t_expenses_grid->RowIndex ?>_def" size="30" placeholder="<?php echo HtmlEncode($t_expenses->def->getPlaceHolder()) ?>" value="<?php echo $t_expenses->def->EditValue ?>"<?php echo $t_expenses->def->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_expenses->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_expenses_grid->RowCnt ?>_t_expenses_def" class="t_expenses_def">
<span<?php echo $t_expenses->def->viewAttributes() ?>>
<?php echo $t_expenses->def->getViewValue() ?></span>
</span>
<?php if (!$t_expenses->isConfirm()) { ?>
<input type="hidden" data-table="t_expenses" data-field="x_def" name="x<?php echo $t_expenses_grid->RowIndex ?>_def" id="x<?php echo $t_expenses_grid->RowIndex ?>_def" value="<?php echo HtmlEncode($t_expenses->def->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_def" name="o<?php echo $t_expenses_grid->RowIndex ?>_def" id="o<?php echo $t_expenses_grid->RowIndex ?>_def" value="<?php echo HtmlEncode($t_expenses->def->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_expenses" data-field="x_def" name="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_def" id="ft_expensesgrid$x<?php echo $t_expenses_grid->RowIndex ?>_def" value="<?php echo HtmlEncode($t_expenses->def->FormValue) ?>">
<input type="hidden" data-table="t_expenses" data-field="x_def" name="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_def" id="ft_expensesgrid$o<?php echo $t_expenses_grid->RowIndex ?>_def" value="<?php echo HtmlEncode($t_expenses->def->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_expenses_grid->ListOptions->render("body", "right", $t_expenses_grid->RowCnt);
?>
	</tr>
<?php if ($t_expenses->RowType == ROWTYPE_ADD || $t_expenses->RowType == ROWTYPE_EDIT) { ?>
<script>
ft_expensesgrid.updateLists(<?php echo $t_expenses_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$t_expenses->isGridAdd() || $t_expenses->CurrentMode == "copy")
		if (!$t_expenses_grid->Recordset->EOF)
			$t_expenses_grid->Recordset->moveNext();
}
?>
<?php
	if ($t_expenses->CurrentMode == "add" || $t_expenses->CurrentMode == "copy" || $t_expenses->CurrentMode == "edit") {
		$t_expenses_grid->RowIndex = '$rowindex$';
		$t_expenses_grid->loadRowValues();

		// Set row properties
		$t_expenses->resetAttributes();
		$t_expenses->RowAttrs = array_merge($t_expenses->RowAttrs, array('data-rowindex'=>$t_expenses_grid->RowIndex, 'id'=>'r0_t_expenses', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($t_expenses->RowAttrs["class"], "ew-template");
		$t_expenses->RowType = ROWTYPE_ADD;

		// Render row
		$t_expenses_grid->renderRow();

		// Render list options
		$t_expenses_grid->renderListOptions();
		$t_expenses_grid->StartRowCnt = 0;
?>
	<tr<?php echo $t_expenses->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_expenses_grid->ListOptions->render("body", "left", $t_expenses_grid->RowIndex);
?>
	<?php if ($t_expenses->id->Visible) { // id ?>
		<td data-name="id">
<?php if (!$t_expenses->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_id" class="form-group t_expenses_id">
<span<?php echo $t_expenses->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->id->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_id" name="x<?php echo $t_expenses_grid->RowIndex ?>_id" id="x<?php echo $t_expenses_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_expenses->id->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_id" name="o<?php echo $t_expenses_grid->RowIndex ?>_id" id="o<?php echo $t_expenses_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_expenses->id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->trip->Visible) { // trip ?>
		<td data-name="trip">
<?php if (!$t_expenses->isConfirm()) { ?>
<?php if ($t_expenses->trip->getSessionValue() <> "") { ?>
<span id="el$rowindex$_t_expenses_trip" class="form-group t_expenses_trip">
<span<?php echo $t_expenses->trip->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->trip->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $t_expenses_grid->RowIndex ?>_trip" name="x<?php echo $t_expenses_grid->RowIndex ?>_trip" value="<?php echo HtmlEncode($t_expenses->trip->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_t_expenses_trip" class="form-group t_expenses_trip">
<?php $t_expenses->trip->EditAttrs["onchange"] = "ew.autoFill(this);" . @$t_expenses->trip->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_expenses" data-field="x_trip" data-value-separator="<?php echo $t_expenses->trip->displayValueSeparatorAttribute() ?>" id="x<?php echo $t_expenses_grid->RowIndex ?>_trip" name="x<?php echo $t_expenses_grid->RowIndex ?>_trip"<?php echo $t_expenses->trip->editAttributes() ?>>
		<?php echo $t_expenses->trip->selectOptionListHtml("x<?php echo $t_expenses_grid->RowIndex ?>_trip") ?>
	</select>
</div>
<?php echo $t_expenses->trip->Lookup->getParamTag("p_x" . $t_expenses_grid->RowIndex . "_trip") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_trip" class="form-group t_expenses_trip">
<span<?php echo $t_expenses->trip->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->trip->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_trip" name="x<?php echo $t_expenses_grid->RowIndex ?>_trip" id="x<?php echo $t_expenses_grid->RowIndex ?>_trip" value="<?php echo HtmlEncode($t_expenses->trip->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_trip" name="o<?php echo $t_expenses_grid->RowIndex ?>_trip" id="o<?php echo $t_expenses_grid->RowIndex ?>_trip" value="<?php echo HtmlEncode($t_expenses->trip->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->diesal->Visible) { // diesal ?>
		<td data-name="diesal">
<?php if (!$t_expenses->isConfirm()) { ?>
<span id="el$rowindex$_t_expenses_diesal" class="form-group t_expenses_diesal">
<input type="text" data-table="t_expenses" data-field="x_diesal" name="x<?php echo $t_expenses_grid->RowIndex ?>_diesal" id="x<?php echo $t_expenses_grid->RowIndex ?>_diesal" size="30" placeholder="<?php echo HtmlEncode($t_expenses->diesal->getPlaceHolder()) ?>" value="<?php echo $t_expenses->diesal->EditValue ?>"<?php echo $t_expenses->diesal->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_diesal" class="form-group t_expenses_diesal">
<span<?php echo $t_expenses->diesal->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->diesal->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_diesal" name="x<?php echo $t_expenses_grid->RowIndex ?>_diesal" id="x<?php echo $t_expenses_grid->RowIndex ?>_diesal" value="<?php echo HtmlEncode($t_expenses->diesal->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_diesal" name="o<?php echo $t_expenses_grid->RowIndex ?>_diesal" id="o<?php echo $t_expenses_grid->RowIndex ?>_diesal" value="<?php echo HtmlEncode($t_expenses->diesal->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->border->Visible) { // border ?>
		<td data-name="border">
<?php if (!$t_expenses->isConfirm()) { ?>
<span id="el$rowindex$_t_expenses_border" class="form-group t_expenses_border">
<input type="text" data-table="t_expenses" data-field="x_border" name="x<?php echo $t_expenses_grid->RowIndex ?>_border" id="x<?php echo $t_expenses_grid->RowIndex ?>_border" size="30" placeholder="<?php echo HtmlEncode($t_expenses->border->getPlaceHolder()) ?>" value="<?php echo $t_expenses->border->EditValue ?>"<?php echo $t_expenses->border->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_border" class="form-group t_expenses_border">
<span<?php echo $t_expenses->border->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->border->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_border" name="x<?php echo $t_expenses_grid->RowIndex ?>_border" id="x<?php echo $t_expenses_grid->RowIndex ?>_border" value="<?php echo HtmlEncode($t_expenses->border->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_border" name="o<?php echo $t_expenses_grid->RowIndex ?>_border" id="o<?php echo $t_expenses_grid->RowIndex ?>_border" value="<?php echo HtmlEncode($t_expenses->border->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->rto->Visible) { // rto ?>
		<td data-name="rto">
<?php if (!$t_expenses->isConfirm()) { ?>
<span id="el$rowindex$_t_expenses_rto" class="form-group t_expenses_rto">
<input type="text" data-table="t_expenses" data-field="x_rto" name="x<?php echo $t_expenses_grid->RowIndex ?>_rto" id="x<?php echo $t_expenses_grid->RowIndex ?>_rto" size="30" placeholder="<?php echo HtmlEncode($t_expenses->rto->getPlaceHolder()) ?>" value="<?php echo $t_expenses->rto->EditValue ?>"<?php echo $t_expenses->rto->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_rto" class="form-group t_expenses_rto">
<span<?php echo $t_expenses->rto->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->rto->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_rto" name="x<?php echo $t_expenses_grid->RowIndex ?>_rto" id="x<?php echo $t_expenses_grid->RowIndex ?>_rto" value="<?php echo HtmlEncode($t_expenses->rto->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_rto" name="o<?php echo $t_expenses_grid->RowIndex ?>_rto" id="o<?php echo $t_expenses_grid->RowIndex ?>_rto" value="<?php echo HtmlEncode($t_expenses->rto->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->da->Visible) { // da ?>
		<td data-name="da">
<?php if (!$t_expenses->isConfirm()) { ?>
<span id="el$rowindex$_t_expenses_da" class="form-group t_expenses_da">
<input type="text" data-table="t_expenses" data-field="x_da" name="x<?php echo $t_expenses_grid->RowIndex ?>_da" id="x<?php echo $t_expenses_grid->RowIndex ?>_da" size="30" placeholder="<?php echo HtmlEncode($t_expenses->da->getPlaceHolder()) ?>" value="<?php echo $t_expenses->da->EditValue ?>"<?php echo $t_expenses->da->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_da" class="form-group t_expenses_da">
<span<?php echo $t_expenses->da->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->da->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_da" name="x<?php echo $t_expenses_grid->RowIndex ?>_da" id="x<?php echo $t_expenses_grid->RowIndex ?>_da" value="<?php echo HtmlEncode($t_expenses->da->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_da" name="o<?php echo $t_expenses_grid->RowIndex ?>_da" id="o<?php echo $t_expenses_grid->RowIndex ?>_da" value="<?php echo HtmlEncode($t_expenses->da->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->repairing->Visible) { // repairing ?>
		<td data-name="repairing">
<?php if (!$t_expenses->isConfirm()) { ?>
<span id="el$rowindex$_t_expenses_repairing" class="form-group t_expenses_repairing">
<input type="text" data-table="t_expenses" data-field="x_repairing" name="x<?php echo $t_expenses_grid->RowIndex ?>_repairing" id="x<?php echo $t_expenses_grid->RowIndex ?>_repairing" size="30" placeholder="<?php echo HtmlEncode($t_expenses->repairing->getPlaceHolder()) ?>" value="<?php echo $t_expenses->repairing->EditValue ?>"<?php echo $t_expenses->repairing->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_repairing" class="form-group t_expenses_repairing">
<span<?php echo $t_expenses->repairing->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->repairing->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_repairing" name="x<?php echo $t_expenses_grid->RowIndex ?>_repairing" id="x<?php echo $t_expenses_grid->RowIndex ?>_repairing" value="<?php echo HtmlEncode($t_expenses->repairing->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_repairing" name="o<?php echo $t_expenses_grid->RowIndex ?>_repairing" id="o<?php echo $t_expenses_grid->RowIndex ?>_repairing" value="<?php echo HtmlEncode($t_expenses->repairing->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->toll->Visible) { // toll ?>
		<td data-name="toll">
<?php if (!$t_expenses->isConfirm()) { ?>
<span id="el$rowindex$_t_expenses_toll" class="form-group t_expenses_toll">
<input type="text" data-table="t_expenses" data-field="x_toll" name="x<?php echo $t_expenses_grid->RowIndex ?>_toll" id="x<?php echo $t_expenses_grid->RowIndex ?>_toll" size="30" placeholder="<?php echo HtmlEncode($t_expenses->toll->getPlaceHolder()) ?>" value="<?php echo $t_expenses->toll->EditValue ?>"<?php echo $t_expenses->toll->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_toll" class="form-group t_expenses_toll">
<span<?php echo $t_expenses->toll->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->toll->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_toll" name="x<?php echo $t_expenses_grid->RowIndex ?>_toll" id="x<?php echo $t_expenses_grid->RowIndex ?>_toll" value="<?php echo HtmlEncode($t_expenses->toll->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_toll" name="o<?php echo $t_expenses_grid->RowIndex ?>_toll" id="o<?php echo $t_expenses_grid->RowIndex ?>_toll" value="<?php echo HtmlEncode($t_expenses->toll->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->other->Visible) { // other ?>
		<td data-name="other">
<?php if (!$t_expenses->isConfirm()) { ?>
<span id="el$rowindex$_t_expenses_other" class="form-group t_expenses_other">
<input type="text" data-table="t_expenses" data-field="x_other" name="x<?php echo $t_expenses_grid->RowIndex ?>_other" id="x<?php echo $t_expenses_grid->RowIndex ?>_other" size="30" placeholder="<?php echo HtmlEncode($t_expenses->other->getPlaceHolder()) ?>" value="<?php echo $t_expenses->other->EditValue ?>"<?php echo $t_expenses->other->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_other" class="form-group t_expenses_other">
<span<?php echo $t_expenses->other->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->other->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_other" name="x<?php echo $t_expenses_grid->RowIndex ?>_other" id="x<?php echo $t_expenses_grid->RowIndex ?>_other" value="<?php echo HtmlEncode($t_expenses->other->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_other" name="o<?php echo $t_expenses_grid->RowIndex ?>_other" id="o<?php echo $t_expenses_grid->RowIndex ?>_other" value="<?php echo HtmlEncode($t_expenses->other->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->cash_paid->Visible) { // cash_paid ?>
		<td data-name="cash_paid">
<?php if (!$t_expenses->isConfirm()) { ?>
<span id="el$rowindex$_t_expenses_cash_paid" class="form-group t_expenses_cash_paid">
<input type="text" data-table="t_expenses" data-field="x_cash_paid" name="x<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" id="x<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" size="30" placeholder="<?php echo HtmlEncode($t_expenses->cash_paid->getPlaceHolder()) ?>" value="<?php echo $t_expenses->cash_paid->EditValue ?>"<?php echo $t_expenses->cash_paid->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_cash_paid" class="form-group t_expenses_cash_paid">
<span<?php echo $t_expenses->cash_paid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->cash_paid->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_cash_paid" name="x<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" id="x<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" value="<?php echo HtmlEncode($t_expenses->cash_paid->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_cash_paid" name="o<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" id="o<?php echo $t_expenses_grid->RowIndex ?>_cash_paid" value="<?php echo HtmlEncode($t_expenses->cash_paid->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->total->Visible) { // total ?>
		<td data-name="total">
<?php if (!$t_expenses->isConfirm()) { ?>
<span id="el$rowindex$_t_expenses_total" class="form-group t_expenses_total">
<input type="text" data-table="t_expenses" data-field="x_total" name="x<?php echo $t_expenses_grid->RowIndex ?>_total" id="x<?php echo $t_expenses_grid->RowIndex ?>_total" size="30" placeholder="<?php echo HtmlEncode($t_expenses->total->getPlaceHolder()) ?>" value="<?php echo $t_expenses->total->EditValue ?>"<?php echo $t_expenses->total->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_total" class="form-group t_expenses_total">
<span<?php echo $t_expenses->total->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->total->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_total" name="x<?php echo $t_expenses_grid->RowIndex ?>_total" id="x<?php echo $t_expenses_grid->RowIndex ?>_total" value="<?php echo HtmlEncode($t_expenses->total->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_total" name="o<?php echo $t_expenses_grid->RowIndex ?>_total" id="o<?php echo $t_expenses_grid->RowIndex ?>_total" value="<?php echo HtmlEncode($t_expenses->total->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->remarks->Visible) { // remarks ?>
		<td data-name="remarks">
<?php if (!$t_expenses->isConfirm()) { ?>
<span id="el$rowindex$_t_expenses_remarks" class="form-group t_expenses_remarks">
<input type="text" data-table="t_expenses" data-field="x_remarks" name="x<?php echo $t_expenses_grid->RowIndex ?>_remarks" id="x<?php echo $t_expenses_grid->RowIndex ?>_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_expenses->remarks->getPlaceHolder()) ?>" value="<?php echo $t_expenses->remarks->EditValue ?>"<?php echo $t_expenses->remarks->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_remarks" class="form-group t_expenses_remarks">
<span<?php echo $t_expenses->remarks->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->remarks->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_remarks" name="x<?php echo $t_expenses_grid->RowIndex ?>_remarks" id="x<?php echo $t_expenses_grid->RowIndex ?>_remarks" value="<?php echo HtmlEncode($t_expenses->remarks->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_remarks" name="o<?php echo $t_expenses_grid->RowIndex ?>_remarks" id="o<?php echo $t_expenses_grid->RowIndex ?>_remarks" value="<?php echo HtmlEncode($t_expenses->remarks->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->dated->Visible) { // dated ?>
		<td data-name="dated">
<?php if (!$t_expenses->isConfirm()) { ?>
<span id="el$rowindex$_t_expenses_dated" class="form-group t_expenses_dated">
<input type="text" data-table="t_expenses" data-field="x_dated" name="x<?php echo $t_expenses_grid->RowIndex ?>_dated" id="x<?php echo $t_expenses_grid->RowIndex ?>_dated" placeholder="<?php echo HtmlEncode($t_expenses->dated->getPlaceHolder()) ?>" value="<?php echo $t_expenses->dated->EditValue ?>"<?php echo $t_expenses->dated->editAttributes() ?>>
<?php if (!$t_expenses->dated->ReadOnly && !$t_expenses->dated->Disabled && !isset($t_expenses->dated->EditAttrs["readonly"]) && !isset($t_expenses->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_expensesgrid", "x<?php echo $t_expenses_grid->RowIndex ?>_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_dated" class="form-group t_expenses_dated">
<span<?php echo $t_expenses->dated->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->dated->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_dated" name="x<?php echo $t_expenses_grid->RowIndex ?>_dated" id="x<?php echo $t_expenses_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($t_expenses->dated->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_dated" name="o<?php echo $t_expenses_grid->RowIndex ?>_dated" id="o<?php echo $t_expenses_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($t_expenses->dated->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->uploads->Visible) { // uploads ?>
		<td data-name="uploads">
<span id="el$rowindex$_t_expenses_uploads" class="form-group t_expenses_uploads">
<div id="fd_x<?php echo $t_expenses_grid->RowIndex ?>_uploads">
<span title="<?php echo $t_expenses->uploads->title() ? $t_expenses->uploads->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($t_expenses->uploads->ReadOnly || $t_expenses->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="t_expenses" data-field="x_uploads" name="x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id="x<?php echo $t_expenses_grid->RowIndex ?>_uploads" multiple="multiple"<?php echo $t_expenses->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fn_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="<?php echo $t_expenses->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fa_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="0">
<input type="hidden" name="fs_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fs_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="255">
<input type="hidden" name="fx_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fx_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="<?php echo $t_expenses->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fm_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="<?php echo $t_expenses->uploads->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" id= "fc_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="<?php echo $t_expenses->uploads->UploadMaxFileCount ?>">
</div>
<table id="ft_x<?php echo $t_expenses_grid->RowIndex ?>_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_uploads" name="o<?php echo $t_expenses_grid->RowIndex ?>_uploads" id="o<?php echo $t_expenses_grid->RowIndex ?>_uploads" value="<?php echo HtmlEncode($t_expenses->uploads->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->operator->Visible) { // operator ?>
		<td data-name="operator">
<?php if (!$t_expenses->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_operator" class="form-group t_expenses_operator">
<span<?php echo $t_expenses->operator->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->operator->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_operator" name="x<?php echo $t_expenses_grid->RowIndex ?>_operator" id="x<?php echo $t_expenses_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_expenses->operator->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_operator" name="o<?php echo $t_expenses_grid->RowIndex ?>_operator" id="o<?php echo $t_expenses_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_expenses->operator->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->datetime->Visible) { // datetime ?>
		<td data-name="datetime">
<?php if (!$t_expenses->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_datetime" class="form-group t_expenses_datetime">
<span<?php echo $t_expenses->datetime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->datetime->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_datetime" name="x<?php echo $t_expenses_grid->RowIndex ?>_datetime" id="x<?php echo $t_expenses_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_expenses->datetime->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_datetime" name="o<?php echo $t_expenses_grid->RowIndex ?>_datetime" id="o<?php echo $t_expenses_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_expenses->datetime->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->diesal_lt->Visible) { // diesal_lt ?>
		<td data-name="diesal_lt">
<?php if (!$t_expenses->isConfirm()) { ?>
<span id="el$rowindex$_t_expenses_diesal_lt" class="form-group t_expenses_diesal_lt">
<input type="text" data-table="t_expenses" data-field="x_diesal_lt" name="x<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" id="x<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" size="30" placeholder="<?php echo HtmlEncode($t_expenses->diesal_lt->getPlaceHolder()) ?>" value="<?php echo $t_expenses->diesal_lt->EditValue ?>"<?php echo $t_expenses->diesal_lt->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_diesal_lt" class="form-group t_expenses_diesal_lt">
<span<?php echo $t_expenses->diesal_lt->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->diesal_lt->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_diesal_lt" name="x<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" id="x<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" value="<?php echo HtmlEncode($t_expenses->diesal_lt->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_diesal_lt" name="o<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" id="o<?php echo $t_expenses_grid->RowIndex ?>_diesal_lt" value="<?php echo HtmlEncode($t_expenses->diesal_lt->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_expenses->def->Visible) { // def ?>
		<td data-name="def">
<?php if (!$t_expenses->isConfirm()) { ?>
<span id="el$rowindex$_t_expenses_def" class="form-group t_expenses_def">
<input type="text" data-table="t_expenses" data-field="x_def" name="x<?php echo $t_expenses_grid->RowIndex ?>_def" id="x<?php echo $t_expenses_grid->RowIndex ?>_def" size="30" placeholder="<?php echo HtmlEncode($t_expenses->def->getPlaceHolder()) ?>" value="<?php echo $t_expenses->def->EditValue ?>"<?php echo $t_expenses->def->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_expenses_def" class="form-group t_expenses_def">
<span<?php echo $t_expenses->def->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses->def->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses" data-field="x_def" name="x<?php echo $t_expenses_grid->RowIndex ?>_def" id="x<?php echo $t_expenses_grid->RowIndex ?>_def" value="<?php echo HtmlEncode($t_expenses->def->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_expenses" data-field="x_def" name="o<?php echo $t_expenses_grid->RowIndex ?>_def" id="o<?php echo $t_expenses_grid->RowIndex ?>_def" value="<?php echo HtmlEncode($t_expenses->def->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_expenses_grid->ListOptions->render("body", "right", $t_expenses_grid->RowIndex);
?>
<script>
ft_expensesgrid.updateLists(<?php echo $t_expenses_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($t_expenses->CurrentMode == "add" || $t_expenses->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $t_expenses_grid->FormKeyCountName ?>" id="<?php echo $t_expenses_grid->FormKeyCountName ?>" value="<?php echo $t_expenses_grid->KeyCount ?>">
<?php echo $t_expenses_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($t_expenses->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $t_expenses_grid->FormKeyCountName ?>" id="<?php echo $t_expenses_grid->FormKeyCountName ?>" value="<?php echo $t_expenses_grid->KeyCount ?>">
<?php echo $t_expenses_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($t_expenses->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="ft_expensesgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($t_expenses_grid->Recordset)
	$t_expenses_grid->Recordset->Close();
?>
</div>
<?php if ($t_expenses_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $t_expenses_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_expenses_grid->TotalRecs == 0 && !$t_expenses->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_expenses_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_expenses_grid->terminate();
?>
<?php if (!$t_expenses->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_expenses", "100%", "500px");
</script>
<?php } ?>