<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$t_expenses_preview = new t_expenses_preview();

// Run the page
$t_expenses_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_expenses_preview->Page_Render();
?>
<?php $t_expenses_preview->showPageHeader(); ?>
<div class="card ew-grid t_expenses"><!-- .card -->
<?php if ($t_expenses_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$t_expenses_preview->renderListOptions();

// Render list options (header, left)
$t_expenses_preview->ListOptions->render("header", "left");
?>
<?php if ($t_expenses->id->Visible) { // id ?>
	<?php if ($t_expenses->SortUrl($t_expenses->id) == "") { ?>
		<th class="<?php echo $t_expenses->id->headerCellClass() ?>"><?php echo $t_expenses->id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->id->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->id->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->id->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->trip->Visible) { // trip ?>
	<?php if ($t_expenses->SortUrl($t_expenses->trip) == "") { ?>
		<th class="<?php echo $t_expenses->trip->headerCellClass() ?>"><?php echo $t_expenses->trip->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->trip->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->trip->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->trip->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->trip->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->trip->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->diesal->Visible) { // diesal ?>
	<?php if ($t_expenses->SortUrl($t_expenses->diesal) == "") { ?>
		<th class="<?php echo $t_expenses->diesal->headerCellClass() ?>"><?php echo $t_expenses->diesal->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->diesal->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->diesal->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->diesal->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->diesal->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->diesal->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->border->Visible) { // border ?>
	<?php if ($t_expenses->SortUrl($t_expenses->border) == "") { ?>
		<th class="<?php echo $t_expenses->border->headerCellClass() ?>"><?php echo $t_expenses->border->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->border->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->border->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->border->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->border->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->border->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->rto->Visible) { // rto ?>
	<?php if ($t_expenses->SortUrl($t_expenses->rto) == "") { ?>
		<th class="<?php echo $t_expenses->rto->headerCellClass() ?>"><?php echo $t_expenses->rto->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->rto->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->rto->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->rto->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->rto->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->rto->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->da->Visible) { // da ?>
	<?php if ($t_expenses->SortUrl($t_expenses->da) == "") { ?>
		<th class="<?php echo $t_expenses->da->headerCellClass() ?>"><?php echo $t_expenses->da->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->da->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->da->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->da->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->da->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->da->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->repairing->Visible) { // repairing ?>
	<?php if ($t_expenses->SortUrl($t_expenses->repairing) == "") { ?>
		<th class="<?php echo $t_expenses->repairing->headerCellClass() ?>"><?php echo $t_expenses->repairing->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->repairing->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->repairing->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->repairing->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->repairing->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->repairing->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->toll->Visible) { // toll ?>
	<?php if ($t_expenses->SortUrl($t_expenses->toll) == "") { ?>
		<th class="<?php echo $t_expenses->toll->headerCellClass() ?>"><?php echo $t_expenses->toll->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->toll->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->toll->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->toll->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->toll->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->toll->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->other->Visible) { // other ?>
	<?php if ($t_expenses->SortUrl($t_expenses->other) == "") { ?>
		<th class="<?php echo $t_expenses->other->headerCellClass() ?>"><?php echo $t_expenses->other->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->other->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->other->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->other->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->other->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->other->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->cash_paid->Visible) { // cash_paid ?>
	<?php if ($t_expenses->SortUrl($t_expenses->cash_paid) == "") { ?>
		<th class="<?php echo $t_expenses->cash_paid->headerCellClass() ?>"><?php echo $t_expenses->cash_paid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->cash_paid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->cash_paid->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->cash_paid->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->cash_paid->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->cash_paid->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->total->Visible) { // total ?>
	<?php if ($t_expenses->SortUrl($t_expenses->total) == "") { ?>
		<th class="<?php echo $t_expenses->total->headerCellClass() ?>"><?php echo $t_expenses->total->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->total->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->total->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->total->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->total->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->total->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->remarks->Visible) { // remarks ?>
	<?php if ($t_expenses->SortUrl($t_expenses->remarks) == "") { ?>
		<th class="<?php echo $t_expenses->remarks->headerCellClass() ?>"><?php echo $t_expenses->remarks->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->remarks->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->remarks->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->remarks->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->remarks->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->remarks->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->dated->Visible) { // dated ?>
	<?php if ($t_expenses->SortUrl($t_expenses->dated) == "") { ?>
		<th class="<?php echo $t_expenses->dated->headerCellClass() ?>"><?php echo $t_expenses->dated->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->dated->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->dated->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->dated->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->dated->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->uploads->Visible) { // uploads ?>
	<?php if ($t_expenses->SortUrl($t_expenses->uploads) == "") { ?>
		<th class="<?php echo $t_expenses->uploads->headerCellClass() ?>"><?php echo $t_expenses->uploads->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->uploads->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->uploads->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->uploads->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->uploads->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->uploads->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->operator->Visible) { // operator ?>
	<?php if ($t_expenses->SortUrl($t_expenses->operator) == "") { ?>
		<th class="<?php echo $t_expenses->operator->headerCellClass() ?>"><?php echo $t_expenses->operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->operator->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->operator->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->operator->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->datetime->Visible) { // datetime ?>
	<?php if ($t_expenses->SortUrl($t_expenses->datetime) == "") { ?>
		<th class="<?php echo $t_expenses->datetime->headerCellClass() ?>"><?php echo $t_expenses->datetime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->datetime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->datetime->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->datetime->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->datetime->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->diesal_lt->Visible) { // diesal_lt ?>
	<?php if ($t_expenses->SortUrl($t_expenses->diesal_lt) == "") { ?>
		<th class="<?php echo $t_expenses->diesal_lt->headerCellClass() ?>"><?php echo $t_expenses->diesal_lt->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->diesal_lt->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->diesal_lt->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->diesal_lt->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->diesal_lt->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->diesal_lt->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_expenses->def->Visible) { // def ?>
	<?php if ($t_expenses->SortUrl($t_expenses->def) == "") { ?>
		<th class="<?php echo $t_expenses->def->headerCellClass() ?>"><?php echo $t_expenses->def->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_expenses->def->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_expenses->def->Name) ?>" data-sort-order="<?php echo $t_expenses_preview->SortField == $t_expenses->def->Name && $t_expenses_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_expenses->def->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_expenses_preview->SortField == $t_expenses->def->Name) { ?><?php if ($t_expenses_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_expenses_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_expenses_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$t_expenses_preview->RecCount = 0;
$t_expenses_preview->RowCnt = 0;
while ($t_expenses_preview->Recordset && !$t_expenses_preview->Recordset->EOF) {

	// Init row class and style
	$t_expenses_preview->RecCount++;
	$t_expenses_preview->RowCnt++;
	$t_expenses_preview->CssStyle = "";
	$t_expenses_preview->loadListRowValues($t_expenses_preview->Recordset);

	// Render row
	$t_expenses_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$t_expenses_preview->resetAttributes();
	$t_expenses_preview->renderListRow();

	// Render list options
	$t_expenses_preview->renderListOptions();
?>
	<tr<?php echo $t_expenses_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_expenses_preview->ListOptions->render("body", "left", $t_expenses_preview->RowCnt);
?>
<?php if ($t_expenses->id->Visible) { // id ?>
		<!-- id -->
		<td<?php echo $t_expenses->id->cellAttributes() ?>>
<span<?php echo $t_expenses->id->viewAttributes() ?>>
<?php echo $t_expenses->id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->trip->Visible) { // trip ?>
		<!-- trip -->
		<td<?php echo $t_expenses->trip->cellAttributes() ?>>
<span<?php echo $t_expenses->trip->viewAttributes() ?>>
<?php echo $t_expenses->trip->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->diesal->Visible) { // diesal ?>
		<!-- diesal -->
		<td<?php echo $t_expenses->diesal->cellAttributes() ?>>
<span<?php echo $t_expenses->diesal->viewAttributes() ?>>
<?php echo $t_expenses->diesal->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->border->Visible) { // border ?>
		<!-- border -->
		<td<?php echo $t_expenses->border->cellAttributes() ?>>
<span<?php echo $t_expenses->border->viewAttributes() ?>>
<?php echo $t_expenses->border->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->rto->Visible) { // rto ?>
		<!-- rto -->
		<td<?php echo $t_expenses->rto->cellAttributes() ?>>
<span<?php echo $t_expenses->rto->viewAttributes() ?>>
<?php echo $t_expenses->rto->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->da->Visible) { // da ?>
		<!-- da -->
		<td<?php echo $t_expenses->da->cellAttributes() ?>>
<span<?php echo $t_expenses->da->viewAttributes() ?>>
<?php echo $t_expenses->da->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->repairing->Visible) { // repairing ?>
		<!-- repairing -->
		<td<?php echo $t_expenses->repairing->cellAttributes() ?>>
<span<?php echo $t_expenses->repairing->viewAttributes() ?>>
<?php echo $t_expenses->repairing->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->toll->Visible) { // toll ?>
		<!-- toll -->
		<td<?php echo $t_expenses->toll->cellAttributes() ?>>
<span<?php echo $t_expenses->toll->viewAttributes() ?>>
<?php echo $t_expenses->toll->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->other->Visible) { // other ?>
		<!-- other -->
		<td<?php echo $t_expenses->other->cellAttributes() ?>>
<span<?php echo $t_expenses->other->viewAttributes() ?>>
<?php echo $t_expenses->other->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->cash_paid->Visible) { // cash_paid ?>
		<!-- cash_paid -->
		<td<?php echo $t_expenses->cash_paid->cellAttributes() ?>>
<span<?php echo $t_expenses->cash_paid->viewAttributes() ?>>
<?php echo $t_expenses->cash_paid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->total->Visible) { // total ?>
		<!-- total -->
		<td<?php echo $t_expenses->total->cellAttributes() ?>>
<span<?php echo $t_expenses->total->viewAttributes() ?>>
<?php echo $t_expenses->total->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->remarks->Visible) { // remarks ?>
		<!-- remarks -->
		<td<?php echo $t_expenses->remarks->cellAttributes() ?>>
<span<?php echo $t_expenses->remarks->viewAttributes() ?>>
<?php echo $t_expenses->remarks->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->dated->Visible) { // dated ?>
		<!-- dated -->
		<td<?php echo $t_expenses->dated->cellAttributes() ?>>
<span<?php echo $t_expenses->dated->viewAttributes() ?>>
<?php echo $t_expenses->dated->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->uploads->Visible) { // uploads ?>
		<!-- uploads -->
		<td<?php echo $t_expenses->uploads->cellAttributes() ?>>
<span>
<?php echo GetFileViewTag($t_expenses->uploads, $t_expenses->uploads->getViewValue()) ?>
</span>
</td>
<?php } ?>
<?php if ($t_expenses->operator->Visible) { // operator ?>
		<!-- operator -->
		<td<?php echo $t_expenses->operator->cellAttributes() ?>>
<span<?php echo $t_expenses->operator->viewAttributes() ?>>
<?php echo $t_expenses->operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->datetime->Visible) { // datetime ?>
		<!-- datetime -->
		<td<?php echo $t_expenses->datetime->cellAttributes() ?>>
<span<?php echo $t_expenses->datetime->viewAttributes() ?>>
<?php echo $t_expenses->datetime->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->diesal_lt->Visible) { // diesal_lt ?>
		<!-- diesal_lt -->
		<td<?php echo $t_expenses->diesal_lt->cellAttributes() ?>>
<span<?php echo $t_expenses->diesal_lt->viewAttributes() ?>>
<?php echo $t_expenses->diesal_lt->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_expenses->def->Visible) { // def ?>
		<!-- def -->
		<td<?php echo $t_expenses->def->cellAttributes() ?>>
<span<?php echo $t_expenses->def->viewAttributes() ?>>
<?php echo $t_expenses->def->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$t_expenses_preview->ListOptions->render("body", "right", $t_expenses_preview->RowCnt);
?>
	</tr>
<?php
	$t_expenses_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($t_expenses_preview->TotalRecs > 0) { ?>
<?php if (!isset($t_expenses_preview->Pager)) $t_expenses_preview->Pager = new PrevNextPager($t_expenses_preview->StartRec, $t_expenses_preview->DisplayRecs, $t_expenses_preview->TotalRecs) ?>
<?php if ($t_expenses_preview->Pager->RecordCount > 0 && $t_expenses_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($t_expenses_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $t_expenses_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($t_expenses_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $t_expenses_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($t_expenses_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $t_expenses_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($t_expenses_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $t_expenses_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $t_expenses_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $t_expenses_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $t_expenses_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($t_expenses_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$t_expenses_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($t_expenses_preview->Recordset)
	$t_expenses_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$t_expenses_preview->terminate();
?>