<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_expenses_view = new t_expenses_view();

// Run the page
$t_expenses_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_expenses_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_expenses->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_expensesview = currentForm = new ew.Form("ft_expensesview", "view");

// Form_CustomValidate event
ft_expensesview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_expensesview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_expensesview.lists["x_trip"] = <?php echo $t_expenses_view->trip->Lookup->toClientList() ?>;
ft_expensesview.lists["x_trip"].options = <?php echo JsonEncode($t_expenses_view->trip->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_expenses->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_expenses_view->ExportOptions->render("body") ?>
<?php $t_expenses_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_expenses_view->showPageHeader(); ?>
<?php
$t_expenses_view->showMessage();
?>
<form name="ft_expensesview" id="ft_expensesview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_expenses_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_expenses_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_expenses">
<input type="hidden" name="modal" value="<?php echo (int)$t_expenses_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_expenses->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_id"><?php echo $t_expenses->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_expenses->id->cellAttributes() ?>>
<span id="el_t_expenses_id">
<span<?php echo $t_expenses->id->viewAttributes() ?>>
<?php echo $t_expenses->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->trip->Visible) { // trip ?>
	<tr id="r_trip">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_trip"><?php echo $t_expenses->trip->caption() ?></span></td>
		<td data-name="trip"<?php echo $t_expenses->trip->cellAttributes() ?>>
<span id="el_t_expenses_trip">
<span<?php echo $t_expenses->trip->viewAttributes() ?>>
<?php echo $t_expenses->trip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->diesal->Visible) { // diesal ?>
	<tr id="r_diesal">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_diesal"><?php echo $t_expenses->diesal->caption() ?></span></td>
		<td data-name="diesal"<?php echo $t_expenses->diesal->cellAttributes() ?>>
<span id="el_t_expenses_diesal">
<span<?php echo $t_expenses->diesal->viewAttributes() ?>>
<?php echo $t_expenses->diesal->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->border->Visible) { // border ?>
	<tr id="r_border">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_border"><?php echo $t_expenses->border->caption() ?></span></td>
		<td data-name="border"<?php echo $t_expenses->border->cellAttributes() ?>>
<span id="el_t_expenses_border">
<span<?php echo $t_expenses->border->viewAttributes() ?>>
<?php echo $t_expenses->border->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->rto->Visible) { // rto ?>
	<tr id="r_rto">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_rto"><?php echo $t_expenses->rto->caption() ?></span></td>
		<td data-name="rto"<?php echo $t_expenses->rto->cellAttributes() ?>>
<span id="el_t_expenses_rto">
<span<?php echo $t_expenses->rto->viewAttributes() ?>>
<?php echo $t_expenses->rto->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->da->Visible) { // da ?>
	<tr id="r_da">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_da"><?php echo $t_expenses->da->caption() ?></span></td>
		<td data-name="da"<?php echo $t_expenses->da->cellAttributes() ?>>
<span id="el_t_expenses_da">
<span<?php echo $t_expenses->da->viewAttributes() ?>>
<?php echo $t_expenses->da->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->repairing->Visible) { // repairing ?>
	<tr id="r_repairing">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_repairing"><?php echo $t_expenses->repairing->caption() ?></span></td>
		<td data-name="repairing"<?php echo $t_expenses->repairing->cellAttributes() ?>>
<span id="el_t_expenses_repairing">
<span<?php echo $t_expenses->repairing->viewAttributes() ?>>
<?php echo $t_expenses->repairing->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->toll->Visible) { // toll ?>
	<tr id="r_toll">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_toll"><?php echo $t_expenses->toll->caption() ?></span></td>
		<td data-name="toll"<?php echo $t_expenses->toll->cellAttributes() ?>>
<span id="el_t_expenses_toll">
<span<?php echo $t_expenses->toll->viewAttributes() ?>>
<?php echo $t_expenses->toll->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->other->Visible) { // other ?>
	<tr id="r_other">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_other"><?php echo $t_expenses->other->caption() ?></span></td>
		<td data-name="other"<?php echo $t_expenses->other->cellAttributes() ?>>
<span id="el_t_expenses_other">
<span<?php echo $t_expenses->other->viewAttributes() ?>>
<?php echo $t_expenses->other->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->cash_paid->Visible) { // cash_paid ?>
	<tr id="r_cash_paid">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_cash_paid"><?php echo $t_expenses->cash_paid->caption() ?></span></td>
		<td data-name="cash_paid"<?php echo $t_expenses->cash_paid->cellAttributes() ?>>
<span id="el_t_expenses_cash_paid">
<span<?php echo $t_expenses->cash_paid->viewAttributes() ?>>
<?php echo $t_expenses->cash_paid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->total->Visible) { // total ?>
	<tr id="r_total">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_total"><?php echo $t_expenses->total->caption() ?></span></td>
		<td data-name="total"<?php echo $t_expenses->total->cellAttributes() ?>>
<span id="el_t_expenses_total">
<span<?php echo $t_expenses->total->viewAttributes() ?>>
<?php echo $t_expenses->total->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_remarks"><?php echo $t_expenses->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $t_expenses->remarks->cellAttributes() ?>>
<span id="el_t_expenses_remarks">
<span<?php echo $t_expenses->remarks->viewAttributes() ?>>
<?php echo $t_expenses->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_dated"><?php echo $t_expenses->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $t_expenses->dated->cellAttributes() ?>>
<span id="el_t_expenses_dated">
<span<?php echo $t_expenses->dated->viewAttributes() ?>>
<?php echo $t_expenses->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_uploads"><?php echo $t_expenses->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $t_expenses->uploads->cellAttributes() ?>>
<span id="el_t_expenses_uploads">
<span>
<?php echo GetFileViewTag($t_expenses->uploads, $t_expenses->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_operator"><?php echo $t_expenses->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_expenses->operator->cellAttributes() ?>>
<span id="el_t_expenses_operator">
<span<?php echo $t_expenses->operator->viewAttributes() ?>>
<?php echo $t_expenses->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_datetime"><?php echo $t_expenses->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_expenses->datetime->cellAttributes() ?>>
<span id="el_t_expenses_datetime">
<span<?php echo $t_expenses->datetime->viewAttributes() ?>>
<?php echo $t_expenses->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->diesal_lt->Visible) { // diesal_lt ?>
	<tr id="r_diesal_lt">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_diesal_lt"><?php echo $t_expenses->diesal_lt->caption() ?></span></td>
		<td data-name="diesal_lt"<?php echo $t_expenses->diesal_lt->cellAttributes() ?>>
<span id="el_t_expenses_diesal_lt">
<span<?php echo $t_expenses->diesal_lt->viewAttributes() ?>>
<?php echo $t_expenses->diesal_lt->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_expenses->def->Visible) { // def ?>
	<tr id="r_def">
		<td class="<?php echo $t_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_expenses_def"><?php echo $t_expenses->def->caption() ?></span></td>
		<td data-name="def"<?php echo $t_expenses->def->cellAttributes() ?>>
<span id="el_t_expenses_def">
<span<?php echo $t_expenses->def->viewAttributes() ?>>
<?php echo $t_expenses->def->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_expenses_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_expenses->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_expenses_view->terminate();
?>