<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_fasttag_expenses_list = new t_fasttag_expenses_list();

// Run the page
$t_fasttag_expenses_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_fasttag_expenses_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_fasttag_expenses->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_fasttag_expenseslist = currentForm = new ew.Form("ft_fasttag_expenseslist", "list");
ft_fasttag_expenseslist.formKeyCountName = '<?php echo $t_fasttag_expenses_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_fasttag_expenseslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_fasttag_expenseslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_fasttag_expenseslist.lists["x_r_from"] = <?php echo $t_fasttag_expenses_list->r_from->Lookup->toClientList() ?>;
ft_fasttag_expenseslist.lists["x_r_from"].options = <?php echo JsonEncode($t_fasttag_expenses_list->r_from->lookupOptions()) ?>;
ft_fasttag_expenseslist.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_fasttag_expenseslist.lists["x_vehicle_id"] = <?php echo $t_fasttag_expenses_list->vehicle_id->Lookup->toClientList() ?>;
ft_fasttag_expenseslist.lists["x_vehicle_id"].options = <?php echo JsonEncode($t_fasttag_expenses_list->vehicle_id->lookupOptions()) ?>;
ft_fasttag_expenseslist.autoSuggests["x_vehicle_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_fasttag_expenseslist.lists["x_trip"] = <?php echo $t_fasttag_expenses_list->trip->Lookup->toClientList() ?>;
ft_fasttag_expenseslist.lists["x_trip"].options = <?php echo JsonEncode($t_fasttag_expenses_list->trip->lookupOptions()) ?>;
ft_fasttag_expenseslist.lists["x_operator"] = <?php echo $t_fasttag_expenses_list->operator->Lookup->toClientList() ?>;
ft_fasttag_expenseslist.lists["x_operator"].options = <?php echo JsonEncode($t_fasttag_expenses_list->operator->lookupOptions()) ?>;

// Form object for search
var ft_fasttag_expenseslistsrch = currentSearchForm = new ew.Form("ft_fasttag_expenseslistsrch");

// Filters
ft_fasttag_expenseslistsrch.filterList = <?php echo $t_fasttag_expenses_list->getFilterList() ?>;

// Init search panel as collapsed
ft_fasttag_expenseslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_fasttag_expenses->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_fasttag_expenses_list->TotalRecs > 0 && $t_fasttag_expenses_list->ExportOptions->visible()) { ?>
<?php $t_fasttag_expenses_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_fasttag_expenses_list->ImportOptions->visible()) { ?>
<?php $t_fasttag_expenses_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_fasttag_expenses_list->SearchOptions->visible()) { ?>
<?php $t_fasttag_expenses_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_fasttag_expenses_list->FilterOptions->visible()) { ?>
<?php $t_fasttag_expenses_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_fasttag_expenses_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_fasttag_expenses->isExport() && !$t_fasttag_expenses->CurrentAction) { ?>
<form name="ft_fasttag_expenseslistsrch" id="ft_fasttag_expenseslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_fasttag_expenses_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_fasttag_expenseslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_fasttag_expenses">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_fasttag_expenses_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_fasttag_expenses_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_fasttag_expenses_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_fasttag_expenses_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_fasttag_expenses_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_fasttag_expenses_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_fasttag_expenses_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_fasttag_expenses_list->showPageHeader(); ?>
<?php
$t_fasttag_expenses_list->showMessage();
?>
<?php if ($t_fasttag_expenses_list->TotalRecs > 0 || $t_fasttag_expenses->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_fasttag_expenses_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_fasttag_expenses">
<?php if (!$t_fasttag_expenses->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_fasttag_expenses->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_fasttag_expenses_list->Pager)) $t_fasttag_expenses_list->Pager = new PrevNextPager($t_fasttag_expenses_list->StartRec, $t_fasttag_expenses_list->DisplayRecs, $t_fasttag_expenses_list->TotalRecs, $t_fasttag_expenses_list->AutoHidePager) ?>
<?php if ($t_fasttag_expenses_list->Pager->RecordCount > 0 && $t_fasttag_expenses_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_fasttag_expenses_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_fasttag_expenses_list->pageUrl() ?>start=<?php echo $t_fasttag_expenses_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_fasttag_expenses_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_fasttag_expenses_list->pageUrl() ?>start=<?php echo $t_fasttag_expenses_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_fasttag_expenses_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_fasttag_expenses_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_fasttag_expenses_list->pageUrl() ?>start=<?php echo $t_fasttag_expenses_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_fasttag_expenses_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_fasttag_expenses_list->pageUrl() ?>start=<?php echo $t_fasttag_expenses_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_fasttag_expenses_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_fasttag_expenses_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_fasttag_expenses_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_fasttag_expenses_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_fasttag_expenses_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_fasttag_expenses_list->TotalRecs > 0 && (!$t_fasttag_expenses_list->AutoHidePageSizeSelector || $t_fasttag_expenses_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_fasttag_expenses">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_fasttag_expenses_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_fasttag_expenses_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_fasttag_expenses_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_fasttag_expenses_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_fasttag_expenses_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_fasttag_expenses->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_fasttag_expenses_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_fasttag_expenseslist" id="ft_fasttag_expenseslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_fasttag_expenses_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_fasttag_expenses_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_fasttag_expenses">
<div id="gmp_t_fasttag_expenses" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_fasttag_expenses_list->TotalRecs > 0 || $t_fasttag_expenses->isGridEdit()) { ?>
<table id="tbl_t_fasttag_expenseslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_fasttag_expenses_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_fasttag_expenses_list->renderListOptions();

// Render list options (header, left)
$t_fasttag_expenses_list->ListOptions->render("header", "left");
?>
<?php if ($t_fasttag_expenses->id->Visible) { // id ?>
	<?php if ($t_fasttag_expenses->sortUrl($t_fasttag_expenses->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_fasttag_expenses->id->headerCellClass() ?>"><div id="elh_t_fasttag_expenses_id" class="t_fasttag_expenses_id"><div class="ew-table-header-caption"><?php echo $t_fasttag_expenses->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_fasttag_expenses->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_fasttag_expenses->SortUrl($t_fasttag_expenses->id) ?>',2);"><div id="elh_t_fasttag_expenses_id" class="t_fasttag_expenses_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_fasttag_expenses->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_fasttag_expenses->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_fasttag_expenses->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_fasttag_expenses->r_from->Visible) { // r_from ?>
	<?php if ($t_fasttag_expenses->sortUrl($t_fasttag_expenses->r_from) == "") { ?>
		<th data-name="r_from" class="<?php echo $t_fasttag_expenses->r_from->headerCellClass() ?>"><div id="elh_t_fasttag_expenses_r_from" class="t_fasttag_expenses_r_from"><div class="ew-table-header-caption"><?php echo $t_fasttag_expenses->r_from->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_from" class="<?php echo $t_fasttag_expenses->r_from->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_fasttag_expenses->SortUrl($t_fasttag_expenses->r_from) ?>',2);"><div id="elh_t_fasttag_expenses_r_from" class="t_fasttag_expenses_r_from">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_fasttag_expenses->r_from->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_fasttag_expenses->r_from->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_fasttag_expenses->r_from->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_fasttag_expenses->vehicle_id->Visible) { // vehicle_id ?>
	<?php if ($t_fasttag_expenses->sortUrl($t_fasttag_expenses->vehicle_id) == "") { ?>
		<th data-name="vehicle_id" class="<?php echo $t_fasttag_expenses->vehicle_id->headerCellClass() ?>"><div id="elh_t_fasttag_expenses_vehicle_id" class="t_fasttag_expenses_vehicle_id"><div class="ew-table-header-caption"><?php echo $t_fasttag_expenses->vehicle_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_id" class="<?php echo $t_fasttag_expenses->vehicle_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_fasttag_expenses->SortUrl($t_fasttag_expenses->vehicle_id) ?>',2);"><div id="elh_t_fasttag_expenses_vehicle_id" class="t_fasttag_expenses_vehicle_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_fasttag_expenses->vehicle_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_fasttag_expenses->vehicle_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_fasttag_expenses->vehicle_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_fasttag_expenses->trip->Visible) { // trip ?>
	<?php if ($t_fasttag_expenses->sortUrl($t_fasttag_expenses->trip) == "") { ?>
		<th data-name="trip" class="<?php echo $t_fasttag_expenses->trip->headerCellClass() ?>"><div id="elh_t_fasttag_expenses_trip" class="t_fasttag_expenses_trip"><div class="ew-table-header-caption"><?php echo $t_fasttag_expenses->trip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="trip" class="<?php echo $t_fasttag_expenses->trip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_fasttag_expenses->SortUrl($t_fasttag_expenses->trip) ?>',2);"><div id="elh_t_fasttag_expenses_trip" class="t_fasttag_expenses_trip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_fasttag_expenses->trip->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_fasttag_expenses->trip->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_fasttag_expenses->trip->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_fasttag_expenses->amount->Visible) { // amount ?>
	<?php if ($t_fasttag_expenses->sortUrl($t_fasttag_expenses->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $t_fasttag_expenses->amount->headerCellClass() ?>"><div id="elh_t_fasttag_expenses_amount" class="t_fasttag_expenses_amount"><div class="ew-table-header-caption"><?php echo $t_fasttag_expenses->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $t_fasttag_expenses->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_fasttag_expenses->SortUrl($t_fasttag_expenses->amount) ?>',2);"><div id="elh_t_fasttag_expenses_amount" class="t_fasttag_expenses_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_fasttag_expenses->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_fasttag_expenses->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_fasttag_expenses->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_fasttag_expenses->dated->Visible) { // dated ?>
	<?php if ($t_fasttag_expenses->sortUrl($t_fasttag_expenses->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $t_fasttag_expenses->dated->headerCellClass() ?>"><div id="elh_t_fasttag_expenses_dated" class="t_fasttag_expenses_dated"><div class="ew-table-header-caption"><?php echo $t_fasttag_expenses->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $t_fasttag_expenses->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_fasttag_expenses->SortUrl($t_fasttag_expenses->dated) ?>',2);"><div id="elh_t_fasttag_expenses_dated" class="t_fasttag_expenses_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_fasttag_expenses->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_fasttag_expenses->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_fasttag_expenses->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_fasttag_expenses->remakrs->Visible) { // remakrs ?>
	<?php if ($t_fasttag_expenses->sortUrl($t_fasttag_expenses->remakrs) == "") { ?>
		<th data-name="remakrs" class="<?php echo $t_fasttag_expenses->remakrs->headerCellClass() ?>"><div id="elh_t_fasttag_expenses_remakrs" class="t_fasttag_expenses_remakrs"><div class="ew-table-header-caption"><?php echo $t_fasttag_expenses->remakrs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remakrs" class="<?php echo $t_fasttag_expenses->remakrs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_fasttag_expenses->SortUrl($t_fasttag_expenses->remakrs) ?>',2);"><div id="elh_t_fasttag_expenses_remakrs" class="t_fasttag_expenses_remakrs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_fasttag_expenses->remakrs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_fasttag_expenses->remakrs->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_fasttag_expenses->remakrs->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_fasttag_expenses->uploads->Visible) { // uploads ?>
	<?php if ($t_fasttag_expenses->sortUrl($t_fasttag_expenses->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $t_fasttag_expenses->uploads->headerCellClass() ?>"><div id="elh_t_fasttag_expenses_uploads" class="t_fasttag_expenses_uploads"><div class="ew-table-header-caption"><?php echo $t_fasttag_expenses->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $t_fasttag_expenses->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_fasttag_expenses->SortUrl($t_fasttag_expenses->uploads) ?>',2);"><div id="elh_t_fasttag_expenses_uploads" class="t_fasttag_expenses_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_fasttag_expenses->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_fasttag_expenses->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_fasttag_expenses->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_fasttag_expenses->operator->Visible) { // operator ?>
	<?php if ($t_fasttag_expenses->sortUrl($t_fasttag_expenses->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $t_fasttag_expenses->operator->headerCellClass() ?>"><div id="elh_t_fasttag_expenses_operator" class="t_fasttag_expenses_operator"><div class="ew-table-header-caption"><?php echo $t_fasttag_expenses->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $t_fasttag_expenses->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_fasttag_expenses->SortUrl($t_fasttag_expenses->operator) ?>',2);"><div id="elh_t_fasttag_expenses_operator" class="t_fasttag_expenses_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_fasttag_expenses->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_fasttag_expenses->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_fasttag_expenses->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_fasttag_expenses->datetime->Visible) { // datetime ?>
	<?php if ($t_fasttag_expenses->sortUrl($t_fasttag_expenses->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $t_fasttag_expenses->datetime->headerCellClass() ?>"><div id="elh_t_fasttag_expenses_datetime" class="t_fasttag_expenses_datetime"><div class="ew-table-header-caption"><?php echo $t_fasttag_expenses->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $t_fasttag_expenses->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_fasttag_expenses->SortUrl($t_fasttag_expenses->datetime) ?>',2);"><div id="elh_t_fasttag_expenses_datetime" class="t_fasttag_expenses_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_fasttag_expenses->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_fasttag_expenses->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_fasttag_expenses->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_fasttag_expenses_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_fasttag_expenses->ExportAll && $t_fasttag_expenses->isExport()) {
	$t_fasttag_expenses_list->StopRec = $t_fasttag_expenses_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_fasttag_expenses_list->TotalRecs > $t_fasttag_expenses_list->StartRec + $t_fasttag_expenses_list->DisplayRecs - 1)
		$t_fasttag_expenses_list->StopRec = $t_fasttag_expenses_list->StartRec + $t_fasttag_expenses_list->DisplayRecs - 1;
	else
		$t_fasttag_expenses_list->StopRec = $t_fasttag_expenses_list->TotalRecs;
}
$t_fasttag_expenses_list->RecCnt = $t_fasttag_expenses_list->StartRec - 1;
if ($t_fasttag_expenses_list->Recordset && !$t_fasttag_expenses_list->Recordset->EOF) {
	$t_fasttag_expenses_list->Recordset->moveFirst();
	$selectLimit = $t_fasttag_expenses_list->UseSelectLimit;
	if (!$selectLimit && $t_fasttag_expenses_list->StartRec > 1)
		$t_fasttag_expenses_list->Recordset->move($t_fasttag_expenses_list->StartRec - 1);
} elseif (!$t_fasttag_expenses->AllowAddDeleteRow && $t_fasttag_expenses_list->StopRec == 0) {
	$t_fasttag_expenses_list->StopRec = $t_fasttag_expenses->GridAddRowCount;
}

// Initialize aggregate
$t_fasttag_expenses->RowType = ROWTYPE_AGGREGATEINIT;
$t_fasttag_expenses->resetAttributes();
$t_fasttag_expenses_list->renderRow();
while ($t_fasttag_expenses_list->RecCnt < $t_fasttag_expenses_list->StopRec) {
	$t_fasttag_expenses_list->RecCnt++;
	if ($t_fasttag_expenses_list->RecCnt >= $t_fasttag_expenses_list->StartRec) {
		$t_fasttag_expenses_list->RowCnt++;

		// Set up key count
		$t_fasttag_expenses_list->KeyCount = $t_fasttag_expenses_list->RowIndex;

		// Init row class and style
		$t_fasttag_expenses->resetAttributes();
		$t_fasttag_expenses->CssClass = "";
		if ($t_fasttag_expenses->isGridAdd()) {
		} else {
			$t_fasttag_expenses_list->loadRowValues($t_fasttag_expenses_list->Recordset); // Load row values
		}
		$t_fasttag_expenses->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_fasttag_expenses->RowAttrs = array_merge($t_fasttag_expenses->RowAttrs, array('data-rowindex'=>$t_fasttag_expenses_list->RowCnt, 'id'=>'r' . $t_fasttag_expenses_list->RowCnt . '_t_fasttag_expenses', 'data-rowtype'=>$t_fasttag_expenses->RowType));

		// Render row
		$t_fasttag_expenses_list->renderRow();

		// Render list options
		$t_fasttag_expenses_list->renderListOptions();
?>
	<tr<?php echo $t_fasttag_expenses->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_fasttag_expenses_list->ListOptions->render("body", "left", $t_fasttag_expenses_list->RowCnt);
?>
	<?php if ($t_fasttag_expenses->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_fasttag_expenses->id->cellAttributes() ?>>
<span id="el<?php echo $t_fasttag_expenses_list->RowCnt ?>_t_fasttag_expenses_id" class="t_fasttag_expenses_id">
<span<?php echo $t_fasttag_expenses->id->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_fasttag_expenses->r_from->Visible) { // r_from ?>
		<td data-name="r_from"<?php echo $t_fasttag_expenses->r_from->cellAttributes() ?>>
<span id="el<?php echo $t_fasttag_expenses_list->RowCnt ?>_t_fasttag_expenses_r_from" class="t_fasttag_expenses_r_from">
<span<?php echo $t_fasttag_expenses->r_from->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->r_from->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_fasttag_expenses->vehicle_id->Visible) { // vehicle_id ?>
		<td data-name="vehicle_id"<?php echo $t_fasttag_expenses->vehicle_id->cellAttributes() ?>>
<span id="el<?php echo $t_fasttag_expenses_list->RowCnt ?>_t_fasttag_expenses_vehicle_id" class="t_fasttag_expenses_vehicle_id">
<span<?php echo $t_fasttag_expenses->vehicle_id->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->vehicle_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_fasttag_expenses->trip->Visible) { // trip ?>
		<td data-name="trip"<?php echo $t_fasttag_expenses->trip->cellAttributes() ?>>
<span id="el<?php echo $t_fasttag_expenses_list->RowCnt ?>_t_fasttag_expenses_trip" class="t_fasttag_expenses_trip">
<span<?php echo $t_fasttag_expenses->trip->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->trip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_fasttag_expenses->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $t_fasttag_expenses->amount->cellAttributes() ?>>
<span id="el<?php echo $t_fasttag_expenses_list->RowCnt ?>_t_fasttag_expenses_amount" class="t_fasttag_expenses_amount">
<span<?php echo $t_fasttag_expenses->amount->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_fasttag_expenses->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $t_fasttag_expenses->dated->cellAttributes() ?>>
<span id="el<?php echo $t_fasttag_expenses_list->RowCnt ?>_t_fasttag_expenses_dated" class="t_fasttag_expenses_dated">
<span<?php echo $t_fasttag_expenses->dated->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_fasttag_expenses->remakrs->Visible) { // remakrs ?>
		<td data-name="remakrs"<?php echo $t_fasttag_expenses->remakrs->cellAttributes() ?>>
<span id="el<?php echo $t_fasttag_expenses_list->RowCnt ?>_t_fasttag_expenses_remakrs" class="t_fasttag_expenses_remakrs">
<span<?php echo $t_fasttag_expenses->remakrs->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->remakrs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_fasttag_expenses->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $t_fasttag_expenses->uploads->cellAttributes() ?>>
<span id="el<?php echo $t_fasttag_expenses_list->RowCnt ?>_t_fasttag_expenses_uploads" class="t_fasttag_expenses_uploads">
<span<?php echo $t_fasttag_expenses->uploads->viewAttributes() ?>>
<?php echo GetFileViewTag($t_fasttag_expenses->uploads, $t_fasttag_expenses->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_fasttag_expenses->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $t_fasttag_expenses->operator->cellAttributes() ?>>
<span id="el<?php echo $t_fasttag_expenses_list->RowCnt ?>_t_fasttag_expenses_operator" class="t_fasttag_expenses_operator">
<span<?php echo $t_fasttag_expenses->operator->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_fasttag_expenses->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $t_fasttag_expenses->datetime->cellAttributes() ?>>
<span id="el<?php echo $t_fasttag_expenses_list->RowCnt ?>_t_fasttag_expenses_datetime" class="t_fasttag_expenses_datetime">
<span<?php echo $t_fasttag_expenses->datetime->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_fasttag_expenses_list->ListOptions->render("body", "right", $t_fasttag_expenses_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_fasttag_expenses->isGridAdd())
		$t_fasttag_expenses_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_fasttag_expenses->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_fasttag_expenses_list->Recordset)
	$t_fasttag_expenses_list->Recordset->Close();
?>
<?php if (!$t_fasttag_expenses->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_fasttag_expenses->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_fasttag_expenses_list->Pager)) $t_fasttag_expenses_list->Pager = new PrevNextPager($t_fasttag_expenses_list->StartRec, $t_fasttag_expenses_list->DisplayRecs, $t_fasttag_expenses_list->TotalRecs, $t_fasttag_expenses_list->AutoHidePager) ?>
<?php if ($t_fasttag_expenses_list->Pager->RecordCount > 0 && $t_fasttag_expenses_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_fasttag_expenses_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_fasttag_expenses_list->pageUrl() ?>start=<?php echo $t_fasttag_expenses_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_fasttag_expenses_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_fasttag_expenses_list->pageUrl() ?>start=<?php echo $t_fasttag_expenses_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_fasttag_expenses_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_fasttag_expenses_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_fasttag_expenses_list->pageUrl() ?>start=<?php echo $t_fasttag_expenses_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_fasttag_expenses_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_fasttag_expenses_list->pageUrl() ?>start=<?php echo $t_fasttag_expenses_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_fasttag_expenses_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_fasttag_expenses_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_fasttag_expenses_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_fasttag_expenses_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_fasttag_expenses_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_fasttag_expenses_list->TotalRecs > 0 && (!$t_fasttag_expenses_list->AutoHidePageSizeSelector || $t_fasttag_expenses_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_fasttag_expenses">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_fasttag_expenses_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_fasttag_expenses_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_fasttag_expenses_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_fasttag_expenses_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_fasttag_expenses_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_fasttag_expenses->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_fasttag_expenses_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_fasttag_expenses_list->TotalRecs == 0 && !$t_fasttag_expenses->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_fasttag_expenses_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_fasttag_expenses_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_fasttag_expenses->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_fasttag_expenses->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_fasttag_expenses", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_fasttag_expenses_list->terminate();
?>