<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_fasttag_expenses_view = new t_fasttag_expenses_view();

// Run the page
$t_fasttag_expenses_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_fasttag_expenses_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_fasttag_expenses->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_fasttag_expensesview = currentForm = new ew.Form("ft_fasttag_expensesview", "view");

// Form_CustomValidate event
ft_fasttag_expensesview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_fasttag_expensesview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_fasttag_expensesview.lists["x_r_from"] = <?php echo $t_fasttag_expenses_view->r_from->Lookup->toClientList() ?>;
ft_fasttag_expensesview.lists["x_r_from"].options = <?php echo JsonEncode($t_fasttag_expenses_view->r_from->lookupOptions()) ?>;
ft_fasttag_expensesview.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_fasttag_expensesview.lists["x_vehicle_id"] = <?php echo $t_fasttag_expenses_view->vehicle_id->Lookup->toClientList() ?>;
ft_fasttag_expensesview.lists["x_vehicle_id"].options = <?php echo JsonEncode($t_fasttag_expenses_view->vehicle_id->lookupOptions()) ?>;
ft_fasttag_expensesview.autoSuggests["x_vehicle_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_fasttag_expensesview.lists["x_trip"] = <?php echo $t_fasttag_expenses_view->trip->Lookup->toClientList() ?>;
ft_fasttag_expensesview.lists["x_trip"].options = <?php echo JsonEncode($t_fasttag_expenses_view->trip->lookupOptions()) ?>;
ft_fasttag_expensesview.lists["x_operator"] = <?php echo $t_fasttag_expenses_view->operator->Lookup->toClientList() ?>;
ft_fasttag_expensesview.lists["x_operator"].options = <?php echo JsonEncode($t_fasttag_expenses_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_fasttag_expenses->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_fasttag_expenses_view->ExportOptions->render("body") ?>
<?php $t_fasttag_expenses_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_fasttag_expenses_view->showPageHeader(); ?>
<?php
$t_fasttag_expenses_view->showMessage();
?>
<form name="ft_fasttag_expensesview" id="ft_fasttag_expensesview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_fasttag_expenses_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_fasttag_expenses_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_fasttag_expenses">
<input type="hidden" name="modal" value="<?php echo (int)$t_fasttag_expenses_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_fasttag_expenses->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_fasttag_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_fasttag_expenses_id"><?php echo $t_fasttag_expenses->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_fasttag_expenses->id->cellAttributes() ?>>
<span id="el_t_fasttag_expenses_id">
<span<?php echo $t_fasttag_expenses->id->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_fasttag_expenses->r_from->Visible) { // r_from ?>
	<tr id="r_r_from">
		<td class="<?php echo $t_fasttag_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_fasttag_expenses_r_from"><?php echo $t_fasttag_expenses->r_from->caption() ?></span></td>
		<td data-name="r_from"<?php echo $t_fasttag_expenses->r_from->cellAttributes() ?>>
<span id="el_t_fasttag_expenses_r_from">
<span<?php echo $t_fasttag_expenses->r_from->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->r_from->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_fasttag_expenses->vehicle_id->Visible) { // vehicle_id ?>
	<tr id="r_vehicle_id">
		<td class="<?php echo $t_fasttag_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_fasttag_expenses_vehicle_id"><?php echo $t_fasttag_expenses->vehicle_id->caption() ?></span></td>
		<td data-name="vehicle_id"<?php echo $t_fasttag_expenses->vehicle_id->cellAttributes() ?>>
<span id="el_t_fasttag_expenses_vehicle_id">
<span<?php echo $t_fasttag_expenses->vehicle_id->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->vehicle_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_fasttag_expenses->trip->Visible) { // trip ?>
	<tr id="r_trip">
		<td class="<?php echo $t_fasttag_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_fasttag_expenses_trip"><?php echo $t_fasttag_expenses->trip->caption() ?></span></td>
		<td data-name="trip"<?php echo $t_fasttag_expenses->trip->cellAttributes() ?>>
<span id="el_t_fasttag_expenses_trip">
<span<?php echo $t_fasttag_expenses->trip->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->trip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_fasttag_expenses->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $t_fasttag_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_fasttag_expenses_amount"><?php echo $t_fasttag_expenses->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $t_fasttag_expenses->amount->cellAttributes() ?>>
<span id="el_t_fasttag_expenses_amount">
<span<?php echo $t_fasttag_expenses->amount->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_fasttag_expenses->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $t_fasttag_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_fasttag_expenses_dated"><?php echo $t_fasttag_expenses->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $t_fasttag_expenses->dated->cellAttributes() ?>>
<span id="el_t_fasttag_expenses_dated">
<span<?php echo $t_fasttag_expenses->dated->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_fasttag_expenses->remakrs->Visible) { // remakrs ?>
	<tr id="r_remakrs">
		<td class="<?php echo $t_fasttag_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_fasttag_expenses_remakrs"><?php echo $t_fasttag_expenses->remakrs->caption() ?></span></td>
		<td data-name="remakrs"<?php echo $t_fasttag_expenses->remakrs->cellAttributes() ?>>
<span id="el_t_fasttag_expenses_remakrs">
<span<?php echo $t_fasttag_expenses->remakrs->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->remakrs->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_fasttag_expenses->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $t_fasttag_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_fasttag_expenses_uploads"><?php echo $t_fasttag_expenses->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $t_fasttag_expenses->uploads->cellAttributes() ?>>
<span id="el_t_fasttag_expenses_uploads">
<span<?php echo $t_fasttag_expenses->uploads->viewAttributes() ?>>
<?php echo GetFileViewTag($t_fasttag_expenses->uploads, $t_fasttag_expenses->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_fasttag_expenses->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_fasttag_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_fasttag_expenses_operator"><?php echo $t_fasttag_expenses->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_fasttag_expenses->operator->cellAttributes() ?>>
<span id="el_t_fasttag_expenses_operator">
<span<?php echo $t_fasttag_expenses->operator->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_fasttag_expenses->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_fasttag_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_fasttag_expenses_datetime"><?php echo $t_fasttag_expenses->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_fasttag_expenses->datetime->cellAttributes() ?>>
<span id="el_t_fasttag_expenses_datetime">
<span<?php echo $t_fasttag_expenses->datetime->viewAttributes() ?>>
<?php echo $t_fasttag_expenses->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_fasttag_expenses_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_fasttag_expenses->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_fasttag_expenses_view->terminate();
?>