<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_ledger_list = new t_ledger_list();

// Run the page
$t_ledger_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_ledger_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_ledger->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_ledgerlist = currentForm = new ew.Form("ft_ledgerlist", "list");
ft_ledgerlist.formKeyCountName = '<?php echo $t_ledger_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_ledgerlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_ledgerlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_ledgerlist.lists["x_trip"] = <?php echo $t_ledger_list->trip->Lookup->toClientList() ?>;
ft_ledgerlist.lists["x_trip"].options = <?php echo JsonEncode($t_ledger_list->trip->lookupOptions()) ?>;
ft_ledgerlist.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var ft_ledgerlistsrch = currentSearchForm = new ew.Form("ft_ledgerlistsrch");

// Validate function for search
ft_ledgerlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_ledger->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
ft_ledgerlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_ledgerlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

ft_ledgerlistsrch.filterList = <?php echo $t_ledger_list->getFilterList() ?>;

// Init search panel as collapsed
ft_ledgerlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_ledger->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_ledger_list->TotalRecs > 0 && $t_ledger_list->ExportOptions->visible()) { ?>
<?php $t_ledger_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_ledger_list->ImportOptions->visible()) { ?>
<?php $t_ledger_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_ledger_list->SearchOptions->visible()) { ?>
<?php $t_ledger_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_ledger_list->FilterOptions->visible()) { ?>
<?php $t_ledger_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_ledger_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_ledger->isExport() && !$t_ledger->CurrentAction) { ?>
<form name="ft_ledgerlistsrch" id="ft_ledgerlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_ledger_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_ledgerlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_ledger">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$t_ledger_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$t_ledger->RowType = ROWTYPE_SEARCH;

// Render row
$t_ledger->resetAttributes();
$t_ledger_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($t_ledger->dated->Visible) { // dated ?>
	<div id="xsc_dated" class="ew-cell form-group">
		<label for="x_dated" class="ew-search-caption ew-label"><?php echo $t_ledger->dated->caption() ?></label>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_ledger->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_ledger->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_ledger->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_ledger->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_ledger->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_ledger->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($t_ledger->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="t_ledger" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_ledger->dated->getPlaceHolder()) ?>" value="<?php echo $t_ledger->dated->EditValue ?>"<?php echo $t_ledger->dated->editAttributes() ?>>
<?php if (!$t_ledger->dated->ReadOnly && !$t_ledger->dated->Disabled && !isset($t_ledger->dated->EditAttrs["readonly"]) && !isset($t_ledger->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_ledgerlistsrch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_dated style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_dated style="d-none"">
<input type="text" data-table="t_ledger" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($t_ledger->dated->getPlaceHolder()) ?>" value="<?php echo $t_ledger->dated->EditValue2 ?>"<?php echo $t_ledger->dated->editAttributes() ?>>
<?php if (!$t_ledger->dated->ReadOnly && !$t_ledger->dated->Disabled && !isset($t_ledger->dated->EditAttrs["readonly"]) && !isset($t_ledger->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_ledgerlistsrch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
<?php if ($t_ledger->name->Visible) { // name ?>
	<div id="xsc_name" class="ew-cell form-group">
		<label for="x_name" class="ew-search-caption ew-label"><?php echo $t_ledger->name->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="t_ledger" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="105" placeholder="<?php echo HtmlEncode($t_ledger->name->getPlaceHolder()) ?>" value="<?php echo $t_ledger->name->EditValue ?>"<?php echo $t_ledger->name->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($t_ledger->ref->Visible) { // ref ?>
	<div id="xsc_ref" class="ew-cell form-group">
		<label for="x_ref" class="ew-search-caption ew-label"><?php echo $t_ledger->ref->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="t_ledger" data-field="x_ref" name="x_ref" id="x_ref" size="30" maxlength="105" placeholder="<?php echo HtmlEncode($t_ledger->ref->getPlaceHolder()) ?>" value="<?php echo $t_ledger->ref->EditValue ?>"<?php echo $t_ledger->ref->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_ledger_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_ledger_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_ledger_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_ledger_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_ledger_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_ledger_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_ledger_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_ledger_list->showPageHeader(); ?>
<?php
$t_ledger_list->showMessage();
?>
<?php if ($t_ledger_list->TotalRecs > 0 || $t_ledger->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_ledger_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_ledger">
<?php if (!$t_ledger->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_ledger->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_ledger_list->Pager)) $t_ledger_list->Pager = new PrevNextPager($t_ledger_list->StartRec, $t_ledger_list->DisplayRecs, $t_ledger_list->TotalRecs, $t_ledger_list->AutoHidePager) ?>
<?php if ($t_ledger_list->Pager->RecordCount > 0 && $t_ledger_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_ledger_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_ledger_list->pageUrl() ?>start=<?php echo $t_ledger_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_ledger_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_ledger_list->pageUrl() ?>start=<?php echo $t_ledger_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_ledger_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_ledger_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_ledger_list->pageUrl() ?>start=<?php echo $t_ledger_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_ledger_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_ledger_list->pageUrl() ?>start=<?php echo $t_ledger_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_ledger_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_ledger_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_ledger_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_ledger_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_ledger_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_ledger_list->TotalRecs > 0 && (!$t_ledger_list->AutoHidePageSizeSelector || $t_ledger_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_ledger">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_ledger_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_ledger_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_ledger_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_ledger_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_ledger_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_ledger->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_ledger_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_ledgerlist" id="ft_ledgerlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_ledger_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_ledger_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_ledger">
<div id="gmp_t_ledger" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_ledger_list->TotalRecs > 0 || $t_ledger->isGridEdit()) { ?>
<table id="tbl_t_ledgerlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_ledger_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_ledger_list->renderListOptions();

// Render list options (header, left)
$t_ledger_list->ListOptions->render("header", "left");
?>
<?php if ($t_ledger->uid->Visible) { // uid ?>
	<?php if ($t_ledger->sortUrl($t_ledger->uid) == "") { ?>
		<th data-name="uid" class="<?php echo $t_ledger->uid->headerCellClass() ?>"><div id="elh_t_ledger_uid" class="t_ledger_uid"><div class="ew-table-header-caption"><?php echo $t_ledger->uid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uid" class="<?php echo $t_ledger->uid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_ledger->SortUrl($t_ledger->uid) ?>',2);"><div id="elh_t_ledger_uid" class="t_ledger_uid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_ledger->uid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_ledger->uid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_ledger->uid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_ledger->dated->Visible) { // dated ?>
	<?php if ($t_ledger->sortUrl($t_ledger->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $t_ledger->dated->headerCellClass() ?>"><div id="elh_t_ledger_dated" class="t_ledger_dated"><div class="ew-table-header-caption"><?php echo $t_ledger->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $t_ledger->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_ledger->SortUrl($t_ledger->dated) ?>',2);"><div id="elh_t_ledger_dated" class="t_ledger_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_ledger->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_ledger->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_ledger->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_ledger->name->Visible) { // name ?>
	<?php if ($t_ledger->sortUrl($t_ledger->name) == "") { ?>
		<th data-name="name" class="<?php echo $t_ledger->name->headerCellClass() ?>"><div id="elh_t_ledger_name" class="t_ledger_name"><div class="ew-table-header-caption"><?php echo $t_ledger->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $t_ledger->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_ledger->SortUrl($t_ledger->name) ?>',2);"><div id="elh_t_ledger_name" class="t_ledger_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_ledger->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_ledger->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_ledger->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_ledger->Balance->Visible) { // Balance ?>
	<?php if ($t_ledger->sortUrl($t_ledger->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $t_ledger->Balance->headerCellClass() ?>"><div id="elh_t_ledger_Balance" class="t_ledger_Balance"><div class="ew-table-header-caption"><?php echo $t_ledger->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $t_ledger->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_ledger->SortUrl($t_ledger->Balance) ?>',2);"><div id="elh_t_ledger_Balance" class="t_ledger_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_ledger->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_ledger->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_ledger->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_ledger->cumulative_sum->Visible) { // cumulative_sum ?>
	<?php if ($t_ledger->sortUrl($t_ledger->cumulative_sum) == "") { ?>
		<th data-name="cumulative_sum" class="<?php echo $t_ledger->cumulative_sum->headerCellClass() ?>"><div id="elh_t_ledger_cumulative_sum" class="t_ledger_cumulative_sum"><div class="ew-table-header-caption"><?php echo $t_ledger->cumulative_sum->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cumulative_sum" class="<?php echo $t_ledger->cumulative_sum->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_ledger->SortUrl($t_ledger->cumulative_sum) ?>',2);"><div id="elh_t_ledger_cumulative_sum" class="t_ledger_cumulative_sum">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_ledger->cumulative_sum->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_ledger->cumulative_sum->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_ledger->cumulative_sum->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_ledger->trip->Visible) { // trip ?>
	<?php if ($t_ledger->sortUrl($t_ledger->trip) == "") { ?>
		<th data-name="trip" class="<?php echo $t_ledger->trip->headerCellClass() ?>"><div id="elh_t_ledger_trip" class="t_ledger_trip"><div class="ew-table-header-caption"><?php echo $t_ledger->trip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="trip" class="<?php echo $t_ledger->trip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_ledger->SortUrl($t_ledger->trip) ?>',2);"><div id="elh_t_ledger_trip" class="t_ledger_trip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_ledger->trip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_ledger->trip->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_ledger->trip->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_ledger->ref->Visible) { // ref ?>
	<?php if ($t_ledger->sortUrl($t_ledger->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $t_ledger->ref->headerCellClass() ?>"><div id="elh_t_ledger_ref" class="t_ledger_ref"><div class="ew-table-header-caption"><?php echo $t_ledger->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $t_ledger->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_ledger->SortUrl($t_ledger->ref) ?>',2);"><div id="elh_t_ledger_ref" class="t_ledger_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_ledger->ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_ledger->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_ledger->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_ledger->remarks->Visible) { // remarks ?>
	<?php if ($t_ledger->sortUrl($t_ledger->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $t_ledger->remarks->headerCellClass() ?>"><div id="elh_t_ledger_remarks" class="t_ledger_remarks"><div class="ew-table-header-caption"><?php echo $t_ledger->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $t_ledger->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_ledger->SortUrl($t_ledger->remarks) ?>',2);"><div id="elh_t_ledger_remarks" class="t_ledger_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_ledger->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_ledger->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_ledger->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_ledger->uploads->Visible) { // uploads ?>
	<?php if ($t_ledger->sortUrl($t_ledger->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $t_ledger->uploads->headerCellClass() ?>"><div id="elh_t_ledger_uploads" class="t_ledger_uploads"><div class="ew-table-header-caption"><?php echo $t_ledger->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $t_ledger->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_ledger->SortUrl($t_ledger->uploads) ?>',2);"><div id="elh_t_ledger_uploads" class="t_ledger_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_ledger->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_ledger->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_ledger->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_ledger_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_ledger->ExportAll && $t_ledger->isExport()) {
	$t_ledger_list->StopRec = $t_ledger_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_ledger_list->TotalRecs > $t_ledger_list->StartRec + $t_ledger_list->DisplayRecs - 1)
		$t_ledger_list->StopRec = $t_ledger_list->StartRec + $t_ledger_list->DisplayRecs - 1;
	else
		$t_ledger_list->StopRec = $t_ledger_list->TotalRecs;
}
$t_ledger_list->RecCnt = $t_ledger_list->StartRec - 1;
if ($t_ledger_list->Recordset && !$t_ledger_list->Recordset->EOF) {
	$t_ledger_list->Recordset->moveFirst();
	$selectLimit = $t_ledger_list->UseSelectLimit;
	if (!$selectLimit && $t_ledger_list->StartRec > 1)
		$t_ledger_list->Recordset->move($t_ledger_list->StartRec - 1);
} elseif (!$t_ledger->AllowAddDeleteRow && $t_ledger_list->StopRec == 0) {
	$t_ledger_list->StopRec = $t_ledger->GridAddRowCount;
}

// Initialize aggregate
$t_ledger->RowType = ROWTYPE_AGGREGATEINIT;
$t_ledger->resetAttributes();
$t_ledger_list->renderRow();
while ($t_ledger_list->RecCnt < $t_ledger_list->StopRec) {
	$t_ledger_list->RecCnt++;
	if ($t_ledger_list->RecCnt >= $t_ledger_list->StartRec) {
		$t_ledger_list->RowCnt++;

		// Set up key count
		$t_ledger_list->KeyCount = $t_ledger_list->RowIndex;

		// Init row class and style
		$t_ledger->resetAttributes();
		$t_ledger->CssClass = "";
		if ($t_ledger->isGridAdd()) {
		} else {
			$t_ledger_list->loadRowValues($t_ledger_list->Recordset); // Load row values
		}
		$t_ledger->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_ledger->RowAttrs = array_merge($t_ledger->RowAttrs, array('data-rowindex'=>$t_ledger_list->RowCnt, 'id'=>'r' . $t_ledger_list->RowCnt . '_t_ledger', 'data-rowtype'=>$t_ledger->RowType));

		// Render row
		$t_ledger_list->renderRow();

		// Render list options
		$t_ledger_list->renderListOptions();
?>
	<tr<?php echo $t_ledger->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_ledger_list->ListOptions->render("body", "left", $t_ledger_list->RowCnt);
?>
	<?php if ($t_ledger->uid->Visible) { // uid ?>
		<td data-name="uid"<?php echo $t_ledger->uid->cellAttributes() ?>>
<span id="el<?php echo $t_ledger_list->RowCnt ?>_t_ledger_uid" class="t_ledger_uid">
<span<?php echo $t_ledger->uid->viewAttributes() ?>>
<?php echo $t_ledger->uid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_ledger->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $t_ledger->dated->cellAttributes() ?>>
<span id="el<?php echo $t_ledger_list->RowCnt ?>_t_ledger_dated" class="t_ledger_dated">
<span<?php echo $t_ledger->dated->viewAttributes() ?>>
<?php if ((!EmptyString($t_ledger->dated->getViewValue())) && $t_ledger->dated->linkAttributes() <> "") { ?>
<a<?php echo $t_ledger->dated->linkAttributes() ?>><?php echo $t_ledger->dated->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_ledger->dated->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_ledger->name->Visible) { // name ?>
		<td data-name="name"<?php echo $t_ledger->name->cellAttributes() ?>>
<span id="el<?php echo $t_ledger_list->RowCnt ?>_t_ledger_name" class="t_ledger_name">
<span<?php echo $t_ledger->name->viewAttributes() ?>>
<?php if ((!EmptyString($t_ledger->name->getViewValue())) && $t_ledger->name->linkAttributes() <> "") { ?>
<a<?php echo $t_ledger->name->linkAttributes() ?>><?php echo $t_ledger->name->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_ledger->name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_ledger->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $t_ledger->Balance->cellAttributes() ?>>
<span id="el<?php echo $t_ledger_list->RowCnt ?>_t_ledger_Balance" class="t_ledger_Balance">
<span<?php echo $t_ledger->Balance->viewAttributes() ?>>
<?php echo $t_ledger->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_ledger->cumulative_sum->Visible) { // cumulative_sum ?>
		<td data-name="cumulative_sum"<?php echo $t_ledger->cumulative_sum->cellAttributes() ?>>
<span id="el<?php echo $t_ledger_list->RowCnt ?>_t_ledger_cumulative_sum" class="t_ledger_cumulative_sum">
<span<?php echo $t_ledger->cumulative_sum->viewAttributes() ?>>
<?php echo $t_ledger->cumulative_sum->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_ledger->trip->Visible) { // trip ?>
		<td data-name="trip"<?php echo $t_ledger->trip->cellAttributes() ?>>
<span id="el<?php echo $t_ledger_list->RowCnt ?>_t_ledger_trip" class="t_ledger_trip">
<span<?php echo $t_ledger->trip->viewAttributes() ?>>
<?php if ((!EmptyString($t_ledger->trip->getViewValue())) && $t_ledger->trip->linkAttributes() <> "") { ?>
<a<?php echo $t_ledger->trip->linkAttributes() ?>><?php echo $t_ledger->trip->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_ledger->trip->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_ledger->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $t_ledger->ref->cellAttributes() ?>>
<span id="el<?php echo $t_ledger_list->RowCnt ?>_t_ledger_ref" class="t_ledger_ref">
<span<?php echo $t_ledger->ref->viewAttributes() ?>>
<?php if ((!EmptyString($t_ledger->ref->getViewValue())) && $t_ledger->ref->linkAttributes() <> "") { ?>
<a<?php echo $t_ledger->ref->linkAttributes() ?>><?php echo $t_ledger->ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_ledger->ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_ledger->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $t_ledger->remarks->cellAttributes() ?>>
<span id="el<?php echo $t_ledger_list->RowCnt ?>_t_ledger_remarks" class="t_ledger_remarks">
<span<?php echo $t_ledger->remarks->viewAttributes() ?>>
<?php echo $t_ledger->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_ledger->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $t_ledger->uploads->cellAttributes() ?>>
<span id="el<?php echo $t_ledger_list->RowCnt ?>_t_ledger_uploads" class="t_ledger_uploads">
<span>
<?php echo GetFileViewTag($t_ledger->uploads, $t_ledger->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_ledger_list->ListOptions->render("body", "right", $t_ledger_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_ledger->isGridAdd())
		$t_ledger_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$t_ledger->RowType = ROWTYPE_AGGREGATE;
$t_ledger->resetAttributes();
$t_ledger_list->renderRow();
?>
<?php if ($t_ledger_list->TotalRecs > 0 && !$t_ledger->isGridAdd() && !$t_ledger->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$t_ledger_list->renderListOptions();

// Render list options (footer, left)
$t_ledger_list->ListOptions->render("footer", "left");
?>
	<?php if ($t_ledger->uid->Visible) { // uid ?>
		<td data-name="uid" class="<?php echo $t_ledger->uid->footerCellClass() ?>"><span id="elf_t_ledger_uid" class="t_ledger_uid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_ledger->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $t_ledger->dated->footerCellClass() ?>"><span id="elf_t_ledger_dated" class="t_ledger_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_ledger->name->Visible) { // name ?>
		<td data-name="name" class="<?php echo $t_ledger->name->footerCellClass() ?>"><span id="elf_t_ledger_name" class="t_ledger_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_ledger->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $t_ledger->Balance->footerCellClass() ?>"><span id="elf_t_ledger_Balance" class="t_ledger_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $t_ledger->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($t_ledger->cumulative_sum->Visible) { // cumulative_sum ?>
		<td data-name="cumulative_sum" class="<?php echo $t_ledger->cumulative_sum->footerCellClass() ?>"><span id="elf_t_ledger_cumulative_sum" class="t_ledger_cumulative_sum">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_ledger->trip->Visible) { // trip ?>
		<td data-name="trip" class="<?php echo $t_ledger->trip->footerCellClass() ?>"><span id="elf_t_ledger_trip" class="t_ledger_trip">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_ledger->ref->Visible) { // ref ?>
		<td data-name="ref" class="<?php echo $t_ledger->ref->footerCellClass() ?>"><span id="elf_t_ledger_ref" class="t_ledger_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_ledger->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $t_ledger->remarks->footerCellClass() ?>"><span id="elf_t_ledger_remarks" class="t_ledger_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_ledger->uploads->Visible) { // uploads ?>
		<td data-name="uploads" class="<?php echo $t_ledger->uploads->footerCellClass() ?>"><span id="elf_t_ledger_uploads" class="t_ledger_uploads">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$t_ledger_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_ledger->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_ledger_list->Recordset)
	$t_ledger_list->Recordset->Close();
?>
<?php if (!$t_ledger->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_ledger->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_ledger_list->Pager)) $t_ledger_list->Pager = new PrevNextPager($t_ledger_list->StartRec, $t_ledger_list->DisplayRecs, $t_ledger_list->TotalRecs, $t_ledger_list->AutoHidePager) ?>
<?php if ($t_ledger_list->Pager->RecordCount > 0 && $t_ledger_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_ledger_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_ledger_list->pageUrl() ?>start=<?php echo $t_ledger_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_ledger_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_ledger_list->pageUrl() ?>start=<?php echo $t_ledger_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_ledger_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_ledger_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_ledger_list->pageUrl() ?>start=<?php echo $t_ledger_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_ledger_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_ledger_list->pageUrl() ?>start=<?php echo $t_ledger_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_ledger_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_ledger_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_ledger_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_ledger_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_ledger_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_ledger_list->TotalRecs > 0 && (!$t_ledger_list->AutoHidePageSizeSelector || $t_ledger_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_ledger">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_ledger_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_ledger_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_ledger_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_ledger_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_ledger_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_ledger->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_ledger_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_ledger_list->TotalRecs == 0 && !$t_ledger->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_ledger_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_ledger_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_ledger->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_ledger->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_ledger", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_ledger_list->terminate();
?>