<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_ledger_search = new t_ledger_search();

// Run the page
$t_ledger_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_ledger_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_ledger_search->IsModal) { ?>
var ft_ledgersearch = currentAdvancedSearchForm = new ew.Form("ft_ledgersearch", "search");
<?php } else { ?>
var ft_ledgersearch = currentForm = new ew.Form("ft_ledgersearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_ledgersearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_ledgersearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_ledgersearch.lists["x_trip"] = <?php echo $t_ledger_search->trip->Lookup->toClientList() ?>;
ft_ledgersearch.lists["x_trip"].options = <?php echo JsonEncode($t_ledger_search->trip->lookupOptions()) ?>;
ft_ledgersearch.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

ft_ledgersearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_uid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_ledger->uid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_ledger->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_ledger->Balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cumulative_sum");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_ledger->cumulative_sum->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_trip");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_ledger->trip->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_ledger_search->showPageHeader(); ?>
<?php
$t_ledger_search->showMessage();
?>
<form name="ft_ledgersearch" id="ft_ledgersearch" class="<?php echo $t_ledger_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_ledger_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_ledger_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_ledger">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_ledger_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_ledger->uid->Visible) { // uid ?>
	<div id="r_uid" class="form-group row">
		<label for="x_uid" class="<?php echo $t_ledger_search->LeftColumnClass ?>"><span id="elh_t_ledger_uid"><?php echo $t_ledger->uid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_uid" id="z_uid" value="="></span>
		</label>
		<div class="<?php echo $t_ledger_search->RightColumnClass ?>"><div<?php echo $t_ledger->uid->cellAttributes() ?>>
			<span id="el_t_ledger_uid">
<input type="text" data-table="t_ledger" data-field="x_uid" name="x_uid" id="x_uid" placeholder="<?php echo HtmlEncode($t_ledger->uid->getPlaceHolder()) ?>" value="<?php echo $t_ledger->uid->EditValue ?>"<?php echo $t_ledger->uid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_ledger->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $t_ledger_search->LeftColumnClass ?>"><span id="elh_t_ledger_dated"><?php echo $t_ledger->dated->caption() ?></span>
		</label>
		<div class="<?php echo $t_ledger_search->RightColumnClass ?>"><div<?php echo $t_ledger->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_ledger->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_ledger->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_ledger->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_ledger->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_ledger->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_ledger->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($t_ledger->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_ledger_dated">
<input type="text" data-table="t_ledger" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_ledger->dated->getPlaceHolder()) ?>" value="<?php echo $t_ledger->dated->EditValue ?>"<?php echo $t_ledger->dated->editAttributes() ?>>
<?php if (!$t_ledger->dated->ReadOnly && !$t_ledger->dated->Disabled && !isset($t_ledger->dated->EditAttrs["readonly"]) && !isset($t_ledger->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_ledgersearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_ledger_dated" class="btw1_dated d-none">
<input type="text" data-table="t_ledger" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($t_ledger->dated->getPlaceHolder()) ?>" value="<?php echo $t_ledger->dated->EditValue2 ?>"<?php echo $t_ledger->dated->editAttributes() ?>>
<?php if (!$t_ledger->dated->ReadOnly && !$t_ledger->dated->Disabled && !isset($t_ledger->dated->EditAttrs["readonly"]) && !isset($t_ledger->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_ledgersearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_ledger->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $t_ledger_search->LeftColumnClass ?>"><span id="elh_t_ledger_name"><?php echo $t_ledger->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_ledger_search->RightColumnClass ?>"><div<?php echo $t_ledger->name->cellAttributes() ?>>
			<span id="el_t_ledger_name">
<input type="text" data-table="t_ledger" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="105" placeholder="<?php echo HtmlEncode($t_ledger->name->getPlaceHolder()) ?>" value="<?php echo $t_ledger->name->EditValue ?>"<?php echo $t_ledger->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_ledger->Balance->Visible) { // Balance ?>
	<div id="r_Balance" class="form-group row">
		<label for="x_Balance" class="<?php echo $t_ledger_search->LeftColumnClass ?>"><span id="elh_t_ledger_Balance"><?php echo $t_ledger->Balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Balance" id="z_Balance" value="="></span>
		</label>
		<div class="<?php echo $t_ledger_search->RightColumnClass ?>"><div<?php echo $t_ledger->Balance->cellAttributes() ?>>
			<span id="el_t_ledger_Balance">
<input type="text" data-table="t_ledger" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($t_ledger->Balance->getPlaceHolder()) ?>" value="<?php echo $t_ledger->Balance->EditValue ?>"<?php echo $t_ledger->Balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_ledger->cumulative_sum->Visible) { // cumulative_sum ?>
	<div id="r_cumulative_sum" class="form-group row">
		<label for="x_cumulative_sum" class="<?php echo $t_ledger_search->LeftColumnClass ?>"><span id="elh_t_ledger_cumulative_sum"><?php echo $t_ledger->cumulative_sum->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cumulative_sum" id="z_cumulative_sum" value="="></span>
		</label>
		<div class="<?php echo $t_ledger_search->RightColumnClass ?>"><div<?php echo $t_ledger->cumulative_sum->cellAttributes() ?>>
			<span id="el_t_ledger_cumulative_sum">
<input type="text" data-table="t_ledger" data-field="x_cumulative_sum" name="x_cumulative_sum" id="x_cumulative_sum" size="30" placeholder="<?php echo HtmlEncode($t_ledger->cumulative_sum->getPlaceHolder()) ?>" value="<?php echo $t_ledger->cumulative_sum->EditValue ?>"<?php echo $t_ledger->cumulative_sum->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_ledger->trip->Visible) { // trip ?>
	<div id="r_trip" class="form-group row">
		<label class="<?php echo $t_ledger_search->LeftColumnClass ?>"><span id="elh_t_ledger_trip"><?php echo $t_ledger->trip->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_trip" id="z_trip" value="="></span>
		</label>
		<div class="<?php echo $t_ledger_search->RightColumnClass ?>"><div<?php echo $t_ledger->trip->cellAttributes() ?>>
			<span id="el_t_ledger_trip">
<?php
$wrkonchange = "" . trim(@$t_ledger->trip->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_ledger->trip->EditAttrs["onchange"] = "";
?>
<span id="as_x_trip" class="text-nowrap" style="z-index: 8940">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_trip" id="sv_x_trip" value="<?php echo RemoveHtml($t_ledger->trip->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_ledger->trip->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_ledger->trip->getPlaceHolder()) ?>"<?php echo $t_ledger->trip->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_ledger->trip->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_trip',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_ledger->trip->ReadOnly || $t_ledger->trip->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_ledger" data-field="x_trip" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_ledger->trip->displayValueSeparatorAttribute() ?>" name="x_trip" id="x_trip" value="<?php echo HtmlEncode($t_ledger->trip->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_ledgersearch.createAutoSuggest({"id":"x_trip","forceSelect":true});
</script>
<?php echo $t_ledger->trip->Lookup->getParamTag("p_x_trip") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_ledger->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label for="x_ref" class="<?php echo $t_ledger_search->LeftColumnClass ?>"><span id="elh_t_ledger_ref"><?php echo $t_ledger->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_ledger_search->RightColumnClass ?>"><div<?php echo $t_ledger->ref->cellAttributes() ?>>
			<span id="el_t_ledger_ref">
<input type="text" data-table="t_ledger" data-field="x_ref" name="x_ref" id="x_ref" size="30" maxlength="105" placeholder="<?php echo HtmlEncode($t_ledger->ref->getPlaceHolder()) ?>" value="<?php echo $t_ledger->ref->EditValue ?>"<?php echo $t_ledger->ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_ledger->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $t_ledger_search->LeftColumnClass ?>"><span id="elh_t_ledger_remarks"><?php echo $t_ledger->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_ledger_search->RightColumnClass ?>"><div<?php echo $t_ledger->remarks->cellAttributes() ?>>
			<span id="el_t_ledger_remarks">
<input type="text" data-table="t_ledger" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_ledger->remarks->getPlaceHolder()) ?>" value="<?php echo $t_ledger->remarks->EditValue ?>"<?php echo $t_ledger->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_ledger->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $t_ledger_search->LeftColumnClass ?>"><span id="elh_t_ledger_uploads"><?php echo $t_ledger->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_ledger_search->RightColumnClass ?>"><div<?php echo $t_ledger->uploads->cellAttributes() ?>>
			<span id="el_t_ledger_uploads">
<input type="text" data-table="t_ledger" data-field="x_uploads" name="x_uploads" id="x_uploads" placeholder="<?php echo HtmlEncode($t_ledger->uploads->getPlaceHolder()) ?>" value="<?php echo $t_ledger->uploads->EditValue ?>"<?php echo $t_ledger->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_ledger_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_ledger_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_ledger_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_ledger_search->terminate();
?>