<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_maintenance_exp_delete = new t_maintenance_exp_delete();

// Run the page
$t_maintenance_exp_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_maintenance_exp_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var ft_maintenance_expdelete = currentForm = new ew.Form("ft_maintenance_expdelete", "delete");

// Form_CustomValidate event
ft_maintenance_expdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_maintenance_expdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_maintenance_expdelete.lists["x_vehicle_no"] = <?php echo $t_maintenance_exp_delete->vehicle_no->Lookup->toClientList() ?>;
ft_maintenance_expdelete.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_maintenance_exp_delete->vehicle_no->lookupOptions()) ?>;
ft_maintenance_expdelete.lists["x_r_from"] = <?php echo $t_maintenance_exp_delete->r_from->Lookup->toClientList() ?>;
ft_maintenance_expdelete.lists["x_r_from"].options = <?php echo JsonEncode($t_maintenance_exp_delete->r_from->lookupOptions()) ?>;
ft_maintenance_expdelete.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_maintenance_expdelete.lists["x_expense_type"] = <?php echo $t_maintenance_exp_delete->expense_type->Lookup->toClientList() ?>;
ft_maintenance_expdelete.lists["x_expense_type"].options = <?php echo JsonEncode($t_maintenance_exp_delete->expense_type->lookupOptions()) ?>;
ft_maintenance_expdelete.lists["x_expense_sub_type"] = <?php echo $t_maintenance_exp_delete->expense_sub_type->Lookup->toClientList() ?>;
ft_maintenance_expdelete.lists["x_expense_sub_type"].options = <?php echo JsonEncode($t_maintenance_exp_delete->expense_sub_type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_maintenance_exp_delete->showPageHeader(); ?>
<?php
$t_maintenance_exp_delete->showMessage();
?>
<form name="ft_maintenance_expdelete" id="ft_maintenance_expdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_maintenance_exp_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_maintenance_exp_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_maintenance_exp">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($t_maintenance_exp_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($t_maintenance_exp->id->Visible) { // id ?>
		<th class="<?php echo $t_maintenance_exp->id->headerCellClass() ?>"><span id="elh_t_maintenance_exp_id" class="t_maintenance_exp_id"><?php echo $t_maintenance_exp->id->caption() ?></span></th>
<?php } ?>
<?php if ($t_maintenance_exp->vehicle_no->Visible) { // vehicle_no ?>
		<th class="<?php echo $t_maintenance_exp->vehicle_no->headerCellClass() ?>"><span id="elh_t_maintenance_exp_vehicle_no" class="t_maintenance_exp_vehicle_no"><?php echo $t_maintenance_exp->vehicle_no->caption() ?></span></th>
<?php } ?>
<?php if ($t_maintenance_exp->r_from->Visible) { // r_from ?>
		<th class="<?php echo $t_maintenance_exp->r_from->headerCellClass() ?>"><span id="elh_t_maintenance_exp_r_from" class="t_maintenance_exp_r_from"><?php echo $t_maintenance_exp->r_from->caption() ?></span></th>
<?php } ?>
<?php if ($t_maintenance_exp->expense_type->Visible) { // expense_type ?>
		<th class="<?php echo $t_maintenance_exp->expense_type->headerCellClass() ?>"><span id="elh_t_maintenance_exp_expense_type" class="t_maintenance_exp_expense_type"><?php echo $t_maintenance_exp->expense_type->caption() ?></span></th>
<?php } ?>
<?php if ($t_maintenance_exp->expense_sub_type->Visible) { // expense_sub_type ?>
		<th class="<?php echo $t_maintenance_exp->expense_sub_type->headerCellClass() ?>"><span id="elh_t_maintenance_exp_expense_sub_type" class="t_maintenance_exp_expense_sub_type"><?php echo $t_maintenance_exp->expense_sub_type->caption() ?></span></th>
<?php } ?>
<?php if ($t_maintenance_exp->amount->Visible) { // amount ?>
		<th class="<?php echo $t_maintenance_exp->amount->headerCellClass() ?>"><span id="elh_t_maintenance_exp_amount" class="t_maintenance_exp_amount"><?php echo $t_maintenance_exp->amount->caption() ?></span></th>
<?php } ?>
<?php if ($t_maintenance_exp->dated->Visible) { // dated ?>
		<th class="<?php echo $t_maintenance_exp->dated->headerCellClass() ?>"><span id="elh_t_maintenance_exp_dated" class="t_maintenance_exp_dated"><?php echo $t_maintenance_exp->dated->caption() ?></span></th>
<?php } ?>
<?php if ($t_maintenance_exp->remarks->Visible) { // remarks ?>
		<th class="<?php echo $t_maintenance_exp->remarks->headerCellClass() ?>"><span id="elh_t_maintenance_exp_remarks" class="t_maintenance_exp_remarks"><?php echo $t_maintenance_exp->remarks->caption() ?></span></th>
<?php } ?>
<?php if ($t_maintenance_exp->uploads->Visible) { // uploads ?>
		<th class="<?php echo $t_maintenance_exp->uploads->headerCellClass() ?>"><span id="elh_t_maintenance_exp_uploads" class="t_maintenance_exp_uploads"><?php echo $t_maintenance_exp->uploads->caption() ?></span></th>
<?php } ?>
<?php if ($t_maintenance_exp->operator->Visible) { // operator ?>
		<th class="<?php echo $t_maintenance_exp->operator->headerCellClass() ?>"><span id="elh_t_maintenance_exp_operator" class="t_maintenance_exp_operator"><?php echo $t_maintenance_exp->operator->caption() ?></span></th>
<?php } ?>
<?php if ($t_maintenance_exp->datetime->Visible) { // datetime ?>
		<th class="<?php echo $t_maintenance_exp->datetime->headerCellClass() ?>"><span id="elh_t_maintenance_exp_datetime" class="t_maintenance_exp_datetime"><?php echo $t_maintenance_exp->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$t_maintenance_exp_delete->RecCnt = 0;
$i = 0;
while (!$t_maintenance_exp_delete->Recordset->EOF) {
	$t_maintenance_exp_delete->RecCnt++;
	$t_maintenance_exp_delete->RowCnt++;

	// Set row properties
	$t_maintenance_exp->resetAttributes();
	$t_maintenance_exp->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$t_maintenance_exp_delete->loadRowValues($t_maintenance_exp_delete->Recordset);

	// Render row
	$t_maintenance_exp_delete->renderRow();
?>
	<tr<?php echo $t_maintenance_exp->rowAttributes() ?>>
<?php if ($t_maintenance_exp->id->Visible) { // id ?>
		<td<?php echo $t_maintenance_exp->id->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_delete->RowCnt ?>_t_maintenance_exp_id" class="t_maintenance_exp_id">
<span<?php echo $t_maintenance_exp->id->viewAttributes() ?>>
<?php echo $t_maintenance_exp->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_maintenance_exp->vehicle_no->Visible) { // vehicle_no ?>
		<td<?php echo $t_maintenance_exp->vehicle_no->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_delete->RowCnt ?>_t_maintenance_exp_vehicle_no" class="t_maintenance_exp_vehicle_no">
<span<?php echo $t_maintenance_exp->vehicle_no->viewAttributes() ?>>
<?php echo $t_maintenance_exp->vehicle_no->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_maintenance_exp->r_from->Visible) { // r_from ?>
		<td<?php echo $t_maintenance_exp->r_from->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_delete->RowCnt ?>_t_maintenance_exp_r_from" class="t_maintenance_exp_r_from">
<span<?php echo $t_maintenance_exp->r_from->viewAttributes() ?>>
<?php echo $t_maintenance_exp->r_from->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_maintenance_exp->expense_type->Visible) { // expense_type ?>
		<td<?php echo $t_maintenance_exp->expense_type->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_delete->RowCnt ?>_t_maintenance_exp_expense_type" class="t_maintenance_exp_expense_type">
<span<?php echo $t_maintenance_exp->expense_type->viewAttributes() ?>>
<?php echo $t_maintenance_exp->expense_type->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_maintenance_exp->expense_sub_type->Visible) { // expense_sub_type ?>
		<td<?php echo $t_maintenance_exp->expense_sub_type->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_delete->RowCnt ?>_t_maintenance_exp_expense_sub_type" class="t_maintenance_exp_expense_sub_type">
<span>
<?php echo GetImageViewTag($t_maintenance_exp->expense_sub_type, $t_maintenance_exp->expense_sub_type->getViewValue()) ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_maintenance_exp->amount->Visible) { // amount ?>
		<td<?php echo $t_maintenance_exp->amount->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_delete->RowCnt ?>_t_maintenance_exp_amount" class="t_maintenance_exp_amount">
<span<?php echo $t_maintenance_exp->amount->viewAttributes() ?>>
<?php echo $t_maintenance_exp->amount->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_maintenance_exp->dated->Visible) { // dated ?>
		<td<?php echo $t_maintenance_exp->dated->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_delete->RowCnt ?>_t_maintenance_exp_dated" class="t_maintenance_exp_dated">
<span<?php echo $t_maintenance_exp->dated->viewAttributes() ?>>
<?php echo $t_maintenance_exp->dated->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_maintenance_exp->remarks->Visible) { // remarks ?>
		<td<?php echo $t_maintenance_exp->remarks->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_delete->RowCnt ?>_t_maintenance_exp_remarks" class="t_maintenance_exp_remarks">
<span<?php echo $t_maintenance_exp->remarks->viewAttributes() ?>>
<?php echo $t_maintenance_exp->remarks->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_maintenance_exp->uploads->Visible) { // uploads ?>
		<td<?php echo $t_maintenance_exp->uploads->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_delete->RowCnt ?>_t_maintenance_exp_uploads" class="t_maintenance_exp_uploads">
<span>
<?php echo GetFileViewTag($t_maintenance_exp->uploads, $t_maintenance_exp->uploads->getViewValue()) ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($t_maintenance_exp->operator->Visible) { // operator ?>
		<td<?php echo $t_maintenance_exp->operator->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_delete->RowCnt ?>_t_maintenance_exp_operator" class="t_maintenance_exp_operator">
<span<?php echo $t_maintenance_exp->operator->viewAttributes() ?>>
<?php echo $t_maintenance_exp->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_maintenance_exp->datetime->Visible) { // datetime ?>
		<td<?php echo $t_maintenance_exp->datetime->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_delete->RowCnt ?>_t_maintenance_exp_datetime" class="t_maintenance_exp_datetime">
<span<?php echo $t_maintenance_exp->datetime->viewAttributes() ?>>
<?php echo $t_maintenance_exp->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$t_maintenance_exp_delete->Recordset->moveNext();
}
$t_maintenance_exp_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_maintenance_exp_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$t_maintenance_exp_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_maintenance_exp_delete->terminate();
?>