<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_maintenance_exp_edit = new t_maintenance_exp_edit();

// Run the page
$t_maintenance_exp_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_maintenance_exp_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var ft_maintenance_expedit = currentForm = new ew.Form("ft_maintenance_expedit", "edit");

// Validate form
ft_maintenance_expedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_maintenance_exp_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance_exp->id->caption(), $t_maintenance_exp->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_maintenance_exp_edit->vehicle_no->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance_exp->vehicle_no->caption(), $t_maintenance_exp->vehicle_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_maintenance_exp_edit->r_from->Required) { ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance_exp->r_from->caption(), $t_maintenance_exp->r_from->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_maintenance_exp->r_from->errorMessage()) ?>");
		<?php if ($t_maintenance_exp_edit->expense_type->Required) { ?>
			elm = this.getElements("x" + infix + "_expense_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance_exp->expense_type->caption(), $t_maintenance_exp->expense_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_maintenance_exp_edit->expense_sub_type->Required) { ?>
			elm = this.getElements("x" + infix + "_expense_sub_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance_exp->expense_sub_type->caption(), $t_maintenance_exp->expense_sub_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_maintenance_exp_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance_exp->amount->caption(), $t_maintenance_exp->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_maintenance_exp->amount->errorMessage()) ?>");
		<?php if ($t_maintenance_exp_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance_exp->dated->caption(), $t_maintenance_exp->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_maintenance_exp->dated->errorMessage()) ?>");
		<?php if ($t_maintenance_exp_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance_exp->remarks->caption(), $t_maintenance_exp->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_maintenance_exp_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $t_maintenance_exp->uploads->caption(), $t_maintenance_exp->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_maintenance_exp_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance_exp->operator->caption(), $t_maintenance_exp->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_maintenance_exp_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance_exp->datetime->caption(), $t_maintenance_exp->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_maintenance_expedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_maintenance_expedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_maintenance_expedit.lists["x_vehicle_no"] = <?php echo $t_maintenance_exp_edit->vehicle_no->Lookup->toClientList() ?>;
ft_maintenance_expedit.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_maintenance_exp_edit->vehicle_no->lookupOptions()) ?>;
ft_maintenance_expedit.lists["x_r_from"] = <?php echo $t_maintenance_exp_edit->r_from->Lookup->toClientList() ?>;
ft_maintenance_expedit.lists["x_r_from"].options = <?php echo JsonEncode($t_maintenance_exp_edit->r_from->lookupOptions()) ?>;
ft_maintenance_expedit.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_maintenance_expedit.lists["x_expense_type"] = <?php echo $t_maintenance_exp_edit->expense_type->Lookup->toClientList() ?>;
ft_maintenance_expedit.lists["x_expense_type"].options = <?php echo JsonEncode($t_maintenance_exp_edit->expense_type->lookupOptions()) ?>;
ft_maintenance_expedit.lists["x_expense_sub_type"] = <?php echo $t_maintenance_exp_edit->expense_sub_type->Lookup->toClientList() ?>;
ft_maintenance_expedit.lists["x_expense_sub_type"].options = <?php echo JsonEncode($t_maintenance_exp_edit->expense_sub_type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_maintenance_exp_edit->showPageHeader(); ?>
<?php
$t_maintenance_exp_edit->showMessage();
?>
<form name="ft_maintenance_expedit" id="ft_maintenance_expedit" class="<?php echo $t_maintenance_exp_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_maintenance_exp_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_maintenance_exp_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_maintenance_exp">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$t_maintenance_exp_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_maintenance_exp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_t_maintenance_exp_id" class="<?php echo $t_maintenance_exp_edit->LeftColumnClass ?>"><?php echo $t_maintenance_exp->id->caption() ?><?php echo ($t_maintenance_exp->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_exp_edit->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->id->cellAttributes() ?>>
<span id="el_t_maintenance_exp_id">
<span<?php echo $t_maintenance_exp->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_maintenance_exp->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_maintenance_exp" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($t_maintenance_exp->id->CurrentValue) ?>">
<?php echo $t_maintenance_exp->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->vehicle_no->Visible) { // vehicle_no ?>
	<div id="r_vehicle_no" class="form-group row">
		<label id="elh_t_maintenance_exp_vehicle_no" for="x_vehicle_no" class="<?php echo $t_maintenance_exp_edit->LeftColumnClass ?>"><?php echo $t_maintenance_exp->vehicle_no->caption() ?><?php echo ($t_maintenance_exp->vehicle_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_exp_edit->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->vehicle_no->cellAttributes() ?>>
<span id="el_t_maintenance_exp_vehicle_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_maintenance_exp" data-field="x_vehicle_no" data-value-separator="<?php echo $t_maintenance_exp->vehicle_no->displayValueSeparatorAttribute() ?>" id="x_vehicle_no" name="x_vehicle_no"<?php echo $t_maintenance_exp->vehicle_no->editAttributes() ?>>
		<?php echo $t_maintenance_exp->vehicle_no->selectOptionListHtml("x_vehicle_no") ?>
	</select>
</div>
<?php echo $t_maintenance_exp->vehicle_no->Lookup->getParamTag("p_x_vehicle_no") ?>
</span>
<?php echo $t_maintenance_exp->vehicle_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label id="elh_t_maintenance_exp_r_from" class="<?php echo $t_maintenance_exp_edit->LeftColumnClass ?>"><?php echo $t_maintenance_exp->r_from->caption() ?><?php echo ($t_maintenance_exp->r_from->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_exp_edit->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->r_from->cellAttributes() ?>>
<span id="el_t_maintenance_exp_r_from">
<?php
$wrkonchange = "" . trim(@$t_maintenance_exp->r_from->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_maintenance_exp->r_from->EditAttrs["onchange"] = "";
?>
<span id="as_x_r_from" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_r_from" id="sv_x_r_from" value="<?php echo RemoveHtml($t_maintenance_exp->r_from->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_maintenance_exp->r_from->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_maintenance_exp->r_from->getPlaceHolder()) ?>"<?php echo $t_maintenance_exp->r_from->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_maintenance_exp->r_from->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_r_from',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_maintenance_exp->r_from->ReadOnly || $t_maintenance_exp->r_from->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_maintenance_exp" data-field="x_r_from" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_maintenance_exp->r_from->displayValueSeparatorAttribute() ?>" name="x_r_from" id="x_r_from" value="<?php echo HtmlEncode($t_maintenance_exp->r_from->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_maintenance_expedit.createAutoSuggest({"id":"x_r_from","forceSelect":true});
</script>
<?php echo $t_maintenance_exp->r_from->Lookup->getParamTag("p_x_r_from") ?>
</span>
<?php echo $t_maintenance_exp->r_from->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->expense_type->Visible) { // expense_type ?>
	<div id="r_expense_type" class="form-group row">
		<label id="elh_t_maintenance_exp_expense_type" for="x_expense_type" class="<?php echo $t_maintenance_exp_edit->LeftColumnClass ?>"><?php echo $t_maintenance_exp->expense_type->caption() ?><?php echo ($t_maintenance_exp->expense_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_exp_edit->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->expense_type->cellAttributes() ?>>
<span id="el_t_maintenance_exp_expense_type">
<?php $t_maintenance_exp->expense_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$t_maintenance_exp->expense_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_maintenance_exp" data-field="x_expense_type" data-value-separator="<?php echo $t_maintenance_exp->expense_type->displayValueSeparatorAttribute() ?>" id="x_expense_type" name="x_expense_type"<?php echo $t_maintenance_exp->expense_type->editAttributes() ?>>
		<?php echo $t_maintenance_exp->expense_type->selectOptionListHtml("x_expense_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "t_expenses_info") && !$t_maintenance_exp->expense_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_expense_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $t_maintenance_exp->expense_type->caption() ?>" data-title="<?php echo $t_maintenance_exp->expense_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_expense_type',url:'_t_expenses_infoaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $t_maintenance_exp->expense_type->Lookup->getParamTag("p_x_expense_type") ?>
</span>
<?php echo $t_maintenance_exp->expense_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->expense_sub_type->Visible) { // expense_sub_type ?>
	<div id="r_expense_sub_type" class="form-group row">
		<label id="elh_t_maintenance_exp_expense_sub_type" for="x_expense_sub_type" class="<?php echo $t_maintenance_exp_edit->LeftColumnClass ?>"><?php echo $t_maintenance_exp->expense_sub_type->caption() ?><?php echo ($t_maintenance_exp->expense_sub_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_exp_edit->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->expense_sub_type->cellAttributes() ?>>
<span id="el_t_maintenance_exp_expense_sub_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_maintenance_exp" data-field="x_expense_sub_type" data-value-separator="<?php echo $t_maintenance_exp->expense_sub_type->displayValueSeparatorAttribute() ?>" id="x_expense_sub_type" name="x_expense_sub_type"<?php echo $t_maintenance_exp->expense_sub_type->editAttributes() ?>>
		<?php echo $t_maintenance_exp->expense_sub_type->selectOptionListHtml("x_expense_sub_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "t_expenses_info") && !$t_maintenance_exp->expense_sub_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_expense_sub_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $t_maintenance_exp->expense_sub_type->caption() ?>" data-title="<?php echo $t_maintenance_exp->expense_sub_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_expense_sub_type',url:'_t_expenses_infoaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $t_maintenance_exp->expense_sub_type->Lookup->getParamTag("p_x_expense_sub_type") ?>
</span>
<?php echo $t_maintenance_exp->expense_sub_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_t_maintenance_exp_amount" for="x_amount" class="<?php echo $t_maintenance_exp_edit->LeftColumnClass ?>"><?php echo $t_maintenance_exp->amount->caption() ?><?php echo ($t_maintenance_exp->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_exp_edit->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->amount->cellAttributes() ?>>
<span id="el_t_maintenance_exp_amount">
<input type="text" data-table="t_maintenance_exp" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($t_maintenance_exp->amount->getPlaceHolder()) ?>" value="<?php echo $t_maintenance_exp->amount->EditValue ?>"<?php echo $t_maintenance_exp->amount->editAttributes() ?>>
</span>
<?php echo $t_maintenance_exp->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_t_maintenance_exp_dated" for="x_dated" class="<?php echo $t_maintenance_exp_edit->LeftColumnClass ?>"><?php echo $t_maintenance_exp->dated->caption() ?><?php echo ($t_maintenance_exp->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_exp_edit->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->dated->cellAttributes() ?>>
<span id="el_t_maintenance_exp_dated">
<input type="text" data-table="t_maintenance_exp" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_maintenance_exp->dated->getPlaceHolder()) ?>" value="<?php echo $t_maintenance_exp->dated->EditValue ?>"<?php echo $t_maintenance_exp->dated->editAttributes() ?>>
<?php if (!$t_maintenance_exp->dated->ReadOnly && !$t_maintenance_exp->dated->Disabled && !isset($t_maintenance_exp->dated->EditAttrs["readonly"]) && !isset($t_maintenance_exp->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_maintenance_expedit", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $t_maintenance_exp->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_t_maintenance_exp_remarks" for="x_remarks" class="<?php echo $t_maintenance_exp_edit->LeftColumnClass ?>"><?php echo $t_maintenance_exp->remarks->caption() ?><?php echo ($t_maintenance_exp->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_exp_edit->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->remarks->cellAttributes() ?>>
<span id="el_t_maintenance_exp_remarks">
<input type="text" data-table="t_maintenance_exp" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_maintenance_exp->remarks->getPlaceHolder()) ?>" value="<?php echo $t_maintenance_exp->remarks->EditValue ?>"<?php echo $t_maintenance_exp->remarks->editAttributes() ?>>
</span>
<?php echo $t_maintenance_exp->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_t_maintenance_exp_uploads" class="<?php echo $t_maintenance_exp_edit->LeftColumnClass ?>"><?php echo $t_maintenance_exp->uploads->caption() ?><?php echo ($t_maintenance_exp->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_exp_edit->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->uploads->cellAttributes() ?>>
<span id="el_t_maintenance_exp_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $t_maintenance_exp->uploads->title() ? $t_maintenance_exp->uploads->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($t_maintenance_exp->uploads->ReadOnly || $t_maintenance_exp->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="t_maintenance_exp" data-field="x_uploads" name="x_uploads" id="x_uploads" multiple="multiple"<?php echo $t_maintenance_exp->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $t_maintenance_exp->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="255">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $t_maintenance_exp->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $t_maintenance_exp->uploads->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_uploads" id= "fc_x_uploads" value="<?php echo $t_maintenance_exp->uploads->UploadMaxFileCount ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $t_maintenance_exp->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_maintenance_exp_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_maintenance_exp_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_maintenance_exp_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_maintenance_exp_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_maintenance_exp_edit->terminate();
?>