<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_maintenance_exp_list = new t_maintenance_exp_list();

// Run the page
$t_maintenance_exp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_maintenance_exp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_maintenance_exp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_maintenance_explist = currentForm = new ew.Form("ft_maintenance_explist", "list");
ft_maintenance_explist.formKeyCountName = '<?php echo $t_maintenance_exp_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_maintenance_explist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_maintenance_explist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_maintenance_explist.lists["x_vehicle_no"] = <?php echo $t_maintenance_exp_list->vehicle_no->Lookup->toClientList() ?>;
ft_maintenance_explist.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_maintenance_exp_list->vehicle_no->lookupOptions()) ?>;
ft_maintenance_explist.lists["x_r_from"] = <?php echo $t_maintenance_exp_list->r_from->Lookup->toClientList() ?>;
ft_maintenance_explist.lists["x_r_from"].options = <?php echo JsonEncode($t_maintenance_exp_list->r_from->lookupOptions()) ?>;
ft_maintenance_explist.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_maintenance_explist.lists["x_expense_type"] = <?php echo $t_maintenance_exp_list->expense_type->Lookup->toClientList() ?>;
ft_maintenance_explist.lists["x_expense_type"].options = <?php echo JsonEncode($t_maintenance_exp_list->expense_type->lookupOptions()) ?>;
ft_maintenance_explist.lists["x_expense_sub_type"] = <?php echo $t_maintenance_exp_list->expense_sub_type->Lookup->toClientList() ?>;
ft_maintenance_explist.lists["x_expense_sub_type"].options = <?php echo JsonEncode($t_maintenance_exp_list->expense_sub_type->lookupOptions()) ?>;

// Form object for search
var ft_maintenance_explistsrch = currentSearchForm = new ew.Form("ft_maintenance_explistsrch");

// Filters
ft_maintenance_explistsrch.filterList = <?php echo $t_maintenance_exp_list->getFilterList() ?>;

// Init search panel as collapsed
ft_maintenance_explistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_maintenance_exp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_maintenance_exp_list->TotalRecs > 0 && $t_maintenance_exp_list->ExportOptions->visible()) { ?>
<?php $t_maintenance_exp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_maintenance_exp_list->ImportOptions->visible()) { ?>
<?php $t_maintenance_exp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_maintenance_exp_list->SearchOptions->visible()) { ?>
<?php $t_maintenance_exp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_maintenance_exp_list->FilterOptions->visible()) { ?>
<?php $t_maintenance_exp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_maintenance_exp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_maintenance_exp->isExport() && !$t_maintenance_exp->CurrentAction) { ?>
<form name="ft_maintenance_explistsrch" id="ft_maintenance_explistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_maintenance_exp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_maintenance_explistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_maintenance_exp">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_maintenance_exp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_maintenance_exp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_maintenance_exp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_maintenance_exp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_maintenance_exp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_maintenance_exp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_maintenance_exp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_maintenance_exp_list->showPageHeader(); ?>
<?php
$t_maintenance_exp_list->showMessage();
?>
<?php if ($t_maintenance_exp_list->TotalRecs > 0 || $t_maintenance_exp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_maintenance_exp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_maintenance_exp">
<?php if (!$t_maintenance_exp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_maintenance_exp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_maintenance_exp_list->Pager)) $t_maintenance_exp_list->Pager = new PrevNextPager($t_maintenance_exp_list->StartRec, $t_maintenance_exp_list->DisplayRecs, $t_maintenance_exp_list->TotalRecs, $t_maintenance_exp_list->AutoHidePager) ?>
<?php if ($t_maintenance_exp_list->Pager->RecordCount > 0 && $t_maintenance_exp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_maintenance_exp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_maintenance_exp_list->pageUrl() ?>start=<?php echo $t_maintenance_exp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_maintenance_exp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_maintenance_exp_list->pageUrl() ?>start=<?php echo $t_maintenance_exp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_maintenance_exp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_maintenance_exp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_maintenance_exp_list->pageUrl() ?>start=<?php echo $t_maintenance_exp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_maintenance_exp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_maintenance_exp_list->pageUrl() ?>start=<?php echo $t_maintenance_exp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_maintenance_exp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_maintenance_exp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_maintenance_exp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_maintenance_exp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_maintenance_exp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_maintenance_exp_list->TotalRecs > 0 && (!$t_maintenance_exp_list->AutoHidePageSizeSelector || $t_maintenance_exp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_maintenance_exp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_maintenance_exp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_maintenance_exp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_maintenance_exp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_maintenance_exp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_maintenance_exp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_maintenance_exp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_maintenance_exp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_maintenance_explist" id="ft_maintenance_explist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_maintenance_exp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_maintenance_exp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_maintenance_exp">
<div id="gmp_t_maintenance_exp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_maintenance_exp_list->TotalRecs > 0 || $t_maintenance_exp->isGridEdit()) { ?>
<table id="tbl_t_maintenance_explist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_maintenance_exp_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_maintenance_exp_list->renderListOptions();

// Render list options (header, left)
$t_maintenance_exp_list->ListOptions->render("header", "left");
?>
<?php if ($t_maintenance_exp->id->Visible) { // id ?>
	<?php if ($t_maintenance_exp->sortUrl($t_maintenance_exp->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_maintenance_exp->id->headerCellClass() ?>"><div id="elh_t_maintenance_exp_id" class="t_maintenance_exp_id"><div class="ew-table-header-caption"><?php echo $t_maintenance_exp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_maintenance_exp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_maintenance_exp->SortUrl($t_maintenance_exp->id) ?>',2);"><div id="elh_t_maintenance_exp_id" class="t_maintenance_exp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_maintenance_exp->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_maintenance_exp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_maintenance_exp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_maintenance_exp->vehicle_no->Visible) { // vehicle_no ?>
	<?php if ($t_maintenance_exp->sortUrl($t_maintenance_exp->vehicle_no) == "") { ?>
		<th data-name="vehicle_no" class="<?php echo $t_maintenance_exp->vehicle_no->headerCellClass() ?>"><div id="elh_t_maintenance_exp_vehicle_no" class="t_maintenance_exp_vehicle_no"><div class="ew-table-header-caption"><?php echo $t_maintenance_exp->vehicle_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_no" class="<?php echo $t_maintenance_exp->vehicle_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_maintenance_exp->SortUrl($t_maintenance_exp->vehicle_no) ?>',2);"><div id="elh_t_maintenance_exp_vehicle_no" class="t_maintenance_exp_vehicle_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_maintenance_exp->vehicle_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_maintenance_exp->vehicle_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_maintenance_exp->vehicle_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_maintenance_exp->r_from->Visible) { // r_from ?>
	<?php if ($t_maintenance_exp->sortUrl($t_maintenance_exp->r_from) == "") { ?>
		<th data-name="r_from" class="<?php echo $t_maintenance_exp->r_from->headerCellClass() ?>"><div id="elh_t_maintenance_exp_r_from" class="t_maintenance_exp_r_from"><div class="ew-table-header-caption"><?php echo $t_maintenance_exp->r_from->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_from" class="<?php echo $t_maintenance_exp->r_from->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_maintenance_exp->SortUrl($t_maintenance_exp->r_from) ?>',2);"><div id="elh_t_maintenance_exp_r_from" class="t_maintenance_exp_r_from">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_maintenance_exp->r_from->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_maintenance_exp->r_from->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_maintenance_exp->r_from->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_maintenance_exp->expense_type->Visible) { // expense_type ?>
	<?php if ($t_maintenance_exp->sortUrl($t_maintenance_exp->expense_type) == "") { ?>
		<th data-name="expense_type" class="<?php echo $t_maintenance_exp->expense_type->headerCellClass() ?>"><div id="elh_t_maintenance_exp_expense_type" class="t_maintenance_exp_expense_type"><div class="ew-table-header-caption"><?php echo $t_maintenance_exp->expense_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="expense_type" class="<?php echo $t_maintenance_exp->expense_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_maintenance_exp->SortUrl($t_maintenance_exp->expense_type) ?>',2);"><div id="elh_t_maintenance_exp_expense_type" class="t_maintenance_exp_expense_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_maintenance_exp->expense_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_maintenance_exp->expense_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_maintenance_exp->expense_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_maintenance_exp->expense_sub_type->Visible) { // expense_sub_type ?>
	<?php if ($t_maintenance_exp->sortUrl($t_maintenance_exp->expense_sub_type) == "") { ?>
		<th data-name="expense_sub_type" class="<?php echo $t_maintenance_exp->expense_sub_type->headerCellClass() ?>"><div id="elh_t_maintenance_exp_expense_sub_type" class="t_maintenance_exp_expense_sub_type"><div class="ew-table-header-caption"><?php echo $t_maintenance_exp->expense_sub_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="expense_sub_type" class="<?php echo $t_maintenance_exp->expense_sub_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_maintenance_exp->SortUrl($t_maintenance_exp->expense_sub_type) ?>',2);"><div id="elh_t_maintenance_exp_expense_sub_type" class="t_maintenance_exp_expense_sub_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_maintenance_exp->expense_sub_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_maintenance_exp->expense_sub_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_maintenance_exp->expense_sub_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_maintenance_exp->amount->Visible) { // amount ?>
	<?php if ($t_maintenance_exp->sortUrl($t_maintenance_exp->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $t_maintenance_exp->amount->headerCellClass() ?>"><div id="elh_t_maintenance_exp_amount" class="t_maintenance_exp_amount"><div class="ew-table-header-caption"><?php echo $t_maintenance_exp->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $t_maintenance_exp->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_maintenance_exp->SortUrl($t_maintenance_exp->amount) ?>',2);"><div id="elh_t_maintenance_exp_amount" class="t_maintenance_exp_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_maintenance_exp->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_maintenance_exp->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_maintenance_exp->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_maintenance_exp->dated->Visible) { // dated ?>
	<?php if ($t_maintenance_exp->sortUrl($t_maintenance_exp->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $t_maintenance_exp->dated->headerCellClass() ?>"><div id="elh_t_maintenance_exp_dated" class="t_maintenance_exp_dated"><div class="ew-table-header-caption"><?php echo $t_maintenance_exp->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $t_maintenance_exp->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_maintenance_exp->SortUrl($t_maintenance_exp->dated) ?>',2);"><div id="elh_t_maintenance_exp_dated" class="t_maintenance_exp_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_maintenance_exp->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_maintenance_exp->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_maintenance_exp->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_maintenance_exp->remarks->Visible) { // remarks ?>
	<?php if ($t_maintenance_exp->sortUrl($t_maintenance_exp->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $t_maintenance_exp->remarks->headerCellClass() ?>"><div id="elh_t_maintenance_exp_remarks" class="t_maintenance_exp_remarks"><div class="ew-table-header-caption"><?php echo $t_maintenance_exp->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $t_maintenance_exp->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_maintenance_exp->SortUrl($t_maintenance_exp->remarks) ?>',2);"><div id="elh_t_maintenance_exp_remarks" class="t_maintenance_exp_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_maintenance_exp->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_maintenance_exp->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_maintenance_exp->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_maintenance_exp->uploads->Visible) { // uploads ?>
	<?php if ($t_maintenance_exp->sortUrl($t_maintenance_exp->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $t_maintenance_exp->uploads->headerCellClass() ?>"><div id="elh_t_maintenance_exp_uploads" class="t_maintenance_exp_uploads"><div class="ew-table-header-caption"><?php echo $t_maintenance_exp->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $t_maintenance_exp->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_maintenance_exp->SortUrl($t_maintenance_exp->uploads) ?>',2);"><div id="elh_t_maintenance_exp_uploads" class="t_maintenance_exp_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_maintenance_exp->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_maintenance_exp->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_maintenance_exp->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_maintenance_exp->operator->Visible) { // operator ?>
	<?php if ($t_maintenance_exp->sortUrl($t_maintenance_exp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $t_maintenance_exp->operator->headerCellClass() ?>"><div id="elh_t_maintenance_exp_operator" class="t_maintenance_exp_operator"><div class="ew-table-header-caption"><?php echo $t_maintenance_exp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $t_maintenance_exp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_maintenance_exp->SortUrl($t_maintenance_exp->operator) ?>',2);"><div id="elh_t_maintenance_exp_operator" class="t_maintenance_exp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_maintenance_exp->operator->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_maintenance_exp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_maintenance_exp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_maintenance_exp->datetime->Visible) { // datetime ?>
	<?php if ($t_maintenance_exp->sortUrl($t_maintenance_exp->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $t_maintenance_exp->datetime->headerCellClass() ?>"><div id="elh_t_maintenance_exp_datetime" class="t_maintenance_exp_datetime"><div class="ew-table-header-caption"><?php echo $t_maintenance_exp->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $t_maintenance_exp->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_maintenance_exp->SortUrl($t_maintenance_exp->datetime) ?>',2);"><div id="elh_t_maintenance_exp_datetime" class="t_maintenance_exp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_maintenance_exp->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_maintenance_exp->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_maintenance_exp->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_maintenance_exp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_maintenance_exp->ExportAll && $t_maintenance_exp->isExport()) {
	$t_maintenance_exp_list->StopRec = $t_maintenance_exp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_maintenance_exp_list->TotalRecs > $t_maintenance_exp_list->StartRec + $t_maintenance_exp_list->DisplayRecs - 1)
		$t_maintenance_exp_list->StopRec = $t_maintenance_exp_list->StartRec + $t_maintenance_exp_list->DisplayRecs - 1;
	else
		$t_maintenance_exp_list->StopRec = $t_maintenance_exp_list->TotalRecs;
}
$t_maintenance_exp_list->RecCnt = $t_maintenance_exp_list->StartRec - 1;
if ($t_maintenance_exp_list->Recordset && !$t_maintenance_exp_list->Recordset->EOF) {
	$t_maintenance_exp_list->Recordset->moveFirst();
	$selectLimit = $t_maintenance_exp_list->UseSelectLimit;
	if (!$selectLimit && $t_maintenance_exp_list->StartRec > 1)
		$t_maintenance_exp_list->Recordset->move($t_maintenance_exp_list->StartRec - 1);
} elseif (!$t_maintenance_exp->AllowAddDeleteRow && $t_maintenance_exp_list->StopRec == 0) {
	$t_maintenance_exp_list->StopRec = $t_maintenance_exp->GridAddRowCount;
}

// Initialize aggregate
$t_maintenance_exp->RowType = ROWTYPE_AGGREGATEINIT;
$t_maintenance_exp->resetAttributes();
$t_maintenance_exp_list->renderRow();
while ($t_maintenance_exp_list->RecCnt < $t_maintenance_exp_list->StopRec) {
	$t_maintenance_exp_list->RecCnt++;
	if ($t_maintenance_exp_list->RecCnt >= $t_maintenance_exp_list->StartRec) {
		$t_maintenance_exp_list->RowCnt++;

		// Set up key count
		$t_maintenance_exp_list->KeyCount = $t_maintenance_exp_list->RowIndex;

		// Init row class and style
		$t_maintenance_exp->resetAttributes();
		$t_maintenance_exp->CssClass = "";
		if ($t_maintenance_exp->isGridAdd()) {
		} else {
			$t_maintenance_exp_list->loadRowValues($t_maintenance_exp_list->Recordset); // Load row values
		}
		$t_maintenance_exp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_maintenance_exp->RowAttrs = array_merge($t_maintenance_exp->RowAttrs, array('data-rowindex'=>$t_maintenance_exp_list->RowCnt, 'id'=>'r' . $t_maintenance_exp_list->RowCnt . '_t_maintenance_exp', 'data-rowtype'=>$t_maintenance_exp->RowType));

		// Render row
		$t_maintenance_exp_list->renderRow();

		// Render list options
		$t_maintenance_exp_list->renderListOptions();
?>
	<tr<?php echo $t_maintenance_exp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_maintenance_exp_list->ListOptions->render("body", "left", $t_maintenance_exp_list->RowCnt);
?>
	<?php if ($t_maintenance_exp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_maintenance_exp->id->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_list->RowCnt ?>_t_maintenance_exp_id" class="t_maintenance_exp_id">
<span<?php echo $t_maintenance_exp->id->viewAttributes() ?>>
<?php echo $t_maintenance_exp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_maintenance_exp->vehicle_no->Visible) { // vehicle_no ?>
		<td data-name="vehicle_no"<?php echo $t_maintenance_exp->vehicle_no->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_list->RowCnt ?>_t_maintenance_exp_vehicle_no" class="t_maintenance_exp_vehicle_no">
<span<?php echo $t_maintenance_exp->vehicle_no->viewAttributes() ?>>
<?php echo $t_maintenance_exp->vehicle_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_maintenance_exp->r_from->Visible) { // r_from ?>
		<td data-name="r_from"<?php echo $t_maintenance_exp->r_from->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_list->RowCnt ?>_t_maintenance_exp_r_from" class="t_maintenance_exp_r_from">
<span<?php echo $t_maintenance_exp->r_from->viewAttributes() ?>>
<?php echo $t_maintenance_exp->r_from->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_maintenance_exp->expense_type->Visible) { // expense_type ?>
		<td data-name="expense_type"<?php echo $t_maintenance_exp->expense_type->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_list->RowCnt ?>_t_maintenance_exp_expense_type" class="t_maintenance_exp_expense_type">
<span<?php echo $t_maintenance_exp->expense_type->viewAttributes() ?>>
<?php echo $t_maintenance_exp->expense_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_maintenance_exp->expense_sub_type->Visible) { // expense_sub_type ?>
		<td data-name="expense_sub_type"<?php echo $t_maintenance_exp->expense_sub_type->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_list->RowCnt ?>_t_maintenance_exp_expense_sub_type" class="t_maintenance_exp_expense_sub_type">
<span>
<?php echo GetImageViewTag($t_maintenance_exp->expense_sub_type, $t_maintenance_exp->expense_sub_type->getViewValue()) ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_maintenance_exp->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $t_maintenance_exp->amount->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_list->RowCnt ?>_t_maintenance_exp_amount" class="t_maintenance_exp_amount">
<span<?php echo $t_maintenance_exp->amount->viewAttributes() ?>>
<?php echo $t_maintenance_exp->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_maintenance_exp->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $t_maintenance_exp->dated->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_list->RowCnt ?>_t_maintenance_exp_dated" class="t_maintenance_exp_dated">
<span<?php echo $t_maintenance_exp->dated->viewAttributes() ?>>
<?php echo $t_maintenance_exp->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_maintenance_exp->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $t_maintenance_exp->remarks->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_list->RowCnt ?>_t_maintenance_exp_remarks" class="t_maintenance_exp_remarks">
<span<?php echo $t_maintenance_exp->remarks->viewAttributes() ?>>
<?php echo $t_maintenance_exp->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_maintenance_exp->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $t_maintenance_exp->uploads->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_list->RowCnt ?>_t_maintenance_exp_uploads" class="t_maintenance_exp_uploads">
<span>
<?php echo GetFileViewTag($t_maintenance_exp->uploads, $t_maintenance_exp->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_maintenance_exp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $t_maintenance_exp->operator->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_list->RowCnt ?>_t_maintenance_exp_operator" class="t_maintenance_exp_operator">
<span<?php echo $t_maintenance_exp->operator->viewAttributes() ?>>
<?php echo $t_maintenance_exp->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_maintenance_exp->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $t_maintenance_exp->datetime->cellAttributes() ?>>
<span id="el<?php echo $t_maintenance_exp_list->RowCnt ?>_t_maintenance_exp_datetime" class="t_maintenance_exp_datetime">
<span<?php echo $t_maintenance_exp->datetime->viewAttributes() ?>>
<?php echo $t_maintenance_exp->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_maintenance_exp_list->ListOptions->render("body", "right", $t_maintenance_exp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_maintenance_exp->isGridAdd())
		$t_maintenance_exp_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_maintenance_exp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_maintenance_exp_list->Recordset)
	$t_maintenance_exp_list->Recordset->Close();
?>
<?php if (!$t_maintenance_exp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_maintenance_exp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_maintenance_exp_list->Pager)) $t_maintenance_exp_list->Pager = new PrevNextPager($t_maintenance_exp_list->StartRec, $t_maintenance_exp_list->DisplayRecs, $t_maintenance_exp_list->TotalRecs, $t_maintenance_exp_list->AutoHidePager) ?>
<?php if ($t_maintenance_exp_list->Pager->RecordCount > 0 && $t_maintenance_exp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_maintenance_exp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_maintenance_exp_list->pageUrl() ?>start=<?php echo $t_maintenance_exp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_maintenance_exp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_maintenance_exp_list->pageUrl() ?>start=<?php echo $t_maintenance_exp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_maintenance_exp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_maintenance_exp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_maintenance_exp_list->pageUrl() ?>start=<?php echo $t_maintenance_exp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_maintenance_exp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_maintenance_exp_list->pageUrl() ?>start=<?php echo $t_maintenance_exp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_maintenance_exp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_maintenance_exp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_maintenance_exp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_maintenance_exp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_maintenance_exp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_maintenance_exp_list->TotalRecs > 0 && (!$t_maintenance_exp_list->AutoHidePageSizeSelector || $t_maintenance_exp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_maintenance_exp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_maintenance_exp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_maintenance_exp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_maintenance_exp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_maintenance_exp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_maintenance_exp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_maintenance_exp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_maintenance_exp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_maintenance_exp_list->TotalRecs == 0 && !$t_maintenance_exp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_maintenance_exp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_maintenance_exp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_maintenance_exp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_maintenance_exp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_maintenance_exp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_maintenance_exp_list->terminate();
?>