<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_maintenance_exp_search = new t_maintenance_exp_search();

// Run the page
$t_maintenance_exp_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_maintenance_exp_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_maintenance_exp_search->IsModal) { ?>
var ft_maintenance_expsearch = currentAdvancedSearchForm = new ew.Form("ft_maintenance_expsearch", "search");
<?php } else { ?>
var ft_maintenance_expsearch = currentForm = new ew.Form("ft_maintenance_expsearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_maintenance_expsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_maintenance_expsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_maintenance_expsearch.lists["x_vehicle_no"] = <?php echo $t_maintenance_exp_search->vehicle_no->Lookup->toClientList() ?>;
ft_maintenance_expsearch.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_maintenance_exp_search->vehicle_no->lookupOptions()) ?>;
ft_maintenance_expsearch.lists["x_r_from"] = <?php echo $t_maintenance_exp_search->r_from->Lookup->toClientList() ?>;
ft_maintenance_expsearch.lists["x_r_from"].options = <?php echo JsonEncode($t_maintenance_exp_search->r_from->lookupOptions()) ?>;
ft_maintenance_expsearch.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_maintenance_expsearch.lists["x_expense_type"] = <?php echo $t_maintenance_exp_search->expense_type->Lookup->toClientList() ?>;
ft_maintenance_expsearch.lists["x_expense_type"].options = <?php echo JsonEncode($t_maintenance_exp_search->expense_type->lookupOptions()) ?>;
ft_maintenance_expsearch.lists["x_expense_sub_type"] = <?php echo $t_maintenance_exp_search->expense_sub_type->Lookup->toClientList() ?>;
ft_maintenance_expsearch.lists["x_expense_sub_type"].options = <?php echo JsonEncode($t_maintenance_exp_search->expense_sub_type->lookupOptions()) ?>;

// Form object for search
// Validate function for search

ft_maintenance_expsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_maintenance_exp->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_r_from");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_maintenance_exp->r_from->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_maintenance_exp->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_maintenance_exp->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_maintenance_exp->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_maintenance_exp->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_maintenance_exp_search->showPageHeader(); ?>
<?php
$t_maintenance_exp_search->showMessage();
?>
<form name="ft_maintenance_expsearch" id="ft_maintenance_expsearch" class="<?php echo $t_maintenance_exp_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_maintenance_exp_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_maintenance_exp_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_maintenance_exp">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_maintenance_exp_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_maintenance_exp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $t_maintenance_exp_search->LeftColumnClass ?>"><span id="elh_t_maintenance_exp_id"><?php echo $t_maintenance_exp->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_exp_search->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->id->cellAttributes() ?>>
			<span id="el_t_maintenance_exp_id">
<input type="text" data-table="t_maintenance_exp" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($t_maintenance_exp->id->getPlaceHolder()) ?>" value="<?php echo $t_maintenance_exp->id->EditValue ?>"<?php echo $t_maintenance_exp->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->vehicle_no->Visible) { // vehicle_no ?>
	<div id="r_vehicle_no" class="form-group row">
		<label for="x_vehicle_no" class="<?php echo $t_maintenance_exp_search->LeftColumnClass ?>"><span id="elh_t_maintenance_exp_vehicle_no"><?php echo $t_maintenance_exp->vehicle_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_no" id="z_vehicle_no" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_exp_search->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->vehicle_no->cellAttributes() ?>>
			<span id="el_t_maintenance_exp_vehicle_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_maintenance_exp" data-field="x_vehicle_no" data-value-separator="<?php echo $t_maintenance_exp->vehicle_no->displayValueSeparatorAttribute() ?>" id="x_vehicle_no" name="x_vehicle_no"<?php echo $t_maintenance_exp->vehicle_no->editAttributes() ?>>
		<?php echo $t_maintenance_exp->vehicle_no->selectOptionListHtml("x_vehicle_no") ?>
	</select>
</div>
<?php echo $t_maintenance_exp->vehicle_no->Lookup->getParamTag("p_x_vehicle_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label class="<?php echo $t_maintenance_exp_search->LeftColumnClass ?>"><span id="elh_t_maintenance_exp_r_from"><?php echo $t_maintenance_exp->r_from->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_from" id="z_r_from" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_exp_search->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->r_from->cellAttributes() ?>>
			<span id="el_t_maintenance_exp_r_from">
<?php
$wrkonchange = "" . trim(@$t_maintenance_exp->r_from->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_maintenance_exp->r_from->EditAttrs["onchange"] = "";
?>
<span id="as_x_r_from" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_r_from" id="sv_x_r_from" value="<?php echo RemoveHtml($t_maintenance_exp->r_from->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_maintenance_exp->r_from->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_maintenance_exp->r_from->getPlaceHolder()) ?>"<?php echo $t_maintenance_exp->r_from->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_maintenance_exp->r_from->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_r_from',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_maintenance_exp->r_from->ReadOnly || $t_maintenance_exp->r_from->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_maintenance_exp" data-field="x_r_from" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_maintenance_exp->r_from->displayValueSeparatorAttribute() ?>" name="x_r_from" id="x_r_from" value="<?php echo HtmlEncode($t_maintenance_exp->r_from->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_maintenance_expsearch.createAutoSuggest({"id":"x_r_from","forceSelect":true});
</script>
<?php echo $t_maintenance_exp->r_from->Lookup->getParamTag("p_x_r_from") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->expense_type->Visible) { // expense_type ?>
	<div id="r_expense_type" class="form-group row">
		<label for="x_expense_type" class="<?php echo $t_maintenance_exp_search->LeftColumnClass ?>"><span id="elh_t_maintenance_exp_expense_type"><?php echo $t_maintenance_exp->expense_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_expense_type" id="z_expense_type" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_exp_search->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->expense_type->cellAttributes() ?>>
			<span id="el_t_maintenance_exp_expense_type">
<?php $t_maintenance_exp->expense_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$t_maintenance_exp->expense_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_maintenance_exp" data-field="x_expense_type" data-value-separator="<?php echo $t_maintenance_exp->expense_type->displayValueSeparatorAttribute() ?>" id="x_expense_type" name="x_expense_type"<?php echo $t_maintenance_exp->expense_type->editAttributes() ?>>
		<?php echo $t_maintenance_exp->expense_type->selectOptionListHtml("x_expense_type") ?>
	</select>
</div>
<?php echo $t_maintenance_exp->expense_type->Lookup->getParamTag("p_x_expense_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->expense_sub_type->Visible) { // expense_sub_type ?>
	<div id="r_expense_sub_type" class="form-group row">
		<label for="x_expense_sub_type" class="<?php echo $t_maintenance_exp_search->LeftColumnClass ?>"><span id="elh_t_maintenance_exp_expense_sub_type"><?php echo $t_maintenance_exp->expense_sub_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_expense_sub_type" id="z_expense_sub_type" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_exp_search->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->expense_sub_type->cellAttributes() ?>>
			<span id="el_t_maintenance_exp_expense_sub_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_maintenance_exp" data-field="x_expense_sub_type" data-value-separator="<?php echo $t_maintenance_exp->expense_sub_type->displayValueSeparatorAttribute() ?>" id="x_expense_sub_type" name="x_expense_sub_type"<?php echo $t_maintenance_exp->expense_sub_type->editAttributes() ?>>
		<?php echo $t_maintenance_exp->expense_sub_type->selectOptionListHtml("x_expense_sub_type") ?>
	</select>
</div>
<?php echo $t_maintenance_exp->expense_sub_type->Lookup->getParamTag("p_x_expense_sub_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $t_maintenance_exp_search->LeftColumnClass ?>"><span id="elh_t_maintenance_exp_amount"><?php echo $t_maintenance_exp->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_exp_search->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->amount->cellAttributes() ?>>
			<span id="el_t_maintenance_exp_amount">
<input type="text" data-table="t_maintenance_exp" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($t_maintenance_exp->amount->getPlaceHolder()) ?>" value="<?php echo $t_maintenance_exp->amount->EditValue ?>"<?php echo $t_maintenance_exp->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $t_maintenance_exp_search->LeftColumnClass ?>"><span id="elh_t_maintenance_exp_dated"><?php echo $t_maintenance_exp->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_exp_search->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->dated->cellAttributes() ?>>
			<span id="el_t_maintenance_exp_dated">
<input type="text" data-table="t_maintenance_exp" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_maintenance_exp->dated->getPlaceHolder()) ?>" value="<?php echo $t_maintenance_exp->dated->EditValue ?>"<?php echo $t_maintenance_exp->dated->editAttributes() ?>>
<?php if (!$t_maintenance_exp->dated->ReadOnly && !$t_maintenance_exp->dated->Disabled && !isset($t_maintenance_exp->dated->EditAttrs["readonly"]) && !isset($t_maintenance_exp->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_maintenance_expsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $t_maintenance_exp_search->LeftColumnClass ?>"><span id="elh_t_maintenance_exp_remarks"><?php echo $t_maintenance_exp->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_maintenance_exp_search->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->remarks->cellAttributes() ?>>
			<span id="el_t_maintenance_exp_remarks">
<input type="text" data-table="t_maintenance_exp" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_maintenance_exp->remarks->getPlaceHolder()) ?>" value="<?php echo $t_maintenance_exp->remarks->EditValue ?>"<?php echo $t_maintenance_exp->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $t_maintenance_exp_search->LeftColumnClass ?>"><span id="elh_t_maintenance_exp_uploads"><?php echo $t_maintenance_exp->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_maintenance_exp_search->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->uploads->cellAttributes() ?>>
			<span id="el_t_maintenance_exp_uploads">
<input type="text" data-table="t_maintenance_exp" data-field="x_uploads" name="x_uploads" id="x_uploads" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_maintenance_exp->uploads->getPlaceHolder()) ?>" value="<?php echo $t_maintenance_exp->uploads->EditValue ?>"<?php echo $t_maintenance_exp->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $t_maintenance_exp_search->LeftColumnClass ?>"><span id="elh_t_maintenance_exp_operator"><?php echo $t_maintenance_exp->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_exp_search->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->operator->cellAttributes() ?>>
			<span id="el_t_maintenance_exp_operator">
<input type="text" data-table="t_maintenance_exp" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($t_maintenance_exp->operator->getPlaceHolder()) ?>" value="<?php echo $t_maintenance_exp->operator->EditValue ?>"<?php echo $t_maintenance_exp->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance_exp->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $t_maintenance_exp_search->LeftColumnClass ?>"><span id="elh_t_maintenance_exp_datetime"><?php echo $t_maintenance_exp->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_exp_search->RightColumnClass ?>"><div<?php echo $t_maintenance_exp->datetime->cellAttributes() ?>>
			<span id="el_t_maintenance_exp_datetime">
<input type="text" data-table="t_maintenance_exp" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($t_maintenance_exp->datetime->getPlaceHolder()) ?>" value="<?php echo $t_maintenance_exp->datetime->EditValue ?>"<?php echo $t_maintenance_exp->datetime->editAttributes() ?>>
<?php if (!$t_maintenance_exp->datetime->ReadOnly && !$t_maintenance_exp->datetime->Disabled && !isset($t_maintenance_exp->datetime->EditAttrs["readonly"]) && !isset($t_maintenance_exp->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_maintenance_expsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_maintenance_exp_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_maintenance_exp_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_maintenance_exp_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_maintenance_exp_search->terminate();
?>