<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_maintenance_exp_view = new t_maintenance_exp_view();

// Run the page
$t_maintenance_exp_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_maintenance_exp_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_maintenance_exp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_maintenance_expview = currentForm = new ew.Form("ft_maintenance_expview", "view");

// Form_CustomValidate event
ft_maintenance_expview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_maintenance_expview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_maintenance_expview.lists["x_vehicle_no"] = <?php echo $t_maintenance_exp_view->vehicle_no->Lookup->toClientList() ?>;
ft_maintenance_expview.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_maintenance_exp_view->vehicle_no->lookupOptions()) ?>;
ft_maintenance_expview.lists["x_r_from"] = <?php echo $t_maintenance_exp_view->r_from->Lookup->toClientList() ?>;
ft_maintenance_expview.lists["x_r_from"].options = <?php echo JsonEncode($t_maintenance_exp_view->r_from->lookupOptions()) ?>;
ft_maintenance_expview.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_maintenance_expview.lists["x_expense_type"] = <?php echo $t_maintenance_exp_view->expense_type->Lookup->toClientList() ?>;
ft_maintenance_expview.lists["x_expense_type"].options = <?php echo JsonEncode($t_maintenance_exp_view->expense_type->lookupOptions()) ?>;
ft_maintenance_expview.lists["x_expense_sub_type"] = <?php echo $t_maintenance_exp_view->expense_sub_type->Lookup->toClientList() ?>;
ft_maintenance_expview.lists["x_expense_sub_type"].options = <?php echo JsonEncode($t_maintenance_exp_view->expense_sub_type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_maintenance_exp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_maintenance_exp_view->ExportOptions->render("body") ?>
<?php $t_maintenance_exp_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_maintenance_exp_view->showPageHeader(); ?>
<?php
$t_maintenance_exp_view->showMessage();
?>
<form name="ft_maintenance_expview" id="ft_maintenance_expview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_maintenance_exp_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_maintenance_exp_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_maintenance_exp">
<input type="hidden" name="modal" value="<?php echo (int)$t_maintenance_exp_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_maintenance_exp->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_maintenance_exp_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_exp_id"><?php echo $t_maintenance_exp->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_maintenance_exp->id->cellAttributes() ?>>
<span id="el_t_maintenance_exp_id">
<span<?php echo $t_maintenance_exp->id->viewAttributes() ?>>
<?php echo $t_maintenance_exp->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance_exp->vehicle_no->Visible) { // vehicle_no ?>
	<tr id="r_vehicle_no">
		<td class="<?php echo $t_maintenance_exp_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_exp_vehicle_no"><?php echo $t_maintenance_exp->vehicle_no->caption() ?></span></td>
		<td data-name="vehicle_no"<?php echo $t_maintenance_exp->vehicle_no->cellAttributes() ?>>
<span id="el_t_maintenance_exp_vehicle_no">
<span<?php echo $t_maintenance_exp->vehicle_no->viewAttributes() ?>>
<?php echo $t_maintenance_exp->vehicle_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance_exp->r_from->Visible) { // r_from ?>
	<tr id="r_r_from">
		<td class="<?php echo $t_maintenance_exp_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_exp_r_from"><?php echo $t_maintenance_exp->r_from->caption() ?></span></td>
		<td data-name="r_from"<?php echo $t_maintenance_exp->r_from->cellAttributes() ?>>
<span id="el_t_maintenance_exp_r_from">
<span<?php echo $t_maintenance_exp->r_from->viewAttributes() ?>>
<?php echo $t_maintenance_exp->r_from->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance_exp->expense_type->Visible) { // expense_type ?>
	<tr id="r_expense_type">
		<td class="<?php echo $t_maintenance_exp_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_exp_expense_type"><?php echo $t_maintenance_exp->expense_type->caption() ?></span></td>
		<td data-name="expense_type"<?php echo $t_maintenance_exp->expense_type->cellAttributes() ?>>
<span id="el_t_maintenance_exp_expense_type">
<span<?php echo $t_maintenance_exp->expense_type->viewAttributes() ?>>
<?php echo $t_maintenance_exp->expense_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance_exp->expense_sub_type->Visible) { // expense_sub_type ?>
	<tr id="r_expense_sub_type">
		<td class="<?php echo $t_maintenance_exp_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_exp_expense_sub_type"><?php echo $t_maintenance_exp->expense_sub_type->caption() ?></span></td>
		<td data-name="expense_sub_type"<?php echo $t_maintenance_exp->expense_sub_type->cellAttributes() ?>>
<span id="el_t_maintenance_exp_expense_sub_type">
<span>
<?php echo GetImageViewTag($t_maintenance_exp->expense_sub_type, $t_maintenance_exp->expense_sub_type->getViewValue()) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance_exp->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $t_maintenance_exp_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_exp_amount"><?php echo $t_maintenance_exp->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $t_maintenance_exp->amount->cellAttributes() ?>>
<span id="el_t_maintenance_exp_amount">
<span<?php echo $t_maintenance_exp->amount->viewAttributes() ?>>
<?php echo $t_maintenance_exp->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance_exp->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $t_maintenance_exp_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_exp_dated"><?php echo $t_maintenance_exp->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $t_maintenance_exp->dated->cellAttributes() ?>>
<span id="el_t_maintenance_exp_dated">
<span<?php echo $t_maintenance_exp->dated->viewAttributes() ?>>
<?php echo $t_maintenance_exp->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance_exp->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $t_maintenance_exp_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_exp_remarks"><?php echo $t_maintenance_exp->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $t_maintenance_exp->remarks->cellAttributes() ?>>
<span id="el_t_maintenance_exp_remarks">
<span<?php echo $t_maintenance_exp->remarks->viewAttributes() ?>>
<?php echo $t_maintenance_exp->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance_exp->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $t_maintenance_exp_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_exp_uploads"><?php echo $t_maintenance_exp->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $t_maintenance_exp->uploads->cellAttributes() ?>>
<span id="el_t_maintenance_exp_uploads">
<span>
<?php echo GetFileViewTag($t_maintenance_exp->uploads, $t_maintenance_exp->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance_exp->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_maintenance_exp_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_exp_operator"><?php echo $t_maintenance_exp->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_maintenance_exp->operator->cellAttributes() ?>>
<span id="el_t_maintenance_exp_operator">
<span<?php echo $t_maintenance_exp->operator->viewAttributes() ?>>
<?php echo $t_maintenance_exp->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance_exp->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_maintenance_exp_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_exp_datetime"><?php echo $t_maintenance_exp->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_maintenance_exp->datetime->cellAttributes() ?>>
<span id="el_t_maintenance_exp_datetime">
<span<?php echo $t_maintenance_exp->datetime->viewAttributes() ?>>
<?php echo $t_maintenance_exp->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_maintenance_exp_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_maintenance_exp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_maintenance_exp_view->terminate();
?>