<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_maintenance_add = new t_maintenance_add();

// Run the page
$t_maintenance_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_maintenance_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var ft_maintenanceadd = currentForm = new ew.Form("ft_maintenanceadd", "add");

// Validate form
ft_maintenanceadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_maintenance_add->vehicle_no->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance->vehicle_no->caption(), $t_maintenance->vehicle_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_maintenance_add->head->Required) { ?>
			elm = this.getElements("x" + infix + "_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance->head->caption(), $t_maintenance->head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_maintenance_add->sub_head->Required) { ?>
			elm = this.getElements("x" + infix + "_sub_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance->sub_head->caption(), $t_maintenance->sub_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_maintenance_add->km->Required) { ?>
			elm = this.getElements("x" + infix + "_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance->km->caption(), $t_maintenance->km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_km");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_maintenance->km->errorMessage()) ?>");
		<?php if ($t_maintenance_add->life_km->Required) { ?>
			elm = this.getElements("x" + infix + "_life_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance->life_km->caption(), $t_maintenance->life_km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_life_km");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_maintenance->life_km->errorMessage()) ?>");
		<?php if ($t_maintenance_add->s_no->Required) { ?>
			elm = this.getElements("x" + infix + "_s_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance->s_no->caption(), $t_maintenance->s_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_maintenance_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance->operator->caption(), $t_maintenance->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_maintenance_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance->datetime->caption(), $t_maintenance->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_maintenance_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance->dated->caption(), $t_maintenance->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_maintenance->dated->errorMessage()) ?>");
		<?php if ($t_maintenance_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_maintenance->remarks->caption(), $t_maintenance->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_maintenanceadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_maintenanceadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_maintenanceadd.lists["x_vehicle_no"] = <?php echo $t_maintenance_add->vehicle_no->Lookup->toClientList() ?>;
ft_maintenanceadd.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_maintenance_add->vehicle_no->lookupOptions()) ?>;
ft_maintenanceadd.lists["x_head"] = <?php echo $t_maintenance_add->head->Lookup->toClientList() ?>;
ft_maintenanceadd.lists["x_head"].options = <?php echo JsonEncode($t_maintenance_add->head->lookupOptions()) ?>;
ft_maintenanceadd.lists["x_sub_head"] = <?php echo $t_maintenance_add->sub_head->Lookup->toClientList() ?>;
ft_maintenanceadd.lists["x_sub_head"].options = <?php echo JsonEncode($t_maintenance_add->sub_head->lookupOptions()) ?>;
ft_maintenanceadd.lists["x_operator"] = <?php echo $t_maintenance_add->operator->Lookup->toClientList() ?>;
ft_maintenanceadd.lists["x_operator"].options = <?php echo JsonEncode($t_maintenance_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_maintenance_add->showPageHeader(); ?>
<?php
$t_maintenance_add->showMessage();
?>
<form name="ft_maintenanceadd" id="ft_maintenanceadd" class="<?php echo $t_maintenance_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_maintenance_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_maintenance_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_maintenance">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$t_maintenance_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($t_maintenance->vehicle_no->Visible) { // vehicle_no ?>
	<div id="r_vehicle_no" class="form-group row">
		<label id="elh_t_maintenance_vehicle_no" for="x_vehicle_no" class="<?php echo $t_maintenance_add->LeftColumnClass ?>"><?php echo $t_maintenance->vehicle_no->caption() ?><?php echo ($t_maintenance->vehicle_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_add->RightColumnClass ?>"><div<?php echo $t_maintenance->vehicle_no->cellAttributes() ?>>
<span id="el_t_maintenance_vehicle_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_maintenance" data-field="x_vehicle_no" data-value-separator="<?php echo $t_maintenance->vehicle_no->displayValueSeparatorAttribute() ?>" id="x_vehicle_no" name="x_vehicle_no"<?php echo $t_maintenance->vehicle_no->editAttributes() ?>>
		<?php echo $t_maintenance->vehicle_no->selectOptionListHtml("x_vehicle_no") ?>
	</select>
</div>
<?php echo $t_maintenance->vehicle_no->Lookup->getParamTag("p_x_vehicle_no") ?>
</span>
<?php echo $t_maintenance->vehicle_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->head->Visible) { // head ?>
	<div id="r_head" class="form-group row">
		<label id="elh_t_maintenance_head" for="x_head" class="<?php echo $t_maintenance_add->LeftColumnClass ?>"><?php echo $t_maintenance->head->caption() ?><?php echo ($t_maintenance->head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_add->RightColumnClass ?>"><div<?php echo $t_maintenance->head->cellAttributes() ?>>
<span id="el_t_maintenance_head">
<?php $t_maintenance->head->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$t_maintenance->head->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_maintenance" data-field="x_head" data-value-separator="<?php echo $t_maintenance->head->displayValueSeparatorAttribute() ?>" id="x_head" name="x_head"<?php echo $t_maintenance->head->editAttributes() ?>>
		<?php echo $t_maintenance->head->selectOptionListHtml("x_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "t_maintenance_info") && !$t_maintenance->head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $t_maintenance->head->caption() ?>" data-title="<?php echo $t_maintenance->head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_head',url:'_t_maintenance_infoaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $t_maintenance->head->Lookup->getParamTag("p_x_head") ?>
</span>
<?php echo $t_maintenance->head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->sub_head->Visible) { // sub_head ?>
	<div id="r_sub_head" class="form-group row">
		<label id="elh_t_maintenance_sub_head" for="x_sub_head" class="<?php echo $t_maintenance_add->LeftColumnClass ?>"><?php echo $t_maintenance->sub_head->caption() ?><?php echo ($t_maintenance->sub_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_add->RightColumnClass ?>"><div<?php echo $t_maintenance->sub_head->cellAttributes() ?>>
<span id="el_t_maintenance_sub_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_maintenance" data-field="x_sub_head" data-value-separator="<?php echo $t_maintenance->sub_head->displayValueSeparatorAttribute() ?>" id="x_sub_head" name="x_sub_head"<?php echo $t_maintenance->sub_head->editAttributes() ?>>
		<?php echo $t_maintenance->sub_head->selectOptionListHtml("x_sub_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "t_maintenance_info") && !$t_maintenance->sub_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_sub_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $t_maintenance->sub_head->caption() ?>" data-title="<?php echo $t_maintenance->sub_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_sub_head',url:'_t_maintenance_infoaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $t_maintenance->sub_head->Lookup->getParamTag("p_x_sub_head") ?>
</span>
<?php echo $t_maintenance->sub_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->km->Visible) { // km ?>
	<div id="r_km" class="form-group row">
		<label id="elh_t_maintenance_km" for="x_km" class="<?php echo $t_maintenance_add->LeftColumnClass ?>"><?php echo $t_maintenance->km->caption() ?><?php echo ($t_maintenance->km->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_add->RightColumnClass ?>"><div<?php echo $t_maintenance->km->cellAttributes() ?>>
<span id="el_t_maintenance_km">
<input type="text" data-table="t_maintenance" data-field="x_km" name="x_km" id="x_km" size="30" placeholder="<?php echo HtmlEncode($t_maintenance->km->getPlaceHolder()) ?>" value="<?php echo $t_maintenance->km->EditValue ?>"<?php echo $t_maintenance->km->editAttributes() ?>>
</span>
<?php echo $t_maintenance->km->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->life_km->Visible) { // life_km ?>
	<div id="r_life_km" class="form-group row">
		<label id="elh_t_maintenance_life_km" for="x_life_km" class="<?php echo $t_maintenance_add->LeftColumnClass ?>"><?php echo $t_maintenance->life_km->caption() ?><?php echo ($t_maintenance->life_km->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_add->RightColumnClass ?>"><div<?php echo $t_maintenance->life_km->cellAttributes() ?>>
<span id="el_t_maintenance_life_km">
<input type="text" data-table="t_maintenance" data-field="x_life_km" name="x_life_km" id="x_life_km" size="30" placeholder="<?php echo HtmlEncode($t_maintenance->life_km->getPlaceHolder()) ?>" value="<?php echo $t_maintenance->life_km->EditValue ?>"<?php echo $t_maintenance->life_km->editAttributes() ?>>
</span>
<?php echo $t_maintenance->life_km->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->s_no->Visible) { // s_no ?>
	<div id="r_s_no" class="form-group row">
		<label id="elh_t_maintenance_s_no" for="x_s_no" class="<?php echo $t_maintenance_add->LeftColumnClass ?>"><?php echo $t_maintenance->s_no->caption() ?><?php echo ($t_maintenance->s_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_add->RightColumnClass ?>"><div<?php echo $t_maintenance->s_no->cellAttributes() ?>>
<span id="el_t_maintenance_s_no">
<input type="text" data-table="t_maintenance" data-field="x_s_no" name="x_s_no" id="x_s_no" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($t_maintenance->s_no->getPlaceHolder()) ?>" value="<?php echo $t_maintenance->s_no->EditValue ?>"<?php echo $t_maintenance->s_no->editAttributes() ?>>
</span>
<?php echo $t_maintenance->s_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_t_maintenance_dated" for="x_dated" class="<?php echo $t_maintenance_add->LeftColumnClass ?>"><?php echo $t_maintenance->dated->caption() ?><?php echo ($t_maintenance->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_add->RightColumnClass ?>"><div<?php echo $t_maintenance->dated->cellAttributes() ?>>
<span id="el_t_maintenance_dated">
<input type="text" data-table="t_maintenance" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_maintenance->dated->getPlaceHolder()) ?>" value="<?php echo $t_maintenance->dated->EditValue ?>"<?php echo $t_maintenance->dated->editAttributes() ?>>
<?php if (!$t_maintenance->dated->ReadOnly && !$t_maintenance->dated->Disabled && !isset($t_maintenance->dated->EditAttrs["readonly"]) && !isset($t_maintenance->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_maintenanceadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $t_maintenance->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_t_maintenance_remarks" for="x_remarks" class="<?php echo $t_maintenance_add->LeftColumnClass ?>"><?php echo $t_maintenance->remarks->caption() ?><?php echo ($t_maintenance->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_maintenance_add->RightColumnClass ?>"><div<?php echo $t_maintenance->remarks->cellAttributes() ?>>
<span id="el_t_maintenance_remarks">
<input type="text" data-table="t_maintenance" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($t_maintenance->remarks->getPlaceHolder()) ?>" value="<?php echo $t_maintenance->remarks->EditValue ?>"<?php echo $t_maintenance->remarks->editAttributes() ?>>
</span>
<?php echo $t_maintenance->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_maintenance_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_maintenance_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_maintenance_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_maintenance_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_maintenance_add->terminate();
?>