<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_maintenance_search = new t_maintenance_search();

// Run the page
$t_maintenance_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_maintenance_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_maintenance_search->IsModal) { ?>
var ft_maintenancesearch = currentAdvancedSearchForm = new ew.Form("ft_maintenancesearch", "search");
<?php } else { ?>
var ft_maintenancesearch = currentForm = new ew.Form("ft_maintenancesearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_maintenancesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_maintenancesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_maintenancesearch.lists["x_vehicle_no"] = <?php echo $t_maintenance_search->vehicle_no->Lookup->toClientList() ?>;
ft_maintenancesearch.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_maintenance_search->vehicle_no->lookupOptions()) ?>;
ft_maintenancesearch.lists["x_head"] = <?php echo $t_maintenance_search->head->Lookup->toClientList() ?>;
ft_maintenancesearch.lists["x_head"].options = <?php echo JsonEncode($t_maintenance_search->head->lookupOptions()) ?>;
ft_maintenancesearch.lists["x_sub_head"] = <?php echo $t_maintenance_search->sub_head->Lookup->toClientList() ?>;
ft_maintenancesearch.lists["x_sub_head"].options = <?php echo JsonEncode($t_maintenance_search->sub_head->lookupOptions()) ?>;
ft_maintenancesearch.lists["x_operator"] = <?php echo $t_maintenance_search->operator->Lookup->toClientList() ?>;
ft_maintenancesearch.lists["x_operator"].options = <?php echo JsonEncode($t_maintenance_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

ft_maintenancesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_maintenance->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_maintenance->km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_life_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_maintenance->life_km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_next_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_maintenance->next_km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_maintenance->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_update_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_maintenance->update_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_maintenance->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_maintenance_search->showPageHeader(); ?>
<?php
$t_maintenance_search->showMessage();
?>
<form name="ft_maintenancesearch" id="ft_maintenancesearch" class="<?php echo $t_maintenance_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_maintenance_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_maintenance_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_maintenance">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_maintenance_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_maintenance->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $t_maintenance_search->LeftColumnClass ?>"><span id="elh_t_maintenance_id"><?php echo $t_maintenance->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_search->RightColumnClass ?>"><div<?php echo $t_maintenance->id->cellAttributes() ?>>
			<span id="el_t_maintenance_id">
<input type="text" data-table="t_maintenance" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($t_maintenance->id->getPlaceHolder()) ?>" value="<?php echo $t_maintenance->id->EditValue ?>"<?php echo $t_maintenance->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->vehicle_no->Visible) { // vehicle_no ?>
	<div id="r_vehicle_no" class="form-group row">
		<label for="x_vehicle_no" class="<?php echo $t_maintenance_search->LeftColumnClass ?>"><span id="elh_t_maintenance_vehicle_no"><?php echo $t_maintenance->vehicle_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_no" id="z_vehicle_no" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_search->RightColumnClass ?>"><div<?php echo $t_maintenance->vehicle_no->cellAttributes() ?>>
			<span id="el_t_maintenance_vehicle_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_maintenance" data-field="x_vehicle_no" data-value-separator="<?php echo $t_maintenance->vehicle_no->displayValueSeparatorAttribute() ?>" id="x_vehicle_no" name="x_vehicle_no"<?php echo $t_maintenance->vehicle_no->editAttributes() ?>>
		<?php echo $t_maintenance->vehicle_no->selectOptionListHtml("x_vehicle_no") ?>
	</select>
</div>
<?php echo $t_maintenance->vehicle_no->Lookup->getParamTag("p_x_vehicle_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->head->Visible) { // head ?>
	<div id="r_head" class="form-group row">
		<label for="x_head" class="<?php echo $t_maintenance_search->LeftColumnClass ?>"><span id="elh_t_maintenance_head"><?php echo $t_maintenance->head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_head" id="z_head" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_search->RightColumnClass ?>"><div<?php echo $t_maintenance->head->cellAttributes() ?>>
			<span id="el_t_maintenance_head">
<?php $t_maintenance->head->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$t_maintenance->head->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_maintenance" data-field="x_head" data-value-separator="<?php echo $t_maintenance->head->displayValueSeparatorAttribute() ?>" id="x_head" name="x_head"<?php echo $t_maintenance->head->editAttributes() ?>>
		<?php echo $t_maintenance->head->selectOptionListHtml("x_head") ?>
	</select>
</div>
<?php echo $t_maintenance->head->Lookup->getParamTag("p_x_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->sub_head->Visible) { // sub_head ?>
	<div id="r_sub_head" class="form-group row">
		<label for="x_sub_head" class="<?php echo $t_maintenance_search->LeftColumnClass ?>"><span id="elh_t_maintenance_sub_head"><?php echo $t_maintenance->sub_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sub_head" id="z_sub_head" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_search->RightColumnClass ?>"><div<?php echo $t_maintenance->sub_head->cellAttributes() ?>>
			<span id="el_t_maintenance_sub_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_maintenance" data-field="x_sub_head" data-value-separator="<?php echo $t_maintenance->sub_head->displayValueSeparatorAttribute() ?>" id="x_sub_head" name="x_sub_head"<?php echo $t_maintenance->sub_head->editAttributes() ?>>
		<?php echo $t_maintenance->sub_head->selectOptionListHtml("x_sub_head") ?>
	</select>
</div>
<?php echo $t_maintenance->sub_head->Lookup->getParamTag("p_x_sub_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->km->Visible) { // km ?>
	<div id="r_km" class="form-group row">
		<label for="x_km" class="<?php echo $t_maintenance_search->LeftColumnClass ?>"><span id="elh_t_maintenance_km"><?php echo $t_maintenance->km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_km" id="z_km" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_search->RightColumnClass ?>"><div<?php echo $t_maintenance->km->cellAttributes() ?>>
			<span id="el_t_maintenance_km">
<input type="text" data-table="t_maintenance" data-field="x_km" name="x_km" id="x_km" size="30" placeholder="<?php echo HtmlEncode($t_maintenance->km->getPlaceHolder()) ?>" value="<?php echo $t_maintenance->km->EditValue ?>"<?php echo $t_maintenance->km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->life_km->Visible) { // life_km ?>
	<div id="r_life_km" class="form-group row">
		<label for="x_life_km" class="<?php echo $t_maintenance_search->LeftColumnClass ?>"><span id="elh_t_maintenance_life_km"><?php echo $t_maintenance->life_km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_life_km" id="z_life_km" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_search->RightColumnClass ?>"><div<?php echo $t_maintenance->life_km->cellAttributes() ?>>
			<span id="el_t_maintenance_life_km">
<input type="text" data-table="t_maintenance" data-field="x_life_km" name="x_life_km" id="x_life_km" size="30" placeholder="<?php echo HtmlEncode($t_maintenance->life_km->getPlaceHolder()) ?>" value="<?php echo $t_maintenance->life_km->EditValue ?>"<?php echo $t_maintenance->life_km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->next_km->Visible) { // next_km ?>
	<div id="r_next_km" class="form-group row">
		<label for="x_next_km" class="<?php echo $t_maintenance_search->LeftColumnClass ?>"><span id="elh_t_maintenance_next_km"><?php echo $t_maintenance->next_km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_next_km" id="z_next_km" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_search->RightColumnClass ?>"><div<?php echo $t_maintenance->next_km->cellAttributes() ?>>
			<span id="el_t_maintenance_next_km">
<input type="text" data-table="t_maintenance" data-field="x_next_km" name="x_next_km" id="x_next_km" size="30" placeholder="<?php echo HtmlEncode($t_maintenance->next_km->getPlaceHolder()) ?>" value="<?php echo $t_maintenance->next_km->EditValue ?>"<?php echo $t_maintenance->next_km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->s_no->Visible) { // s_no ?>
	<div id="r_s_no" class="form-group row">
		<label for="x_s_no" class="<?php echo $t_maintenance_search->LeftColumnClass ?>"><span id="elh_t_maintenance_s_no"><?php echo $t_maintenance->s_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_s_no" id="z_s_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_maintenance_search->RightColumnClass ?>"><div<?php echo $t_maintenance->s_no->cellAttributes() ?>>
			<span id="el_t_maintenance_s_no">
<input type="text" data-table="t_maintenance" data-field="x_s_no" name="x_s_no" id="x_s_no" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($t_maintenance->s_no->getPlaceHolder()) ?>" value="<?php echo $t_maintenance->s_no->EditValue ?>"<?php echo $t_maintenance->s_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $t_maintenance_search->LeftColumnClass ?>"><span id="elh_t_maintenance_operator"><?php echo $t_maintenance->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_search->RightColumnClass ?>"><div<?php echo $t_maintenance->operator->cellAttributes() ?>>
			<span id="el_t_maintenance_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_maintenance" data-field="x_operator" data-value-separator="<?php echo $t_maintenance->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $t_maintenance->operator->editAttributes() ?>>
		<?php echo $t_maintenance->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $t_maintenance->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $t_maintenance_search->LeftColumnClass ?>"><span id="elh_t_maintenance_datetime"><?php echo $t_maintenance->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_search->RightColumnClass ?>"><div<?php echo $t_maintenance->datetime->cellAttributes() ?>>
			<span id="el_t_maintenance_datetime">
<input type="text" data-table="t_maintenance" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($t_maintenance->datetime->getPlaceHolder()) ?>" value="<?php echo $t_maintenance->datetime->EditValue ?>"<?php echo $t_maintenance->datetime->editAttributes() ?>>
<?php if (!$t_maintenance->datetime->ReadOnly && !$t_maintenance->datetime->Disabled && !isset($t_maintenance->datetime->EditAttrs["readonly"]) && !isset($t_maintenance->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_maintenancesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->update_id->Visible) { // update_id ?>
	<div id="r_update_id" class="form-group row">
		<label for="x_update_id" class="<?php echo $t_maintenance_search->LeftColumnClass ?>"><span id="elh_t_maintenance_update_id"><?php echo $t_maintenance->update_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_update_id" id="z_update_id" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_search->RightColumnClass ?>"><div<?php echo $t_maintenance->update_id->cellAttributes() ?>>
			<span id="el_t_maintenance_update_id">
<input type="text" data-table="t_maintenance" data-field="x_update_id" name="x_update_id" id="x_update_id" size="30" placeholder="<?php echo HtmlEncode($t_maintenance->update_id->getPlaceHolder()) ?>" value="<?php echo $t_maintenance->update_id->EditValue ?>"<?php echo $t_maintenance->update_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $t_maintenance_search->LeftColumnClass ?>"><span id="elh_t_maintenance_dated"><?php echo $t_maintenance->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $t_maintenance_search->RightColumnClass ?>"><div<?php echo $t_maintenance->dated->cellAttributes() ?>>
			<span id="el_t_maintenance_dated">
<input type="text" data-table="t_maintenance" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_maintenance->dated->getPlaceHolder()) ?>" value="<?php echo $t_maintenance->dated->EditValue ?>"<?php echo $t_maintenance->dated->editAttributes() ?>>
<?php if (!$t_maintenance->dated->ReadOnly && !$t_maintenance->dated->Disabled && !isset($t_maintenance->dated->EditAttrs["readonly"]) && !isset($t_maintenance->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_maintenancesearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_maintenance->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $t_maintenance_search->LeftColumnClass ?>"><span id="elh_t_maintenance_remarks"><?php echo $t_maintenance->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_maintenance_search->RightColumnClass ?>"><div<?php echo $t_maintenance->remarks->cellAttributes() ?>>
			<span id="el_t_maintenance_remarks">
<input type="text" data-table="t_maintenance" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($t_maintenance->remarks->getPlaceHolder()) ?>" value="<?php echo $t_maintenance->remarks->EditValue ?>"<?php echo $t_maintenance->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_maintenance_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_maintenance_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_maintenance_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_maintenance_search->terminate();
?>