<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_maintenance_view = new t_maintenance_view();

// Run the page
$t_maintenance_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_maintenance_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_maintenance->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_maintenanceview = currentForm = new ew.Form("ft_maintenanceview", "view");

// Form_CustomValidate event
ft_maintenanceview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_maintenanceview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_maintenanceview.lists["x_vehicle_no"] = <?php echo $t_maintenance_view->vehicle_no->Lookup->toClientList() ?>;
ft_maintenanceview.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_maintenance_view->vehicle_no->lookupOptions()) ?>;
ft_maintenanceview.lists["x_head"] = <?php echo $t_maintenance_view->head->Lookup->toClientList() ?>;
ft_maintenanceview.lists["x_head"].options = <?php echo JsonEncode($t_maintenance_view->head->lookupOptions()) ?>;
ft_maintenanceview.lists["x_sub_head"] = <?php echo $t_maintenance_view->sub_head->Lookup->toClientList() ?>;
ft_maintenanceview.lists["x_sub_head"].options = <?php echo JsonEncode($t_maintenance_view->sub_head->lookupOptions()) ?>;
ft_maintenanceview.lists["x_operator"] = <?php echo $t_maintenance_view->operator->Lookup->toClientList() ?>;
ft_maintenanceview.lists["x_operator"].options = <?php echo JsonEncode($t_maintenance_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_maintenance->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_maintenance_view->ExportOptions->render("body") ?>
<?php $t_maintenance_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_maintenance_view->showPageHeader(); ?>
<?php
$t_maintenance_view->showMessage();
?>
<form name="ft_maintenanceview" id="ft_maintenanceview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_maintenance_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_maintenance_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_maintenance">
<input type="hidden" name="modal" value="<?php echo (int)$t_maintenance_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_maintenance->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_id"><?php echo $t_maintenance->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_maintenance->id->cellAttributes() ?>>
<span id="el_t_maintenance_id">
<span<?php echo $t_maintenance->id->viewAttributes() ?>>
<?php echo $t_maintenance->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance->vehicle_no->Visible) { // vehicle_no ?>
	<tr id="r_vehicle_no">
		<td class="<?php echo $t_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_vehicle_no"><?php echo $t_maintenance->vehicle_no->caption() ?></span></td>
		<td data-name="vehicle_no"<?php echo $t_maintenance->vehicle_no->cellAttributes() ?>>
<span id="el_t_maintenance_vehicle_no">
<span<?php echo $t_maintenance->vehicle_no->viewAttributes() ?>>
<?php echo $t_maintenance->vehicle_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance->head->Visible) { // head ?>
	<tr id="r_head">
		<td class="<?php echo $t_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_head"><?php echo $t_maintenance->head->caption() ?></span></td>
		<td data-name="head"<?php echo $t_maintenance->head->cellAttributes() ?>>
<span id="el_t_maintenance_head">
<span<?php echo $t_maintenance->head->viewAttributes() ?>>
<?php echo $t_maintenance->head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance->sub_head->Visible) { // sub_head ?>
	<tr id="r_sub_head">
		<td class="<?php echo $t_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_sub_head"><?php echo $t_maintenance->sub_head->caption() ?></span></td>
		<td data-name="sub_head"<?php echo $t_maintenance->sub_head->cellAttributes() ?>>
<span id="el_t_maintenance_sub_head">
<span<?php echo $t_maintenance->sub_head->viewAttributes() ?>>
<?php echo $t_maintenance->sub_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance->km->Visible) { // km ?>
	<tr id="r_km">
		<td class="<?php echo $t_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_km"><?php echo $t_maintenance->km->caption() ?></span></td>
		<td data-name="km"<?php echo $t_maintenance->km->cellAttributes() ?>>
<span id="el_t_maintenance_km">
<span<?php echo $t_maintenance->km->viewAttributes() ?>>
<?php echo $t_maintenance->km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance->life_km->Visible) { // life_km ?>
	<tr id="r_life_km">
		<td class="<?php echo $t_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_life_km"><?php echo $t_maintenance->life_km->caption() ?></span></td>
		<td data-name="life_km"<?php echo $t_maintenance->life_km->cellAttributes() ?>>
<span id="el_t_maintenance_life_km">
<span<?php echo $t_maintenance->life_km->viewAttributes() ?>>
<?php echo $t_maintenance->life_km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance->next_km->Visible) { // next_km ?>
	<tr id="r_next_km">
		<td class="<?php echo $t_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_next_km"><?php echo $t_maintenance->next_km->caption() ?></span></td>
		<td data-name="next_km"<?php echo $t_maintenance->next_km->cellAttributes() ?>>
<span id="el_t_maintenance_next_km">
<span<?php echo $t_maintenance->next_km->viewAttributes() ?>>
<?php echo $t_maintenance->next_km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance->s_no->Visible) { // s_no ?>
	<tr id="r_s_no">
		<td class="<?php echo $t_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_s_no"><?php echo $t_maintenance->s_no->caption() ?></span></td>
		<td data-name="s_no"<?php echo $t_maintenance->s_no->cellAttributes() ?>>
<span id="el_t_maintenance_s_no">
<span<?php echo $t_maintenance->s_no->viewAttributes() ?>>
<?php echo $t_maintenance->s_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_operator"><?php echo $t_maintenance->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_maintenance->operator->cellAttributes() ?>>
<span id="el_t_maintenance_operator">
<span<?php echo $t_maintenance->operator->viewAttributes() ?>>
<?php echo $t_maintenance->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_datetime"><?php echo $t_maintenance->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_maintenance->datetime->cellAttributes() ?>>
<span id="el_t_maintenance_datetime">
<span<?php echo $t_maintenance->datetime->viewAttributes() ?>>
<?php echo $t_maintenance->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance->update_id->Visible) { // update_id ?>
	<tr id="r_update_id">
		<td class="<?php echo $t_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_update_id"><?php echo $t_maintenance->update_id->caption() ?></span></td>
		<td data-name="update_id"<?php echo $t_maintenance->update_id->cellAttributes() ?>>
<span id="el_t_maintenance_update_id">
<span<?php echo $t_maintenance->update_id->viewAttributes() ?>>
<?php echo $t_maintenance->update_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $t_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_dated"><?php echo $t_maintenance->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $t_maintenance->dated->cellAttributes() ?>>
<span id="el_t_maintenance_dated">
<span<?php echo $t_maintenance->dated->viewAttributes() ?>>
<?php echo $t_maintenance->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_maintenance->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $t_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_maintenance_remarks"><?php echo $t_maintenance->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $t_maintenance->remarks->cellAttributes() ?>>
<span id="el_t_maintenance_remarks">
<span<?php echo $t_maintenance->remarks->viewAttributes() ?>>
<?php echo $t_maintenance->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_maintenance_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_maintenance->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_maintenance_view->terminate();
?>