<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_payment_bulk_list = new t_payment_bulk_list();

// Run the page
$t_payment_bulk_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_payment_bulk_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_payment_bulk->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_payment_bulklist = currentForm = new ew.Form("ft_payment_bulklist", "list");
ft_payment_bulklist.formKeyCountName = '<?php echo $t_payment_bulk_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_payment_bulklist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_payment_bulklist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_payment_bulklist.lists["x_r_from"] = <?php echo $t_payment_bulk_list->r_from->Lookup->toClientList() ?>;
ft_payment_bulklist.lists["x_r_from"].options = <?php echo JsonEncode($t_payment_bulk_list->r_from->lookupOptions()) ?>;
ft_payment_bulklist.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_payment_bulklist.lists["x_r_to"] = <?php echo $t_payment_bulk_list->r_to->Lookup->toClientList() ?>;
ft_payment_bulklist.lists["x_r_to"].options = <?php echo JsonEncode($t_payment_bulk_list->r_to->lookupOptions()) ?>;
ft_payment_bulklist.autoSuggests["x_r_to"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_payment_bulklist.lists["x_trip"] = <?php echo $t_payment_bulk_list->trip->Lookup->toClientList() ?>;
ft_payment_bulklist.lists["x_trip"].options = <?php echo JsonEncode($t_payment_bulk_list->trip->lookupOptions()) ?>;
ft_payment_bulklist.lists["x_operator"] = <?php echo $t_payment_bulk_list->operator->Lookup->toClientList() ?>;
ft_payment_bulklist.lists["x_operator"].options = <?php echo JsonEncode($t_payment_bulk_list->operator->lookupOptions()) ?>;

// Form object for search
var ft_payment_bulklistsrch = currentSearchForm = new ew.Form("ft_payment_bulklistsrch");

// Filters
ft_payment_bulklistsrch.filterList = <?php echo $t_payment_bulk_list->getFilterList() ?>;

// Init search panel as collapsed
ft_payment_bulklistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_payment_bulk->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_payment_bulk_list->TotalRecs > 0 && $t_payment_bulk_list->ExportOptions->visible()) { ?>
<?php $t_payment_bulk_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_payment_bulk_list->ImportOptions->visible()) { ?>
<?php $t_payment_bulk_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_payment_bulk_list->SearchOptions->visible()) { ?>
<?php $t_payment_bulk_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_payment_bulk_list->FilterOptions->visible()) { ?>
<?php $t_payment_bulk_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_payment_bulk_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_payment_bulk->isExport() && !$t_payment_bulk->CurrentAction) { ?>
<form name="ft_payment_bulklistsrch" id="ft_payment_bulklistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_payment_bulk_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_payment_bulklistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_payment_bulk">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_payment_bulk_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_payment_bulk_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_payment_bulk_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_payment_bulk_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_payment_bulk_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_payment_bulk_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_payment_bulk_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_payment_bulk_list->showPageHeader(); ?>
<?php
$t_payment_bulk_list->showMessage();
?>
<?php if ($t_payment_bulk_list->TotalRecs > 0 || $t_payment_bulk->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_payment_bulk_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_payment_bulk">
<?php if (!$t_payment_bulk->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_payment_bulk->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_payment_bulk_list->Pager)) $t_payment_bulk_list->Pager = new PrevNextPager($t_payment_bulk_list->StartRec, $t_payment_bulk_list->DisplayRecs, $t_payment_bulk_list->TotalRecs, $t_payment_bulk_list->AutoHidePager) ?>
<?php if ($t_payment_bulk_list->Pager->RecordCount > 0 && $t_payment_bulk_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_payment_bulk_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_payment_bulk_list->pageUrl() ?>start=<?php echo $t_payment_bulk_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_payment_bulk_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_payment_bulk_list->pageUrl() ?>start=<?php echo $t_payment_bulk_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_payment_bulk_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_payment_bulk_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_payment_bulk_list->pageUrl() ?>start=<?php echo $t_payment_bulk_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_payment_bulk_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_payment_bulk_list->pageUrl() ?>start=<?php echo $t_payment_bulk_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_payment_bulk_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_payment_bulk_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_payment_bulk_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_payment_bulk_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_payment_bulk_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_payment_bulk_list->TotalRecs > 0 && (!$t_payment_bulk_list->AutoHidePageSizeSelector || $t_payment_bulk_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_payment_bulk">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_payment_bulk_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_payment_bulk_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_payment_bulk_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_payment_bulk_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_payment_bulk_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_payment_bulk->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_payment_bulk_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_payment_bulklist" id="ft_payment_bulklist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_payment_bulk_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_payment_bulk_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_payment_bulk">
<div id="gmp_t_payment_bulk" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_payment_bulk_list->TotalRecs > 0 || $t_payment_bulk->isGridEdit()) { ?>
<table id="tbl_t_payment_bulklist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_payment_bulk_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_payment_bulk_list->renderListOptions();

// Render list options (header, left)
$t_payment_bulk_list->ListOptions->render("header", "left");
?>
<?php if ($t_payment_bulk->id->Visible) { // id ?>
	<?php if ($t_payment_bulk->sortUrl($t_payment_bulk->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_payment_bulk->id->headerCellClass() ?>"><div id="elh_t_payment_bulk_id" class="t_payment_bulk_id"><div class="ew-table-header-caption"><?php echo $t_payment_bulk->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_payment_bulk->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment_bulk->SortUrl($t_payment_bulk->id) ?>',2);"><div id="elh_t_payment_bulk_id" class="t_payment_bulk_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment_bulk->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_payment_bulk->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment_bulk->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment_bulk->r_from->Visible) { // r_from ?>
	<?php if ($t_payment_bulk->sortUrl($t_payment_bulk->r_from) == "") { ?>
		<th data-name="r_from" class="<?php echo $t_payment_bulk->r_from->headerCellClass() ?>"><div id="elh_t_payment_bulk_r_from" class="t_payment_bulk_r_from"><div class="ew-table-header-caption"><?php echo $t_payment_bulk->r_from->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_from" class="<?php echo $t_payment_bulk->r_from->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment_bulk->SortUrl($t_payment_bulk->r_from) ?>',2);"><div id="elh_t_payment_bulk_r_from" class="t_payment_bulk_r_from">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment_bulk->r_from->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_payment_bulk->r_from->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment_bulk->r_from->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment_bulk->r_to->Visible) { // r_to ?>
	<?php if ($t_payment_bulk->sortUrl($t_payment_bulk->r_to) == "") { ?>
		<th data-name="r_to" class="<?php echo $t_payment_bulk->r_to->headerCellClass() ?>"><div id="elh_t_payment_bulk_r_to" class="t_payment_bulk_r_to"><div class="ew-table-header-caption"><?php echo $t_payment_bulk->r_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_to" class="<?php echo $t_payment_bulk->r_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment_bulk->SortUrl($t_payment_bulk->r_to) ?>',2);"><div id="elh_t_payment_bulk_r_to" class="t_payment_bulk_r_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment_bulk->r_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_payment_bulk->r_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment_bulk->r_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment_bulk->trip->Visible) { // trip ?>
	<?php if ($t_payment_bulk->sortUrl($t_payment_bulk->trip) == "") { ?>
		<th data-name="trip" class="<?php echo $t_payment_bulk->trip->headerCellClass() ?>"><div id="elh_t_payment_bulk_trip" class="t_payment_bulk_trip"><div class="ew-table-header-caption"><?php echo $t_payment_bulk->trip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="trip" class="<?php echo $t_payment_bulk->trip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment_bulk->SortUrl($t_payment_bulk->trip) ?>',2);"><div id="elh_t_payment_bulk_trip" class="t_payment_bulk_trip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment_bulk->trip->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_payment_bulk->trip->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment_bulk->trip->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment_bulk->amount->Visible) { // amount ?>
	<?php if ($t_payment_bulk->sortUrl($t_payment_bulk->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $t_payment_bulk->amount->headerCellClass() ?>"><div id="elh_t_payment_bulk_amount" class="t_payment_bulk_amount"><div class="ew-table-header-caption"><?php echo $t_payment_bulk->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $t_payment_bulk->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment_bulk->SortUrl($t_payment_bulk->amount) ?>',2);"><div id="elh_t_payment_bulk_amount" class="t_payment_bulk_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment_bulk->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_payment_bulk->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment_bulk->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment_bulk->dated->Visible) { // dated ?>
	<?php if ($t_payment_bulk->sortUrl($t_payment_bulk->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $t_payment_bulk->dated->headerCellClass() ?>"><div id="elh_t_payment_bulk_dated" class="t_payment_bulk_dated"><div class="ew-table-header-caption"><?php echo $t_payment_bulk->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $t_payment_bulk->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment_bulk->SortUrl($t_payment_bulk->dated) ?>',2);"><div id="elh_t_payment_bulk_dated" class="t_payment_bulk_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment_bulk->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_payment_bulk->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment_bulk->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment_bulk->remarks->Visible) { // remarks ?>
	<?php if ($t_payment_bulk->sortUrl($t_payment_bulk->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $t_payment_bulk->remarks->headerCellClass() ?>"><div id="elh_t_payment_bulk_remarks" class="t_payment_bulk_remarks"><div class="ew-table-header-caption"><?php echo $t_payment_bulk->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $t_payment_bulk->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment_bulk->SortUrl($t_payment_bulk->remarks) ?>',2);"><div id="elh_t_payment_bulk_remarks" class="t_payment_bulk_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment_bulk->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_payment_bulk->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment_bulk->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment_bulk->uploads->Visible) { // uploads ?>
	<?php if ($t_payment_bulk->sortUrl($t_payment_bulk->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $t_payment_bulk->uploads->headerCellClass() ?>"><div id="elh_t_payment_bulk_uploads" class="t_payment_bulk_uploads"><div class="ew-table-header-caption"><?php echo $t_payment_bulk->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $t_payment_bulk->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment_bulk->SortUrl($t_payment_bulk->uploads) ?>',2);"><div id="elh_t_payment_bulk_uploads" class="t_payment_bulk_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment_bulk->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_payment_bulk->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment_bulk->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment_bulk->operator->Visible) { // operator ?>
	<?php if ($t_payment_bulk->sortUrl($t_payment_bulk->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $t_payment_bulk->operator->headerCellClass() ?>"><div id="elh_t_payment_bulk_operator" class="t_payment_bulk_operator"><div class="ew-table-header-caption"><?php echo $t_payment_bulk->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $t_payment_bulk->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment_bulk->SortUrl($t_payment_bulk->operator) ?>',2);"><div id="elh_t_payment_bulk_operator" class="t_payment_bulk_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment_bulk->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_payment_bulk->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment_bulk->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment_bulk->datetime->Visible) { // datetime ?>
	<?php if ($t_payment_bulk->sortUrl($t_payment_bulk->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $t_payment_bulk->datetime->headerCellClass() ?>"><div id="elh_t_payment_bulk_datetime" class="t_payment_bulk_datetime"><div class="ew-table-header-caption"><?php echo $t_payment_bulk->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $t_payment_bulk->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment_bulk->SortUrl($t_payment_bulk->datetime) ?>',2);"><div id="elh_t_payment_bulk_datetime" class="t_payment_bulk_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment_bulk->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_payment_bulk->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment_bulk->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_payment_bulk_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_payment_bulk->ExportAll && $t_payment_bulk->isExport()) {
	$t_payment_bulk_list->StopRec = $t_payment_bulk_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_payment_bulk_list->TotalRecs > $t_payment_bulk_list->StartRec + $t_payment_bulk_list->DisplayRecs - 1)
		$t_payment_bulk_list->StopRec = $t_payment_bulk_list->StartRec + $t_payment_bulk_list->DisplayRecs - 1;
	else
		$t_payment_bulk_list->StopRec = $t_payment_bulk_list->TotalRecs;
}
$t_payment_bulk_list->RecCnt = $t_payment_bulk_list->StartRec - 1;
if ($t_payment_bulk_list->Recordset && !$t_payment_bulk_list->Recordset->EOF) {
	$t_payment_bulk_list->Recordset->moveFirst();
	$selectLimit = $t_payment_bulk_list->UseSelectLimit;
	if (!$selectLimit && $t_payment_bulk_list->StartRec > 1)
		$t_payment_bulk_list->Recordset->move($t_payment_bulk_list->StartRec - 1);
} elseif (!$t_payment_bulk->AllowAddDeleteRow && $t_payment_bulk_list->StopRec == 0) {
	$t_payment_bulk_list->StopRec = $t_payment_bulk->GridAddRowCount;
}

// Initialize aggregate
$t_payment_bulk->RowType = ROWTYPE_AGGREGATEINIT;
$t_payment_bulk->resetAttributes();
$t_payment_bulk_list->renderRow();
while ($t_payment_bulk_list->RecCnt < $t_payment_bulk_list->StopRec) {
	$t_payment_bulk_list->RecCnt++;
	if ($t_payment_bulk_list->RecCnt >= $t_payment_bulk_list->StartRec) {
		$t_payment_bulk_list->RowCnt++;

		// Set up key count
		$t_payment_bulk_list->KeyCount = $t_payment_bulk_list->RowIndex;

		// Init row class and style
		$t_payment_bulk->resetAttributes();
		$t_payment_bulk->CssClass = "";
		if ($t_payment_bulk->isGridAdd()) {
		} else {
			$t_payment_bulk_list->loadRowValues($t_payment_bulk_list->Recordset); // Load row values
		}
		$t_payment_bulk->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_payment_bulk->RowAttrs = array_merge($t_payment_bulk->RowAttrs, array('data-rowindex'=>$t_payment_bulk_list->RowCnt, 'id'=>'r' . $t_payment_bulk_list->RowCnt . '_t_payment_bulk', 'data-rowtype'=>$t_payment_bulk->RowType));

		// Render row
		$t_payment_bulk_list->renderRow();

		// Render list options
		$t_payment_bulk_list->renderListOptions();
?>
	<tr<?php echo $t_payment_bulk->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_payment_bulk_list->ListOptions->render("body", "left", $t_payment_bulk_list->RowCnt);
?>
	<?php if ($t_payment_bulk->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_payment_bulk->id->cellAttributes() ?>>
<span id="el<?php echo $t_payment_bulk_list->RowCnt ?>_t_payment_bulk_id" class="t_payment_bulk_id">
<span<?php echo $t_payment_bulk->id->viewAttributes() ?>>
<?php echo $t_payment_bulk->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment_bulk->r_from->Visible) { // r_from ?>
		<td data-name="r_from"<?php echo $t_payment_bulk->r_from->cellAttributes() ?>>
<span id="el<?php echo $t_payment_bulk_list->RowCnt ?>_t_payment_bulk_r_from" class="t_payment_bulk_r_from">
<span<?php echo $t_payment_bulk->r_from->viewAttributes() ?>>
<?php echo $t_payment_bulk->r_from->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment_bulk->r_to->Visible) { // r_to ?>
		<td data-name="r_to"<?php echo $t_payment_bulk->r_to->cellAttributes() ?>>
<span id="el<?php echo $t_payment_bulk_list->RowCnt ?>_t_payment_bulk_r_to" class="t_payment_bulk_r_to">
<span<?php echo $t_payment_bulk->r_to->viewAttributes() ?>>
<?php echo $t_payment_bulk->r_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment_bulk->trip->Visible) { // trip ?>
		<td data-name="trip"<?php echo $t_payment_bulk->trip->cellAttributes() ?>>
<span id="el<?php echo $t_payment_bulk_list->RowCnt ?>_t_payment_bulk_trip" class="t_payment_bulk_trip">
<span<?php echo $t_payment_bulk->trip->viewAttributes() ?>>
<?php echo $t_payment_bulk->trip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment_bulk->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $t_payment_bulk->amount->cellAttributes() ?>>
<span id="el<?php echo $t_payment_bulk_list->RowCnt ?>_t_payment_bulk_amount" class="t_payment_bulk_amount">
<span<?php echo $t_payment_bulk->amount->viewAttributes() ?>>
<?php echo $t_payment_bulk->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment_bulk->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $t_payment_bulk->dated->cellAttributes() ?>>
<span id="el<?php echo $t_payment_bulk_list->RowCnt ?>_t_payment_bulk_dated" class="t_payment_bulk_dated">
<span<?php echo $t_payment_bulk->dated->viewAttributes() ?>>
<?php echo $t_payment_bulk->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment_bulk->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $t_payment_bulk->remarks->cellAttributes() ?>>
<span id="el<?php echo $t_payment_bulk_list->RowCnt ?>_t_payment_bulk_remarks" class="t_payment_bulk_remarks">
<span<?php echo $t_payment_bulk->remarks->viewAttributes() ?>>
<?php echo $t_payment_bulk->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment_bulk->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $t_payment_bulk->uploads->cellAttributes() ?>>
<span id="el<?php echo $t_payment_bulk_list->RowCnt ?>_t_payment_bulk_uploads" class="t_payment_bulk_uploads">
<span>
<?php echo GetFileViewTag($t_payment_bulk->uploads, $t_payment_bulk->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment_bulk->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $t_payment_bulk->operator->cellAttributes() ?>>
<span id="el<?php echo $t_payment_bulk_list->RowCnt ?>_t_payment_bulk_operator" class="t_payment_bulk_operator">
<span<?php echo $t_payment_bulk->operator->viewAttributes() ?>>
<?php echo $t_payment_bulk->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment_bulk->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $t_payment_bulk->datetime->cellAttributes() ?>>
<span id="el<?php echo $t_payment_bulk_list->RowCnt ?>_t_payment_bulk_datetime" class="t_payment_bulk_datetime">
<span<?php echo $t_payment_bulk->datetime->viewAttributes() ?>>
<?php echo $t_payment_bulk->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_payment_bulk_list->ListOptions->render("body", "right", $t_payment_bulk_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_payment_bulk->isGridAdd())
		$t_payment_bulk_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_payment_bulk->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_payment_bulk_list->Recordset)
	$t_payment_bulk_list->Recordset->Close();
?>
<?php if (!$t_payment_bulk->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_payment_bulk->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_payment_bulk_list->Pager)) $t_payment_bulk_list->Pager = new PrevNextPager($t_payment_bulk_list->StartRec, $t_payment_bulk_list->DisplayRecs, $t_payment_bulk_list->TotalRecs, $t_payment_bulk_list->AutoHidePager) ?>
<?php if ($t_payment_bulk_list->Pager->RecordCount > 0 && $t_payment_bulk_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_payment_bulk_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_payment_bulk_list->pageUrl() ?>start=<?php echo $t_payment_bulk_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_payment_bulk_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_payment_bulk_list->pageUrl() ?>start=<?php echo $t_payment_bulk_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_payment_bulk_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_payment_bulk_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_payment_bulk_list->pageUrl() ?>start=<?php echo $t_payment_bulk_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_payment_bulk_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_payment_bulk_list->pageUrl() ?>start=<?php echo $t_payment_bulk_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_payment_bulk_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_payment_bulk_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_payment_bulk_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_payment_bulk_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_payment_bulk_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_payment_bulk_list->TotalRecs > 0 && (!$t_payment_bulk_list->AutoHidePageSizeSelector || $t_payment_bulk_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_payment_bulk">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_payment_bulk_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_payment_bulk_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_payment_bulk_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_payment_bulk_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_payment_bulk_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_payment_bulk->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_payment_bulk_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_payment_bulk_list->TotalRecs == 0 && !$t_payment_bulk->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_payment_bulk_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_payment_bulk_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_payment_bulk->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_payment_bulk->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_payment_bulk", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_payment_bulk_list->terminate();
?>