<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_payment_bulk_view = new t_payment_bulk_view();

// Run the page
$t_payment_bulk_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_payment_bulk_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_payment_bulk->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_payment_bulkview = currentForm = new ew.Form("ft_payment_bulkview", "view");

// Form_CustomValidate event
ft_payment_bulkview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_payment_bulkview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_payment_bulkview.lists["x_r_from"] = <?php echo $t_payment_bulk_view->r_from->Lookup->toClientList() ?>;
ft_payment_bulkview.lists["x_r_from"].options = <?php echo JsonEncode($t_payment_bulk_view->r_from->lookupOptions()) ?>;
ft_payment_bulkview.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_payment_bulkview.lists["x_r_to"] = <?php echo $t_payment_bulk_view->r_to->Lookup->toClientList() ?>;
ft_payment_bulkview.lists["x_r_to"].options = <?php echo JsonEncode($t_payment_bulk_view->r_to->lookupOptions()) ?>;
ft_payment_bulkview.autoSuggests["x_r_to"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_payment_bulkview.lists["x_trip"] = <?php echo $t_payment_bulk_view->trip->Lookup->toClientList() ?>;
ft_payment_bulkview.lists["x_trip"].options = <?php echo JsonEncode($t_payment_bulk_view->trip->lookupOptions()) ?>;
ft_payment_bulkview.lists["x_operator"] = <?php echo $t_payment_bulk_view->operator->Lookup->toClientList() ?>;
ft_payment_bulkview.lists["x_operator"].options = <?php echo JsonEncode($t_payment_bulk_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_payment_bulk->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_payment_bulk_view->ExportOptions->render("body") ?>
<?php $t_payment_bulk_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_payment_bulk_view->showPageHeader(); ?>
<?php
$t_payment_bulk_view->showMessage();
?>
<form name="ft_payment_bulkview" id="ft_payment_bulkview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_payment_bulk_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_payment_bulk_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_payment_bulk">
<input type="hidden" name="modal" value="<?php echo (int)$t_payment_bulk_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_payment_bulk->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_payment_bulk_view->TableLeftColumnClass ?>"><span id="elh_t_payment_bulk_id"><?php echo $t_payment_bulk->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_payment_bulk->id->cellAttributes() ?>>
<span id="el_t_payment_bulk_id">
<span<?php echo $t_payment_bulk->id->viewAttributes() ?>>
<?php echo $t_payment_bulk->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment_bulk->r_from->Visible) { // r_from ?>
	<tr id="r_r_from">
		<td class="<?php echo $t_payment_bulk_view->TableLeftColumnClass ?>"><span id="elh_t_payment_bulk_r_from"><?php echo $t_payment_bulk->r_from->caption() ?></span></td>
		<td data-name="r_from"<?php echo $t_payment_bulk->r_from->cellAttributes() ?>>
<span id="el_t_payment_bulk_r_from">
<span<?php echo $t_payment_bulk->r_from->viewAttributes() ?>>
<?php echo $t_payment_bulk->r_from->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment_bulk->r_to->Visible) { // r_to ?>
	<tr id="r_r_to">
		<td class="<?php echo $t_payment_bulk_view->TableLeftColumnClass ?>"><span id="elh_t_payment_bulk_r_to"><?php echo $t_payment_bulk->r_to->caption() ?></span></td>
		<td data-name="r_to"<?php echo $t_payment_bulk->r_to->cellAttributes() ?>>
<span id="el_t_payment_bulk_r_to">
<span<?php echo $t_payment_bulk->r_to->viewAttributes() ?>>
<?php echo $t_payment_bulk->r_to->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment_bulk->trip->Visible) { // trip ?>
	<tr id="r_trip">
		<td class="<?php echo $t_payment_bulk_view->TableLeftColumnClass ?>"><span id="elh_t_payment_bulk_trip"><?php echo $t_payment_bulk->trip->caption() ?></span></td>
		<td data-name="trip"<?php echo $t_payment_bulk->trip->cellAttributes() ?>>
<span id="el_t_payment_bulk_trip">
<span<?php echo $t_payment_bulk->trip->viewAttributes() ?>>
<?php echo $t_payment_bulk->trip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment_bulk->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $t_payment_bulk_view->TableLeftColumnClass ?>"><span id="elh_t_payment_bulk_amount"><?php echo $t_payment_bulk->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $t_payment_bulk->amount->cellAttributes() ?>>
<span id="el_t_payment_bulk_amount">
<span<?php echo $t_payment_bulk->amount->viewAttributes() ?>>
<?php echo $t_payment_bulk->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment_bulk->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $t_payment_bulk_view->TableLeftColumnClass ?>"><span id="elh_t_payment_bulk_dated"><?php echo $t_payment_bulk->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $t_payment_bulk->dated->cellAttributes() ?>>
<span id="el_t_payment_bulk_dated">
<span<?php echo $t_payment_bulk->dated->viewAttributes() ?>>
<?php echo $t_payment_bulk->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment_bulk->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $t_payment_bulk_view->TableLeftColumnClass ?>"><span id="elh_t_payment_bulk_remarks"><?php echo $t_payment_bulk->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $t_payment_bulk->remarks->cellAttributes() ?>>
<span id="el_t_payment_bulk_remarks">
<span<?php echo $t_payment_bulk->remarks->viewAttributes() ?>>
<?php echo $t_payment_bulk->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment_bulk->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $t_payment_bulk_view->TableLeftColumnClass ?>"><span id="elh_t_payment_bulk_uploads"><?php echo $t_payment_bulk->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $t_payment_bulk->uploads->cellAttributes() ?>>
<span id="el_t_payment_bulk_uploads">
<span>
<?php echo GetFileViewTag($t_payment_bulk->uploads, $t_payment_bulk->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment_bulk->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_payment_bulk_view->TableLeftColumnClass ?>"><span id="elh_t_payment_bulk_operator"><?php echo $t_payment_bulk->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_payment_bulk->operator->cellAttributes() ?>>
<span id="el_t_payment_bulk_operator">
<span<?php echo $t_payment_bulk->operator->viewAttributes() ?>>
<?php echo $t_payment_bulk->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment_bulk->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_payment_bulk_view->TableLeftColumnClass ?>"><span id="elh_t_payment_bulk_datetime"><?php echo $t_payment_bulk->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_payment_bulk->datetime->cellAttributes() ?>>
<span id="el_t_payment_bulk_datetime">
<span<?php echo $t_payment_bulk->datetime->viewAttributes() ?>>
<?php echo $t_payment_bulk->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_payment_bulk_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_payment_bulk->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_payment_bulk_view->terminate();
?>