<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_payment_delete = new t_payment_delete();

// Run the page
$t_payment_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_payment_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var ft_paymentdelete = currentForm = new ew.Form("ft_paymentdelete", "delete");

// Form_CustomValidate event
ft_paymentdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_paymentdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_paymentdelete.lists["x_trip"] = <?php echo $t_payment_delete->trip->Lookup->toClientList() ?>;
ft_paymentdelete.lists["x_trip"].options = <?php echo JsonEncode($t_payment_delete->trip->lookupOptions()) ?>;
ft_paymentdelete.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentdelete.lists["x_r_from"] = <?php echo $t_payment_delete->r_from->Lookup->toClientList() ?>;
ft_paymentdelete.lists["x_r_from"].options = <?php echo JsonEncode($t_payment_delete->r_from->lookupOptions()) ?>;
ft_paymentdelete.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentdelete.lists["x_driver"] = <?php echo $t_payment_delete->driver->Lookup->toClientList() ?>;
ft_paymentdelete.lists["x_driver"].options = <?php echo JsonEncode($t_payment_delete->driver->lookupOptions()) ?>;
ft_paymentdelete.autoSuggests["x_driver"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentdelete.lists["x_operator"] = <?php echo $t_payment_delete->operator->Lookup->toClientList() ?>;
ft_paymentdelete.lists["x_operator"].options = <?php echo JsonEncode($t_payment_delete->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_payment_delete->showPageHeader(); ?>
<?php
$t_payment_delete->showMessage();
?>
<form name="ft_paymentdelete" id="ft_paymentdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_payment_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_payment_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_payment">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($t_payment_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($t_payment->id->Visible) { // id ?>
		<th class="<?php echo $t_payment->id->headerCellClass() ?>"><span id="elh_t_payment_id" class="t_payment_id"><?php echo $t_payment->id->caption() ?></span></th>
<?php } ?>
<?php if ($t_payment->trip->Visible) { // trip ?>
		<th class="<?php echo $t_payment->trip->headerCellClass() ?>"><span id="elh_t_payment_trip" class="t_payment_trip"><?php echo $t_payment->trip->caption() ?></span></th>
<?php } ?>
<?php if ($t_payment->r_from->Visible) { // r_from ?>
		<th class="<?php echo $t_payment->r_from->headerCellClass() ?>"><span id="elh_t_payment_r_from" class="t_payment_r_from"><?php echo $t_payment->r_from->caption() ?></span></th>
<?php } ?>
<?php if ($t_payment->driver->Visible) { // driver ?>
		<th class="<?php echo $t_payment->driver->headerCellClass() ?>"><span id="elh_t_payment_driver" class="t_payment_driver"><?php echo $t_payment->driver->caption() ?></span></th>
<?php } ?>
<?php if ($t_payment->cashpaid->Visible) { // cashpaid ?>
		<th class="<?php echo $t_payment->cashpaid->headerCellClass() ?>"><span id="elh_t_payment_cashpaid" class="t_payment_cashpaid"><?php echo $t_payment->cashpaid->caption() ?></span></th>
<?php } ?>
<?php if ($t_payment->amount->Visible) { // amount ?>
		<th class="<?php echo $t_payment->amount->headerCellClass() ?>"><span id="elh_t_payment_amount" class="t_payment_amount"><?php echo $t_payment->amount->caption() ?></span></th>
<?php } ?>
<?php if ($t_payment->dated->Visible) { // dated ?>
		<th class="<?php echo $t_payment->dated->headerCellClass() ?>"><span id="elh_t_payment_dated" class="t_payment_dated"><?php echo $t_payment->dated->caption() ?></span></th>
<?php } ?>
<?php if ($t_payment->remarks->Visible) { // remarks ?>
		<th class="<?php echo $t_payment->remarks->headerCellClass() ?>"><span id="elh_t_payment_remarks" class="t_payment_remarks"><?php echo $t_payment->remarks->caption() ?></span></th>
<?php } ?>
<?php if ($t_payment->uploads->Visible) { // uploads ?>
		<th class="<?php echo $t_payment->uploads->headerCellClass() ?>"><span id="elh_t_payment_uploads" class="t_payment_uploads"><?php echo $t_payment->uploads->caption() ?></span></th>
<?php } ?>
<?php if ($t_payment->operator->Visible) { // operator ?>
		<th class="<?php echo $t_payment->operator->headerCellClass() ?>"><span id="elh_t_payment_operator" class="t_payment_operator"><?php echo $t_payment->operator->caption() ?></span></th>
<?php } ?>
<?php if ($t_payment->datetime->Visible) { // datetime ?>
		<th class="<?php echo $t_payment->datetime->headerCellClass() ?>"><span id="elh_t_payment_datetime" class="t_payment_datetime"><?php echo $t_payment->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$t_payment_delete->RecCnt = 0;
$i = 0;
while (!$t_payment_delete->Recordset->EOF) {
	$t_payment_delete->RecCnt++;
	$t_payment_delete->RowCnt++;

	// Set row properties
	$t_payment->resetAttributes();
	$t_payment->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$t_payment_delete->loadRowValues($t_payment_delete->Recordset);

	// Render row
	$t_payment_delete->renderRow();
?>
	<tr<?php echo $t_payment->rowAttributes() ?>>
<?php if ($t_payment->id->Visible) { // id ?>
		<td<?php echo $t_payment->id->cellAttributes() ?>>
<span id="el<?php echo $t_payment_delete->RowCnt ?>_t_payment_id" class="t_payment_id">
<span<?php echo $t_payment->id->viewAttributes() ?>>
<?php echo $t_payment->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_payment->trip->Visible) { // trip ?>
		<td<?php echo $t_payment->trip->cellAttributes() ?>>
<span id="el<?php echo $t_payment_delete->RowCnt ?>_t_payment_trip" class="t_payment_trip">
<span<?php echo $t_payment->trip->viewAttributes() ?>>
<?php echo $t_payment->trip->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_payment->r_from->Visible) { // r_from ?>
		<td<?php echo $t_payment->r_from->cellAttributes() ?>>
<span id="el<?php echo $t_payment_delete->RowCnt ?>_t_payment_r_from" class="t_payment_r_from">
<span<?php echo $t_payment->r_from->viewAttributes() ?>>
<?php echo $t_payment->r_from->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_payment->driver->Visible) { // driver ?>
		<td<?php echo $t_payment->driver->cellAttributes() ?>>
<span id="el<?php echo $t_payment_delete->RowCnt ?>_t_payment_driver" class="t_payment_driver">
<span<?php echo $t_payment->driver->viewAttributes() ?>>
<?php echo $t_payment->driver->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_payment->cashpaid->Visible) { // cashpaid ?>
		<td<?php echo $t_payment->cashpaid->cellAttributes() ?>>
<span id="el<?php echo $t_payment_delete->RowCnt ?>_t_payment_cashpaid" class="t_payment_cashpaid">
<span<?php echo $t_payment->cashpaid->viewAttributes() ?>>
<?php echo $t_payment->cashpaid->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_payment->amount->Visible) { // amount ?>
		<td<?php echo $t_payment->amount->cellAttributes() ?>>
<span id="el<?php echo $t_payment_delete->RowCnt ?>_t_payment_amount" class="t_payment_amount">
<span<?php echo $t_payment->amount->viewAttributes() ?>>
<?php echo $t_payment->amount->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_payment->dated->Visible) { // dated ?>
		<td<?php echo $t_payment->dated->cellAttributes() ?>>
<span id="el<?php echo $t_payment_delete->RowCnt ?>_t_payment_dated" class="t_payment_dated">
<span<?php echo $t_payment->dated->viewAttributes() ?>>
<?php echo $t_payment->dated->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_payment->remarks->Visible) { // remarks ?>
		<td<?php echo $t_payment->remarks->cellAttributes() ?>>
<span id="el<?php echo $t_payment_delete->RowCnt ?>_t_payment_remarks" class="t_payment_remarks">
<span<?php echo $t_payment->remarks->viewAttributes() ?>>
<?php echo $t_payment->remarks->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_payment->uploads->Visible) { // uploads ?>
		<td<?php echo $t_payment->uploads->cellAttributes() ?>>
<span id="el<?php echo $t_payment_delete->RowCnt ?>_t_payment_uploads" class="t_payment_uploads">
<span>
<?php echo GetFileViewTag($t_payment->uploads, $t_payment->uploads->getViewValue()) ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($t_payment->operator->Visible) { // operator ?>
		<td<?php echo $t_payment->operator->cellAttributes() ?>>
<span id="el<?php echo $t_payment_delete->RowCnt ?>_t_payment_operator" class="t_payment_operator">
<span<?php echo $t_payment->operator->viewAttributes() ?>>
<?php echo $t_payment->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_payment->datetime->Visible) { // datetime ?>
		<td<?php echo $t_payment->datetime->cellAttributes() ?>>
<span id="el<?php echo $t_payment_delete->RowCnt ?>_t_payment_datetime" class="t_payment_datetime">
<span<?php echo $t_payment->datetime->viewAttributes() ?>>
<?php echo $t_payment->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$t_payment_delete->Recordset->moveNext();
}
$t_payment_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_payment_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$t_payment_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_payment_delete->terminate();
?>