<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_payment_edit = new t_payment_edit();

// Run the page
$t_payment_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_payment_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var ft_paymentedit = currentForm = new ew.Form("ft_paymentedit", "edit");

// Validate form
ft_paymentedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_payment_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_payment->id->caption(), $t_payment->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_payment->id->errorMessage()) ?>");
		<?php if ($t_payment_edit->trip->Required) { ?>
			elm = this.getElements("x" + infix + "_trip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_payment->trip->caption(), $t_payment->trip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_payment_edit->r_from->Required) { ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_payment->r_from->caption(), $t_payment->r_from->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_payment->r_from->errorMessage()) ?>");
		<?php if ($t_payment_edit->driver->Required) { ?>
			elm = this.getElements("x" + infix + "_driver");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_payment->driver->caption(), $t_payment->driver->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_payment_edit->cashpaid->Required) { ?>
			elm = this.getElements("x" + infix + "_cashpaid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_payment->cashpaid->caption(), $t_payment->cashpaid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_cashpaid");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_payment->cashpaid->errorMessage()) ?>");
		<?php if ($t_payment_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_payment->amount->caption(), $t_payment->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_payment->amount->errorMessage()) ?>");
		<?php if ($t_payment_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_payment->dated->caption(), $t_payment->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_payment->dated->errorMessage()) ?>");
		<?php if ($t_payment_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_payment->remarks->caption(), $t_payment->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_payment_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $t_payment->uploads->caption(), $t_payment->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_payment_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_payment->operator->caption(), $t_payment->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_payment_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_payment->datetime->caption(), $t_payment->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_paymentedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_paymentedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_paymentedit.lists["x_trip"] = <?php echo $t_payment_edit->trip->Lookup->toClientList() ?>;
ft_paymentedit.lists["x_trip"].options = <?php echo JsonEncode($t_payment_edit->trip->lookupOptions()) ?>;
ft_paymentedit.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentedit.lists["x_r_from"] = <?php echo $t_payment_edit->r_from->Lookup->toClientList() ?>;
ft_paymentedit.lists["x_r_from"].options = <?php echo JsonEncode($t_payment_edit->r_from->lookupOptions()) ?>;
ft_paymentedit.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentedit.lists["x_driver"] = <?php echo $t_payment_edit->driver->Lookup->toClientList() ?>;
ft_paymentedit.lists["x_driver"].options = <?php echo JsonEncode($t_payment_edit->driver->lookupOptions()) ?>;
ft_paymentedit.autoSuggests["x_driver"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentedit.lists["x_operator"] = <?php echo $t_payment_edit->operator->Lookup->toClientList() ?>;
ft_paymentedit.lists["x_operator"].options = <?php echo JsonEncode($t_payment_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_payment_edit->showPageHeader(); ?>
<?php
$t_payment_edit->showMessage();
?>
<form name="ft_paymentedit" id="ft_paymentedit" class="<?php echo $t_payment_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_payment_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_payment_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_payment">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$t_payment_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_payment->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_t_payment_id" for="x_id" class="<?php echo $t_payment_edit->LeftColumnClass ?>"><?php echo $t_payment->id->caption() ?><?php echo ($t_payment->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_payment_edit->RightColumnClass ?>"><div<?php echo $t_payment->id->cellAttributes() ?>>
<span id="el_t_payment_id">
<span<?php echo $t_payment->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_payment->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_payment" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($t_payment->id->CurrentValue) ?>">
<?php echo $t_payment->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_payment->trip->Visible) { // trip ?>
	<div id="r_trip" class="form-group row">
		<label id="elh_t_payment_trip" class="<?php echo $t_payment_edit->LeftColumnClass ?>"><?php echo $t_payment->trip->caption() ?><?php echo ($t_payment->trip->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_payment_edit->RightColumnClass ?>"><div<?php echo $t_payment->trip->cellAttributes() ?>>
<span id="el_t_payment_trip">
<span<?php echo $t_payment->trip->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_payment->trip->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_payment" data-field="x_trip" name="x_trip" id="x_trip" value="<?php echo HtmlEncode($t_payment->trip->CurrentValue) ?>">
<?php echo $t_payment->trip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_payment->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label id="elh_t_payment_r_from" class="<?php echo $t_payment_edit->LeftColumnClass ?>"><?php echo $t_payment->r_from->caption() ?><?php echo ($t_payment->r_from->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_payment_edit->RightColumnClass ?>"><div<?php echo $t_payment->r_from->cellAttributes() ?>>
<span id="el_t_payment_r_from">
<?php
$wrkonchange = "" . trim(@$t_payment->r_from->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_payment->r_from->EditAttrs["onchange"] = "";
?>
<span id="as_x_r_from" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_r_from" id="sv_x_r_from" value="<?php echo RemoveHtml($t_payment->r_from->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_payment->r_from->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_payment->r_from->getPlaceHolder()) ?>"<?php echo $t_payment->r_from->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_payment->r_from->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_r_from',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_payment->r_from->ReadOnly || $t_payment->r_from->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_payment" data-field="x_r_from" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_payment->r_from->displayValueSeparatorAttribute() ?>" name="x_r_from" id="x_r_from" value="<?php echo HtmlEncode($t_payment->r_from->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_paymentedit.createAutoSuggest({"id":"x_r_from","forceSelect":true});
</script>
<?php echo $t_payment->r_from->Lookup->getParamTag("p_x_r_from") ?>
</span>
<?php echo $t_payment->r_from->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_payment->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label id="elh_t_payment_driver" class="<?php echo $t_payment_edit->LeftColumnClass ?>"><?php echo $t_payment->driver->caption() ?><?php echo ($t_payment->driver->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_payment_edit->RightColumnClass ?>"><div<?php echo $t_payment->driver->cellAttributes() ?>>
<span id="el_t_payment_driver">
<?php
$wrkonchange = "" . trim(@$t_payment->driver->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_payment->driver->EditAttrs["onchange"] = "";
?>
<span id="as_x_driver" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_driver" id="sv_x_driver" value="<?php echo RemoveHtml($t_payment->driver->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_payment->driver->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_payment->driver->getPlaceHolder()) ?>"<?php echo $t_payment->driver->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_payment" data-field="x_driver" data-value-separator="<?php echo $t_payment->driver->displayValueSeparatorAttribute() ?>" name="x_driver" id="x_driver" value="<?php echo HtmlEncode($t_payment->driver->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_paymentedit.createAutoSuggest({"id":"x_driver","forceSelect":false});
</script>
<?php echo $t_payment->driver->Lookup->getParamTag("p_x_driver") ?>
</span>
<?php echo $t_payment->driver->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_payment->cashpaid->Visible) { // cashpaid ?>
	<div id="r_cashpaid" class="form-group row">
		<label id="elh_t_payment_cashpaid" for="x_cashpaid" class="<?php echo $t_payment_edit->LeftColumnClass ?>"><?php echo $t_payment->cashpaid->caption() ?><?php echo ($t_payment->cashpaid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_payment_edit->RightColumnClass ?>"><div<?php echo $t_payment->cashpaid->cellAttributes() ?>>
<span id="el_t_payment_cashpaid">
<input type="text" data-table="t_payment" data-field="x_cashpaid" name="x_cashpaid" id="x_cashpaid" size="30" placeholder="<?php echo HtmlEncode($t_payment->cashpaid->getPlaceHolder()) ?>" value="<?php echo $t_payment->cashpaid->EditValue ?>"<?php echo $t_payment->cashpaid->editAttributes() ?>>
</span>
<?php echo $t_payment->cashpaid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_payment->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_t_payment_amount" for="x_amount" class="<?php echo $t_payment_edit->LeftColumnClass ?>"><?php echo $t_payment->amount->caption() ?><?php echo ($t_payment->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_payment_edit->RightColumnClass ?>"><div<?php echo $t_payment->amount->cellAttributes() ?>>
<span id="el_t_payment_amount">
<input type="text" data-table="t_payment" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($t_payment->amount->getPlaceHolder()) ?>" value="<?php echo $t_payment->amount->EditValue ?>"<?php echo $t_payment->amount->editAttributes() ?>>
</span>
<?php echo $t_payment->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_payment->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_t_payment_dated" for="x_dated" class="<?php echo $t_payment_edit->LeftColumnClass ?>"><?php echo $t_payment->dated->caption() ?><?php echo ($t_payment->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_payment_edit->RightColumnClass ?>"><div<?php echo $t_payment->dated->cellAttributes() ?>>
<span id="el_t_payment_dated">
<input type="text" data-table="t_payment" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_payment->dated->getPlaceHolder()) ?>" value="<?php echo $t_payment->dated->EditValue ?>"<?php echo $t_payment->dated->editAttributes() ?>>
<?php if (!$t_payment->dated->ReadOnly && !$t_payment->dated->Disabled && !isset($t_payment->dated->EditAttrs["readonly"]) && !isset($t_payment->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_paymentedit", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $t_payment->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_payment->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_t_payment_remarks" for="x_remarks" class="<?php echo $t_payment_edit->LeftColumnClass ?>"><?php echo $t_payment->remarks->caption() ?><?php echo ($t_payment->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_payment_edit->RightColumnClass ?>"><div<?php echo $t_payment->remarks->cellAttributes() ?>>
<span id="el_t_payment_remarks">
<input type="text" data-table="t_payment" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_payment->remarks->getPlaceHolder()) ?>" value="<?php echo $t_payment->remarks->EditValue ?>"<?php echo $t_payment->remarks->editAttributes() ?>>
</span>
<?php echo $t_payment->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_payment->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_t_payment_uploads" class="<?php echo $t_payment_edit->LeftColumnClass ?>"><?php echo $t_payment->uploads->caption() ?><?php echo ($t_payment->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_payment_edit->RightColumnClass ?>"><div<?php echo $t_payment->uploads->cellAttributes() ?>>
<span id="el_t_payment_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $t_payment->uploads->title() ? $t_payment->uploads->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($t_payment->uploads->ReadOnly || $t_payment->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="t_payment" data-field="x_uploads" name="x_uploads" id="x_uploads"<?php echo $t_payment->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $t_payment->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="255">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $t_payment->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $t_payment->uploads->UploadMaxFileSize ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $t_payment->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_payment_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_payment_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_payment_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_payment_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_payment_edit->terminate();
?>