<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_payment_list = new t_payment_list();

// Run the page
$t_payment_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_payment_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_payment->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_paymentlist = currentForm = new ew.Form("ft_paymentlist", "list");
ft_paymentlist.formKeyCountName = '<?php echo $t_payment_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_paymentlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_paymentlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_paymentlist.lists["x_trip"] = <?php echo $t_payment_list->trip->Lookup->toClientList() ?>;
ft_paymentlist.lists["x_trip"].options = <?php echo JsonEncode($t_payment_list->trip->lookupOptions()) ?>;
ft_paymentlist.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentlist.lists["x_r_from"] = <?php echo $t_payment_list->r_from->Lookup->toClientList() ?>;
ft_paymentlist.lists["x_r_from"].options = <?php echo JsonEncode($t_payment_list->r_from->lookupOptions()) ?>;
ft_paymentlist.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentlist.lists["x_driver"] = <?php echo $t_payment_list->driver->Lookup->toClientList() ?>;
ft_paymentlist.lists["x_driver"].options = <?php echo JsonEncode($t_payment_list->driver->lookupOptions()) ?>;
ft_paymentlist.autoSuggests["x_driver"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentlist.lists["x_operator"] = <?php echo $t_payment_list->operator->Lookup->toClientList() ?>;
ft_paymentlist.lists["x_operator"].options = <?php echo JsonEncode($t_payment_list->operator->lookupOptions()) ?>;

// Form object for search
var ft_paymentlistsrch = currentSearchForm = new ew.Form("ft_paymentlistsrch");

// Validate function for search
ft_paymentlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_trip");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_payment->trip->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_r_from");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_payment->r_from->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
ft_paymentlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_paymentlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_paymentlistsrch.lists["x_trip"] = <?php echo $t_payment_list->trip->Lookup->toClientList() ?>;
ft_paymentlistsrch.lists["x_trip"].options = <?php echo JsonEncode($t_payment_list->trip->lookupOptions()) ?>;
ft_paymentlistsrch.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentlistsrch.lists["x_r_from"] = <?php echo $t_payment_list->r_from->Lookup->toClientList() ?>;
ft_paymentlistsrch.lists["x_r_from"].options = <?php echo JsonEncode($t_payment_list->r_from->lookupOptions()) ?>;
ft_paymentlistsrch.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentlistsrch.lists["x_driver"] = <?php echo $t_payment_list->driver->Lookup->toClientList() ?>;
ft_paymentlistsrch.lists["x_driver"].options = <?php echo JsonEncode($t_payment_list->driver->lookupOptions()) ?>;
ft_paymentlistsrch.autoSuggests["x_driver"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
ft_paymentlistsrch.filterList = <?php echo $t_payment_list->getFilterList() ?>;

// Init search panel as collapsed
ft_paymentlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_payment->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_payment_list->TotalRecs > 0 && $t_payment_list->ExportOptions->visible()) { ?>
<?php $t_payment_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_payment_list->ImportOptions->visible()) { ?>
<?php $t_payment_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_payment_list->SearchOptions->visible()) { ?>
<?php $t_payment_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_payment_list->FilterOptions->visible()) { ?>
<?php $t_payment_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_payment_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_payment->isExport() && !$t_payment->CurrentAction) { ?>
<form name="ft_paymentlistsrch" id="ft_paymentlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_payment_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_paymentlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_payment">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$t_payment_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$t_payment->RowType = ROWTYPE_SEARCH;

// Render row
$t_payment->resetAttributes();
$t_payment_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($t_payment->trip->Visible) { // trip ?>
	<div id="xsc_trip" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $t_payment->trip->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_trip" id="z_trip" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$t_payment->trip->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_payment->trip->EditAttrs["onchange"] = "";
?>
<span id="as_x_trip" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_trip" id="sv_x_trip" value="<?php echo RemoveHtml($t_payment->trip->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_payment->trip->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_payment->trip->getPlaceHolder()) ?>"<?php echo $t_payment->trip->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_payment->trip->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_trip',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_payment->trip->ReadOnly || $t_payment->trip->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_payment" data-field="x_trip" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_payment->trip->displayValueSeparatorAttribute() ?>" name="x_trip" id="x_trip" value="<?php echo HtmlEncode($t_payment->trip->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_paymentlistsrch.createAutoSuggest({"id":"x_trip","forceSelect":true});
</script>
<?php echo $t_payment->trip->Lookup->getParamTag("p_x_trip") ?>
</span>
	</div>
<?php } ?>
<?php if ($t_payment->r_from->Visible) { // r_from ?>
	<div id="xsc_r_from" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $t_payment->r_from->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_from" id="z_r_from" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$t_payment->r_from->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_payment->r_from->EditAttrs["onchange"] = "";
?>
<span id="as_x_r_from" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_r_from" id="sv_x_r_from" value="<?php echo RemoveHtml($t_payment->r_from->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_payment->r_from->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_payment->r_from->getPlaceHolder()) ?>"<?php echo $t_payment->r_from->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_payment->r_from->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_r_from',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_payment->r_from->ReadOnly || $t_payment->r_from->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_payment" data-field="x_r_from" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_payment->r_from->displayValueSeparatorAttribute() ?>" name="x_r_from" id="x_r_from" value="<?php echo HtmlEncode($t_payment->r_from->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_paymentlistsrch.createAutoSuggest({"id":"x_r_from","forceSelect":true});
</script>
<?php echo $t_payment->r_from->Lookup->getParamTag("p_x_r_from") ?>
</span>
	</div>
<?php } ?>
<?php if ($t_payment->driver->Visible) { // driver ?>
	<div id="xsc_driver" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $t_payment->driver->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_driver" id="z_driver" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$t_payment->driver->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_payment->driver->EditAttrs["onchange"] = "";
?>
<span id="as_x_driver" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_driver" id="sv_x_driver" value="<?php echo RemoveHtml($t_payment->driver->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_payment->driver->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_payment->driver->getPlaceHolder()) ?>"<?php echo $t_payment->driver->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_payment" data-field="x_driver" data-value-separator="<?php echo $t_payment->driver->displayValueSeparatorAttribute() ?>" name="x_driver" id="x_driver" value="<?php echo HtmlEncode($t_payment->driver->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_paymentlistsrch.createAutoSuggest({"id":"x_driver","forceSelect":false});
</script>
<?php echo $t_payment->driver->Lookup->getParamTag("p_x_driver") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_payment_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_payment_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_payment_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_payment_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_payment_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_payment_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_payment_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_payment_list->showPageHeader(); ?>
<?php
$t_payment_list->showMessage();
?>
<?php if ($t_payment_list->TotalRecs > 0 || $t_payment->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_payment_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_payment">
<?php if (!$t_payment->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_payment->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_payment_list->Pager)) $t_payment_list->Pager = new PrevNextPager($t_payment_list->StartRec, $t_payment_list->DisplayRecs, $t_payment_list->TotalRecs, $t_payment_list->AutoHidePager) ?>
<?php if ($t_payment_list->Pager->RecordCount > 0 && $t_payment_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_payment_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_payment_list->pageUrl() ?>start=<?php echo $t_payment_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_payment_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_payment_list->pageUrl() ?>start=<?php echo $t_payment_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_payment_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_payment_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_payment_list->pageUrl() ?>start=<?php echo $t_payment_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_payment_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_payment_list->pageUrl() ?>start=<?php echo $t_payment_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_payment_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_payment_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_payment_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_payment_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_payment_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_payment_list->TotalRecs > 0 && (!$t_payment_list->AutoHidePageSizeSelector || $t_payment_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_payment">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_payment_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_payment_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_payment_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_payment_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_payment_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_payment->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_payment_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_paymentlist" id="ft_paymentlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_payment_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_payment_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_payment">
<div id="gmp_t_payment" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_payment_list->TotalRecs > 0 || $t_payment->isGridEdit()) { ?>
<table id="tbl_t_paymentlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_payment_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_payment_list->renderListOptions();

// Render list options (header, left)
$t_payment_list->ListOptions->render("header", "left");
?>
<?php if ($t_payment->id->Visible) { // id ?>
	<?php if ($t_payment->sortUrl($t_payment->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_payment->id->headerCellClass() ?>"><div id="elh_t_payment_id" class="t_payment_id"><div class="ew-table-header-caption"><?php echo $t_payment->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_payment->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment->SortUrl($t_payment->id) ?>',2);"><div id="elh_t_payment_id" class="t_payment_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_payment->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment->trip->Visible) { // trip ?>
	<?php if ($t_payment->sortUrl($t_payment->trip) == "") { ?>
		<th data-name="trip" class="<?php echo $t_payment->trip->headerCellClass() ?>"><div id="elh_t_payment_trip" class="t_payment_trip"><div class="ew-table-header-caption"><?php echo $t_payment->trip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="trip" class="<?php echo $t_payment->trip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment->SortUrl($t_payment->trip) ?>',2);"><div id="elh_t_payment_trip" class="t_payment_trip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment->trip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_payment->trip->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment->trip->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment->r_from->Visible) { // r_from ?>
	<?php if ($t_payment->sortUrl($t_payment->r_from) == "") { ?>
		<th data-name="r_from" class="<?php echo $t_payment->r_from->headerCellClass() ?>"><div id="elh_t_payment_r_from" class="t_payment_r_from"><div class="ew-table-header-caption"><?php echo $t_payment->r_from->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_from" class="<?php echo $t_payment->r_from->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment->SortUrl($t_payment->r_from) ?>',2);"><div id="elh_t_payment_r_from" class="t_payment_r_from">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment->r_from->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_payment->r_from->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment->r_from->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment->driver->Visible) { // driver ?>
	<?php if ($t_payment->sortUrl($t_payment->driver) == "") { ?>
		<th data-name="driver" class="<?php echo $t_payment->driver->headerCellClass() ?>"><div id="elh_t_payment_driver" class="t_payment_driver"><div class="ew-table-header-caption"><?php echo $t_payment->driver->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="driver" class="<?php echo $t_payment->driver->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment->SortUrl($t_payment->driver) ?>',2);"><div id="elh_t_payment_driver" class="t_payment_driver">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment->driver->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_payment->driver->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment->driver->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment->cashpaid->Visible) { // cashpaid ?>
	<?php if ($t_payment->sortUrl($t_payment->cashpaid) == "") { ?>
		<th data-name="cashpaid" class="<?php echo $t_payment->cashpaid->headerCellClass() ?>"><div id="elh_t_payment_cashpaid" class="t_payment_cashpaid"><div class="ew-table-header-caption"><?php echo $t_payment->cashpaid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cashpaid" class="<?php echo $t_payment->cashpaid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment->SortUrl($t_payment->cashpaid) ?>',2);"><div id="elh_t_payment_cashpaid" class="t_payment_cashpaid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment->cashpaid->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_payment->cashpaid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment->cashpaid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment->amount->Visible) { // amount ?>
	<?php if ($t_payment->sortUrl($t_payment->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $t_payment->amount->headerCellClass() ?>"><div id="elh_t_payment_amount" class="t_payment_amount"><div class="ew-table-header-caption"><?php echo $t_payment->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $t_payment->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment->SortUrl($t_payment->amount) ?>',2);"><div id="elh_t_payment_amount" class="t_payment_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_payment->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment->dated->Visible) { // dated ?>
	<?php if ($t_payment->sortUrl($t_payment->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $t_payment->dated->headerCellClass() ?>"><div id="elh_t_payment_dated" class="t_payment_dated"><div class="ew-table-header-caption"><?php echo $t_payment->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $t_payment->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment->SortUrl($t_payment->dated) ?>',2);"><div id="elh_t_payment_dated" class="t_payment_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_payment->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment->remarks->Visible) { // remarks ?>
	<?php if ($t_payment->sortUrl($t_payment->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $t_payment->remarks->headerCellClass() ?>"><div id="elh_t_payment_remarks" class="t_payment_remarks"><div class="ew-table-header-caption"><?php echo $t_payment->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $t_payment->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment->SortUrl($t_payment->remarks) ?>',2);"><div id="elh_t_payment_remarks" class="t_payment_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_payment->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment->uploads->Visible) { // uploads ?>
	<?php if ($t_payment->sortUrl($t_payment->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $t_payment->uploads->headerCellClass() ?>"><div id="elh_t_payment_uploads" class="t_payment_uploads"><div class="ew-table-header-caption"><?php echo $t_payment->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $t_payment->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment->SortUrl($t_payment->uploads) ?>',2);"><div id="elh_t_payment_uploads" class="t_payment_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_payment->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment->operator->Visible) { // operator ?>
	<?php if ($t_payment->sortUrl($t_payment->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $t_payment->operator->headerCellClass() ?>"><div id="elh_t_payment_operator" class="t_payment_operator"><div class="ew-table-header-caption"><?php echo $t_payment->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $t_payment->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment->SortUrl($t_payment->operator) ?>',2);"><div id="elh_t_payment_operator" class="t_payment_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_payment->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_payment->datetime->Visible) { // datetime ?>
	<?php if ($t_payment->sortUrl($t_payment->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $t_payment->datetime->headerCellClass() ?>"><div id="elh_t_payment_datetime" class="t_payment_datetime"><div class="ew-table-header-caption"><?php echo $t_payment->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $t_payment->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_payment->SortUrl($t_payment->datetime) ?>',2);"><div id="elh_t_payment_datetime" class="t_payment_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_payment->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_payment->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_payment->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_payment_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_payment->ExportAll && $t_payment->isExport()) {
	$t_payment_list->StopRec = $t_payment_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_payment_list->TotalRecs > $t_payment_list->StartRec + $t_payment_list->DisplayRecs - 1)
		$t_payment_list->StopRec = $t_payment_list->StartRec + $t_payment_list->DisplayRecs - 1;
	else
		$t_payment_list->StopRec = $t_payment_list->TotalRecs;
}
$t_payment_list->RecCnt = $t_payment_list->StartRec - 1;
if ($t_payment_list->Recordset && !$t_payment_list->Recordset->EOF) {
	$t_payment_list->Recordset->moveFirst();
	$selectLimit = $t_payment_list->UseSelectLimit;
	if (!$selectLimit && $t_payment_list->StartRec > 1)
		$t_payment_list->Recordset->move($t_payment_list->StartRec - 1);
} elseif (!$t_payment->AllowAddDeleteRow && $t_payment_list->StopRec == 0) {
	$t_payment_list->StopRec = $t_payment->GridAddRowCount;
}

// Initialize aggregate
$t_payment->RowType = ROWTYPE_AGGREGATEINIT;
$t_payment->resetAttributes();
$t_payment_list->renderRow();
while ($t_payment_list->RecCnt < $t_payment_list->StopRec) {
	$t_payment_list->RecCnt++;
	if ($t_payment_list->RecCnt >= $t_payment_list->StartRec) {
		$t_payment_list->RowCnt++;

		// Set up key count
		$t_payment_list->KeyCount = $t_payment_list->RowIndex;

		// Init row class and style
		$t_payment->resetAttributes();
		$t_payment->CssClass = "";
		if ($t_payment->isGridAdd()) {
		} else {
			$t_payment_list->loadRowValues($t_payment_list->Recordset); // Load row values
		}
		$t_payment->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_payment->RowAttrs = array_merge($t_payment->RowAttrs, array('data-rowindex'=>$t_payment_list->RowCnt, 'id'=>'r' . $t_payment_list->RowCnt . '_t_payment', 'data-rowtype'=>$t_payment->RowType));

		// Render row
		$t_payment_list->renderRow();

		// Render list options
		$t_payment_list->renderListOptions();
?>
	<tr<?php echo $t_payment->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_payment_list->ListOptions->render("body", "left", $t_payment_list->RowCnt);
?>
	<?php if ($t_payment->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_payment->id->cellAttributes() ?>>
<span id="el<?php echo $t_payment_list->RowCnt ?>_t_payment_id" class="t_payment_id">
<span<?php echo $t_payment->id->viewAttributes() ?>>
<?php echo $t_payment->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment->trip->Visible) { // trip ?>
		<td data-name="trip"<?php echo $t_payment->trip->cellAttributes() ?>>
<span id="el<?php echo $t_payment_list->RowCnt ?>_t_payment_trip" class="t_payment_trip">
<span<?php echo $t_payment->trip->viewAttributes() ?>>
<?php echo $t_payment->trip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment->r_from->Visible) { // r_from ?>
		<td data-name="r_from"<?php echo $t_payment->r_from->cellAttributes() ?>>
<span id="el<?php echo $t_payment_list->RowCnt ?>_t_payment_r_from" class="t_payment_r_from">
<span<?php echo $t_payment->r_from->viewAttributes() ?>>
<?php echo $t_payment->r_from->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment->driver->Visible) { // driver ?>
		<td data-name="driver"<?php echo $t_payment->driver->cellAttributes() ?>>
<span id="el<?php echo $t_payment_list->RowCnt ?>_t_payment_driver" class="t_payment_driver">
<span<?php echo $t_payment->driver->viewAttributes() ?>>
<?php echo $t_payment->driver->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment->cashpaid->Visible) { // cashpaid ?>
		<td data-name="cashpaid"<?php echo $t_payment->cashpaid->cellAttributes() ?>>
<span id="el<?php echo $t_payment_list->RowCnt ?>_t_payment_cashpaid" class="t_payment_cashpaid">
<span<?php echo $t_payment->cashpaid->viewAttributes() ?>>
<?php echo $t_payment->cashpaid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $t_payment->amount->cellAttributes() ?>>
<span id="el<?php echo $t_payment_list->RowCnt ?>_t_payment_amount" class="t_payment_amount">
<span<?php echo $t_payment->amount->viewAttributes() ?>>
<?php echo $t_payment->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $t_payment->dated->cellAttributes() ?>>
<span id="el<?php echo $t_payment_list->RowCnt ?>_t_payment_dated" class="t_payment_dated">
<span<?php echo $t_payment->dated->viewAttributes() ?>>
<?php echo $t_payment->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $t_payment->remarks->cellAttributes() ?>>
<span id="el<?php echo $t_payment_list->RowCnt ?>_t_payment_remarks" class="t_payment_remarks">
<span<?php echo $t_payment->remarks->viewAttributes() ?>>
<?php echo $t_payment->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $t_payment->uploads->cellAttributes() ?>>
<span id="el<?php echo $t_payment_list->RowCnt ?>_t_payment_uploads" class="t_payment_uploads">
<span>
<?php echo GetFileViewTag($t_payment->uploads, $t_payment->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $t_payment->operator->cellAttributes() ?>>
<span id="el<?php echo $t_payment_list->RowCnt ?>_t_payment_operator" class="t_payment_operator">
<span<?php echo $t_payment->operator->viewAttributes() ?>>
<?php echo $t_payment->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_payment->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $t_payment->datetime->cellAttributes() ?>>
<span id="el<?php echo $t_payment_list->RowCnt ?>_t_payment_datetime" class="t_payment_datetime">
<span<?php echo $t_payment->datetime->viewAttributes() ?>>
<?php echo $t_payment->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_payment_list->ListOptions->render("body", "right", $t_payment_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_payment->isGridAdd())
		$t_payment_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_payment->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_payment_list->Recordset)
	$t_payment_list->Recordset->Close();
?>
<?php if (!$t_payment->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_payment->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_payment_list->Pager)) $t_payment_list->Pager = new PrevNextPager($t_payment_list->StartRec, $t_payment_list->DisplayRecs, $t_payment_list->TotalRecs, $t_payment_list->AutoHidePager) ?>
<?php if ($t_payment_list->Pager->RecordCount > 0 && $t_payment_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_payment_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_payment_list->pageUrl() ?>start=<?php echo $t_payment_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_payment_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_payment_list->pageUrl() ?>start=<?php echo $t_payment_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_payment_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_payment_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_payment_list->pageUrl() ?>start=<?php echo $t_payment_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_payment_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_payment_list->pageUrl() ?>start=<?php echo $t_payment_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_payment_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_payment_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_payment_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_payment_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_payment_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_payment_list->TotalRecs > 0 && (!$t_payment_list->AutoHidePageSizeSelector || $t_payment_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_payment">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_payment_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_payment_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_payment_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_payment_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_payment_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_payment->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_payment_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_payment_list->TotalRecs == 0 && !$t_payment->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_payment_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_payment_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_payment->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_payment->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_payment", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_payment_list->terminate();
?>