<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_payment_search = new t_payment_search();

// Run the page
$t_payment_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_payment_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_payment_search->IsModal) { ?>
var ft_paymentsearch = currentAdvancedSearchForm = new ew.Form("ft_paymentsearch", "search");
<?php } else { ?>
var ft_paymentsearch = currentForm = new ew.Form("ft_paymentsearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_paymentsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_paymentsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_paymentsearch.lists["x_trip"] = <?php echo $t_payment_search->trip->Lookup->toClientList() ?>;
ft_paymentsearch.lists["x_trip"].options = <?php echo JsonEncode($t_payment_search->trip->lookupOptions()) ?>;
ft_paymentsearch.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentsearch.lists["x_r_from"] = <?php echo $t_payment_search->r_from->Lookup->toClientList() ?>;
ft_paymentsearch.lists["x_r_from"].options = <?php echo JsonEncode($t_payment_search->r_from->lookupOptions()) ?>;
ft_paymentsearch.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentsearch.lists["x_driver"] = <?php echo $t_payment_search->driver->Lookup->toClientList() ?>;
ft_paymentsearch.lists["x_driver"].options = <?php echo JsonEncode($t_payment_search->driver->lookupOptions()) ?>;
ft_paymentsearch.autoSuggests["x_driver"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentsearch.lists["x_operator"] = <?php echo $t_payment_search->operator->Lookup->toClientList() ?>;
ft_paymentsearch.lists["x_operator"].options = <?php echo JsonEncode($t_payment_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

ft_paymentsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_payment->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_trip");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_payment->trip->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_r_from");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_payment->r_from->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cashpaid");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_payment->cashpaid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_payment->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_payment->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_payment->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_payment_search->showPageHeader(); ?>
<?php
$t_payment_search->showMessage();
?>
<form name="ft_paymentsearch" id="ft_paymentsearch" class="<?php echo $t_payment_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_payment_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_payment_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_payment">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_payment_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_payment->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $t_payment_search->LeftColumnClass ?>"><span id="elh_t_payment_id"><?php echo $t_payment->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $t_payment_search->RightColumnClass ?>"><div<?php echo $t_payment->id->cellAttributes() ?>>
			<span id="el_t_payment_id">
<input type="text" data-table="t_payment" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($t_payment->id->getPlaceHolder()) ?>" value="<?php echo $t_payment->id->EditValue ?>"<?php echo $t_payment->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_payment->trip->Visible) { // trip ?>
	<div id="r_trip" class="form-group row">
		<label class="<?php echo $t_payment_search->LeftColumnClass ?>"><span id="elh_t_payment_trip"><?php echo $t_payment->trip->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_trip" id="z_trip" value="="></span>
		</label>
		<div class="<?php echo $t_payment_search->RightColumnClass ?>"><div<?php echo $t_payment->trip->cellAttributes() ?>>
			<span id="el_t_payment_trip">
<?php
$wrkonchange = "" . trim(@$t_payment->trip->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_payment->trip->EditAttrs["onchange"] = "";
?>
<span id="as_x_trip" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_trip" id="sv_x_trip" value="<?php echo RemoveHtml($t_payment->trip->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_payment->trip->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_payment->trip->getPlaceHolder()) ?>"<?php echo $t_payment->trip->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_payment->trip->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_trip',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_payment->trip->ReadOnly || $t_payment->trip->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_payment" data-field="x_trip" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_payment->trip->displayValueSeparatorAttribute() ?>" name="x_trip" id="x_trip" value="<?php echo HtmlEncode($t_payment->trip->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_paymentsearch.createAutoSuggest({"id":"x_trip","forceSelect":true});
</script>
<?php echo $t_payment->trip->Lookup->getParamTag("p_x_trip") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_payment->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label class="<?php echo $t_payment_search->LeftColumnClass ?>"><span id="elh_t_payment_r_from"><?php echo $t_payment->r_from->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_from" id="z_r_from" value="="></span>
		</label>
		<div class="<?php echo $t_payment_search->RightColumnClass ?>"><div<?php echo $t_payment->r_from->cellAttributes() ?>>
			<span id="el_t_payment_r_from">
<?php
$wrkonchange = "" . trim(@$t_payment->r_from->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_payment->r_from->EditAttrs["onchange"] = "";
?>
<span id="as_x_r_from" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_r_from" id="sv_x_r_from" value="<?php echo RemoveHtml($t_payment->r_from->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_payment->r_from->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_payment->r_from->getPlaceHolder()) ?>"<?php echo $t_payment->r_from->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_payment->r_from->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_r_from',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_payment->r_from->ReadOnly || $t_payment->r_from->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_payment" data-field="x_r_from" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_payment->r_from->displayValueSeparatorAttribute() ?>" name="x_r_from" id="x_r_from" value="<?php echo HtmlEncode($t_payment->r_from->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_paymentsearch.createAutoSuggest({"id":"x_r_from","forceSelect":true});
</script>
<?php echo $t_payment->r_from->Lookup->getParamTag("p_x_r_from") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_payment->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label class="<?php echo $t_payment_search->LeftColumnClass ?>"><span id="elh_t_payment_driver"><?php echo $t_payment->driver->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_driver" id="z_driver" value="="></span>
		</label>
		<div class="<?php echo $t_payment_search->RightColumnClass ?>"><div<?php echo $t_payment->driver->cellAttributes() ?>>
			<span id="el_t_payment_driver">
<?php
$wrkonchange = "" . trim(@$t_payment->driver->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_payment->driver->EditAttrs["onchange"] = "";
?>
<span id="as_x_driver" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_driver" id="sv_x_driver" value="<?php echo RemoveHtml($t_payment->driver->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_payment->driver->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_payment->driver->getPlaceHolder()) ?>"<?php echo $t_payment->driver->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_payment" data-field="x_driver" data-value-separator="<?php echo $t_payment->driver->displayValueSeparatorAttribute() ?>" name="x_driver" id="x_driver" value="<?php echo HtmlEncode($t_payment->driver->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_paymentsearch.createAutoSuggest({"id":"x_driver","forceSelect":false});
</script>
<?php echo $t_payment->driver->Lookup->getParamTag("p_x_driver") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_payment->cashpaid->Visible) { // cashpaid ?>
	<div id="r_cashpaid" class="form-group row">
		<label for="x_cashpaid" class="<?php echo $t_payment_search->LeftColumnClass ?>"><span id="elh_t_payment_cashpaid"><?php echo $t_payment->cashpaid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cashpaid" id="z_cashpaid" value="="></span>
		</label>
		<div class="<?php echo $t_payment_search->RightColumnClass ?>"><div<?php echo $t_payment->cashpaid->cellAttributes() ?>>
			<span id="el_t_payment_cashpaid">
<input type="text" data-table="t_payment" data-field="x_cashpaid" name="x_cashpaid" id="x_cashpaid" size="30" placeholder="<?php echo HtmlEncode($t_payment->cashpaid->getPlaceHolder()) ?>" value="<?php echo $t_payment->cashpaid->EditValue ?>"<?php echo $t_payment->cashpaid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_payment->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $t_payment_search->LeftColumnClass ?>"><span id="elh_t_payment_amount"><?php echo $t_payment->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $t_payment_search->RightColumnClass ?>"><div<?php echo $t_payment->amount->cellAttributes() ?>>
			<span id="el_t_payment_amount">
<input type="text" data-table="t_payment" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($t_payment->amount->getPlaceHolder()) ?>" value="<?php echo $t_payment->amount->EditValue ?>"<?php echo $t_payment->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_payment->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $t_payment_search->LeftColumnClass ?>"><span id="elh_t_payment_dated"><?php echo $t_payment->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $t_payment_search->RightColumnClass ?>"><div<?php echo $t_payment->dated->cellAttributes() ?>>
			<span id="el_t_payment_dated">
<input type="text" data-table="t_payment" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_payment->dated->getPlaceHolder()) ?>" value="<?php echo $t_payment->dated->EditValue ?>"<?php echo $t_payment->dated->editAttributes() ?>>
<?php if (!$t_payment->dated->ReadOnly && !$t_payment->dated->Disabled && !isset($t_payment->dated->EditAttrs["readonly"]) && !isset($t_payment->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_paymentsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_payment->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $t_payment_search->LeftColumnClass ?>"><span id="elh_t_payment_remarks"><?php echo $t_payment->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_payment_search->RightColumnClass ?>"><div<?php echo $t_payment->remarks->cellAttributes() ?>>
			<span id="el_t_payment_remarks">
<input type="text" data-table="t_payment" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_payment->remarks->getPlaceHolder()) ?>" value="<?php echo $t_payment->remarks->EditValue ?>"<?php echo $t_payment->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_payment->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $t_payment_search->LeftColumnClass ?>"><span id="elh_t_payment_uploads"><?php echo $t_payment->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_payment_search->RightColumnClass ?>"><div<?php echo $t_payment->uploads->cellAttributes() ?>>
			<span id="el_t_payment_uploads">
<input type="text" data-table="t_payment" data-field="x_uploads" name="x_uploads" id="x_uploads" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_payment->uploads->getPlaceHolder()) ?>" value="<?php echo $t_payment->uploads->EditValue ?>"<?php echo $t_payment->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_payment->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $t_payment_search->LeftColumnClass ?>"><span id="elh_t_payment_operator"><?php echo $t_payment->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $t_payment_search->RightColumnClass ?>"><div<?php echo $t_payment->operator->cellAttributes() ?>>
			<span id="el_t_payment_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_payment" data-field="x_operator" data-value-separator="<?php echo $t_payment->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $t_payment->operator->editAttributes() ?>>
		<?php echo $t_payment->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $t_payment->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_payment->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $t_payment_search->LeftColumnClass ?>"><span id="elh_t_payment_datetime"><?php echo $t_payment->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $t_payment_search->RightColumnClass ?>"><div<?php echo $t_payment->datetime->cellAttributes() ?>>
			<span id="el_t_payment_datetime">
<input type="text" data-table="t_payment" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($t_payment->datetime->getPlaceHolder()) ?>" value="<?php echo $t_payment->datetime->EditValue ?>"<?php echo $t_payment->datetime->editAttributes() ?>>
<?php if (!$t_payment->datetime->ReadOnly && !$t_payment->datetime->Disabled && !isset($t_payment->datetime->EditAttrs["readonly"]) && !isset($t_payment->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_paymentsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_payment_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_payment_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_payment_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_payment_search->terminate();
?>