<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_payment_view = new t_payment_view();

// Run the page
$t_payment_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_payment_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_payment->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_paymentview = currentForm = new ew.Form("ft_paymentview", "view");

// Form_CustomValidate event
ft_paymentview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_paymentview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_paymentview.lists["x_trip"] = <?php echo $t_payment_view->trip->Lookup->toClientList() ?>;
ft_paymentview.lists["x_trip"].options = <?php echo JsonEncode($t_payment_view->trip->lookupOptions()) ?>;
ft_paymentview.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentview.lists["x_r_from"] = <?php echo $t_payment_view->r_from->Lookup->toClientList() ?>;
ft_paymentview.lists["x_r_from"].options = <?php echo JsonEncode($t_payment_view->r_from->lookupOptions()) ?>;
ft_paymentview.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentview.lists["x_driver"] = <?php echo $t_payment_view->driver->Lookup->toClientList() ?>;
ft_paymentview.lists["x_driver"].options = <?php echo JsonEncode($t_payment_view->driver->lookupOptions()) ?>;
ft_paymentview.autoSuggests["x_driver"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_paymentview.lists["x_operator"] = <?php echo $t_payment_view->operator->Lookup->toClientList() ?>;
ft_paymentview.lists["x_operator"].options = <?php echo JsonEncode($t_payment_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_payment->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_payment_view->ExportOptions->render("body") ?>
<?php $t_payment_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_payment_view->showPageHeader(); ?>
<?php
$t_payment_view->showMessage();
?>
<form name="ft_paymentview" id="ft_paymentview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_payment_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_payment_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_payment">
<input type="hidden" name="modal" value="<?php echo (int)$t_payment_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_payment->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_payment_view->TableLeftColumnClass ?>"><span id="elh_t_payment_id"><?php echo $t_payment->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_payment->id->cellAttributes() ?>>
<span id="el_t_payment_id">
<span<?php echo $t_payment->id->viewAttributes() ?>>
<?php echo $t_payment->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment->trip->Visible) { // trip ?>
	<tr id="r_trip">
		<td class="<?php echo $t_payment_view->TableLeftColumnClass ?>"><span id="elh_t_payment_trip"><?php echo $t_payment->trip->caption() ?></span></td>
		<td data-name="trip"<?php echo $t_payment->trip->cellAttributes() ?>>
<span id="el_t_payment_trip">
<span<?php echo $t_payment->trip->viewAttributes() ?>>
<?php echo $t_payment->trip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment->r_from->Visible) { // r_from ?>
	<tr id="r_r_from">
		<td class="<?php echo $t_payment_view->TableLeftColumnClass ?>"><span id="elh_t_payment_r_from"><?php echo $t_payment->r_from->caption() ?></span></td>
		<td data-name="r_from"<?php echo $t_payment->r_from->cellAttributes() ?>>
<span id="el_t_payment_r_from">
<span<?php echo $t_payment->r_from->viewAttributes() ?>>
<?php echo $t_payment->r_from->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment->driver->Visible) { // driver ?>
	<tr id="r_driver">
		<td class="<?php echo $t_payment_view->TableLeftColumnClass ?>"><span id="elh_t_payment_driver"><?php echo $t_payment->driver->caption() ?></span></td>
		<td data-name="driver"<?php echo $t_payment->driver->cellAttributes() ?>>
<span id="el_t_payment_driver">
<span<?php echo $t_payment->driver->viewAttributes() ?>>
<?php echo $t_payment->driver->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment->cashpaid->Visible) { // cashpaid ?>
	<tr id="r_cashpaid">
		<td class="<?php echo $t_payment_view->TableLeftColumnClass ?>"><span id="elh_t_payment_cashpaid"><?php echo $t_payment->cashpaid->caption() ?></span></td>
		<td data-name="cashpaid"<?php echo $t_payment->cashpaid->cellAttributes() ?>>
<span id="el_t_payment_cashpaid">
<span<?php echo $t_payment->cashpaid->viewAttributes() ?>>
<?php echo $t_payment->cashpaid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $t_payment_view->TableLeftColumnClass ?>"><span id="elh_t_payment_amount"><?php echo $t_payment->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $t_payment->amount->cellAttributes() ?>>
<span id="el_t_payment_amount">
<span<?php echo $t_payment->amount->viewAttributes() ?>>
<?php echo $t_payment->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $t_payment_view->TableLeftColumnClass ?>"><span id="elh_t_payment_dated"><?php echo $t_payment->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $t_payment->dated->cellAttributes() ?>>
<span id="el_t_payment_dated">
<span<?php echo $t_payment->dated->viewAttributes() ?>>
<?php echo $t_payment->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $t_payment_view->TableLeftColumnClass ?>"><span id="elh_t_payment_remarks"><?php echo $t_payment->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $t_payment->remarks->cellAttributes() ?>>
<span id="el_t_payment_remarks">
<span<?php echo $t_payment->remarks->viewAttributes() ?>>
<?php echo $t_payment->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $t_payment_view->TableLeftColumnClass ?>"><span id="elh_t_payment_uploads"><?php echo $t_payment->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $t_payment->uploads->cellAttributes() ?>>
<span id="el_t_payment_uploads">
<span>
<?php echo GetFileViewTag($t_payment->uploads, $t_payment->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_payment_view->TableLeftColumnClass ?>"><span id="elh_t_payment_operator"><?php echo $t_payment->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_payment->operator->cellAttributes() ?>>
<span id="el_t_payment_operator">
<span<?php echo $t_payment->operator->viewAttributes() ?>>
<?php echo $t_payment->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_payment->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_payment_view->TableLeftColumnClass ?>"><span id="elh_t_payment_datetime"><?php echo $t_payment->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_payment->datetime->cellAttributes() ?>>
<span id="el_t_payment_datetime">
<span<?php echo $t_payment->datetime->viewAttributes() ?>>
<?php echo $t_payment->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_payment_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_payment->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_payment_view->terminate();
?>