<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_receipt_bulk_add = new t_receipt_bulk_add();

// Run the page
$t_receipt_bulk_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_receipt_bulk_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var ft_receipt_bulkadd = currentForm = new ew.Form("ft_receipt_bulkadd", "add");

// Validate form
ft_receipt_bulkadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_receipt_bulk_add->r_from->Required) { ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_bulk->r_from->caption(), $t_receipt_bulk->r_from->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_receipt_bulk_add->r_to->Required) { ?>
			elm = this.getElements("x" + infix + "_r_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_bulk->r_to->caption(), $t_receipt_bulk->r_to->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_r_to");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_receipt_bulk->r_to->errorMessage()) ?>");
		<?php if ($t_receipt_bulk_add->trip->Required) { ?>
			elm = this.getElements("x" + infix + "_trip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_bulk->trip->caption(), $t_receipt_bulk->trip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_receipt_bulk_add->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_bulk->amount->caption(), $t_receipt_bulk->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_receipt_bulk->amount->errorMessage()) ?>");
		<?php if ($t_receipt_bulk_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_bulk->dated->caption(), $t_receipt_bulk->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_receipt_bulk->dated->errorMessage()) ?>");
		<?php if ($t_receipt_bulk_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_bulk->remarks->caption(), $t_receipt_bulk->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_receipt_bulk_add->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $t_receipt_bulk->uploads->caption(), $t_receipt_bulk->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_receipt_bulk_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_bulk->operator->caption(), $t_receipt_bulk->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_receipt_bulk_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_bulk->datetime->caption(), $t_receipt_bulk->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_receipt_bulkadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_receipt_bulkadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_receipt_bulkadd.lists["x_r_from"] = <?php echo $t_receipt_bulk_add->r_from->Lookup->toClientList() ?>;
ft_receipt_bulkadd.lists["x_r_from"].options = <?php echo JsonEncode($t_receipt_bulk_add->r_from->lookupOptions()) ?>;
ft_receipt_bulkadd.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_receipt_bulkadd.lists["x_r_to"] = <?php echo $t_receipt_bulk_add->r_to->Lookup->toClientList() ?>;
ft_receipt_bulkadd.lists["x_r_to"].options = <?php echo JsonEncode($t_receipt_bulk_add->r_to->lookupOptions()) ?>;
ft_receipt_bulkadd.autoSuggests["x_r_to"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_receipt_bulkadd.lists["x_trip"] = <?php echo $t_receipt_bulk_add->trip->Lookup->toClientList() ?>;
ft_receipt_bulkadd.lists["x_trip"].options = <?php echo JsonEncode($t_receipt_bulk_add->trip->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_receipt_bulk_add->showPageHeader(); ?>
<?php
$t_receipt_bulk_add->showMessage();
?>
<form name="ft_receipt_bulkadd" id="ft_receipt_bulkadd" class="<?php echo $t_receipt_bulk_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_receipt_bulk_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_receipt_bulk_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_receipt_bulk">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$t_receipt_bulk_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($t_receipt_bulk->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label id="elh_t_receipt_bulk_r_from" class="<?php echo $t_receipt_bulk_add->LeftColumnClass ?>"><?php echo $t_receipt_bulk->r_from->caption() ?><?php echo ($t_receipt_bulk->r_from->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_receipt_bulk_add->RightColumnClass ?>"><div<?php echo $t_receipt_bulk->r_from->cellAttributes() ?>>
<span id="el_t_receipt_bulk_r_from">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$t_receipt_bulk->r_from->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_receipt_bulk->r_from->EditAttrs["onchange"] = "";
?>
<span id="as_x_r_from" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_r_from" id="sv_x_r_from" value="<?php echo RemoveHtml($t_receipt_bulk->r_from->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_receipt_bulk->r_from->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_receipt_bulk->r_from->getPlaceHolder()) ?>"<?php echo $t_receipt_bulk->r_from->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_receipt_bulk->r_from->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_r_from',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_receipt_bulk->r_from->ReadOnly || $t_receipt_bulk->r_from->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_receipt_bulk" data-field="x_r_from" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_receipt_bulk->r_from->displayValueSeparatorAttribute() ?>" name="x_r_from" id="x_r_from" value="<?php echo HtmlEncode($t_receipt_bulk->r_from->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_receipt_bulkadd.createAutoSuggest({"id":"x_r_from","forceSelect":true});
</script>
<?php echo $t_receipt_bulk->r_from->Lookup->getParamTag("p_x_r_from") ?>
</span>
<?php echo $t_receipt_bulk->r_from->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_receipt_bulk->r_to->Visible) { // r_to ?>
	<div id="r_r_to" class="form-group row">
		<label id="elh_t_receipt_bulk_r_to" class="<?php echo $t_receipt_bulk_add->LeftColumnClass ?>"><?php echo $t_receipt_bulk->r_to->caption() ?><?php echo ($t_receipt_bulk->r_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_receipt_bulk_add->RightColumnClass ?>"><div<?php echo $t_receipt_bulk->r_to->cellAttributes() ?>>
<span id="el_t_receipt_bulk_r_to">
<?php
$wrkonchange = "" . trim(@$t_receipt_bulk->r_to->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_receipt_bulk->r_to->EditAttrs["onchange"] = "";
?>
<span id="as_x_r_to" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_r_to" id="sv_x_r_to" value="<?php echo RemoveHtml($t_receipt_bulk->r_to->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_receipt_bulk->r_to->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_receipt_bulk->r_to->getPlaceHolder()) ?>"<?php echo $t_receipt_bulk->r_to->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_receipt_bulk->r_to->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_r_to',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_receipt_bulk->r_to->ReadOnly || $t_receipt_bulk->r_to->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_receipt_bulk" data-field="x_r_to" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_receipt_bulk->r_to->displayValueSeparatorAttribute() ?>" name="x_r_to" id="x_r_to" value="<?php echo HtmlEncode($t_receipt_bulk->r_to->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_receipt_bulkadd.createAutoSuggest({"id":"x_r_to","forceSelect":true});
</script>
<?php echo $t_receipt_bulk->r_to->Lookup->getParamTag("p_x_r_to") ?>
</span>
<?php echo $t_receipt_bulk->r_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_receipt_bulk->trip->Visible) { // trip ?>
	<div id="r_trip" class="form-group row">
		<label id="elh_t_receipt_bulk_trip" class="<?php echo $t_receipt_bulk_add->LeftColumnClass ?>"><?php echo $t_receipt_bulk->trip->caption() ?><?php echo ($t_receipt_bulk->trip->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_receipt_bulk_add->RightColumnClass ?>"><div<?php echo $t_receipt_bulk->trip->cellAttributes() ?>>
<span id="el_t_receipt_bulk_trip">
<div id="tp_x_trip" class="ew-template"><input type="radio" class="form-check-input" data-table="t_receipt_bulk" data-field="x_trip" data-value-separator="<?php echo $t_receipt_bulk->trip->displayValueSeparatorAttribute() ?>" name="x_trip" id="x_trip" value="{value}"<?php echo $t_receipt_bulk->trip->editAttributes() ?>></div>
<div id="dsl_x_trip" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $t_receipt_bulk->trip->radioButtonListHtml(FALSE, "x_trip") ?>
</div></div>
<?php echo $t_receipt_bulk->trip->Lookup->getParamTag("p_x_trip") ?>
</span>
<?php echo $t_receipt_bulk->trip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_receipt_bulk->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_t_receipt_bulk_amount" for="x_amount" class="<?php echo $t_receipt_bulk_add->LeftColumnClass ?>"><?php echo $t_receipt_bulk->amount->caption() ?><?php echo ($t_receipt_bulk->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_receipt_bulk_add->RightColumnClass ?>"><div<?php echo $t_receipt_bulk->amount->cellAttributes() ?>>
<span id="el_t_receipt_bulk_amount">
<input type="text" data-table="t_receipt_bulk" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($t_receipt_bulk->amount->getPlaceHolder()) ?>" value="<?php echo $t_receipt_bulk->amount->EditValue ?>"<?php echo $t_receipt_bulk->amount->editAttributes() ?>>
</span>
<?php echo $t_receipt_bulk->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_receipt_bulk->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_t_receipt_bulk_dated" for="x_dated" class="<?php echo $t_receipt_bulk_add->LeftColumnClass ?>"><?php echo $t_receipt_bulk->dated->caption() ?><?php echo ($t_receipt_bulk->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_receipt_bulk_add->RightColumnClass ?>"><div<?php echo $t_receipt_bulk->dated->cellAttributes() ?>>
<span id="el_t_receipt_bulk_dated">
<input type="text" data-table="t_receipt_bulk" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_receipt_bulk->dated->getPlaceHolder()) ?>" value="<?php echo $t_receipt_bulk->dated->EditValue ?>"<?php echo $t_receipt_bulk->dated->editAttributes() ?>>
<?php if (!$t_receipt_bulk->dated->ReadOnly && !$t_receipt_bulk->dated->Disabled && !isset($t_receipt_bulk->dated->EditAttrs["readonly"]) && !isset($t_receipt_bulk->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_receipt_bulkadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $t_receipt_bulk->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_receipt_bulk->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_t_receipt_bulk_remarks" for="x_remarks" class="<?php echo $t_receipt_bulk_add->LeftColumnClass ?>"><?php echo $t_receipt_bulk->remarks->caption() ?><?php echo ($t_receipt_bulk->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_receipt_bulk_add->RightColumnClass ?>"><div<?php echo $t_receipt_bulk->remarks->cellAttributes() ?>>
<span id="el_t_receipt_bulk_remarks">
<input type="text" data-table="t_receipt_bulk" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_receipt_bulk->remarks->getPlaceHolder()) ?>" value="<?php echo $t_receipt_bulk->remarks->EditValue ?>"<?php echo $t_receipt_bulk->remarks->editAttributes() ?>>
</span>
<?php echo $t_receipt_bulk->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_receipt_bulk->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_t_receipt_bulk_uploads" class="<?php echo $t_receipt_bulk_add->LeftColumnClass ?>"><?php echo $t_receipt_bulk->uploads->caption() ?><?php echo ($t_receipt_bulk->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_receipt_bulk_add->RightColumnClass ?>"><div<?php echo $t_receipt_bulk->uploads->cellAttributes() ?>>
<span id="el_t_receipt_bulk_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $t_receipt_bulk->uploads->title() ? $t_receipt_bulk->uploads->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($t_receipt_bulk->uploads->ReadOnly || $t_receipt_bulk->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="t_receipt_bulk" data-field="x_uploads" name="x_uploads" id="x_uploads"<?php echo $t_receipt_bulk->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $t_receipt_bulk->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="255">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $t_receipt_bulk->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $t_receipt_bulk->uploads->UploadMaxFileSize ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $t_receipt_bulk->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_receipt_bulk_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_receipt_bulk_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_receipt_bulk_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_receipt_bulk_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_receipt_bulk_add->terminate();
?>