<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_receipt_bulk_delete = new t_receipt_bulk_delete();

// Run the page
$t_receipt_bulk_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_receipt_bulk_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var ft_receipt_bulkdelete = currentForm = new ew.Form("ft_receipt_bulkdelete", "delete");

// Form_CustomValidate event
ft_receipt_bulkdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_receipt_bulkdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_receipt_bulkdelete.lists["x_r_from"] = <?php echo $t_receipt_bulk_delete->r_from->Lookup->toClientList() ?>;
ft_receipt_bulkdelete.lists["x_r_from"].options = <?php echo JsonEncode($t_receipt_bulk_delete->r_from->lookupOptions()) ?>;
ft_receipt_bulkdelete.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_receipt_bulkdelete.lists["x_r_to"] = <?php echo $t_receipt_bulk_delete->r_to->Lookup->toClientList() ?>;
ft_receipt_bulkdelete.lists["x_r_to"].options = <?php echo JsonEncode($t_receipt_bulk_delete->r_to->lookupOptions()) ?>;
ft_receipt_bulkdelete.autoSuggests["x_r_to"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_receipt_bulkdelete.lists["x_trip"] = <?php echo $t_receipt_bulk_delete->trip->Lookup->toClientList() ?>;
ft_receipt_bulkdelete.lists["x_trip"].options = <?php echo JsonEncode($t_receipt_bulk_delete->trip->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_receipt_bulk_delete->showPageHeader(); ?>
<?php
$t_receipt_bulk_delete->showMessage();
?>
<form name="ft_receipt_bulkdelete" id="ft_receipt_bulkdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_receipt_bulk_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_receipt_bulk_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_receipt_bulk">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($t_receipt_bulk_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($t_receipt_bulk->id->Visible) { // id ?>
		<th class="<?php echo $t_receipt_bulk->id->headerCellClass() ?>"><span id="elh_t_receipt_bulk_id" class="t_receipt_bulk_id"><?php echo $t_receipt_bulk->id->caption() ?></span></th>
<?php } ?>
<?php if ($t_receipt_bulk->r_from->Visible) { // r_from ?>
		<th class="<?php echo $t_receipt_bulk->r_from->headerCellClass() ?>"><span id="elh_t_receipt_bulk_r_from" class="t_receipt_bulk_r_from"><?php echo $t_receipt_bulk->r_from->caption() ?></span></th>
<?php } ?>
<?php if ($t_receipt_bulk->r_to->Visible) { // r_to ?>
		<th class="<?php echo $t_receipt_bulk->r_to->headerCellClass() ?>"><span id="elh_t_receipt_bulk_r_to" class="t_receipt_bulk_r_to"><?php echo $t_receipt_bulk->r_to->caption() ?></span></th>
<?php } ?>
<?php if ($t_receipt_bulk->trip->Visible) { // trip ?>
		<th class="<?php echo $t_receipt_bulk->trip->headerCellClass() ?>"><span id="elh_t_receipt_bulk_trip" class="t_receipt_bulk_trip"><?php echo $t_receipt_bulk->trip->caption() ?></span></th>
<?php } ?>
<?php if ($t_receipt_bulk->amount->Visible) { // amount ?>
		<th class="<?php echo $t_receipt_bulk->amount->headerCellClass() ?>"><span id="elh_t_receipt_bulk_amount" class="t_receipt_bulk_amount"><?php echo $t_receipt_bulk->amount->caption() ?></span></th>
<?php } ?>
<?php if ($t_receipt_bulk->dated->Visible) { // dated ?>
		<th class="<?php echo $t_receipt_bulk->dated->headerCellClass() ?>"><span id="elh_t_receipt_bulk_dated" class="t_receipt_bulk_dated"><?php echo $t_receipt_bulk->dated->caption() ?></span></th>
<?php } ?>
<?php if ($t_receipt_bulk->remarks->Visible) { // remarks ?>
		<th class="<?php echo $t_receipt_bulk->remarks->headerCellClass() ?>"><span id="elh_t_receipt_bulk_remarks" class="t_receipt_bulk_remarks"><?php echo $t_receipt_bulk->remarks->caption() ?></span></th>
<?php } ?>
<?php if ($t_receipt_bulk->uploads->Visible) { // uploads ?>
		<th class="<?php echo $t_receipt_bulk->uploads->headerCellClass() ?>"><span id="elh_t_receipt_bulk_uploads" class="t_receipt_bulk_uploads"><?php echo $t_receipt_bulk->uploads->caption() ?></span></th>
<?php } ?>
<?php if ($t_receipt_bulk->operator->Visible) { // operator ?>
		<th class="<?php echo $t_receipt_bulk->operator->headerCellClass() ?>"><span id="elh_t_receipt_bulk_operator" class="t_receipt_bulk_operator"><?php echo $t_receipt_bulk->operator->caption() ?></span></th>
<?php } ?>
<?php if ($t_receipt_bulk->datetime->Visible) { // datetime ?>
		<th class="<?php echo $t_receipt_bulk->datetime->headerCellClass() ?>"><span id="elh_t_receipt_bulk_datetime" class="t_receipt_bulk_datetime"><?php echo $t_receipt_bulk->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$t_receipt_bulk_delete->RecCnt = 0;
$i = 0;
while (!$t_receipt_bulk_delete->Recordset->EOF) {
	$t_receipt_bulk_delete->RecCnt++;
	$t_receipt_bulk_delete->RowCnt++;

	// Set row properties
	$t_receipt_bulk->resetAttributes();
	$t_receipt_bulk->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$t_receipt_bulk_delete->loadRowValues($t_receipt_bulk_delete->Recordset);

	// Render row
	$t_receipt_bulk_delete->renderRow();
?>
	<tr<?php echo $t_receipt_bulk->rowAttributes() ?>>
<?php if ($t_receipt_bulk->id->Visible) { // id ?>
		<td<?php echo $t_receipt_bulk->id->cellAttributes() ?>>
<span id="el<?php echo $t_receipt_bulk_delete->RowCnt ?>_t_receipt_bulk_id" class="t_receipt_bulk_id">
<span<?php echo $t_receipt_bulk->id->viewAttributes() ?>>
<?php echo $t_receipt_bulk->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_receipt_bulk->r_from->Visible) { // r_from ?>
		<td<?php echo $t_receipt_bulk->r_from->cellAttributes() ?>>
<span id="el<?php echo $t_receipt_bulk_delete->RowCnt ?>_t_receipt_bulk_r_from" class="t_receipt_bulk_r_from">
<span<?php echo $t_receipt_bulk->r_from->viewAttributes() ?>>
<?php echo $t_receipt_bulk->r_from->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_receipt_bulk->r_to->Visible) { // r_to ?>
		<td<?php echo $t_receipt_bulk->r_to->cellAttributes() ?>>
<span id="el<?php echo $t_receipt_bulk_delete->RowCnt ?>_t_receipt_bulk_r_to" class="t_receipt_bulk_r_to">
<span<?php echo $t_receipt_bulk->r_to->viewAttributes() ?>>
<?php echo $t_receipt_bulk->r_to->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_receipt_bulk->trip->Visible) { // trip ?>
		<td<?php echo $t_receipt_bulk->trip->cellAttributes() ?>>
<span id="el<?php echo $t_receipt_bulk_delete->RowCnt ?>_t_receipt_bulk_trip" class="t_receipt_bulk_trip">
<span<?php echo $t_receipt_bulk->trip->viewAttributes() ?>>
<?php echo $t_receipt_bulk->trip->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_receipt_bulk->amount->Visible) { // amount ?>
		<td<?php echo $t_receipt_bulk->amount->cellAttributes() ?>>
<span id="el<?php echo $t_receipt_bulk_delete->RowCnt ?>_t_receipt_bulk_amount" class="t_receipt_bulk_amount">
<span<?php echo $t_receipt_bulk->amount->viewAttributes() ?>>
<?php echo $t_receipt_bulk->amount->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_receipt_bulk->dated->Visible) { // dated ?>
		<td<?php echo $t_receipt_bulk->dated->cellAttributes() ?>>
<span id="el<?php echo $t_receipt_bulk_delete->RowCnt ?>_t_receipt_bulk_dated" class="t_receipt_bulk_dated">
<span<?php echo $t_receipt_bulk->dated->viewAttributes() ?>>
<?php echo $t_receipt_bulk->dated->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_receipt_bulk->remarks->Visible) { // remarks ?>
		<td<?php echo $t_receipt_bulk->remarks->cellAttributes() ?>>
<span id="el<?php echo $t_receipt_bulk_delete->RowCnt ?>_t_receipt_bulk_remarks" class="t_receipt_bulk_remarks">
<span<?php echo $t_receipt_bulk->remarks->viewAttributes() ?>>
<?php echo $t_receipt_bulk->remarks->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_receipt_bulk->uploads->Visible) { // uploads ?>
		<td<?php echo $t_receipt_bulk->uploads->cellAttributes() ?>>
<span id="el<?php echo $t_receipt_bulk_delete->RowCnt ?>_t_receipt_bulk_uploads" class="t_receipt_bulk_uploads">
<span>
<?php echo GetFileViewTag($t_receipt_bulk->uploads, $t_receipt_bulk->uploads->getViewValue()) ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($t_receipt_bulk->operator->Visible) { // operator ?>
		<td<?php echo $t_receipt_bulk->operator->cellAttributes() ?>>
<span id="el<?php echo $t_receipt_bulk_delete->RowCnt ?>_t_receipt_bulk_operator" class="t_receipt_bulk_operator">
<span<?php echo $t_receipt_bulk->operator->viewAttributes() ?>>
<?php echo $t_receipt_bulk->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($t_receipt_bulk->datetime->Visible) { // datetime ?>
		<td<?php echo $t_receipt_bulk->datetime->cellAttributes() ?>>
<span id="el<?php echo $t_receipt_bulk_delete->RowCnt ?>_t_receipt_bulk_datetime" class="t_receipt_bulk_datetime">
<span<?php echo $t_receipt_bulk->datetime->viewAttributes() ?>>
<?php echo $t_receipt_bulk->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$t_receipt_bulk_delete->Recordset->moveNext();
}
$t_receipt_bulk_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_receipt_bulk_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$t_receipt_bulk_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_receipt_bulk_delete->terminate();
?>