<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_receipt_d_edit = new t_receipt_d_edit();

// Run the page
$t_receipt_d_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_receipt_d_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var ft_receipt_dedit = currentForm = new ew.Form("ft_receipt_dedit", "edit");

// Validate form
ft_receipt_dedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_receipt_d_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_d->id->caption(), $t_receipt_d->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_receipt_d->id->errorMessage()) ?>");
		<?php if ($t_receipt_d_edit->trip->Required) { ?>
			elm = this.getElements("x" + infix + "_trip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_d->trip->caption(), $t_receipt_d->trip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_receipt_d_edit->r_from->Required) { ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_d->r_from->caption(), $t_receipt_d->r_from->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_receipt_d_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_d->amount->caption(), $t_receipt_d->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_receipt_d->amount->errorMessage()) ?>");
		<?php if ($t_receipt_d_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_d->dated->caption(), $t_receipt_d->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_receipt_d->dated->errorMessage()) ?>");
		<?php if ($t_receipt_d_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_d->remarks->caption(), $t_receipt_d->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_receipt_d_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $t_receipt_d->uploads->caption(), $t_receipt_d->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_receipt_d_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_d->operator->caption(), $t_receipt_d->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_receipt_d_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_receipt_d->datetime->caption(), $t_receipt_d->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_receipt_dedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_receipt_dedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_receipt_dedit.lists["x_trip"] = <?php echo $t_receipt_d_edit->trip->Lookup->toClientList() ?>;
ft_receipt_dedit.lists["x_trip"].options = <?php echo JsonEncode($t_receipt_d_edit->trip->lookupOptions()) ?>;
ft_receipt_dedit.lists["x_r_from"] = <?php echo $t_receipt_d_edit->r_from->Lookup->toClientList() ?>;
ft_receipt_dedit.lists["x_r_from"].options = <?php echo JsonEncode($t_receipt_d_edit->r_from->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_receipt_d_edit->showPageHeader(); ?>
<?php
$t_receipt_d_edit->showMessage();
?>
<form name="ft_receipt_dedit" id="ft_receipt_dedit" class="<?php echo $t_receipt_d_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_receipt_d_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_receipt_d_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_receipt_d">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$t_receipt_d_edit->IsModal ?>">
<?php if ($t_receipt_d->getCurrentMasterTable() == "t_trip_info") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="t_trip_info">
<input type="hidden" name="fk_id" value="<?php echo $t_receipt_d->trip->getSessionValue() ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_receipt_d->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_t_receipt_d_id" for="x_id" class="<?php echo $t_receipt_d_edit->LeftColumnClass ?>"><?php echo $t_receipt_d->id->caption() ?><?php echo ($t_receipt_d->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_receipt_d_edit->RightColumnClass ?>"><div<?php echo $t_receipt_d->id->cellAttributes() ?>>
<span id="el_t_receipt_d_id">
<span<?php echo $t_receipt_d->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_receipt_d->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_receipt_d" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($t_receipt_d->id->CurrentValue) ?>">
<?php echo $t_receipt_d->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_receipt_d->trip->Visible) { // trip ?>
	<div id="r_trip" class="form-group row">
		<label id="elh_t_receipt_d_trip" class="<?php echo $t_receipt_d_edit->LeftColumnClass ?>"><?php echo $t_receipt_d->trip->caption() ?><?php echo ($t_receipt_d->trip->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_receipt_d_edit->RightColumnClass ?>"><div<?php echo $t_receipt_d->trip->cellAttributes() ?>>
<span id="el_t_receipt_d_trip">
<span<?php echo $t_receipt_d->trip->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_receipt_d->trip->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_receipt_d" data-field="x_trip" name="x_trip" id="x_trip" value="<?php echo HtmlEncode($t_receipt_d->trip->CurrentValue) ?>">
<?php echo $t_receipt_d->trip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_receipt_d->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label id="elh_t_receipt_d_r_from" class="<?php echo $t_receipt_d_edit->LeftColumnClass ?>"><?php echo $t_receipt_d->r_from->caption() ?><?php echo ($t_receipt_d->r_from->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_receipt_d_edit->RightColumnClass ?>"><div<?php echo $t_receipt_d->r_from->cellAttributes() ?>>
<span id="el_t_receipt_d_r_from">
<div id="tp_x_r_from" class="ew-template"><input type="radio" class="form-check-input" data-table="t_receipt_d" data-field="x_r_from" data-value-separator="<?php echo $t_receipt_d->r_from->displayValueSeparatorAttribute() ?>" name="x_r_from" id="x_r_from" value="{value}"<?php echo $t_receipt_d->r_from->editAttributes() ?>></div>
<div id="dsl_x_r_from" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $t_receipt_d->r_from->radioButtonListHtml(FALSE, "x_r_from") ?>
</div></div>
</span>
<?php echo $t_receipt_d->r_from->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_receipt_d->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_t_receipt_d_amount" for="x_amount" class="<?php echo $t_receipt_d_edit->LeftColumnClass ?>"><?php echo $t_receipt_d->amount->caption() ?><?php echo ($t_receipt_d->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_receipt_d_edit->RightColumnClass ?>"><div<?php echo $t_receipt_d->amount->cellAttributes() ?>>
<span id="el_t_receipt_d_amount">
<input type="text" data-table="t_receipt_d" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($t_receipt_d->amount->getPlaceHolder()) ?>" value="<?php echo $t_receipt_d->amount->EditValue ?>"<?php echo $t_receipt_d->amount->editAttributes() ?>>
</span>
<?php echo $t_receipt_d->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_receipt_d->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_t_receipt_d_dated" for="x_dated" class="<?php echo $t_receipt_d_edit->LeftColumnClass ?>"><?php echo $t_receipt_d->dated->caption() ?><?php echo ($t_receipt_d->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_receipt_d_edit->RightColumnClass ?>"><div<?php echo $t_receipt_d->dated->cellAttributes() ?>>
<span id="el_t_receipt_d_dated">
<input type="text" data-table="t_receipt_d" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_receipt_d->dated->getPlaceHolder()) ?>" value="<?php echo $t_receipt_d->dated->EditValue ?>"<?php echo $t_receipt_d->dated->editAttributes() ?>>
<?php if (!$t_receipt_d->dated->ReadOnly && !$t_receipt_d->dated->Disabled && !isset($t_receipt_d->dated->EditAttrs["readonly"]) && !isset($t_receipt_d->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_receipt_dedit", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $t_receipt_d->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_receipt_d->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_t_receipt_d_remarks" for="x_remarks" class="<?php echo $t_receipt_d_edit->LeftColumnClass ?>"><?php echo $t_receipt_d->remarks->caption() ?><?php echo ($t_receipt_d->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_receipt_d_edit->RightColumnClass ?>"><div<?php echo $t_receipt_d->remarks->cellAttributes() ?>>
<span id="el_t_receipt_d_remarks">
<input type="text" data-table="t_receipt_d" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_receipt_d->remarks->getPlaceHolder()) ?>" value="<?php echo $t_receipt_d->remarks->EditValue ?>"<?php echo $t_receipt_d->remarks->editAttributes() ?>>
</span>
<?php echo $t_receipt_d->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_receipt_d->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_t_receipt_d_uploads" class="<?php echo $t_receipt_d_edit->LeftColumnClass ?>"><?php echo $t_receipt_d->uploads->caption() ?><?php echo ($t_receipt_d->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_receipt_d_edit->RightColumnClass ?>"><div<?php echo $t_receipt_d->uploads->cellAttributes() ?>>
<span id="el_t_receipt_d_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $t_receipt_d->uploads->title() ? $t_receipt_d->uploads->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($t_receipt_d->uploads->ReadOnly || $t_receipt_d->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="t_receipt_d" data-field="x_uploads" name="x_uploads" id="x_uploads"<?php echo $t_receipt_d->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $t_receipt_d->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="255">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $t_receipt_d->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $t_receipt_d->uploads->UploadMaxFileSize ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $t_receipt_d->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_receipt_d_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_receipt_d_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_receipt_d_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_receipt_d_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_receipt_d_edit->terminate();
?>