<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$t_receipt_d_preview = new t_receipt_d_preview();

// Run the page
$t_receipt_d_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_receipt_d_preview->Page_Render();
?>
<?php $t_receipt_d_preview->showPageHeader(); ?>
<div class="card ew-grid t_receipt_d"><!-- .card -->
<?php if ($t_receipt_d_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$t_receipt_d_preview->renderListOptions();

// Render list options (header, left)
$t_receipt_d_preview->ListOptions->render("header", "left");
?>
<?php if ($t_receipt_d->id->Visible) { // id ?>
	<?php if ($t_receipt_d->SortUrl($t_receipt_d->id) == "") { ?>
		<th class="<?php echo $t_receipt_d->id->headerCellClass() ?>"><?php echo $t_receipt_d->id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_receipt_d->id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_receipt_d->id->Name) ?>" data-sort-order="<?php echo $t_receipt_d_preview->SortField == $t_receipt_d->id->Name && $t_receipt_d_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_receipt_d->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_receipt_d_preview->SortField == $t_receipt_d->id->Name) { ?><?php if ($t_receipt_d_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_receipt_d_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_receipt_d->trip->Visible) { // trip ?>
	<?php if ($t_receipt_d->SortUrl($t_receipt_d->trip) == "") { ?>
		<th class="<?php echo $t_receipt_d->trip->headerCellClass() ?>"><?php echo $t_receipt_d->trip->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_receipt_d->trip->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_receipt_d->trip->Name) ?>" data-sort-order="<?php echo $t_receipt_d_preview->SortField == $t_receipt_d->trip->Name && $t_receipt_d_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_receipt_d->trip->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_receipt_d_preview->SortField == $t_receipt_d->trip->Name) { ?><?php if ($t_receipt_d_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_receipt_d_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_receipt_d->r_from->Visible) { // r_from ?>
	<?php if ($t_receipt_d->SortUrl($t_receipt_d->r_from) == "") { ?>
		<th class="<?php echo $t_receipt_d->r_from->headerCellClass() ?>"><?php echo $t_receipt_d->r_from->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_receipt_d->r_from->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_receipt_d->r_from->Name) ?>" data-sort-order="<?php echo $t_receipt_d_preview->SortField == $t_receipt_d->r_from->Name && $t_receipt_d_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_receipt_d->r_from->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_receipt_d_preview->SortField == $t_receipt_d->r_from->Name) { ?><?php if ($t_receipt_d_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_receipt_d_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_receipt_d->amount->Visible) { // amount ?>
	<?php if ($t_receipt_d->SortUrl($t_receipt_d->amount) == "") { ?>
		<th class="<?php echo $t_receipt_d->amount->headerCellClass() ?>"><?php echo $t_receipt_d->amount->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_receipt_d->amount->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_receipt_d->amount->Name) ?>" data-sort-order="<?php echo $t_receipt_d_preview->SortField == $t_receipt_d->amount->Name && $t_receipt_d_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_receipt_d->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_receipt_d_preview->SortField == $t_receipt_d->amount->Name) { ?><?php if ($t_receipt_d_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_receipt_d_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_receipt_d->dated->Visible) { // dated ?>
	<?php if ($t_receipt_d->SortUrl($t_receipt_d->dated) == "") { ?>
		<th class="<?php echo $t_receipt_d->dated->headerCellClass() ?>"><?php echo $t_receipt_d->dated->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_receipt_d->dated->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_receipt_d->dated->Name) ?>" data-sort-order="<?php echo $t_receipt_d_preview->SortField == $t_receipt_d->dated->Name && $t_receipt_d_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_receipt_d->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_receipt_d_preview->SortField == $t_receipt_d->dated->Name) { ?><?php if ($t_receipt_d_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_receipt_d_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_receipt_d->remarks->Visible) { // remarks ?>
	<?php if ($t_receipt_d->SortUrl($t_receipt_d->remarks) == "") { ?>
		<th class="<?php echo $t_receipt_d->remarks->headerCellClass() ?>"><?php echo $t_receipt_d->remarks->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_receipt_d->remarks->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_receipt_d->remarks->Name) ?>" data-sort-order="<?php echo $t_receipt_d_preview->SortField == $t_receipt_d->remarks->Name && $t_receipt_d_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_receipt_d->remarks->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_receipt_d_preview->SortField == $t_receipt_d->remarks->Name) { ?><?php if ($t_receipt_d_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_receipt_d_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_receipt_d->uploads->Visible) { // uploads ?>
	<?php if ($t_receipt_d->SortUrl($t_receipt_d->uploads) == "") { ?>
		<th class="<?php echo $t_receipt_d->uploads->headerCellClass() ?>"><?php echo $t_receipt_d->uploads->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_receipt_d->uploads->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_receipt_d->uploads->Name) ?>" data-sort-order="<?php echo $t_receipt_d_preview->SortField == $t_receipt_d->uploads->Name && $t_receipt_d_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_receipt_d->uploads->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_receipt_d_preview->SortField == $t_receipt_d->uploads->Name) { ?><?php if ($t_receipt_d_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_receipt_d_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_receipt_d->operator->Visible) { // operator ?>
	<?php if ($t_receipt_d->SortUrl($t_receipt_d->operator) == "") { ?>
		<th class="<?php echo $t_receipt_d->operator->headerCellClass() ?>"><?php echo $t_receipt_d->operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_receipt_d->operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_receipt_d->operator->Name) ?>" data-sort-order="<?php echo $t_receipt_d_preview->SortField == $t_receipt_d->operator->Name && $t_receipt_d_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_receipt_d->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_receipt_d_preview->SortField == $t_receipt_d->operator->Name) { ?><?php if ($t_receipt_d_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_receipt_d_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_receipt_d->datetime->Visible) { // datetime ?>
	<?php if ($t_receipt_d->SortUrl($t_receipt_d->datetime) == "") { ?>
		<th class="<?php echo $t_receipt_d->datetime->headerCellClass() ?>"><?php echo $t_receipt_d->datetime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_receipt_d->datetime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_receipt_d->datetime->Name) ?>" data-sort-order="<?php echo $t_receipt_d_preview->SortField == $t_receipt_d->datetime->Name && $t_receipt_d_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_receipt_d->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_receipt_d_preview->SortField == $t_receipt_d->datetime->Name) { ?><?php if ($t_receipt_d_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_receipt_d_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_receipt_d_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$t_receipt_d_preview->RecCount = 0;
$t_receipt_d_preview->RowCnt = 0;
while ($t_receipt_d_preview->Recordset && !$t_receipt_d_preview->Recordset->EOF) {

	// Init row class and style
	$t_receipt_d_preview->RecCount++;
	$t_receipt_d_preview->RowCnt++;
	$t_receipt_d_preview->CssStyle = "";
	$t_receipt_d_preview->loadListRowValues($t_receipt_d_preview->Recordset);

	// Render row
	$t_receipt_d_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$t_receipt_d_preview->resetAttributes();
	$t_receipt_d_preview->renderListRow();

	// Render list options
	$t_receipt_d_preview->renderListOptions();
?>
	<tr<?php echo $t_receipt_d_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_receipt_d_preview->ListOptions->render("body", "left", $t_receipt_d_preview->RowCnt);
?>
<?php if ($t_receipt_d->id->Visible) { // id ?>
		<!-- id -->
		<td<?php echo $t_receipt_d->id->cellAttributes() ?>>
<span<?php echo $t_receipt_d->id->viewAttributes() ?>>
<?php echo $t_receipt_d->id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_receipt_d->trip->Visible) { // trip ?>
		<!-- trip -->
		<td<?php echo $t_receipt_d->trip->cellAttributes() ?>>
<span<?php echo $t_receipt_d->trip->viewAttributes() ?>>
<?php echo $t_receipt_d->trip->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_receipt_d->r_from->Visible) { // r_from ?>
		<!-- r_from -->
		<td<?php echo $t_receipt_d->r_from->cellAttributes() ?>>
<span<?php echo $t_receipt_d->r_from->viewAttributes() ?>>
<?php echo $t_receipt_d->r_from->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_receipt_d->amount->Visible) { // amount ?>
		<!-- amount -->
		<td<?php echo $t_receipt_d->amount->cellAttributes() ?>>
<span<?php echo $t_receipt_d->amount->viewAttributes() ?>>
<?php echo $t_receipt_d->amount->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_receipt_d->dated->Visible) { // dated ?>
		<!-- dated -->
		<td<?php echo $t_receipt_d->dated->cellAttributes() ?>>
<span<?php echo $t_receipt_d->dated->viewAttributes() ?>>
<?php echo $t_receipt_d->dated->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_receipt_d->remarks->Visible) { // remarks ?>
		<!-- remarks -->
		<td<?php echo $t_receipt_d->remarks->cellAttributes() ?>>
<span<?php echo $t_receipt_d->remarks->viewAttributes() ?>>
<?php echo $t_receipt_d->remarks->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_receipt_d->uploads->Visible) { // uploads ?>
		<!-- uploads -->
		<td<?php echo $t_receipt_d->uploads->cellAttributes() ?>>
<span<?php echo $t_receipt_d->uploads->viewAttributes() ?>>
<?php echo GetFileViewTag($t_receipt_d->uploads, $t_receipt_d->uploads->getViewValue()) ?>
</span>
</td>
<?php } ?>
<?php if ($t_receipt_d->operator->Visible) { // operator ?>
		<!-- operator -->
		<td<?php echo $t_receipt_d->operator->cellAttributes() ?>>
<span<?php echo $t_receipt_d->operator->viewAttributes() ?>>
<?php echo $t_receipt_d->operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_receipt_d->datetime->Visible) { // datetime ?>
		<!-- datetime -->
		<td<?php echo $t_receipt_d->datetime->cellAttributes() ?>>
<span<?php echo $t_receipt_d->datetime->viewAttributes() ?>>
<?php echo $t_receipt_d->datetime->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$t_receipt_d_preview->ListOptions->render("body", "right", $t_receipt_d_preview->RowCnt);
?>
	</tr>
<?php
	$t_receipt_d_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($t_receipt_d_preview->TotalRecs > 0) { ?>
<?php if (!isset($t_receipt_d_preview->Pager)) $t_receipt_d_preview->Pager = new PrevNextPager($t_receipt_d_preview->StartRec, $t_receipt_d_preview->DisplayRecs, $t_receipt_d_preview->TotalRecs) ?>
<?php if ($t_receipt_d_preview->Pager->RecordCount > 0 && $t_receipt_d_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($t_receipt_d_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $t_receipt_d_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($t_receipt_d_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $t_receipt_d_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($t_receipt_d_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $t_receipt_d_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($t_receipt_d_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $t_receipt_d_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $t_receipt_d_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $t_receipt_d_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $t_receipt_d_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($t_receipt_d_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$t_receipt_d_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($t_receipt_d_preview->Recordset)
	$t_receipt_d_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$t_receipt_d_preview->terminate();
?>