<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_receipt_d_view = new t_receipt_d_view();

// Run the page
$t_receipt_d_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_receipt_d_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_receipt_d->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_receipt_dview = currentForm = new ew.Form("ft_receipt_dview", "view");

// Form_CustomValidate event
ft_receipt_dview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_receipt_dview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_receipt_dview.lists["x_trip"] = <?php echo $t_receipt_d_view->trip->Lookup->toClientList() ?>;
ft_receipt_dview.lists["x_trip"].options = <?php echo JsonEncode($t_receipt_d_view->trip->lookupOptions()) ?>;
ft_receipt_dview.lists["x_r_from"] = <?php echo $t_receipt_d_view->r_from->Lookup->toClientList() ?>;
ft_receipt_dview.lists["x_r_from"].options = <?php echo JsonEncode($t_receipt_d_view->r_from->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_receipt_d->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_receipt_d_view->ExportOptions->render("body") ?>
<?php $t_receipt_d_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_receipt_d_view->showPageHeader(); ?>
<?php
$t_receipt_d_view->showMessage();
?>
<form name="ft_receipt_dview" id="ft_receipt_dview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_receipt_d_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_receipt_d_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_receipt_d">
<input type="hidden" name="modal" value="<?php echo (int)$t_receipt_d_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_receipt_d->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_receipt_d_view->TableLeftColumnClass ?>"><span id="elh_t_receipt_d_id"><?php echo $t_receipt_d->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_receipt_d->id->cellAttributes() ?>>
<span id="el_t_receipt_d_id">
<span<?php echo $t_receipt_d->id->viewAttributes() ?>>
<?php echo $t_receipt_d->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_receipt_d->trip->Visible) { // trip ?>
	<tr id="r_trip">
		<td class="<?php echo $t_receipt_d_view->TableLeftColumnClass ?>"><span id="elh_t_receipt_d_trip"><?php echo $t_receipt_d->trip->caption() ?></span></td>
		<td data-name="trip"<?php echo $t_receipt_d->trip->cellAttributes() ?>>
<span id="el_t_receipt_d_trip">
<span<?php echo $t_receipt_d->trip->viewAttributes() ?>>
<?php echo $t_receipt_d->trip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_receipt_d->r_from->Visible) { // r_from ?>
	<tr id="r_r_from">
		<td class="<?php echo $t_receipt_d_view->TableLeftColumnClass ?>"><span id="elh_t_receipt_d_r_from"><?php echo $t_receipt_d->r_from->caption() ?></span></td>
		<td data-name="r_from"<?php echo $t_receipt_d->r_from->cellAttributes() ?>>
<span id="el_t_receipt_d_r_from">
<span<?php echo $t_receipt_d->r_from->viewAttributes() ?>>
<?php echo $t_receipt_d->r_from->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_receipt_d->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $t_receipt_d_view->TableLeftColumnClass ?>"><span id="elh_t_receipt_d_amount"><?php echo $t_receipt_d->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $t_receipt_d->amount->cellAttributes() ?>>
<span id="el_t_receipt_d_amount">
<span<?php echo $t_receipt_d->amount->viewAttributes() ?>>
<?php echo $t_receipt_d->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_receipt_d->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $t_receipt_d_view->TableLeftColumnClass ?>"><span id="elh_t_receipt_d_dated"><?php echo $t_receipt_d->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $t_receipt_d->dated->cellAttributes() ?>>
<span id="el_t_receipt_d_dated">
<span<?php echo $t_receipt_d->dated->viewAttributes() ?>>
<?php echo $t_receipt_d->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_receipt_d->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $t_receipt_d_view->TableLeftColumnClass ?>"><span id="elh_t_receipt_d_remarks"><?php echo $t_receipt_d->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $t_receipt_d->remarks->cellAttributes() ?>>
<span id="el_t_receipt_d_remarks">
<span<?php echo $t_receipt_d->remarks->viewAttributes() ?>>
<?php echo $t_receipt_d->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_receipt_d->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $t_receipt_d_view->TableLeftColumnClass ?>"><span id="elh_t_receipt_d_uploads"><?php echo $t_receipt_d->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $t_receipt_d->uploads->cellAttributes() ?>>
<span id="el_t_receipt_d_uploads">
<span<?php echo $t_receipt_d->uploads->viewAttributes() ?>>
<?php echo GetFileViewTag($t_receipt_d->uploads, $t_receipt_d->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_receipt_d->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_receipt_d_view->TableLeftColumnClass ?>"><span id="elh_t_receipt_d_operator"><?php echo $t_receipt_d->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_receipt_d->operator->cellAttributes() ?>>
<span id="el_t_receipt_d_operator">
<span<?php echo $t_receipt_d->operator->viewAttributes() ?>>
<?php echo $t_receipt_d->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_receipt_d->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_receipt_d_view->TableLeftColumnClass ?>"><span id="elh_t_receipt_d_datetime"><?php echo $t_receipt_d->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_receipt_d->datetime->cellAttributes() ?>>
<span id="el_t_receipt_d_datetime">
<span<?php echo $t_receipt_d->datetime->viewAttributes() ?>>
<?php echo $t_receipt_d->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_receipt_d_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_receipt_d->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_receipt_d_view->terminate();
?>