<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_route_info_add = new t_route_info_add();

// Run the page
$t_route_info_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_route_info_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var ft_route_infoadd = currentForm = new ew.Form("ft_route_infoadd", "add");

// Validate form
ft_route_infoadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_route_info_add->r_from->Required) { ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->r_from->caption(), $t_route_info->r_from->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_route_info_add->r_to->Required) { ?>
			elm = this.getElements("x" + infix + "_r_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->r_to->caption(), $t_route_info->r_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_route_info_add->km->Required) { ?>
			elm = this.getElements("x" + infix + "_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->km->caption(), $t_route_info->km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_km");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_route_info->km->errorMessage()) ?>");
		<?php if ($t_route_info_add->days->Required) { ?>
			elm = this.getElements("x" + infix + "_days");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->days->caption(), $t_route_info->days->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_days");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_route_info->days->errorMessage()) ?>");
		<?php if ($t_route_info_add->load_expenses->Required) { ?>
			elm = this.getElements("x" + infix + "_load_expenses");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->load_expenses->caption(), $t_route_info->load_expenses->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_expenses");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_route_info->load_expenses->errorMessage()) ?>");
		<?php if ($t_route_info_add->unload_expenses->Required) { ?>
			elm = this.getElements("x" + infix + "_unload_expenses");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->unload_expenses->caption(), $t_route_info->unload_expenses->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_unload_expenses");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_route_info->unload_expenses->errorMessage()) ?>");
		<?php if ($t_route_info_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->status->caption(), $t_route_info->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_route_info_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->operator->caption(), $t_route_info->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_route_info_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->datetime->caption(), $t_route_info->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_route_infoadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_route_infoadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_route_infoadd.lists["x_status"] = <?php echo $t_route_info_add->status->Lookup->toClientList() ?>;
ft_route_infoadd.lists["x_status"].options = <?php echo JsonEncode($t_route_info_add->status->options(FALSE, TRUE)) ?>;
ft_route_infoadd.lists["x_operator"] = <?php echo $t_route_info_add->operator->Lookup->toClientList() ?>;
ft_route_infoadd.lists["x_operator"].options = <?php echo JsonEncode($t_route_info_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_route_info_add->showPageHeader(); ?>
<?php
$t_route_info_add->showMessage();
?>
<form name="ft_route_infoadd" id="ft_route_infoadd" class="<?php echo $t_route_info_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_route_info_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_route_info_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_route_info">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$t_route_info_add->IsModal ?>">
<?php if ($t_route_info->getCurrentMasterTable() == "t_trip_info") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="t_trip_info">
<input type="hidden" name="fk__route" value="<?php echo $t_route_info->id->getSessionValue() ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($t_route_info->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label id="elh_t_route_info_r_from" for="x_r_from" class="<?php echo $t_route_info_add->LeftColumnClass ?>"><?php echo $t_route_info->r_from->caption() ?><?php echo ($t_route_info->r_from->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_route_info_add->RightColumnClass ?>"><div<?php echo $t_route_info->r_from->cellAttributes() ?>>
<span id="el_t_route_info_r_from">
<input type="text" data-table="t_route_info" data-field="x_r_from" name="x_r_from" id="x_r_from" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($t_route_info->r_from->getPlaceHolder()) ?>" value="<?php echo $t_route_info->r_from->EditValue ?>"<?php echo $t_route_info->r_from->editAttributes() ?>>
</span>
<?php echo $t_route_info->r_from->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->r_to->Visible) { // r_to ?>
	<div id="r_r_to" class="form-group row">
		<label id="elh_t_route_info_r_to" for="x_r_to" class="<?php echo $t_route_info_add->LeftColumnClass ?>"><?php echo $t_route_info->r_to->caption() ?><?php echo ($t_route_info->r_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_route_info_add->RightColumnClass ?>"><div<?php echo $t_route_info->r_to->cellAttributes() ?>>
<span id="el_t_route_info_r_to">
<input type="text" data-table="t_route_info" data-field="x_r_to" name="x_r_to" id="x_r_to" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($t_route_info->r_to->getPlaceHolder()) ?>" value="<?php echo $t_route_info->r_to->EditValue ?>"<?php echo $t_route_info->r_to->editAttributes() ?>>
</span>
<?php echo $t_route_info->r_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->km->Visible) { // km ?>
	<div id="r_km" class="form-group row">
		<label id="elh_t_route_info_km" for="x_km" class="<?php echo $t_route_info_add->LeftColumnClass ?>"><?php echo $t_route_info->km->caption() ?><?php echo ($t_route_info->km->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_route_info_add->RightColumnClass ?>"><div<?php echo $t_route_info->km->cellAttributes() ?>>
<span id="el_t_route_info_km">
<input type="text" data-table="t_route_info" data-field="x_km" name="x_km" id="x_km" size="30" placeholder="<?php echo HtmlEncode($t_route_info->km->getPlaceHolder()) ?>" value="<?php echo $t_route_info->km->EditValue ?>"<?php echo $t_route_info->km->editAttributes() ?>>
</span>
<?php echo $t_route_info->km->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->days->Visible) { // days ?>
	<div id="r_days" class="form-group row">
		<label id="elh_t_route_info_days" for="x_days" class="<?php echo $t_route_info_add->LeftColumnClass ?>"><?php echo $t_route_info->days->caption() ?><?php echo ($t_route_info->days->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_route_info_add->RightColumnClass ?>"><div<?php echo $t_route_info->days->cellAttributes() ?>>
<span id="el_t_route_info_days">
<input type="text" data-table="t_route_info" data-field="x_days" name="x_days" id="x_days" size="30" placeholder="<?php echo HtmlEncode($t_route_info->days->getPlaceHolder()) ?>" value="<?php echo $t_route_info->days->EditValue ?>"<?php echo $t_route_info->days->editAttributes() ?>>
</span>
<?php echo $t_route_info->days->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->load_expenses->Visible) { // load_expenses ?>
	<div id="r_load_expenses" class="form-group row">
		<label id="elh_t_route_info_load_expenses" for="x_load_expenses" class="<?php echo $t_route_info_add->LeftColumnClass ?>"><?php echo $t_route_info->load_expenses->caption() ?><?php echo ($t_route_info->load_expenses->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_route_info_add->RightColumnClass ?>"><div<?php echo $t_route_info->load_expenses->cellAttributes() ?>>
<span id="el_t_route_info_load_expenses">
<input type="text" data-table="t_route_info" data-field="x_load_expenses" name="x_load_expenses" id="x_load_expenses" size="30" placeholder="<?php echo HtmlEncode($t_route_info->load_expenses->getPlaceHolder()) ?>" value="<?php echo $t_route_info->load_expenses->EditValue ?>"<?php echo $t_route_info->load_expenses->editAttributes() ?>>
</span>
<?php echo $t_route_info->load_expenses->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->unload_expenses->Visible) { // unload_expenses ?>
	<div id="r_unload_expenses" class="form-group row">
		<label id="elh_t_route_info_unload_expenses" for="x_unload_expenses" class="<?php echo $t_route_info_add->LeftColumnClass ?>"><?php echo $t_route_info->unload_expenses->caption() ?><?php echo ($t_route_info->unload_expenses->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_route_info_add->RightColumnClass ?>"><div<?php echo $t_route_info->unload_expenses->cellAttributes() ?>>
<span id="el_t_route_info_unload_expenses">
<input type="text" data-table="t_route_info" data-field="x_unload_expenses" name="x_unload_expenses" id="x_unload_expenses" size="30" placeholder="<?php echo HtmlEncode($t_route_info->unload_expenses->getPlaceHolder()) ?>" value="<?php echo $t_route_info->unload_expenses->EditValue ?>"<?php echo $t_route_info->unload_expenses->editAttributes() ?>>
</span>
<?php echo $t_route_info->unload_expenses->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_t_route_info_status" for="x_status" class="<?php echo $t_route_info_add->LeftColumnClass ?>"><?php echo $t_route_info->status->caption() ?><?php echo ($t_route_info->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_route_info_add->RightColumnClass ?>"><div<?php echo $t_route_info->status->cellAttributes() ?>>
<span id="el_t_route_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_route_info" data-field="x_status" data-value-separator="<?php echo $t_route_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $t_route_info->status->editAttributes() ?>>
		<?php echo $t_route_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $t_route_info->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
	<?php if (strval($t_route_info->id->getSessionValue()) <> "") { ?>
	<input type="hidden" name="x_id" id="x_id" value="<?php echo HtmlEncode(strval($t_route_info->id->getSessionValue())) ?>">
	<?php } ?>
<?php if (!$t_route_info_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_route_info_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_route_info_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_route_info_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_route_info_add->terminate();
?>