<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_route_info_addopt = new t_route_info_addopt();

// Run the page
$t_route_info_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_route_info_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var ft_route_infoaddopt = currentForm = new ew.Form("ft_route_infoaddopt", "addopt");

// Validate form
ft_route_infoaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_route_info_addopt->r_from->Required) { ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->r_from->caption(), $t_route_info->r_from->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_route_info_addopt->r_to->Required) { ?>
			elm = this.getElements("x" + infix + "_r_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->r_to->caption(), $t_route_info->r_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_route_info_addopt->km->Required) { ?>
			elm = this.getElements("x" + infix + "_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->km->caption(), $t_route_info->km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_km");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_route_info->km->errorMessage()) ?>");
		<?php if ($t_route_info_addopt->days->Required) { ?>
			elm = this.getElements("x" + infix + "_days");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->days->caption(), $t_route_info->days->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_days");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_route_info->days->errorMessage()) ?>");
		<?php if ($t_route_info_addopt->load_expenses->Required) { ?>
			elm = this.getElements("x" + infix + "_load_expenses");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->load_expenses->caption(), $t_route_info->load_expenses->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_expenses");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_route_info->load_expenses->errorMessage()) ?>");
		<?php if ($t_route_info_addopt->unload_expenses->Required) { ?>
			elm = this.getElements("x" + infix + "_unload_expenses");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->unload_expenses->caption(), $t_route_info->unload_expenses->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_unload_expenses");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_route_info->unload_expenses->errorMessage()) ?>");
		<?php if ($t_route_info_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->status->caption(), $t_route_info->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_route_info_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->operator->caption(), $t_route_info->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_route_info_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->datetime->caption(), $t_route_info->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_route_infoaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_route_infoaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_route_infoaddopt.lists["x_status"] = <?php echo $t_route_info_addopt->status->Lookup->toClientList() ?>;
ft_route_infoaddopt.lists["x_status"].options = <?php echo JsonEncode($t_route_info_addopt->status->options(FALSE, TRUE)) ?>;
ft_route_infoaddopt.lists["x_operator"] = <?php echo $t_route_info_addopt->operator->Lookup->toClientList() ?>;
ft_route_infoaddopt.lists["x_operator"].options = <?php echo JsonEncode($t_route_info_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_route_info_addopt->showPageHeader(); ?>
<?php
$t_route_info_addopt->showMessage();
?>
<form name="ft_route_infoaddopt" id="ft_route_infoaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($t_route_info_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_route_info_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $t_route_info_addopt->TableVar ?>">
<?php if ($t_route_info->r_from->Visible) { // r_from ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_r_from"><?php echo $t_route_info->r_from->caption() ?><?php echo ($t_route_info->r_from->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="t_route_info" data-field="x_r_from" name="x_r_from" id="x_r_from" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($t_route_info->r_from->getPlaceHolder()) ?>" value="<?php echo $t_route_info->r_from->EditValue ?>"<?php echo $t_route_info->r_from->editAttributes() ?>>
<?php echo $t_route_info->r_from->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($t_route_info->r_to->Visible) { // r_to ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_r_to"><?php echo $t_route_info->r_to->caption() ?><?php echo ($t_route_info->r_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="t_route_info" data-field="x_r_to" name="x_r_to" id="x_r_to" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($t_route_info->r_to->getPlaceHolder()) ?>" value="<?php echo $t_route_info->r_to->EditValue ?>"<?php echo $t_route_info->r_to->editAttributes() ?>>
<?php echo $t_route_info->r_to->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($t_route_info->km->Visible) { // km ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_km"><?php echo $t_route_info->km->caption() ?><?php echo ($t_route_info->km->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="t_route_info" data-field="x_km" name="x_km" id="x_km" size="30" placeholder="<?php echo HtmlEncode($t_route_info->km->getPlaceHolder()) ?>" value="<?php echo $t_route_info->km->EditValue ?>"<?php echo $t_route_info->km->editAttributes() ?>>
<?php echo $t_route_info->km->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($t_route_info->days->Visible) { // days ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_days"><?php echo $t_route_info->days->caption() ?><?php echo ($t_route_info->days->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="t_route_info" data-field="x_days" name="x_days" id="x_days" size="30" placeholder="<?php echo HtmlEncode($t_route_info->days->getPlaceHolder()) ?>" value="<?php echo $t_route_info->days->EditValue ?>"<?php echo $t_route_info->days->editAttributes() ?>>
<?php echo $t_route_info->days->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($t_route_info->load_expenses->Visible) { // load_expenses ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_load_expenses"><?php echo $t_route_info->load_expenses->caption() ?><?php echo ($t_route_info->load_expenses->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="t_route_info" data-field="x_load_expenses" name="x_load_expenses" id="x_load_expenses" size="30" placeholder="<?php echo HtmlEncode($t_route_info->load_expenses->getPlaceHolder()) ?>" value="<?php echo $t_route_info->load_expenses->EditValue ?>"<?php echo $t_route_info->load_expenses->editAttributes() ?>>
<?php echo $t_route_info->load_expenses->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($t_route_info->unload_expenses->Visible) { // unload_expenses ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_unload_expenses"><?php echo $t_route_info->unload_expenses->caption() ?><?php echo ($t_route_info->unload_expenses->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="t_route_info" data-field="x_unload_expenses" name="x_unload_expenses" id="x_unload_expenses" size="30" placeholder="<?php echo HtmlEncode($t_route_info->unload_expenses->getPlaceHolder()) ?>" value="<?php echo $t_route_info->unload_expenses->EditValue ?>"<?php echo $t_route_info->unload_expenses->editAttributes() ?>>
<?php echo $t_route_info->unload_expenses->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($t_route_info->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $t_route_info->status->caption() ?><?php echo ($t_route_info->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_route_info" data-field="x_status" data-value-separator="<?php echo $t_route_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $t_route_info->status->editAttributes() ?>>
		<?php echo $t_route_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $t_route_info->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($t_route_info->operator->Visible) { // operator ?>
	<input type="hidden" data-table="t_route_info" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($t_route_info->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($t_route_info->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="t_route_info" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($t_route_info->datetime->CurrentValue) ?>">
	<?php if (!$t_route_info->datetime->ReadOnly && !$t_route_info->datetime->Disabled && !isset($t_route_info->datetime->EditAttrs["readonly"]) && !isset($t_route_info->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("ft_route_infoaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
</form>
<?php
$t_route_info_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$t_route_info_addopt->terminate();
?>