<?php
namespace PHPMaker2019\fibre;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($t_route_info_grid))
	$t_route_info_grid = new t_route_info_grid();

// Run the page
$t_route_info_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_route_info_grid->Page_Render();
?>
<?php if (!$t_route_info->isExport()) { ?>
<script>

// Form object
var ft_route_infogrid = new ew.Form("ft_route_infogrid", "grid");
ft_route_infogrid.formKeyCountName = '<?php echo $t_route_info_grid->FormKeyCountName ?>';

// Validate form
ft_route_infogrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($t_route_info_grid->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->id->caption(), $t_route_info->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_route_info_grid->route_name->Required) { ?>
			elm = this.getElements("x" + infix + "_route_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->route_name->caption(), $t_route_info->route_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_route_info_grid->load_expenses->Required) { ?>
			elm = this.getElements("x" + infix + "_load_expenses");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->load_expenses->caption(), $t_route_info->load_expenses->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_expenses");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_route_info->load_expenses->errorMessage()) ?>");
		<?php if ($t_route_info_grid->unload_expenses->Required) { ?>
			elm = this.getElements("x" + infix + "_unload_expenses");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->unload_expenses->caption(), $t_route_info->unload_expenses->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_unload_expenses");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_route_info->unload_expenses->errorMessage()) ?>");
		<?php if ($t_route_info_grid->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->status->caption(), $t_route_info->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_route_info_grid->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->operator->caption(), $t_route_info->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_route_info_grid->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_route_info->datetime->caption(), $t_route_info->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
ft_route_infogrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "route_name", false)) return false;
	if (ew.valueChanged(fobj, infix, "load_expenses", false)) return false;
	if (ew.valueChanged(fobj, infix, "unload_expenses", false)) return false;
	if (ew.valueChanged(fobj, infix, "status", false)) return false;
	return true;
}

// Form_CustomValidate event
ft_route_infogrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_route_infogrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_route_infogrid.lists["x_status"] = <?php echo $t_route_info_grid->status->Lookup->toClientList() ?>;
ft_route_infogrid.lists["x_status"].options = <?php echo JsonEncode($t_route_info_grid->status->options(FALSE, TRUE)) ?>;
ft_route_infogrid.lists["x_operator"] = <?php echo $t_route_info_grid->operator->Lookup->toClientList() ?>;
ft_route_infogrid.lists["x_operator"].options = <?php echo JsonEncode($t_route_info_grid->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$t_route_info_grid->renderOtherOptions();
?>
<?php $t_route_info_grid->showPageHeader(); ?>
<?php
$t_route_info_grid->showMessage();
?>
<?php if ($t_route_info_grid->TotalRecs > 0 || $t_route_info->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_route_info_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_route_info">
<?php if ($t_route_info_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $t_route_info_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="ft_route_infogrid" class="ew-form ew-list-form form-inline">
<div id="gmp_t_route_info" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_t_route_infogrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_route_info_grid->RowType = ROWTYPE_HEADER;

// Render list options
$t_route_info_grid->renderListOptions();

// Render list options (header, left)
$t_route_info_grid->ListOptions->render("header", "left");
?>
<?php if ($t_route_info->id->Visible) { // id ?>
	<?php if ($t_route_info->sortUrl($t_route_info->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_route_info->id->headerCellClass() ?>"><div id="elh_t_route_info_id" class="t_route_info_id"><div class="ew-table-header-caption"><?php echo $t_route_info->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_route_info->id->headerCellClass() ?>"><div><div id="elh_t_route_info_id" class="t_route_info_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->route_name->Visible) { // route_name ?>
	<?php if ($t_route_info->sortUrl($t_route_info->route_name) == "") { ?>
		<th data-name="route_name" class="<?php echo $t_route_info->route_name->headerCellClass() ?>"><div id="elh_t_route_info_route_name" class="t_route_info_route_name"><div class="ew-table-header-caption"><?php echo $t_route_info->route_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="route_name" class="<?php echo $t_route_info->route_name->headerCellClass() ?>"><div><div id="elh_t_route_info_route_name" class="t_route_info_route_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->route_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info->route_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info->route_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->load_expenses->Visible) { // load_expenses ?>
	<?php if ($t_route_info->sortUrl($t_route_info->load_expenses) == "") { ?>
		<th data-name="load_expenses" class="<?php echo $t_route_info->load_expenses->headerCellClass() ?>"><div id="elh_t_route_info_load_expenses" class="t_route_info_load_expenses"><div class="ew-table-header-caption"><?php echo $t_route_info->load_expenses->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="load_expenses" class="<?php echo $t_route_info->load_expenses->headerCellClass() ?>"><div><div id="elh_t_route_info_load_expenses" class="t_route_info_load_expenses">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->load_expenses->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info->load_expenses->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info->load_expenses->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->unload_expenses->Visible) { // unload_expenses ?>
	<?php if ($t_route_info->sortUrl($t_route_info->unload_expenses) == "") { ?>
		<th data-name="unload_expenses" class="<?php echo $t_route_info->unload_expenses->headerCellClass() ?>"><div id="elh_t_route_info_unload_expenses" class="t_route_info_unload_expenses"><div class="ew-table-header-caption"><?php echo $t_route_info->unload_expenses->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unload_expenses" class="<?php echo $t_route_info->unload_expenses->headerCellClass() ?>"><div><div id="elh_t_route_info_unload_expenses" class="t_route_info_unload_expenses">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->unload_expenses->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info->unload_expenses->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info->unload_expenses->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->status->Visible) { // status ?>
	<?php if ($t_route_info->sortUrl($t_route_info->status) == "") { ?>
		<th data-name="status" class="<?php echo $t_route_info->status->headerCellClass() ?>"><div id="elh_t_route_info_status" class="t_route_info_status"><div class="ew-table-header-caption"><?php echo $t_route_info->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $t_route_info->status->headerCellClass() ?>"><div><div id="elh_t_route_info_status" class="t_route_info_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->operator->Visible) { // operator ?>
	<?php if ($t_route_info->sortUrl($t_route_info->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $t_route_info->operator->headerCellClass() ?>"><div id="elh_t_route_info_operator" class="t_route_info_operator"><div class="ew-table-header-caption"><?php echo $t_route_info->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $t_route_info->operator->headerCellClass() ?>"><div><div id="elh_t_route_info_operator" class="t_route_info_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->datetime->Visible) { // datetime ?>
	<?php if ($t_route_info->sortUrl($t_route_info->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $t_route_info->datetime->headerCellClass() ?>"><div id="elh_t_route_info_datetime" class="t_route_info_datetime"><div class="ew-table-header-caption"><?php echo $t_route_info->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $t_route_info->datetime->headerCellClass() ?>"><div><div id="elh_t_route_info_datetime" class="t_route_info_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_route_info_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$t_route_info_grid->StartRec = 1;
$t_route_info_grid->StopRec = $t_route_info_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $t_route_info_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($t_route_info_grid->FormKeyCountName) && ($t_route_info->isGridAdd() || $t_route_info->isGridEdit() || $t_route_info->isConfirm())) {
		$t_route_info_grid->KeyCount = $CurrentForm->getValue($t_route_info_grid->FormKeyCountName);
		$t_route_info_grid->StopRec = $t_route_info_grid->StartRec + $t_route_info_grid->KeyCount - 1;
	}
}
$t_route_info_grid->RecCnt = $t_route_info_grid->StartRec - 1;
if ($t_route_info_grid->Recordset && !$t_route_info_grid->Recordset->EOF) {
	$t_route_info_grid->Recordset->moveFirst();
	$selectLimit = $t_route_info_grid->UseSelectLimit;
	if (!$selectLimit && $t_route_info_grid->StartRec > 1)
		$t_route_info_grid->Recordset->move($t_route_info_grid->StartRec - 1);
} elseif (!$t_route_info->AllowAddDeleteRow && $t_route_info_grid->StopRec == 0) {
	$t_route_info_grid->StopRec = $t_route_info->GridAddRowCount;
}

// Initialize aggregate
$t_route_info->RowType = ROWTYPE_AGGREGATEINIT;
$t_route_info->resetAttributes();
$t_route_info_grid->renderRow();
if ($t_route_info->isGridAdd())
	$t_route_info_grid->RowIndex = 0;
if ($t_route_info->isGridEdit())
	$t_route_info_grid->RowIndex = 0;
while ($t_route_info_grid->RecCnt < $t_route_info_grid->StopRec) {
	$t_route_info_grid->RecCnt++;
	if ($t_route_info_grid->RecCnt >= $t_route_info_grid->StartRec) {
		$t_route_info_grid->RowCnt++;
		if ($t_route_info->isGridAdd() || $t_route_info->isGridEdit() || $t_route_info->isConfirm()) {
			$t_route_info_grid->RowIndex++;
			$CurrentForm->Index = $t_route_info_grid->RowIndex;
			if ($CurrentForm->hasValue($t_route_info_grid->FormActionName) && $t_route_info_grid->EventCancelled)
				$t_route_info_grid->RowAction = strval($CurrentForm->getValue($t_route_info_grid->FormActionName));
			elseif ($t_route_info->isGridAdd())
				$t_route_info_grid->RowAction = "insert";
			else
				$t_route_info_grid->RowAction = "";
		}

		// Set up key count
		$t_route_info_grid->KeyCount = $t_route_info_grid->RowIndex;

		// Init row class and style
		$t_route_info->resetAttributes();
		$t_route_info->CssClass = "";
		if ($t_route_info->isGridAdd()) {
			if ($t_route_info->CurrentMode == "copy") {
				$t_route_info_grid->loadRowValues($t_route_info_grid->Recordset); // Load row values
				$t_route_info_grid->setRecordKey($t_route_info_grid->RowOldKey, $t_route_info_grid->Recordset); // Set old record key
			} else {
				$t_route_info_grid->loadRowValues(); // Load default values
				$t_route_info_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$t_route_info_grid->loadRowValues($t_route_info_grid->Recordset); // Load row values
		}
		$t_route_info->RowType = ROWTYPE_VIEW; // Render view
		if ($t_route_info->isGridAdd()) // Grid add
			$t_route_info->RowType = ROWTYPE_ADD; // Render add
		if ($t_route_info->isGridAdd() && $t_route_info->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$t_route_info_grid->restoreCurrentRowFormValues($t_route_info_grid->RowIndex); // Restore form values
		if ($t_route_info->isGridEdit()) { // Grid edit
			if ($t_route_info->EventCancelled)
				$t_route_info_grid->restoreCurrentRowFormValues($t_route_info_grid->RowIndex); // Restore form values
			if ($t_route_info_grid->RowAction == "insert")
				$t_route_info->RowType = ROWTYPE_ADD; // Render add
			else
				$t_route_info->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($t_route_info->isGridEdit() && ($t_route_info->RowType == ROWTYPE_EDIT || $t_route_info->RowType == ROWTYPE_ADD) && $t_route_info->EventCancelled) // Update failed
			$t_route_info_grid->restoreCurrentRowFormValues($t_route_info_grid->RowIndex); // Restore form values
		if ($t_route_info->RowType == ROWTYPE_EDIT) // Edit row
			$t_route_info_grid->EditRowCnt++;
		if ($t_route_info->isConfirm()) // Confirm row
			$t_route_info_grid->restoreCurrentRowFormValues($t_route_info_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$t_route_info->RowAttrs = array_merge($t_route_info->RowAttrs, array('data-rowindex'=>$t_route_info_grid->RowCnt, 'id'=>'r' . $t_route_info_grid->RowCnt . '_t_route_info', 'data-rowtype'=>$t_route_info->RowType));

		// Render row
		$t_route_info_grid->renderRow();

		// Render list options
		$t_route_info_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($t_route_info_grid->RowAction <> "delete" && $t_route_info_grid->RowAction <> "insertdelete" && !($t_route_info_grid->RowAction == "insert" && $t_route_info->isConfirm() && $t_route_info_grid->emptyRow())) {
?>
	<tr<?php echo $t_route_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_route_info_grid->ListOptions->render("body", "left", $t_route_info_grid->RowCnt);
?>
	<?php if ($t_route_info->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_route_info->id->cellAttributes() ?>>
<?php if ($t_route_info->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="t_route_info" data-field="x_id" name="o<?php echo $t_route_info_grid->RowIndex ?>_id" id="o<?php echo $t_route_info_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_route_info->id->OldValue) ?>">
<?php } ?>
<?php if ($t_route_info->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_id" class="form-group t_route_info_id">
<span<?php echo $t_route_info->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_route_info->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_id" name="x<?php echo $t_route_info_grid->RowIndex ?>_id" id="x<?php echo $t_route_info_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_route_info->id->CurrentValue) ?>">
<?php } ?>
<?php if ($t_route_info->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_id" class="t_route_info_id">
<span<?php echo $t_route_info->id->viewAttributes() ?>>
<?php echo $t_route_info->id->getViewValue() ?></span>
</span>
<?php if (!$t_route_info->isConfirm()) { ?>
<input type="hidden" data-table="t_route_info" data-field="x_id" name="x<?php echo $t_route_info_grid->RowIndex ?>_id" id="x<?php echo $t_route_info_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_route_info->id->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_id" name="o<?php echo $t_route_info_grid->RowIndex ?>_id" id="o<?php echo $t_route_info_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_route_info->id->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_route_info" data-field="x_id" name="ft_route_infogrid$x<?php echo $t_route_info_grid->RowIndex ?>_id" id="ft_route_infogrid$x<?php echo $t_route_info_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_route_info->id->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_id" name="ft_route_infogrid$o<?php echo $t_route_info_grid->RowIndex ?>_id" id="ft_route_infogrid$o<?php echo $t_route_info_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_route_info->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_route_info->route_name->Visible) { // route_name ?>
		<td data-name="route_name"<?php echo $t_route_info->route_name->cellAttributes() ?>>
<?php if ($t_route_info->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_route_name" class="form-group t_route_info_route_name">
<input type="text" data-table="t_route_info" data-field="x_route_name" name="x<?php echo $t_route_info_grid->RowIndex ?>_route_name" id="x<?php echo $t_route_info_grid->RowIndex ?>_route_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_route_info->route_name->getPlaceHolder()) ?>" value="<?php echo $t_route_info->route_name->EditValue ?>"<?php echo $t_route_info->route_name->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_route_name" name="o<?php echo $t_route_info_grid->RowIndex ?>_route_name" id="o<?php echo $t_route_info_grid->RowIndex ?>_route_name" value="<?php echo HtmlEncode($t_route_info->route_name->OldValue) ?>">
<?php } ?>
<?php if ($t_route_info->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_route_name" class="form-group t_route_info_route_name">
<input type="text" data-table="t_route_info" data-field="x_route_name" name="x<?php echo $t_route_info_grid->RowIndex ?>_route_name" id="x<?php echo $t_route_info_grid->RowIndex ?>_route_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_route_info->route_name->getPlaceHolder()) ?>" value="<?php echo $t_route_info->route_name->EditValue ?>"<?php echo $t_route_info->route_name->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_route_info->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_route_name" class="t_route_info_route_name">
<span<?php echo $t_route_info->route_name->viewAttributes() ?>>
<?php echo $t_route_info->route_name->getViewValue() ?></span>
</span>
<?php if (!$t_route_info->isConfirm()) { ?>
<input type="hidden" data-table="t_route_info" data-field="x_route_name" name="x<?php echo $t_route_info_grid->RowIndex ?>_route_name" id="x<?php echo $t_route_info_grid->RowIndex ?>_route_name" value="<?php echo HtmlEncode($t_route_info->route_name->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_route_name" name="o<?php echo $t_route_info_grid->RowIndex ?>_route_name" id="o<?php echo $t_route_info_grid->RowIndex ?>_route_name" value="<?php echo HtmlEncode($t_route_info->route_name->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_route_info" data-field="x_route_name" name="ft_route_infogrid$x<?php echo $t_route_info_grid->RowIndex ?>_route_name" id="ft_route_infogrid$x<?php echo $t_route_info_grid->RowIndex ?>_route_name" value="<?php echo HtmlEncode($t_route_info->route_name->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_route_name" name="ft_route_infogrid$o<?php echo $t_route_info_grid->RowIndex ?>_route_name" id="ft_route_infogrid$o<?php echo $t_route_info_grid->RowIndex ?>_route_name" value="<?php echo HtmlEncode($t_route_info->route_name->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_route_info->load_expenses->Visible) { // load_expenses ?>
		<td data-name="load_expenses"<?php echo $t_route_info->load_expenses->cellAttributes() ?>>
<?php if ($t_route_info->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_load_expenses" class="form-group t_route_info_load_expenses">
<input type="text" data-table="t_route_info" data-field="x_load_expenses" name="x<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" id="x<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" size="30" placeholder="<?php echo HtmlEncode($t_route_info->load_expenses->getPlaceHolder()) ?>" value="<?php echo $t_route_info->load_expenses->EditValue ?>"<?php echo $t_route_info->load_expenses->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_load_expenses" name="o<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" id="o<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" value="<?php echo HtmlEncode($t_route_info->load_expenses->OldValue) ?>">
<?php } ?>
<?php if ($t_route_info->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_load_expenses" class="form-group t_route_info_load_expenses">
<input type="text" data-table="t_route_info" data-field="x_load_expenses" name="x<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" id="x<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" size="30" placeholder="<?php echo HtmlEncode($t_route_info->load_expenses->getPlaceHolder()) ?>" value="<?php echo $t_route_info->load_expenses->EditValue ?>"<?php echo $t_route_info->load_expenses->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_route_info->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_load_expenses" class="t_route_info_load_expenses">
<span<?php echo $t_route_info->load_expenses->viewAttributes() ?>>
<?php echo $t_route_info->load_expenses->getViewValue() ?></span>
</span>
<?php if (!$t_route_info->isConfirm()) { ?>
<input type="hidden" data-table="t_route_info" data-field="x_load_expenses" name="x<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" id="x<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" value="<?php echo HtmlEncode($t_route_info->load_expenses->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_load_expenses" name="o<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" id="o<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" value="<?php echo HtmlEncode($t_route_info->load_expenses->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_route_info" data-field="x_load_expenses" name="ft_route_infogrid$x<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" id="ft_route_infogrid$x<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" value="<?php echo HtmlEncode($t_route_info->load_expenses->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_load_expenses" name="ft_route_infogrid$o<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" id="ft_route_infogrid$o<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" value="<?php echo HtmlEncode($t_route_info->load_expenses->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_route_info->unload_expenses->Visible) { // unload_expenses ?>
		<td data-name="unload_expenses"<?php echo $t_route_info->unload_expenses->cellAttributes() ?>>
<?php if ($t_route_info->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_unload_expenses" class="form-group t_route_info_unload_expenses">
<input type="text" data-table="t_route_info" data-field="x_unload_expenses" name="x<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" id="x<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" size="30" placeholder="<?php echo HtmlEncode($t_route_info->unload_expenses->getPlaceHolder()) ?>" value="<?php echo $t_route_info->unload_expenses->EditValue ?>"<?php echo $t_route_info->unload_expenses->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_unload_expenses" name="o<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" id="o<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" value="<?php echo HtmlEncode($t_route_info->unload_expenses->OldValue) ?>">
<?php } ?>
<?php if ($t_route_info->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_unload_expenses" class="form-group t_route_info_unload_expenses">
<input type="text" data-table="t_route_info" data-field="x_unload_expenses" name="x<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" id="x<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" size="30" placeholder="<?php echo HtmlEncode($t_route_info->unload_expenses->getPlaceHolder()) ?>" value="<?php echo $t_route_info->unload_expenses->EditValue ?>"<?php echo $t_route_info->unload_expenses->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_route_info->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_unload_expenses" class="t_route_info_unload_expenses">
<span<?php echo $t_route_info->unload_expenses->viewAttributes() ?>>
<?php echo $t_route_info->unload_expenses->getViewValue() ?></span>
</span>
<?php if (!$t_route_info->isConfirm()) { ?>
<input type="hidden" data-table="t_route_info" data-field="x_unload_expenses" name="x<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" id="x<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" value="<?php echo HtmlEncode($t_route_info->unload_expenses->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_unload_expenses" name="o<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" id="o<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" value="<?php echo HtmlEncode($t_route_info->unload_expenses->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_route_info" data-field="x_unload_expenses" name="ft_route_infogrid$x<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" id="ft_route_infogrid$x<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" value="<?php echo HtmlEncode($t_route_info->unload_expenses->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_unload_expenses" name="ft_route_infogrid$o<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" id="ft_route_infogrid$o<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" value="<?php echo HtmlEncode($t_route_info->unload_expenses->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_route_info->status->Visible) { // status ?>
		<td data-name="status"<?php echo $t_route_info->status->cellAttributes() ?>>
<?php if ($t_route_info->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_status" class="form-group t_route_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_route_info" data-field="x_status" data-value-separator="<?php echo $t_route_info->status->displayValueSeparatorAttribute() ?>" id="x<?php echo $t_route_info_grid->RowIndex ?>_status" name="x<?php echo $t_route_info_grid->RowIndex ?>_status"<?php echo $t_route_info->status->editAttributes() ?>>
		<?php echo $t_route_info->status->selectOptionListHtml("x<?php echo $t_route_info_grid->RowIndex ?>_status") ?>
	</select>
</div>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_status" name="o<?php echo $t_route_info_grid->RowIndex ?>_status" id="o<?php echo $t_route_info_grid->RowIndex ?>_status" value="<?php echo HtmlEncode($t_route_info->status->OldValue) ?>">
<?php } ?>
<?php if ($t_route_info->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_status" class="form-group t_route_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_route_info" data-field="x_status" data-value-separator="<?php echo $t_route_info->status->displayValueSeparatorAttribute() ?>" id="x<?php echo $t_route_info_grid->RowIndex ?>_status" name="x<?php echo $t_route_info_grid->RowIndex ?>_status"<?php echo $t_route_info->status->editAttributes() ?>>
		<?php echo $t_route_info->status->selectOptionListHtml("x<?php echo $t_route_info_grid->RowIndex ?>_status") ?>
	</select>
</div>
</span>
<?php } ?>
<?php if ($t_route_info->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_status" class="t_route_info_status">
<span<?php echo $t_route_info->status->viewAttributes() ?>>
<?php echo $t_route_info->status->getViewValue() ?></span>
</span>
<?php if (!$t_route_info->isConfirm()) { ?>
<input type="hidden" data-table="t_route_info" data-field="x_status" name="x<?php echo $t_route_info_grid->RowIndex ?>_status" id="x<?php echo $t_route_info_grid->RowIndex ?>_status" value="<?php echo HtmlEncode($t_route_info->status->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_status" name="o<?php echo $t_route_info_grid->RowIndex ?>_status" id="o<?php echo $t_route_info_grid->RowIndex ?>_status" value="<?php echo HtmlEncode($t_route_info->status->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_route_info" data-field="x_status" name="ft_route_infogrid$x<?php echo $t_route_info_grid->RowIndex ?>_status" id="ft_route_infogrid$x<?php echo $t_route_info_grid->RowIndex ?>_status" value="<?php echo HtmlEncode($t_route_info->status->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_status" name="ft_route_infogrid$o<?php echo $t_route_info_grid->RowIndex ?>_status" id="ft_route_infogrid$o<?php echo $t_route_info_grid->RowIndex ?>_status" value="<?php echo HtmlEncode($t_route_info->status->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_route_info->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $t_route_info->operator->cellAttributes() ?>>
<?php if ($t_route_info->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="t_route_info" data-field="x_operator" name="o<?php echo $t_route_info_grid->RowIndex ?>_operator" id="o<?php echo $t_route_info_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_route_info->operator->OldValue) ?>">
<?php } ?>
<?php if ($t_route_info->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($t_route_info->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_operator" class="t_route_info_operator">
<span<?php echo $t_route_info->operator->viewAttributes() ?>>
<?php echo $t_route_info->operator->getViewValue() ?></span>
</span>
<?php if (!$t_route_info->isConfirm()) { ?>
<input type="hidden" data-table="t_route_info" data-field="x_operator" name="x<?php echo $t_route_info_grid->RowIndex ?>_operator" id="x<?php echo $t_route_info_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_route_info->operator->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_operator" name="o<?php echo $t_route_info_grid->RowIndex ?>_operator" id="o<?php echo $t_route_info_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_route_info->operator->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_route_info" data-field="x_operator" name="ft_route_infogrid$x<?php echo $t_route_info_grid->RowIndex ?>_operator" id="ft_route_infogrid$x<?php echo $t_route_info_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_route_info->operator->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_operator" name="ft_route_infogrid$o<?php echo $t_route_info_grid->RowIndex ?>_operator" id="ft_route_infogrid$o<?php echo $t_route_info_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_route_info->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_route_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $t_route_info->datetime->cellAttributes() ?>>
<?php if ($t_route_info->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="t_route_info" data-field="x_datetime" name="o<?php echo $t_route_info_grid->RowIndex ?>_datetime" id="o<?php echo $t_route_info_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_route_info->datetime->OldValue) ?>">
<?php } ?>
<?php if ($t_route_info->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($t_route_info->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_route_info_grid->RowCnt ?>_t_route_info_datetime" class="t_route_info_datetime">
<span<?php echo $t_route_info->datetime->viewAttributes() ?>>
<?php echo $t_route_info->datetime->getViewValue() ?></span>
</span>
<?php if (!$t_route_info->isConfirm()) { ?>
<input type="hidden" data-table="t_route_info" data-field="x_datetime" name="x<?php echo $t_route_info_grid->RowIndex ?>_datetime" id="x<?php echo $t_route_info_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_route_info->datetime->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_datetime" name="o<?php echo $t_route_info_grid->RowIndex ?>_datetime" id="o<?php echo $t_route_info_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_route_info->datetime->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="t_route_info" data-field="x_datetime" name="ft_route_infogrid$x<?php echo $t_route_info_grid->RowIndex ?>_datetime" id="ft_route_infogrid$x<?php echo $t_route_info_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_route_info->datetime->FormValue) ?>">
<input type="hidden" data-table="t_route_info" data-field="x_datetime" name="ft_route_infogrid$o<?php echo $t_route_info_grid->RowIndex ?>_datetime" id="ft_route_infogrid$o<?php echo $t_route_info_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_route_info->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_route_info_grid->ListOptions->render("body", "right", $t_route_info_grid->RowCnt);
?>
	</tr>
<?php if ($t_route_info->RowType == ROWTYPE_ADD || $t_route_info->RowType == ROWTYPE_EDIT) { ?>
<script>
ft_route_infogrid.updateLists(<?php echo $t_route_info_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$t_route_info->isGridAdd() || $t_route_info->CurrentMode == "copy")
		if (!$t_route_info_grid->Recordset->EOF)
			$t_route_info_grid->Recordset->moveNext();
}
?>
<?php
	if ($t_route_info->CurrentMode == "add" || $t_route_info->CurrentMode == "copy" || $t_route_info->CurrentMode == "edit") {
		$t_route_info_grid->RowIndex = '$rowindex$';
		$t_route_info_grid->loadRowValues();

		// Set row properties
		$t_route_info->resetAttributes();
		$t_route_info->RowAttrs = array_merge($t_route_info->RowAttrs, array('data-rowindex'=>$t_route_info_grid->RowIndex, 'id'=>'r0_t_route_info', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($t_route_info->RowAttrs["class"], "ew-template");
		$t_route_info->RowType = ROWTYPE_ADD;

		// Render row
		$t_route_info_grid->renderRow();

		// Render list options
		$t_route_info_grid->renderListOptions();
		$t_route_info_grid->StartRowCnt = 0;
?>
	<tr<?php echo $t_route_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_route_info_grid->ListOptions->render("body", "left", $t_route_info_grid->RowIndex);
?>
	<?php if ($t_route_info->id->Visible) { // id ?>
		<td data-name="id">
<?php if (!$t_route_info->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_t_route_info_id" class="form-group t_route_info_id">
<span<?php echo $t_route_info->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_route_info->id->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_id" name="x<?php echo $t_route_info_grid->RowIndex ?>_id" id="x<?php echo $t_route_info_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_route_info->id->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_route_info" data-field="x_id" name="o<?php echo $t_route_info_grid->RowIndex ?>_id" id="o<?php echo $t_route_info_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($t_route_info->id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_route_info->route_name->Visible) { // route_name ?>
		<td data-name="route_name">
<?php if (!$t_route_info->isConfirm()) { ?>
<span id="el$rowindex$_t_route_info_route_name" class="form-group t_route_info_route_name">
<input type="text" data-table="t_route_info" data-field="x_route_name" name="x<?php echo $t_route_info_grid->RowIndex ?>_route_name" id="x<?php echo $t_route_info_grid->RowIndex ?>_route_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_route_info->route_name->getPlaceHolder()) ?>" value="<?php echo $t_route_info->route_name->EditValue ?>"<?php echo $t_route_info->route_name->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_route_info_route_name" class="form-group t_route_info_route_name">
<span<?php echo $t_route_info->route_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_route_info->route_name->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_route_name" name="x<?php echo $t_route_info_grid->RowIndex ?>_route_name" id="x<?php echo $t_route_info_grid->RowIndex ?>_route_name" value="<?php echo HtmlEncode($t_route_info->route_name->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_route_info" data-field="x_route_name" name="o<?php echo $t_route_info_grid->RowIndex ?>_route_name" id="o<?php echo $t_route_info_grid->RowIndex ?>_route_name" value="<?php echo HtmlEncode($t_route_info->route_name->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_route_info->load_expenses->Visible) { // load_expenses ?>
		<td data-name="load_expenses">
<?php if (!$t_route_info->isConfirm()) { ?>
<span id="el$rowindex$_t_route_info_load_expenses" class="form-group t_route_info_load_expenses">
<input type="text" data-table="t_route_info" data-field="x_load_expenses" name="x<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" id="x<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" size="30" placeholder="<?php echo HtmlEncode($t_route_info->load_expenses->getPlaceHolder()) ?>" value="<?php echo $t_route_info->load_expenses->EditValue ?>"<?php echo $t_route_info->load_expenses->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_route_info_load_expenses" class="form-group t_route_info_load_expenses">
<span<?php echo $t_route_info->load_expenses->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_route_info->load_expenses->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_load_expenses" name="x<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" id="x<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" value="<?php echo HtmlEncode($t_route_info->load_expenses->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_route_info" data-field="x_load_expenses" name="o<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" id="o<?php echo $t_route_info_grid->RowIndex ?>_load_expenses" value="<?php echo HtmlEncode($t_route_info->load_expenses->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_route_info->unload_expenses->Visible) { // unload_expenses ?>
		<td data-name="unload_expenses">
<?php if (!$t_route_info->isConfirm()) { ?>
<span id="el$rowindex$_t_route_info_unload_expenses" class="form-group t_route_info_unload_expenses">
<input type="text" data-table="t_route_info" data-field="x_unload_expenses" name="x<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" id="x<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" size="30" placeholder="<?php echo HtmlEncode($t_route_info->unload_expenses->getPlaceHolder()) ?>" value="<?php echo $t_route_info->unload_expenses->EditValue ?>"<?php echo $t_route_info->unload_expenses->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_route_info_unload_expenses" class="form-group t_route_info_unload_expenses">
<span<?php echo $t_route_info->unload_expenses->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_route_info->unload_expenses->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_unload_expenses" name="x<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" id="x<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" value="<?php echo HtmlEncode($t_route_info->unload_expenses->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_route_info" data-field="x_unload_expenses" name="o<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" id="o<?php echo $t_route_info_grid->RowIndex ?>_unload_expenses" value="<?php echo HtmlEncode($t_route_info->unload_expenses->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_route_info->status->Visible) { // status ?>
		<td data-name="status">
<?php if (!$t_route_info->isConfirm()) { ?>
<span id="el$rowindex$_t_route_info_status" class="form-group t_route_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_route_info" data-field="x_status" data-value-separator="<?php echo $t_route_info->status->displayValueSeparatorAttribute() ?>" id="x<?php echo $t_route_info_grid->RowIndex ?>_status" name="x<?php echo $t_route_info_grid->RowIndex ?>_status"<?php echo $t_route_info->status->editAttributes() ?>>
		<?php echo $t_route_info->status->selectOptionListHtml("x<?php echo $t_route_info_grid->RowIndex ?>_status") ?>
	</select>
</div>
</span>
<?php } else { ?>
<span id="el$rowindex$_t_route_info_status" class="form-group t_route_info_status">
<span<?php echo $t_route_info->status->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_route_info->status->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_status" name="x<?php echo $t_route_info_grid->RowIndex ?>_status" id="x<?php echo $t_route_info_grid->RowIndex ?>_status" value="<?php echo HtmlEncode($t_route_info->status->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_route_info" data-field="x_status" name="o<?php echo $t_route_info_grid->RowIndex ?>_status" id="o<?php echo $t_route_info_grid->RowIndex ?>_status" value="<?php echo HtmlEncode($t_route_info->status->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_route_info->operator->Visible) { // operator ?>
		<td data-name="operator">
<?php if (!$t_route_info->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_t_route_info_operator" class="form-group t_route_info_operator">
<span<?php echo $t_route_info->operator->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_route_info->operator->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_operator" name="x<?php echo $t_route_info_grid->RowIndex ?>_operator" id="x<?php echo $t_route_info_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_route_info->operator->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_route_info" data-field="x_operator" name="o<?php echo $t_route_info_grid->RowIndex ?>_operator" id="o<?php echo $t_route_info_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_route_info->operator->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_route_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime">
<?php if (!$t_route_info->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_t_route_info_datetime" class="form-group t_route_info_datetime">
<span<?php echo $t_route_info->datetime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_route_info->datetime->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="t_route_info" data-field="x_datetime" name="x<?php echo $t_route_info_grid->RowIndex ?>_datetime" id="x<?php echo $t_route_info_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_route_info->datetime->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="t_route_info" data-field="x_datetime" name="o<?php echo $t_route_info_grid->RowIndex ?>_datetime" id="o<?php echo $t_route_info_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_route_info->datetime->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_route_info_grid->ListOptions->render("body", "right", $t_route_info_grid->RowIndex);
?>
<script>
ft_route_infogrid.updateLists(<?php echo $t_route_info_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($t_route_info->CurrentMode == "add" || $t_route_info->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $t_route_info_grid->FormKeyCountName ?>" id="<?php echo $t_route_info_grid->FormKeyCountName ?>" value="<?php echo $t_route_info_grid->KeyCount ?>">
<?php echo $t_route_info_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($t_route_info->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $t_route_info_grid->FormKeyCountName ?>" id="<?php echo $t_route_info_grid->FormKeyCountName ?>" value="<?php echo $t_route_info_grid->KeyCount ?>">
<?php echo $t_route_info_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($t_route_info->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="ft_route_infogrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($t_route_info_grid->Recordset)
	$t_route_info_grid->Recordset->Close();
?>
</div>
<?php if ($t_route_info_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $t_route_info_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_route_info_grid->TotalRecs == 0 && !$t_route_info->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_route_info_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_route_info_grid->terminate();
?>
<?php if (!$t_route_info->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_route_info", "100%", "500px");
</script>
<?php } ?>