<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_route_info_list = new t_route_info_list();

// Run the page
$t_route_info_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_route_info_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_route_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_route_infolist = currentForm = new ew.Form("ft_route_infolist", "list");
ft_route_infolist.formKeyCountName = '<?php echo $t_route_info_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_route_infolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_route_infolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_route_infolist.lists["x_status"] = <?php echo $t_route_info_list->status->Lookup->toClientList() ?>;
ft_route_infolist.lists["x_status"].options = <?php echo JsonEncode($t_route_info_list->status->options(FALSE, TRUE)) ?>;
ft_route_infolist.lists["x_operator"] = <?php echo $t_route_info_list->operator->Lookup->toClientList() ?>;
ft_route_infolist.lists["x_operator"].options = <?php echo JsonEncode($t_route_info_list->operator->lookupOptions()) ?>;

// Form object for search
var ft_route_infolistsrch = currentSearchForm = new ew.Form("ft_route_infolistsrch");

// Filters
ft_route_infolistsrch.filterList = <?php echo $t_route_info_list->getFilterList() ?>;

// Init search panel as collapsed
ft_route_infolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_route_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_route_info_list->TotalRecs > 0 && $t_route_info_list->ExportOptions->visible()) { ?>
<?php $t_route_info_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_route_info_list->ImportOptions->visible()) { ?>
<?php $t_route_info_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_route_info_list->SearchOptions->visible()) { ?>
<?php $t_route_info_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_route_info_list->FilterOptions->visible()) { ?>
<?php $t_route_info_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$t_route_info->isExport() || EXPORT_MASTER_RECORD && $t_route_info->isExport("print")) { ?>
<?php
if ($t_route_info_list->DbMasterFilter <> "" && $t_route_info->getCurrentMasterTable() == "t_trip_info") {
	if ($t_route_info_list->MasterRecordExists) {
		include_once "t_trip_infomaster.php";
	}
}
?>
<?php } ?>
<?php
$t_route_info_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_route_info->isExport() && !$t_route_info->CurrentAction) { ?>
<form name="ft_route_infolistsrch" id="ft_route_infolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_route_info_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_route_infolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_route_info">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_route_info_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_route_info_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_route_info_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_route_info_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_route_info_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_route_info_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_route_info_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_route_info_list->showPageHeader(); ?>
<?php
$t_route_info_list->showMessage();
?>
<?php if ($t_route_info_list->TotalRecs > 0 || $t_route_info->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_route_info_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_route_info">
<?php if (!$t_route_info->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_route_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_route_info_list->Pager)) $t_route_info_list->Pager = new PrevNextPager($t_route_info_list->StartRec, $t_route_info_list->DisplayRecs, $t_route_info_list->TotalRecs, $t_route_info_list->AutoHidePager) ?>
<?php if ($t_route_info_list->Pager->RecordCount > 0 && $t_route_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_route_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_route_info_list->pageUrl() ?>start=<?php echo $t_route_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_route_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_route_info_list->pageUrl() ?>start=<?php echo $t_route_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_route_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_route_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_route_info_list->pageUrl() ?>start=<?php echo $t_route_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_route_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_route_info_list->pageUrl() ?>start=<?php echo $t_route_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_route_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_route_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_route_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_route_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_route_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_route_info_list->TotalRecs > 0 && (!$t_route_info_list->AutoHidePageSizeSelector || $t_route_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_route_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_route_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_route_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_route_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_route_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_route_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_route_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_route_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_route_infolist" id="ft_route_infolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_route_info_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_route_info_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_route_info">
<?php if ($t_route_info->getCurrentMasterTable() == "t_trip_info" && $t_route_info->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="t_trip_info">
<input type="hidden" name="fk__route" value="<?php echo $t_route_info->id->getSessionValue() ?>">
<?php } ?>
<div id="gmp_t_route_info" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_route_info_list->TotalRecs > 0 || $t_route_info->isGridEdit()) { ?>
<table id="tbl_t_route_infolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_route_info_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_route_info_list->renderListOptions();

// Render list options (header, left)
$t_route_info_list->ListOptions->render("header", "left");
?>
<?php if ($t_route_info->id->Visible) { // id ?>
	<?php if ($t_route_info->sortUrl($t_route_info->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_route_info->id->headerCellClass() ?>"><div id="elh_t_route_info_id" class="t_route_info_id"><div class="ew-table-header-caption"><?php echo $t_route_info->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_route_info->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_route_info->SortUrl($t_route_info->id) ?>',2);"><div id="elh_t_route_info_id" class="t_route_info_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_route_info->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->route_name->Visible) { // route_name ?>
	<?php if ($t_route_info->sortUrl($t_route_info->route_name) == "") { ?>
		<th data-name="route_name" class="<?php echo $t_route_info->route_name->headerCellClass() ?>"><div id="elh_t_route_info_route_name" class="t_route_info_route_name"><div class="ew-table-header-caption"><?php echo $t_route_info->route_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="route_name" class="<?php echo $t_route_info->route_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_route_info->SortUrl($t_route_info->route_name) ?>',2);"><div id="elh_t_route_info_route_name" class="t_route_info_route_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->route_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_route_info->route_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info->route_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->load_expenses->Visible) { // load_expenses ?>
	<?php if ($t_route_info->sortUrl($t_route_info->load_expenses) == "") { ?>
		<th data-name="load_expenses" class="<?php echo $t_route_info->load_expenses->headerCellClass() ?>"><div id="elh_t_route_info_load_expenses" class="t_route_info_load_expenses"><div class="ew-table-header-caption"><?php echo $t_route_info->load_expenses->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="load_expenses" class="<?php echo $t_route_info->load_expenses->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_route_info->SortUrl($t_route_info->load_expenses) ?>',2);"><div id="elh_t_route_info_load_expenses" class="t_route_info_load_expenses">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->load_expenses->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info->load_expenses->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info->load_expenses->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->unload_expenses->Visible) { // unload_expenses ?>
	<?php if ($t_route_info->sortUrl($t_route_info->unload_expenses) == "") { ?>
		<th data-name="unload_expenses" class="<?php echo $t_route_info->unload_expenses->headerCellClass() ?>"><div id="elh_t_route_info_unload_expenses" class="t_route_info_unload_expenses"><div class="ew-table-header-caption"><?php echo $t_route_info->unload_expenses->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unload_expenses" class="<?php echo $t_route_info->unload_expenses->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_route_info->SortUrl($t_route_info->unload_expenses) ?>',2);"><div id="elh_t_route_info_unload_expenses" class="t_route_info_unload_expenses">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->unload_expenses->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info->unload_expenses->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info->unload_expenses->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->status->Visible) { // status ?>
	<?php if ($t_route_info->sortUrl($t_route_info->status) == "") { ?>
		<th data-name="status" class="<?php echo $t_route_info->status->headerCellClass() ?>"><div id="elh_t_route_info_status" class="t_route_info_status"><div class="ew-table-header-caption"><?php echo $t_route_info->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $t_route_info->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_route_info->SortUrl($t_route_info->status) ?>',2);"><div id="elh_t_route_info_status" class="t_route_info_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->operator->Visible) { // operator ?>
	<?php if ($t_route_info->sortUrl($t_route_info->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $t_route_info->operator->headerCellClass() ?>"><div id="elh_t_route_info_operator" class="t_route_info_operator"><div class="ew-table-header-caption"><?php echo $t_route_info->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $t_route_info->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_route_info->SortUrl($t_route_info->operator) ?>',2);"><div id="elh_t_route_info_operator" class="t_route_info_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->datetime->Visible) { // datetime ?>
	<?php if ($t_route_info->sortUrl($t_route_info->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $t_route_info->datetime->headerCellClass() ?>"><div id="elh_t_route_info_datetime" class="t_route_info_datetime"><div class="ew-table-header-caption"><?php echo $t_route_info->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $t_route_info->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_route_info->SortUrl($t_route_info->datetime) ?>',2);"><div id="elh_t_route_info_datetime" class="t_route_info_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_route_info_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_route_info->ExportAll && $t_route_info->isExport()) {
	$t_route_info_list->StopRec = $t_route_info_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_route_info_list->TotalRecs > $t_route_info_list->StartRec + $t_route_info_list->DisplayRecs - 1)
		$t_route_info_list->StopRec = $t_route_info_list->StartRec + $t_route_info_list->DisplayRecs - 1;
	else
		$t_route_info_list->StopRec = $t_route_info_list->TotalRecs;
}
$t_route_info_list->RecCnt = $t_route_info_list->StartRec - 1;
if ($t_route_info_list->Recordset && !$t_route_info_list->Recordset->EOF) {
	$t_route_info_list->Recordset->moveFirst();
	$selectLimit = $t_route_info_list->UseSelectLimit;
	if (!$selectLimit && $t_route_info_list->StartRec > 1)
		$t_route_info_list->Recordset->move($t_route_info_list->StartRec - 1);
} elseif (!$t_route_info->AllowAddDeleteRow && $t_route_info_list->StopRec == 0) {
	$t_route_info_list->StopRec = $t_route_info->GridAddRowCount;
}

// Initialize aggregate
$t_route_info->RowType = ROWTYPE_AGGREGATEINIT;
$t_route_info->resetAttributes();
$t_route_info_list->renderRow();
while ($t_route_info_list->RecCnt < $t_route_info_list->StopRec) {
	$t_route_info_list->RecCnt++;
	if ($t_route_info_list->RecCnt >= $t_route_info_list->StartRec) {
		$t_route_info_list->RowCnt++;

		// Set up key count
		$t_route_info_list->KeyCount = $t_route_info_list->RowIndex;

		// Init row class and style
		$t_route_info->resetAttributes();
		$t_route_info->CssClass = "";
		if ($t_route_info->isGridAdd()) {
		} else {
			$t_route_info_list->loadRowValues($t_route_info_list->Recordset); // Load row values
		}
		$t_route_info->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_route_info->RowAttrs = array_merge($t_route_info->RowAttrs, array('data-rowindex'=>$t_route_info_list->RowCnt, 'id'=>'r' . $t_route_info_list->RowCnt . '_t_route_info', 'data-rowtype'=>$t_route_info->RowType));

		// Render row
		$t_route_info_list->renderRow();

		// Render list options
		$t_route_info_list->renderListOptions();
?>
	<tr<?php echo $t_route_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_route_info_list->ListOptions->render("body", "left", $t_route_info_list->RowCnt);
?>
	<?php if ($t_route_info->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_route_info->id->cellAttributes() ?>>
<span id="el<?php echo $t_route_info_list->RowCnt ?>_t_route_info_id" class="t_route_info_id">
<span<?php echo $t_route_info->id->viewAttributes() ?>>
<?php echo $t_route_info->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_route_info->route_name->Visible) { // route_name ?>
		<td data-name="route_name"<?php echo $t_route_info->route_name->cellAttributes() ?>>
<span id="el<?php echo $t_route_info_list->RowCnt ?>_t_route_info_route_name" class="t_route_info_route_name">
<span<?php echo $t_route_info->route_name->viewAttributes() ?>>
<?php echo $t_route_info->route_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_route_info->load_expenses->Visible) { // load_expenses ?>
		<td data-name="load_expenses"<?php echo $t_route_info->load_expenses->cellAttributes() ?>>
<span id="el<?php echo $t_route_info_list->RowCnt ?>_t_route_info_load_expenses" class="t_route_info_load_expenses">
<span<?php echo $t_route_info->load_expenses->viewAttributes() ?>>
<?php echo $t_route_info->load_expenses->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_route_info->unload_expenses->Visible) { // unload_expenses ?>
		<td data-name="unload_expenses"<?php echo $t_route_info->unload_expenses->cellAttributes() ?>>
<span id="el<?php echo $t_route_info_list->RowCnt ?>_t_route_info_unload_expenses" class="t_route_info_unload_expenses">
<span<?php echo $t_route_info->unload_expenses->viewAttributes() ?>>
<?php echo $t_route_info->unload_expenses->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_route_info->status->Visible) { // status ?>
		<td data-name="status"<?php echo $t_route_info->status->cellAttributes() ?>>
<span id="el<?php echo $t_route_info_list->RowCnt ?>_t_route_info_status" class="t_route_info_status">
<span<?php echo $t_route_info->status->viewAttributes() ?>>
<?php echo $t_route_info->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_route_info->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $t_route_info->operator->cellAttributes() ?>>
<span id="el<?php echo $t_route_info_list->RowCnt ?>_t_route_info_operator" class="t_route_info_operator">
<span<?php echo $t_route_info->operator->viewAttributes() ?>>
<?php echo $t_route_info->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_route_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $t_route_info->datetime->cellAttributes() ?>>
<span id="el<?php echo $t_route_info_list->RowCnt ?>_t_route_info_datetime" class="t_route_info_datetime">
<span<?php echo $t_route_info->datetime->viewAttributes() ?>>
<?php echo $t_route_info->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_route_info_list->ListOptions->render("body", "right", $t_route_info_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_route_info->isGridAdd())
		$t_route_info_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_route_info->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_route_info_list->Recordset)
	$t_route_info_list->Recordset->Close();
?>
<?php if (!$t_route_info->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_route_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_route_info_list->Pager)) $t_route_info_list->Pager = new PrevNextPager($t_route_info_list->StartRec, $t_route_info_list->DisplayRecs, $t_route_info_list->TotalRecs, $t_route_info_list->AutoHidePager) ?>
<?php if ($t_route_info_list->Pager->RecordCount > 0 && $t_route_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_route_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_route_info_list->pageUrl() ?>start=<?php echo $t_route_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_route_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_route_info_list->pageUrl() ?>start=<?php echo $t_route_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_route_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_route_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_route_info_list->pageUrl() ?>start=<?php echo $t_route_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_route_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_route_info_list->pageUrl() ?>start=<?php echo $t_route_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_route_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_route_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_route_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_route_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_route_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_route_info_list->TotalRecs > 0 && (!$t_route_info_list->AutoHidePageSizeSelector || $t_route_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_route_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_route_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_route_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_route_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_route_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_route_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_route_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_route_info_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_route_info_list->TotalRecs == 0 && !$t_route_info->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_route_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_route_info_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_route_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_route_info->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_route_info", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_route_info_list->terminate();
?>