<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$t_route_info_preview = new t_route_info_preview();

// Run the page
$t_route_info_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_route_info_preview->Page_Render();
?>
<?php $t_route_info_preview->showPageHeader(); ?>
<div class="card ew-grid t_route_info"><!-- .card -->
<?php if ($t_route_info_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$t_route_info_preview->renderListOptions();

// Render list options (header, left)
$t_route_info_preview->ListOptions->render("header", "left");
?>
<?php if ($t_route_info->id->Visible) { // id ?>
	<?php if ($t_route_info->SortUrl($t_route_info->id) == "") { ?>
		<th class="<?php echo $t_route_info->id->headerCellClass() ?>"><?php echo $t_route_info->id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_route_info->id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_route_info->id->Name) ?>" data-sort-order="<?php echo $t_route_info_preview->SortField == $t_route_info->id->Name && $t_route_info_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info_preview->SortField == $t_route_info->id->Name) { ?><?php if ($t_route_info_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->route_name->Visible) { // route_name ?>
	<?php if ($t_route_info->SortUrl($t_route_info->route_name) == "") { ?>
		<th class="<?php echo $t_route_info->route_name->headerCellClass() ?>"><?php echo $t_route_info->route_name->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_route_info->route_name->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_route_info->route_name->Name) ?>" data-sort-order="<?php echo $t_route_info_preview->SortField == $t_route_info->route_name->Name && $t_route_info_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->route_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info_preview->SortField == $t_route_info->route_name->Name) { ?><?php if ($t_route_info_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->load_expenses->Visible) { // load_expenses ?>
	<?php if ($t_route_info->SortUrl($t_route_info->load_expenses) == "") { ?>
		<th class="<?php echo $t_route_info->load_expenses->headerCellClass() ?>"><?php echo $t_route_info->load_expenses->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_route_info->load_expenses->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_route_info->load_expenses->Name) ?>" data-sort-order="<?php echo $t_route_info_preview->SortField == $t_route_info->load_expenses->Name && $t_route_info_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->load_expenses->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info_preview->SortField == $t_route_info->load_expenses->Name) { ?><?php if ($t_route_info_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->unload_expenses->Visible) { // unload_expenses ?>
	<?php if ($t_route_info->SortUrl($t_route_info->unload_expenses) == "") { ?>
		<th class="<?php echo $t_route_info->unload_expenses->headerCellClass() ?>"><?php echo $t_route_info->unload_expenses->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_route_info->unload_expenses->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_route_info->unload_expenses->Name) ?>" data-sort-order="<?php echo $t_route_info_preview->SortField == $t_route_info->unload_expenses->Name && $t_route_info_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->unload_expenses->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info_preview->SortField == $t_route_info->unload_expenses->Name) { ?><?php if ($t_route_info_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->status->Visible) { // status ?>
	<?php if ($t_route_info->SortUrl($t_route_info->status) == "") { ?>
		<th class="<?php echo $t_route_info->status->headerCellClass() ?>"><?php echo $t_route_info->status->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_route_info->status->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_route_info->status->Name) ?>" data-sort-order="<?php echo $t_route_info_preview->SortField == $t_route_info->status->Name && $t_route_info_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info_preview->SortField == $t_route_info->status->Name) { ?><?php if ($t_route_info_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->operator->Visible) { // operator ?>
	<?php if ($t_route_info->SortUrl($t_route_info->operator) == "") { ?>
		<th class="<?php echo $t_route_info->operator->headerCellClass() ?>"><?php echo $t_route_info->operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_route_info->operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_route_info->operator->Name) ?>" data-sort-order="<?php echo $t_route_info_preview->SortField == $t_route_info->operator->Name && $t_route_info_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info_preview->SortField == $t_route_info->operator->Name) { ?><?php if ($t_route_info_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_route_info->datetime->Visible) { // datetime ?>
	<?php if ($t_route_info->SortUrl($t_route_info->datetime) == "") { ?>
		<th class="<?php echo $t_route_info->datetime->headerCellClass() ?>"><?php echo $t_route_info->datetime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $t_route_info->datetime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($t_route_info->datetime->Name) ?>" data-sort-order="<?php echo $t_route_info_preview->SortField == $t_route_info->datetime->Name && $t_route_info_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_route_info->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_route_info_preview->SortField == $t_route_info->datetime->Name) { ?><?php if ($t_route_info_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_route_info_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_route_info_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$t_route_info_preview->RecCount = 0;
$t_route_info_preview->RowCnt = 0;
while ($t_route_info_preview->Recordset && !$t_route_info_preview->Recordset->EOF) {

	// Init row class and style
	$t_route_info_preview->RecCount++;
	$t_route_info_preview->RowCnt++;
	$t_route_info_preview->CssStyle = "";
	$t_route_info_preview->loadListRowValues($t_route_info_preview->Recordset);

	// Render row
	$t_route_info_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$t_route_info_preview->resetAttributes();
	$t_route_info_preview->renderListRow();

	// Render list options
	$t_route_info_preview->renderListOptions();
?>
	<tr<?php echo $t_route_info_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_route_info_preview->ListOptions->render("body", "left", $t_route_info_preview->RowCnt);
?>
<?php if ($t_route_info->id->Visible) { // id ?>
		<!-- id -->
		<td<?php echo $t_route_info->id->cellAttributes() ?>>
<span<?php echo $t_route_info->id->viewAttributes() ?>>
<?php echo $t_route_info->id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_route_info->route_name->Visible) { // route_name ?>
		<!-- route_name -->
		<td<?php echo $t_route_info->route_name->cellAttributes() ?>>
<span<?php echo $t_route_info->route_name->viewAttributes() ?>>
<?php echo $t_route_info->route_name->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_route_info->load_expenses->Visible) { // load_expenses ?>
		<!-- load_expenses -->
		<td<?php echo $t_route_info->load_expenses->cellAttributes() ?>>
<span<?php echo $t_route_info->load_expenses->viewAttributes() ?>>
<?php echo $t_route_info->load_expenses->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_route_info->unload_expenses->Visible) { // unload_expenses ?>
		<!-- unload_expenses -->
		<td<?php echo $t_route_info->unload_expenses->cellAttributes() ?>>
<span<?php echo $t_route_info->unload_expenses->viewAttributes() ?>>
<?php echo $t_route_info->unload_expenses->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_route_info->status->Visible) { // status ?>
		<!-- status -->
		<td<?php echo $t_route_info->status->cellAttributes() ?>>
<span<?php echo $t_route_info->status->viewAttributes() ?>>
<?php echo $t_route_info->status->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_route_info->operator->Visible) { // operator ?>
		<!-- operator -->
		<td<?php echo $t_route_info->operator->cellAttributes() ?>>
<span<?php echo $t_route_info->operator->viewAttributes() ?>>
<?php echo $t_route_info->operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($t_route_info->datetime->Visible) { // datetime ?>
		<!-- datetime -->
		<td<?php echo $t_route_info->datetime->cellAttributes() ?>>
<span<?php echo $t_route_info->datetime->viewAttributes() ?>>
<?php echo $t_route_info->datetime->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$t_route_info_preview->ListOptions->render("body", "right", $t_route_info_preview->RowCnt);
?>
	</tr>
<?php
	$t_route_info_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($t_route_info_preview->TotalRecs > 0) { ?>
<?php if (!isset($t_route_info_preview->Pager)) $t_route_info_preview->Pager = new PrevNextPager($t_route_info_preview->StartRec, $t_route_info_preview->DisplayRecs, $t_route_info_preview->TotalRecs) ?>
<?php if ($t_route_info_preview->Pager->RecordCount > 0 && $t_route_info_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($t_route_info_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $t_route_info_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($t_route_info_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $t_route_info_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($t_route_info_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $t_route_info_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($t_route_info_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $t_route_info_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $t_route_info_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $t_route_info_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $t_route_info_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($t_route_info_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$t_route_info_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($t_route_info_preview->Recordset)
	$t_route_info_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$t_route_info_preview->terminate();
?>