<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_route_info_search = new t_route_info_search();

// Run the page
$t_route_info_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_route_info_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_route_info_search->IsModal) { ?>
var ft_route_infosearch = currentAdvancedSearchForm = new ew.Form("ft_route_infosearch", "search");
<?php } else { ?>
var ft_route_infosearch = currentForm = new ew.Form("ft_route_infosearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_route_infosearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_route_infosearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_route_infosearch.lists["x_status"] = <?php echo $t_route_info_search->status->Lookup->toClientList() ?>;
ft_route_infosearch.lists["x_status"].options = <?php echo JsonEncode($t_route_info_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

ft_route_infosearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_route_info->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_route_info->km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_days");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_route_info->days->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_load_expenses");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_route_info->load_expenses->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_unload_expenses");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_route_info->unload_expenses->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_route_info->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_route_info_search->showPageHeader(); ?>
<?php
$t_route_info_search->showMessage();
?>
<form name="ft_route_infosearch" id="ft_route_infosearch" class="<?php echo $t_route_info_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_route_info_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_route_info_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_route_info">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_route_info_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_route_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $t_route_info_search->LeftColumnClass ?>"><span id="elh_t_route_info_id"><?php echo $t_route_info->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $t_route_info_search->RightColumnClass ?>"><div<?php echo $t_route_info->id->cellAttributes() ?>>
			<span id="el_t_route_info_id">
<input type="text" data-table="t_route_info" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($t_route_info->id->getPlaceHolder()) ?>" value="<?php echo $t_route_info->id->EditValue ?>"<?php echo $t_route_info->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->route_name->Visible) { // route_name ?>
	<div id="r_route_name" class="form-group row">
		<label for="x_route_name" class="<?php echo $t_route_info_search->LeftColumnClass ?>"><span id="elh_t_route_info_route_name"><?php echo $t_route_info->route_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_route_name" id="z_route_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_route_info_search->RightColumnClass ?>"><div<?php echo $t_route_info->route_name->cellAttributes() ?>>
			<span id="el_t_route_info_route_name">
<input type="text" data-table="t_route_info" data-field="x_route_name" name="x_route_name" id="x_route_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_route_info->route_name->getPlaceHolder()) ?>" value="<?php echo $t_route_info->route_name->EditValue ?>"<?php echo $t_route_info->route_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label for="x_r_from" class="<?php echo $t_route_info_search->LeftColumnClass ?>"><span id="elh_t_route_info_r_from"><?php echo $t_route_info->r_from->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_r_from" id="z_r_from" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_route_info_search->RightColumnClass ?>"><div<?php echo $t_route_info->r_from->cellAttributes() ?>>
			<span id="el_t_route_info_r_from">
<input type="text" data-table="t_route_info" data-field="x_r_from" name="x_r_from" id="x_r_from" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($t_route_info->r_from->getPlaceHolder()) ?>" value="<?php echo $t_route_info->r_from->EditValue ?>"<?php echo $t_route_info->r_from->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->r_to->Visible) { // r_to ?>
	<div id="r_r_to" class="form-group row">
		<label for="x_r_to" class="<?php echo $t_route_info_search->LeftColumnClass ?>"><span id="elh_t_route_info_r_to"><?php echo $t_route_info->r_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_r_to" id="z_r_to" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_route_info_search->RightColumnClass ?>"><div<?php echo $t_route_info->r_to->cellAttributes() ?>>
			<span id="el_t_route_info_r_to">
<input type="text" data-table="t_route_info" data-field="x_r_to" name="x_r_to" id="x_r_to" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($t_route_info->r_to->getPlaceHolder()) ?>" value="<?php echo $t_route_info->r_to->EditValue ?>"<?php echo $t_route_info->r_to->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->km->Visible) { // km ?>
	<div id="r_km" class="form-group row">
		<label for="x_km" class="<?php echo $t_route_info_search->LeftColumnClass ?>"><span id="elh_t_route_info_km"><?php echo $t_route_info->km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_km" id="z_km" value="="></span>
		</label>
		<div class="<?php echo $t_route_info_search->RightColumnClass ?>"><div<?php echo $t_route_info->km->cellAttributes() ?>>
			<span id="el_t_route_info_km">
<input type="text" data-table="t_route_info" data-field="x_km" name="x_km" id="x_km" size="30" placeholder="<?php echo HtmlEncode($t_route_info->km->getPlaceHolder()) ?>" value="<?php echo $t_route_info->km->EditValue ?>"<?php echo $t_route_info->km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->days->Visible) { // days ?>
	<div id="r_days" class="form-group row">
		<label for="x_days" class="<?php echo $t_route_info_search->LeftColumnClass ?>"><span id="elh_t_route_info_days"><?php echo $t_route_info->days->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_days" id="z_days" value="="></span>
		</label>
		<div class="<?php echo $t_route_info_search->RightColumnClass ?>"><div<?php echo $t_route_info->days->cellAttributes() ?>>
			<span id="el_t_route_info_days">
<input type="text" data-table="t_route_info" data-field="x_days" name="x_days" id="x_days" size="30" placeholder="<?php echo HtmlEncode($t_route_info->days->getPlaceHolder()) ?>" value="<?php echo $t_route_info->days->EditValue ?>"<?php echo $t_route_info->days->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->load_expenses->Visible) { // load_expenses ?>
	<div id="r_load_expenses" class="form-group row">
		<label for="x_load_expenses" class="<?php echo $t_route_info_search->LeftColumnClass ?>"><span id="elh_t_route_info_load_expenses"><?php echo $t_route_info->load_expenses->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_load_expenses" id="z_load_expenses" value="="></span>
		</label>
		<div class="<?php echo $t_route_info_search->RightColumnClass ?>"><div<?php echo $t_route_info->load_expenses->cellAttributes() ?>>
			<span id="el_t_route_info_load_expenses">
<input type="text" data-table="t_route_info" data-field="x_load_expenses" name="x_load_expenses" id="x_load_expenses" size="30" placeholder="<?php echo HtmlEncode($t_route_info->load_expenses->getPlaceHolder()) ?>" value="<?php echo $t_route_info->load_expenses->EditValue ?>"<?php echo $t_route_info->load_expenses->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->unload_expenses->Visible) { // unload_expenses ?>
	<div id="r_unload_expenses" class="form-group row">
		<label for="x_unload_expenses" class="<?php echo $t_route_info_search->LeftColumnClass ?>"><span id="elh_t_route_info_unload_expenses"><?php echo $t_route_info->unload_expenses->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unload_expenses" id="z_unload_expenses" value="="></span>
		</label>
		<div class="<?php echo $t_route_info_search->RightColumnClass ?>"><div<?php echo $t_route_info->unload_expenses->cellAttributes() ?>>
			<span id="el_t_route_info_unload_expenses">
<input type="text" data-table="t_route_info" data-field="x_unload_expenses" name="x_unload_expenses" id="x_unload_expenses" size="30" placeholder="<?php echo HtmlEncode($t_route_info->unload_expenses->getPlaceHolder()) ?>" value="<?php echo $t_route_info->unload_expenses->EditValue ?>"<?php echo $t_route_info->unload_expenses->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $t_route_info_search->LeftColumnClass ?>"><span id="elh_t_route_info_status"><?php echo $t_route_info->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $t_route_info_search->RightColumnClass ?>"><div<?php echo $t_route_info->status->cellAttributes() ?>>
			<span id="el_t_route_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_route_info" data-field="x_status" data-value-separator="<?php echo $t_route_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $t_route_info->status->editAttributes() ?>>
		<?php echo $t_route_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_route_info->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $t_route_info_search->LeftColumnClass ?>"><span id="elh_t_route_info_datetime"><?php echo $t_route_info->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $t_route_info_search->RightColumnClass ?>"><div<?php echo $t_route_info->datetime->cellAttributes() ?>>
			<span id="el_t_route_info_datetime">
<input type="text" data-table="t_route_info" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($t_route_info->datetime->getPlaceHolder()) ?>" value="<?php echo $t_route_info->datetime->EditValue ?>"<?php echo $t_route_info->datetime->editAttributes() ?>>
<?php if (!$t_route_info->datetime->ReadOnly && !$t_route_info->datetime->Disabled && !isset($t_route_info->datetime->EditAttrs["readonly"]) && !isset($t_route_info->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_route_infosearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_route_info_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_route_info_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_route_info_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_route_info_search->terminate();
?>