<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_route_info_view = new t_route_info_view();

// Run the page
$t_route_info_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_route_info_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_route_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_route_infoview = currentForm = new ew.Form("ft_route_infoview", "view");

// Form_CustomValidate event
ft_route_infoview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_route_infoview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_route_infoview.lists["x_status"] = <?php echo $t_route_info_view->status->Lookup->toClientList() ?>;
ft_route_infoview.lists["x_status"].options = <?php echo JsonEncode($t_route_info_view->status->options(FALSE, TRUE)) ?>;
ft_route_infoview.lists["x_operator"] = <?php echo $t_route_info_view->operator->Lookup->toClientList() ?>;
ft_route_infoview.lists["x_operator"].options = <?php echo JsonEncode($t_route_info_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_route_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_route_info_view->ExportOptions->render("body") ?>
<?php $t_route_info_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_route_info_view->showPageHeader(); ?>
<?php
$t_route_info_view->showMessage();
?>
<form name="ft_route_infoview" id="ft_route_infoview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_route_info_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_route_info_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_route_info">
<input type="hidden" name="modal" value="<?php echo (int)$t_route_info_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_route_info->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_route_info_view->TableLeftColumnClass ?>"><span id="elh_t_route_info_id"><?php echo $t_route_info->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_route_info->id->cellAttributes() ?>>
<span id="el_t_route_info_id">
<span<?php echo $t_route_info->id->viewAttributes() ?>>
<?php echo $t_route_info->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_route_info->route_name->Visible) { // route_name ?>
	<tr id="r_route_name">
		<td class="<?php echo $t_route_info_view->TableLeftColumnClass ?>"><span id="elh_t_route_info_route_name"><?php echo $t_route_info->route_name->caption() ?></span></td>
		<td data-name="route_name"<?php echo $t_route_info->route_name->cellAttributes() ?>>
<span id="el_t_route_info_route_name">
<span<?php echo $t_route_info->route_name->viewAttributes() ?>>
<?php echo $t_route_info->route_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_route_info->r_from->Visible) { // r_from ?>
	<tr id="r_r_from">
		<td class="<?php echo $t_route_info_view->TableLeftColumnClass ?>"><span id="elh_t_route_info_r_from"><?php echo $t_route_info->r_from->caption() ?></span></td>
		<td data-name="r_from"<?php echo $t_route_info->r_from->cellAttributes() ?>>
<span id="el_t_route_info_r_from">
<span<?php echo $t_route_info->r_from->viewAttributes() ?>>
<?php echo $t_route_info->r_from->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_route_info->r_to->Visible) { // r_to ?>
	<tr id="r_r_to">
		<td class="<?php echo $t_route_info_view->TableLeftColumnClass ?>"><span id="elh_t_route_info_r_to"><?php echo $t_route_info->r_to->caption() ?></span></td>
		<td data-name="r_to"<?php echo $t_route_info->r_to->cellAttributes() ?>>
<span id="el_t_route_info_r_to">
<span<?php echo $t_route_info->r_to->viewAttributes() ?>>
<?php echo $t_route_info->r_to->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_route_info->km->Visible) { // km ?>
	<tr id="r_km">
		<td class="<?php echo $t_route_info_view->TableLeftColumnClass ?>"><span id="elh_t_route_info_km"><?php echo $t_route_info->km->caption() ?></span></td>
		<td data-name="km"<?php echo $t_route_info->km->cellAttributes() ?>>
<span id="el_t_route_info_km">
<span<?php echo $t_route_info->km->viewAttributes() ?>>
<?php echo $t_route_info->km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_route_info->days->Visible) { // days ?>
	<tr id="r_days">
		<td class="<?php echo $t_route_info_view->TableLeftColumnClass ?>"><span id="elh_t_route_info_days"><?php echo $t_route_info->days->caption() ?></span></td>
		<td data-name="days"<?php echo $t_route_info->days->cellAttributes() ?>>
<span id="el_t_route_info_days">
<span<?php echo $t_route_info->days->viewAttributes() ?>>
<?php echo $t_route_info->days->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_route_info->load_expenses->Visible) { // load_expenses ?>
	<tr id="r_load_expenses">
		<td class="<?php echo $t_route_info_view->TableLeftColumnClass ?>"><span id="elh_t_route_info_load_expenses"><?php echo $t_route_info->load_expenses->caption() ?></span></td>
		<td data-name="load_expenses"<?php echo $t_route_info->load_expenses->cellAttributes() ?>>
<span id="el_t_route_info_load_expenses">
<span<?php echo $t_route_info->load_expenses->viewAttributes() ?>>
<?php echo $t_route_info->load_expenses->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_route_info->unload_expenses->Visible) { // unload_expenses ?>
	<tr id="r_unload_expenses">
		<td class="<?php echo $t_route_info_view->TableLeftColumnClass ?>"><span id="elh_t_route_info_unload_expenses"><?php echo $t_route_info->unload_expenses->caption() ?></span></td>
		<td data-name="unload_expenses"<?php echo $t_route_info->unload_expenses->cellAttributes() ?>>
<span id="el_t_route_info_unload_expenses">
<span<?php echo $t_route_info->unload_expenses->viewAttributes() ?>>
<?php echo $t_route_info->unload_expenses->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_route_info->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $t_route_info_view->TableLeftColumnClass ?>"><span id="elh_t_route_info_status"><?php echo $t_route_info->status->caption() ?></span></td>
		<td data-name="status"<?php echo $t_route_info->status->cellAttributes() ?>>
<span id="el_t_route_info_status">
<span<?php echo $t_route_info->status->viewAttributes() ?>>
<?php echo $t_route_info->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_route_info->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_route_info_view->TableLeftColumnClass ?>"><span id="elh_t_route_info_operator"><?php echo $t_route_info->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_route_info->operator->cellAttributes() ?>>
<span id="el_t_route_info_operator">
<span<?php echo $t_route_info->operator->viewAttributes() ?>>
<?php echo $t_route_info->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_route_info->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_route_info_view->TableLeftColumnClass ?>"><span id="elh_t_route_info_datetime"><?php echo $t_route_info->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_route_info->datetime->cellAttributes() ?>>
<span id="el_t_route_info_datetime">
<span<?php echo $t_route_info->datetime->viewAttributes() ?>>
<?php echo $t_route_info->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_route_info_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_route_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_route_info_view->terminate();
?>