<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_balance_list = new t_trip_balance_list();

// Run the page
$t_trip_balance_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_balance_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_trip_balance->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_trip_balancelist = currentForm = new ew.Form("ft_trip_balancelist", "list");
ft_trip_balancelist.formKeyCountName = '<?php echo $t_trip_balance_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_trip_balancelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_balancelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_balancelist.lists["x_trip"] = <?php echo $t_trip_balance_list->trip->Lookup->toClientList() ?>;
ft_trip_balancelist.lists["x_trip"].options = <?php echo JsonEncode($t_trip_balance_list->trip->lookupOptions()) ?>;
ft_trip_balancelist.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var ft_trip_balancelistsrch = currentSearchForm = new ew.Form("ft_trip_balancelistsrch");

// Validate function for search
ft_trip_balancelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_balance->Balance->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
ft_trip_balancelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_balancelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

ft_trip_balancelistsrch.filterList = <?php echo $t_trip_balance_list->getFilterList() ?>;

// Init search panel as collapsed
ft_trip_balancelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_trip_balance->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_trip_balance_list->TotalRecs > 0 && $t_trip_balance_list->ExportOptions->visible()) { ?>
<?php $t_trip_balance_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_balance_list->ImportOptions->visible()) { ?>
<?php $t_trip_balance_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_balance_list->SearchOptions->visible()) { ?>
<?php $t_trip_balance_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_balance_list->FilterOptions->visible()) { ?>
<?php $t_trip_balance_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_trip_balance_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_trip_balance->isExport() && !$t_trip_balance->CurrentAction) { ?>
<form name="ft_trip_balancelistsrch" id="ft_trip_balancelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_trip_balance_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_trip_balancelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_trip_balance">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$t_trip_balance_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$t_trip_balance->RowType = ROWTYPE_SEARCH;

// Render row
$t_trip_balance->resetAttributes();
$t_trip_balance_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($t_trip_balance->name->Visible) { // name ?>
	<div id="xsc_name" class="ew-cell form-group">
		<label for="x_name" class="ew-search-caption ew-label"><?php echo $t_trip_balance->name->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="t_trip_balance" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="105" placeholder="<?php echo HtmlEncode($t_trip_balance->name->getPlaceHolder()) ?>" value="<?php echo $t_trip_balance->name->EditValue ?>"<?php echo $t_trip_balance->name->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($t_trip_balance->Balance->Visible) { // Balance ?>
	<div id="xsc_Balance" class="ew-cell form-group">
		<label for="x_Balance" class="ew-search-caption ew-label"><?php echo $t_trip_balance->Balance->caption() ?></label>
		<span class="ew-search-operator"><select name="z_Balance" id="z_Balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="t_trip_balance" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($t_trip_balance->Balance->getPlaceHolder()) ?>" value="<?php echo $t_trip_balance->Balance->EditValue ?>"<?php echo $t_trip_balance->Balance->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_Balance style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_Balance style="d-none"">
<input type="text" data-table="t_trip_balance" data-field="x_Balance" name="y_Balance" id="y_Balance" size="30" placeholder="<?php echo HtmlEncode($t_trip_balance->Balance->getPlaceHolder()) ?>" value="<?php echo $t_trip_balance->Balance->EditValue2 ?>"<?php echo $t_trip_balance->Balance->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_trip_balance_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_trip_balance_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_trip_balance_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_trip_balance_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_trip_balance_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_trip_balance_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_trip_balance_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_trip_balance_list->showPageHeader(); ?>
<?php
$t_trip_balance_list->showMessage();
?>
<?php if ($t_trip_balance_list->TotalRecs > 0 || $t_trip_balance->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_trip_balance_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_trip_balance">
<?php if (!$t_trip_balance->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_trip_balance->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_trip_balance_list->Pager)) $t_trip_balance_list->Pager = new PrevNextPager($t_trip_balance_list->StartRec, $t_trip_balance_list->DisplayRecs, $t_trip_balance_list->TotalRecs, $t_trip_balance_list->AutoHidePager) ?>
<?php if ($t_trip_balance_list->Pager->RecordCount > 0 && $t_trip_balance_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_trip_balance_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_trip_balance_list->pageUrl() ?>start=<?php echo $t_trip_balance_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_trip_balance_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_trip_balance_list->pageUrl() ?>start=<?php echo $t_trip_balance_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_trip_balance_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_trip_balance_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_trip_balance_list->pageUrl() ?>start=<?php echo $t_trip_balance_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_trip_balance_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_trip_balance_list->pageUrl() ?>start=<?php echo $t_trip_balance_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_trip_balance_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_trip_balance_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_trip_balance_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_trip_balance_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_trip_balance_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_trip_balance_list->TotalRecs > 0 && (!$t_trip_balance_list->AutoHidePageSizeSelector || $t_trip_balance_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_trip_balance">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_trip_balance_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_trip_balance_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_trip_balance_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_trip_balance_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_trip_balance_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_trip_balance->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_trip_balance_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_trip_balancelist" id="ft_trip_balancelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_balance_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_balance_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_balance">
<div id="gmp_t_trip_balance" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_trip_balance_list->TotalRecs > 0 || $t_trip_balance->isGridEdit()) { ?>
<table id="tbl_t_trip_balancelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_trip_balance_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_trip_balance_list->renderListOptions();

// Render list options (header, left)
$t_trip_balance_list->ListOptions->render("header", "left");
?>
<?php if ($t_trip_balance->trip->Visible) { // trip ?>
	<?php if ($t_trip_balance->sortUrl($t_trip_balance->trip) == "") { ?>
		<th data-name="trip" class="<?php echo $t_trip_balance->trip->headerCellClass() ?>"><div id="elh_t_trip_balance_trip" class="t_trip_balance_trip"><div class="ew-table-header-caption"><?php echo $t_trip_balance->trip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="trip" class="<?php echo $t_trip_balance->trip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_balance->SortUrl($t_trip_balance->trip) ?>',2);"><div id="elh_t_trip_balance_trip" class="t_trip_balance_trip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_balance->trip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_balance->trip->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_balance->trip->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_balance->name->Visible) { // name ?>
	<?php if ($t_trip_balance->sortUrl($t_trip_balance->name) == "") { ?>
		<th data-name="name" class="<?php echo $t_trip_balance->name->headerCellClass() ?>"><div id="elh_t_trip_balance_name" class="t_trip_balance_name"><div class="ew-table-header-caption"><?php echo $t_trip_balance->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $t_trip_balance->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_balance->SortUrl($t_trip_balance->name) ?>',2);"><div id="elh_t_trip_balance_name" class="t_trip_balance_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_balance->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_balance->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_balance->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_balance->Balance->Visible) { // Balance ?>
	<?php if ($t_trip_balance->sortUrl($t_trip_balance->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $t_trip_balance->Balance->headerCellClass() ?>"><div id="elh_t_trip_balance_Balance" class="t_trip_balance_Balance"><div class="ew-table-header-caption"><?php echo $t_trip_balance->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $t_trip_balance->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_balance->SortUrl($t_trip_balance->Balance) ?>',2);"><div id="elh_t_trip_balance_Balance" class="t_trip_balance_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_balance->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_balance->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_balance->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_trip_balance_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_trip_balance->ExportAll && $t_trip_balance->isExport()) {
	$t_trip_balance_list->StopRec = $t_trip_balance_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_trip_balance_list->TotalRecs > $t_trip_balance_list->StartRec + $t_trip_balance_list->DisplayRecs - 1)
		$t_trip_balance_list->StopRec = $t_trip_balance_list->StartRec + $t_trip_balance_list->DisplayRecs - 1;
	else
		$t_trip_balance_list->StopRec = $t_trip_balance_list->TotalRecs;
}
$t_trip_balance_list->RecCnt = $t_trip_balance_list->StartRec - 1;
if ($t_trip_balance_list->Recordset && !$t_trip_balance_list->Recordset->EOF) {
	$t_trip_balance_list->Recordset->moveFirst();
	$selectLimit = $t_trip_balance_list->UseSelectLimit;
	if (!$selectLimit && $t_trip_balance_list->StartRec > 1)
		$t_trip_balance_list->Recordset->move($t_trip_balance_list->StartRec - 1);
} elseif (!$t_trip_balance->AllowAddDeleteRow && $t_trip_balance_list->StopRec == 0) {
	$t_trip_balance_list->StopRec = $t_trip_balance->GridAddRowCount;
}

// Initialize aggregate
$t_trip_balance->RowType = ROWTYPE_AGGREGATEINIT;
$t_trip_balance->resetAttributes();
$t_trip_balance_list->renderRow();
while ($t_trip_balance_list->RecCnt < $t_trip_balance_list->StopRec) {
	$t_trip_balance_list->RecCnt++;
	if ($t_trip_balance_list->RecCnt >= $t_trip_balance_list->StartRec) {
		$t_trip_balance_list->RowCnt++;

		// Set up key count
		$t_trip_balance_list->KeyCount = $t_trip_balance_list->RowIndex;

		// Init row class and style
		$t_trip_balance->resetAttributes();
		$t_trip_balance->CssClass = "";
		if ($t_trip_balance->isGridAdd()) {
		} else {
			$t_trip_balance_list->loadRowValues($t_trip_balance_list->Recordset); // Load row values
		}
		$t_trip_balance->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_trip_balance->RowAttrs = array_merge($t_trip_balance->RowAttrs, array('data-rowindex'=>$t_trip_balance_list->RowCnt, 'id'=>'r' . $t_trip_balance_list->RowCnt . '_t_trip_balance', 'data-rowtype'=>$t_trip_balance->RowType));

		// Render row
		$t_trip_balance_list->renderRow();

		// Render list options
		$t_trip_balance_list->renderListOptions();
?>
	<tr<?php echo $t_trip_balance->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_trip_balance_list->ListOptions->render("body", "left", $t_trip_balance_list->RowCnt);
?>
	<?php if ($t_trip_balance->trip->Visible) { // trip ?>
		<td data-name="trip"<?php echo $t_trip_balance->trip->cellAttributes() ?>>
<span id="el<?php echo $t_trip_balance_list->RowCnt ?>_t_trip_balance_trip" class="t_trip_balance_trip">
<span<?php echo $t_trip_balance->trip->viewAttributes() ?>>
<?php if ((!EmptyString($t_trip_balance->trip->getViewValue())) && $t_trip_balance->trip->linkAttributes() <> "") { ?>
<a<?php echo $t_trip_balance->trip->linkAttributes() ?>><?php echo $t_trip_balance->trip->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_trip_balance->trip->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_balance->name->Visible) { // name ?>
		<td data-name="name"<?php echo $t_trip_balance->name->cellAttributes() ?>>
<span id="el<?php echo $t_trip_balance_list->RowCnt ?>_t_trip_balance_name" class="t_trip_balance_name">
<span<?php echo $t_trip_balance->name->viewAttributes() ?>>
<?php if ((!EmptyString($t_trip_balance->name->getViewValue())) && $t_trip_balance->name->linkAttributes() <> "") { ?>
<a<?php echo $t_trip_balance->name->linkAttributes() ?>><?php echo $t_trip_balance->name->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_trip_balance->name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_balance->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $t_trip_balance->Balance->cellAttributes() ?>>
<span id="el<?php echo $t_trip_balance_list->RowCnt ?>_t_trip_balance_Balance" class="t_trip_balance_Balance">
<span<?php echo $t_trip_balance->Balance->viewAttributes() ?>>
<?php echo $t_trip_balance->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_trip_balance_list->ListOptions->render("body", "right", $t_trip_balance_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_trip_balance->isGridAdd())
		$t_trip_balance_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_trip_balance->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_trip_balance_list->Recordset)
	$t_trip_balance_list->Recordset->Close();
?>
<?php if (!$t_trip_balance->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_trip_balance->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_trip_balance_list->Pager)) $t_trip_balance_list->Pager = new PrevNextPager($t_trip_balance_list->StartRec, $t_trip_balance_list->DisplayRecs, $t_trip_balance_list->TotalRecs, $t_trip_balance_list->AutoHidePager) ?>
<?php if ($t_trip_balance_list->Pager->RecordCount > 0 && $t_trip_balance_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_trip_balance_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_trip_balance_list->pageUrl() ?>start=<?php echo $t_trip_balance_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_trip_balance_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_trip_balance_list->pageUrl() ?>start=<?php echo $t_trip_balance_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_trip_balance_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_trip_balance_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_trip_balance_list->pageUrl() ?>start=<?php echo $t_trip_balance_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_trip_balance_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_trip_balance_list->pageUrl() ?>start=<?php echo $t_trip_balance_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_trip_balance_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_trip_balance_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_trip_balance_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_trip_balance_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_trip_balance_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_trip_balance_list->TotalRecs > 0 && (!$t_trip_balance_list->AutoHidePageSizeSelector || $t_trip_balance_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_trip_balance">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_trip_balance_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_trip_balance_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_trip_balance_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_trip_balance_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_trip_balance_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_trip_balance->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_trip_balance_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_trip_balance_list->TotalRecs == 0 && !$t_trip_balance->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_trip_balance_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_trip_balance_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_trip_balance->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_trip_balance->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_trip_balance", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_trip_balance_list->terminate();
?>