<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_balance_search = new t_trip_balance_search();

// Run the page
$t_trip_balance_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_balance_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_trip_balance_search->IsModal) { ?>
var ft_trip_balancesearch = currentAdvancedSearchForm = new ew.Form("ft_trip_balancesearch", "search");
<?php } else { ?>
var ft_trip_balancesearch = currentForm = new ew.Form("ft_trip_balancesearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_trip_balancesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_balancesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_balancesearch.lists["x_trip"] = <?php echo $t_trip_balance_search->trip->Lookup->toClientList() ?>;
ft_trip_balancesearch.lists["x_trip"].options = <?php echo JsonEncode($t_trip_balance_search->trip->lookupOptions()) ?>;
ft_trip_balancesearch.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

ft_trip_balancesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_balance->Balance->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_trip_balance_search->showPageHeader(); ?>
<?php
$t_trip_balance_search->showMessage();
?>
<form name="ft_trip_balancesearch" id="ft_trip_balancesearch" class="<?php echo $t_trip_balance_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_balance_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_balance_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_balance">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_trip_balance_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_balance->trip->Visible) { // trip ?>
	<div id="r_trip" class="form-group row">
		<label class="<?php echo $t_trip_balance_search->LeftColumnClass ?>"><span id="elh_t_trip_balance_trip"><?php echo $t_trip_balance->trip->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_trip" id="z_trip" value="="></span>
		</label>
		<div class="<?php echo $t_trip_balance_search->RightColumnClass ?>"><div<?php echo $t_trip_balance->trip->cellAttributes() ?>>
			<span id="el_t_trip_balance_trip">
<?php
$wrkonchange = "" . trim(@$t_trip_balance->trip->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_balance->trip->EditAttrs["onchange"] = "";
?>
<span id="as_x_trip" class="text-nowrap" style="z-index: 8990">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_trip" id="sv_x_trip" value="<?php echo RemoveHtml($t_trip_balance->trip->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_balance->trip->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_balance->trip->getPlaceHolder()) ?>"<?php echo $t_trip_balance->trip->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_balance->trip->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_trip',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_balance->trip->ReadOnly || $t_trip_balance->trip->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_balance" data-field="x_trip" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_balance->trip->displayValueSeparatorAttribute() ?>" name="x_trip" id="x_trip" value="<?php echo HtmlEncode($t_trip_balance->trip->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_balancesearch.createAutoSuggest({"id":"x_trip","forceSelect":false});
</script>
<?php echo $t_trip_balance->trip->Lookup->getParamTag("p_x_trip") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_balance->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $t_trip_balance_search->LeftColumnClass ?>"><span id="elh_t_trip_balance_name"><?php echo $t_trip_balance->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_balance_search->RightColumnClass ?>"><div<?php echo $t_trip_balance->name->cellAttributes() ?>>
			<span id="el_t_trip_balance_name">
<input type="text" data-table="t_trip_balance" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="105" placeholder="<?php echo HtmlEncode($t_trip_balance->name->getPlaceHolder()) ?>" value="<?php echo $t_trip_balance->name->EditValue ?>"<?php echo $t_trip_balance->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_balance->Balance->Visible) { // Balance ?>
	<div id="r_Balance" class="form-group row">
		<label for="x_Balance" class="<?php echo $t_trip_balance_search->LeftColumnClass ?>"><span id="elh_t_trip_balance_Balance"><?php echo $t_trip_balance->Balance->caption() ?></span>
		</label>
		<div class="<?php echo $t_trip_balance_search->RightColumnClass ?>"><div<?php echo $t_trip_balance->Balance->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_Balance" id="z_Balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_balance->Balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_trip_balance_Balance">
<input type="text" data-table="t_trip_balance" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($t_trip_balance->Balance->getPlaceHolder()) ?>" value="<?php echo $t_trip_balance->Balance->EditValue ?>"<?php echo $t_trip_balance->Balance->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_Balance d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_trip_balance_Balance" class="btw1_Balance d-none">
<input type="text" data-table="t_trip_balance" data-field="x_Balance" name="y_Balance" id="y_Balance" size="30" placeholder="<?php echo HtmlEncode($t_trip_balance->Balance->getPlaceHolder()) ?>" value="<?php echo $t_trip_balance->Balance->EditValue2 ?>"<?php echo $t_trip_balance->Balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_balance->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label for="x_url" class="<?php echo $t_trip_balance_search->LeftColumnClass ?>"><span id="elh_t_trip_balance_url"><?php echo $t_trip_balance->url->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_url" id="z_url" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_balance_search->RightColumnClass ?>"><div<?php echo $t_trip_balance->url->cellAttributes() ?>>
			<span id="el_t_trip_balance_url">
<input type="text" data-table="t_trip_balance" data-field="x_url" name="x_url" id="x_url" size="35" maxlength="161" placeholder="<?php echo HtmlEncode($t_trip_balance->url->getPlaceHolder()) ?>" value="<?php echo $t_trip_balance->url->EditValue ?>"<?php echo $t_trip_balance->url->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_trip_balance_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_trip_balance_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_trip_balance_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_trip_balance_search->terminate();
?>