<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_buyer_list = new t_trip_buyer_list();

// Run the page
$t_trip_buyer_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_buyer_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_trip_buyer->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_trip_buyerlist = currentForm = new ew.Form("ft_trip_buyerlist", "list");
ft_trip_buyerlist.formKeyCountName = '<?php echo $t_trip_buyer_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_trip_buyerlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_buyerlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_buyerlist.lists["x_buyer"] = <?php echo $t_trip_buyer_list->buyer->Lookup->toClientList() ?>;
ft_trip_buyerlist.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_buyer_list->buyer->lookupOptions()) ?>;
ft_trip_buyerlist.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var ft_trip_buyerlistsrch = currentSearchForm = new ew.Form("ft_trip_buyerlistsrch");

// Validate function for search
ft_trip_buyerlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_buyer");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_buyer->buyer->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_invoice_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_buyer->invoice_date->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
ft_trip_buyerlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_buyerlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_buyerlistsrch.lists["x_buyer"] = <?php echo $t_trip_buyer_list->buyer->Lookup->toClientList() ?>;
ft_trip_buyerlistsrch.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_buyer_list->buyer->lookupOptions()) ?>;
ft_trip_buyerlistsrch.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
ft_trip_buyerlistsrch.filterList = <?php echo $t_trip_buyer_list->getFilterList() ?>;

// Init search panel as collapsed
ft_trip_buyerlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_trip_buyer->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_trip_buyer_list->TotalRecs > 0 && $t_trip_buyer_list->ExportOptions->visible()) { ?>
<?php $t_trip_buyer_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_buyer_list->ImportOptions->visible()) { ?>
<?php $t_trip_buyer_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_buyer_list->SearchOptions->visible()) { ?>
<?php $t_trip_buyer_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_buyer_list->FilterOptions->visible()) { ?>
<?php $t_trip_buyer_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_trip_buyer_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_trip_buyer->isExport() && !$t_trip_buyer->CurrentAction) { ?>
<form name="ft_trip_buyerlistsrch" id="ft_trip_buyerlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_trip_buyer_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_trip_buyerlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_trip_buyer">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$t_trip_buyer_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$t_trip_buyer->RowType = ROWTYPE_SEARCH;

// Render row
$t_trip_buyer->resetAttributes();
$t_trip_buyer_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($t_trip_buyer->buyer->Visible) { // buyer ?>
	<div id="xsc_buyer" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $t_trip_buyer->buyer->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer" id="z_buyer" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$t_trip_buyer->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_buyer->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($t_trip_buyer->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_buyer->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_buyer->buyer->getPlaceHolder()) ?>"<?php echo $t_trip_buyer->buyer->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_buyer->buyer->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_buyer->buyer->ReadOnly || $t_trip_buyer->buyer->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_buyer" data-field="x_buyer" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_buyer->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($t_trip_buyer->buyer->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_buyerlistsrch.createAutoSuggest({"id":"x_buyer","forceSelect":true});
</script>
<?php echo $t_trip_buyer->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
	</div>
<?php } ?>
<?php if ($t_trip_buyer->invoice_date->Visible) { // invoice_date ?>
	<div id="xsc_invoice_date" class="ew-cell form-group">
		<label for="x_invoice_date" class="ew-search-caption ew-label"><?php echo $t_trip_buyer->invoice_date->caption() ?></label>
		<span class="ew-search-operator"><select name="z_invoice_date" id="z_invoice_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="t_trip_buyer" data-field="x_invoice_date" name="x_invoice_date" id="x_invoice_date" placeholder="<?php echo HtmlEncode($t_trip_buyer->invoice_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_buyer->invoice_date->EditValue ?>"<?php echo $t_trip_buyer->invoice_date->editAttributes() ?>>
<?php if (!$t_trip_buyer->invoice_date->ReadOnly && !$t_trip_buyer->invoice_date->Disabled && !isset($t_trip_buyer->invoice_date->EditAttrs["readonly"]) && !isset($t_trip_buyer->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_buyerlistsrch", "x_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_invoice_date style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_invoice_date style="d-none"">
<input type="text" data-table="t_trip_buyer" data-field="x_invoice_date" name="y_invoice_date" id="y_invoice_date" placeholder="<?php echo HtmlEncode($t_trip_buyer->invoice_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_buyer->invoice_date->EditValue2 ?>"<?php echo $t_trip_buyer->invoice_date->editAttributes() ?>>
<?php if (!$t_trip_buyer->invoice_date->ReadOnly && !$t_trip_buyer->invoice_date->Disabled && !isset($t_trip_buyer->invoice_date->EditAttrs["readonly"]) && !isset($t_trip_buyer->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_buyerlistsrch", "y_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_trip_buyer_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_trip_buyer_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_trip_buyer_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_trip_buyer_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_trip_buyer_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_trip_buyer_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_trip_buyer_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_trip_buyer_list->showPageHeader(); ?>
<?php
$t_trip_buyer_list->showMessage();
?>
<?php if ($t_trip_buyer_list->TotalRecs > 0 || $t_trip_buyer->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_trip_buyer_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_trip_buyer">
<?php if (!$t_trip_buyer->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_trip_buyer->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_trip_buyer_list->Pager)) $t_trip_buyer_list->Pager = new PrevNextPager($t_trip_buyer_list->StartRec, $t_trip_buyer_list->DisplayRecs, $t_trip_buyer_list->TotalRecs, $t_trip_buyer_list->AutoHidePager) ?>
<?php if ($t_trip_buyer_list->Pager->RecordCount > 0 && $t_trip_buyer_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_trip_buyer_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_trip_buyer_list->pageUrl() ?>start=<?php echo $t_trip_buyer_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_trip_buyer_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_trip_buyer_list->pageUrl() ?>start=<?php echo $t_trip_buyer_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_trip_buyer_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_trip_buyer_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_trip_buyer_list->pageUrl() ?>start=<?php echo $t_trip_buyer_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_trip_buyer_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_trip_buyer_list->pageUrl() ?>start=<?php echo $t_trip_buyer_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_trip_buyer_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_trip_buyer_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_trip_buyer_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_trip_buyer_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_trip_buyer_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_trip_buyer_list->TotalRecs > 0 && (!$t_trip_buyer_list->AutoHidePageSizeSelector || $t_trip_buyer_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_trip_buyer">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_trip_buyer_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_trip_buyer_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_trip_buyer_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_trip_buyer_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_trip_buyer_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_trip_buyer->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_trip_buyer_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_trip_buyerlist" id="ft_trip_buyerlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_buyer_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_buyer_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_buyer">
<div id="gmp_t_trip_buyer" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_trip_buyer_list->TotalRecs > 0 || $t_trip_buyer->isGridEdit()) { ?>
<table id="tbl_t_trip_buyerlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_trip_buyer_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_trip_buyer_list->renderListOptions();

// Render list options (header, left)
$t_trip_buyer_list->ListOptions->render("header", "left");
?>
<?php if ($t_trip_buyer->id->Visible) { // id ?>
	<?php if ($t_trip_buyer->sortUrl($t_trip_buyer->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_trip_buyer->id->headerCellClass() ?>"><div id="elh_t_trip_buyer_id" class="t_trip_buyer_id"><div class="ew-table-header-caption"><?php echo $t_trip_buyer->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_trip_buyer->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_buyer->SortUrl($t_trip_buyer->id) ?>',2);"><div id="elh_t_trip_buyer_id" class="t_trip_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_buyer->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_buyer->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_buyer->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_buyer->route_name->Visible) { // route_name ?>
	<?php if ($t_trip_buyer->sortUrl($t_trip_buyer->route_name) == "") { ?>
		<th data-name="route_name" class="<?php echo $t_trip_buyer->route_name->headerCellClass() ?>"><div id="elh_t_trip_buyer_route_name" class="t_trip_buyer_route_name"><div class="ew-table-header-caption"><?php echo $t_trip_buyer->route_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="route_name" class="<?php echo $t_trip_buyer->route_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_buyer->SortUrl($t_trip_buyer->route_name) ?>',2);"><div id="elh_t_trip_buyer_route_name" class="t_trip_buyer_route_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_buyer->route_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_buyer->route_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_buyer->route_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_buyer->buyer->Visible) { // buyer ?>
	<?php if ($t_trip_buyer->sortUrl($t_trip_buyer->buyer) == "") { ?>
		<th data-name="buyer" class="<?php echo $t_trip_buyer->buyer->headerCellClass() ?>"><div id="elh_t_trip_buyer_buyer" class="t_trip_buyer_buyer"><div class="ew-table-header-caption"><?php echo $t_trip_buyer->buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer" class="<?php echo $t_trip_buyer->buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_buyer->SortUrl($t_trip_buyer->buyer) ?>',2);"><div id="elh_t_trip_buyer_buyer" class="t_trip_buyer_buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_buyer->buyer->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_buyer->buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_buyer->buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_buyer->delivery_receipt->Visible) { // delivery_receipt ?>
	<?php if ($t_trip_buyer->sortUrl($t_trip_buyer->delivery_receipt) == "") { ?>
		<th data-name="delivery_receipt" class="<?php echo $t_trip_buyer->delivery_receipt->headerCellClass() ?>"><div id="elh_t_trip_buyer_delivery_receipt" class="t_trip_buyer_delivery_receipt"><div class="ew-table-header-caption"><?php echo $t_trip_buyer->delivery_receipt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_receipt" class="<?php echo $t_trip_buyer->delivery_receipt->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_buyer->SortUrl($t_trip_buyer->delivery_receipt) ?>',2);"><div id="elh_t_trip_buyer_delivery_receipt" class="t_trip_buyer_delivery_receipt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_buyer->delivery_receipt->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_buyer->delivery_receipt->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_buyer->delivery_receipt->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_buyer->delivery_docket->Visible) { // delivery_docket ?>
	<?php if ($t_trip_buyer->sortUrl($t_trip_buyer->delivery_docket) == "") { ?>
		<th data-name="delivery_docket" class="<?php echo $t_trip_buyer->delivery_docket->headerCellClass() ?>"><div id="elh_t_trip_buyer_delivery_docket" class="t_trip_buyer_delivery_docket"><div class="ew-table-header-caption"><?php echo $t_trip_buyer->delivery_docket->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_docket" class="<?php echo $t_trip_buyer->delivery_docket->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_buyer->SortUrl($t_trip_buyer->delivery_docket) ?>',2);"><div id="elh_t_trip_buyer_delivery_docket" class="t_trip_buyer_delivery_docket">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_buyer->delivery_docket->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_buyer->delivery_docket->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_buyer->delivery_docket->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_buyer->invoice_no->Visible) { // invoice_no ?>
	<?php if ($t_trip_buyer->sortUrl($t_trip_buyer->invoice_no) == "") { ?>
		<th data-name="invoice_no" class="<?php echo $t_trip_buyer->invoice_no->headerCellClass() ?>"><div id="elh_t_trip_buyer_invoice_no" class="t_trip_buyer_invoice_no"><div class="ew-table-header-caption"><?php echo $t_trip_buyer->invoice_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_no" class="<?php echo $t_trip_buyer->invoice_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_buyer->SortUrl($t_trip_buyer->invoice_no) ?>',2);"><div id="elh_t_trip_buyer_invoice_no" class="t_trip_buyer_invoice_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_buyer->invoice_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_buyer->invoice_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_buyer->invoice_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_buyer->invoice_date->Visible) { // invoice_date ?>
	<?php if ($t_trip_buyer->sortUrl($t_trip_buyer->invoice_date) == "") { ?>
		<th data-name="invoice_date" class="<?php echo $t_trip_buyer->invoice_date->headerCellClass() ?>"><div id="elh_t_trip_buyer_invoice_date" class="t_trip_buyer_invoice_date"><div class="ew-table-header-caption"><?php echo $t_trip_buyer->invoice_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_date" class="<?php echo $t_trip_buyer->invoice_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_buyer->SortUrl($t_trip_buyer->invoice_date) ?>',2);"><div id="elh_t_trip_buyer_invoice_date" class="t_trip_buyer_invoice_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_buyer->invoice_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_buyer->invoice_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_buyer->invoice_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_trip_buyer_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_trip_buyer->ExportAll && $t_trip_buyer->isExport()) {
	$t_trip_buyer_list->StopRec = $t_trip_buyer_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_trip_buyer_list->TotalRecs > $t_trip_buyer_list->StartRec + $t_trip_buyer_list->DisplayRecs - 1)
		$t_trip_buyer_list->StopRec = $t_trip_buyer_list->StartRec + $t_trip_buyer_list->DisplayRecs - 1;
	else
		$t_trip_buyer_list->StopRec = $t_trip_buyer_list->TotalRecs;
}
$t_trip_buyer_list->RecCnt = $t_trip_buyer_list->StartRec - 1;
if ($t_trip_buyer_list->Recordset && !$t_trip_buyer_list->Recordset->EOF) {
	$t_trip_buyer_list->Recordset->moveFirst();
	$selectLimit = $t_trip_buyer_list->UseSelectLimit;
	if (!$selectLimit && $t_trip_buyer_list->StartRec > 1)
		$t_trip_buyer_list->Recordset->move($t_trip_buyer_list->StartRec - 1);
} elseif (!$t_trip_buyer->AllowAddDeleteRow && $t_trip_buyer_list->StopRec == 0) {
	$t_trip_buyer_list->StopRec = $t_trip_buyer->GridAddRowCount;
}

// Initialize aggregate
$t_trip_buyer->RowType = ROWTYPE_AGGREGATEINIT;
$t_trip_buyer->resetAttributes();
$t_trip_buyer_list->renderRow();
while ($t_trip_buyer_list->RecCnt < $t_trip_buyer_list->StopRec) {
	$t_trip_buyer_list->RecCnt++;
	if ($t_trip_buyer_list->RecCnt >= $t_trip_buyer_list->StartRec) {
		$t_trip_buyer_list->RowCnt++;

		// Set up key count
		$t_trip_buyer_list->KeyCount = $t_trip_buyer_list->RowIndex;

		// Init row class and style
		$t_trip_buyer->resetAttributes();
		$t_trip_buyer->CssClass = "";
		if ($t_trip_buyer->isGridAdd()) {
		} else {
			$t_trip_buyer_list->loadRowValues($t_trip_buyer_list->Recordset); // Load row values
		}
		$t_trip_buyer->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_trip_buyer->RowAttrs = array_merge($t_trip_buyer->RowAttrs, array('data-rowindex'=>$t_trip_buyer_list->RowCnt, 'id'=>'r' . $t_trip_buyer_list->RowCnt . '_t_trip_buyer', 'data-rowtype'=>$t_trip_buyer->RowType));

		// Render row
		$t_trip_buyer_list->renderRow();

		// Render list options
		$t_trip_buyer_list->renderListOptions();
?>
	<tr<?php echo $t_trip_buyer->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_trip_buyer_list->ListOptions->render("body", "left", $t_trip_buyer_list->RowCnt);
?>
	<?php if ($t_trip_buyer->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_trip_buyer->id->cellAttributes() ?>>
<span id="el<?php echo $t_trip_buyer_list->RowCnt ?>_t_trip_buyer_id" class="t_trip_buyer_id">
<span<?php echo $t_trip_buyer->id->viewAttributes() ?>>
<?php echo $t_trip_buyer->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_buyer->route_name->Visible) { // route_name ?>
		<td data-name="route_name"<?php echo $t_trip_buyer->route_name->cellAttributes() ?>>
<span id="el<?php echo $t_trip_buyer_list->RowCnt ?>_t_trip_buyer_route_name" class="t_trip_buyer_route_name">
<span<?php echo $t_trip_buyer->route_name->viewAttributes() ?>>
<?php echo $t_trip_buyer->route_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_buyer->buyer->Visible) { // buyer ?>
		<td data-name="buyer"<?php echo $t_trip_buyer->buyer->cellAttributes() ?>>
<span id="el<?php echo $t_trip_buyer_list->RowCnt ?>_t_trip_buyer_buyer" class="t_trip_buyer_buyer">
<span<?php echo $t_trip_buyer->buyer->viewAttributes() ?>>
<?php echo $t_trip_buyer->buyer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_buyer->delivery_receipt->Visible) { // delivery_receipt ?>
		<td data-name="delivery_receipt"<?php echo $t_trip_buyer->delivery_receipt->cellAttributes() ?>>
<span id="el<?php echo $t_trip_buyer_list->RowCnt ?>_t_trip_buyer_delivery_receipt" class="t_trip_buyer_delivery_receipt">
<span>
<?php echo GetFileViewTag($t_trip_buyer->delivery_receipt, $t_trip_buyer->delivery_receipt->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_buyer->delivery_docket->Visible) { // delivery_docket ?>
		<td data-name="delivery_docket"<?php echo $t_trip_buyer->delivery_docket->cellAttributes() ?>>
<span id="el<?php echo $t_trip_buyer_list->RowCnt ?>_t_trip_buyer_delivery_docket" class="t_trip_buyer_delivery_docket">
<span<?php echo $t_trip_buyer->delivery_docket->viewAttributes() ?>>
<?php echo $t_trip_buyer->delivery_docket->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_buyer->invoice_no->Visible) { // invoice_no ?>
		<td data-name="invoice_no"<?php echo $t_trip_buyer->invoice_no->cellAttributes() ?>>
<span id="el<?php echo $t_trip_buyer_list->RowCnt ?>_t_trip_buyer_invoice_no" class="t_trip_buyer_invoice_no">
<span<?php echo $t_trip_buyer->invoice_no->viewAttributes() ?>>
<?php echo $t_trip_buyer->invoice_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_buyer->invoice_date->Visible) { // invoice_date ?>
		<td data-name="invoice_date"<?php echo $t_trip_buyer->invoice_date->cellAttributes() ?>>
<span id="el<?php echo $t_trip_buyer_list->RowCnt ?>_t_trip_buyer_invoice_date" class="t_trip_buyer_invoice_date">
<span<?php echo $t_trip_buyer->invoice_date->viewAttributes() ?>>
<?php echo $t_trip_buyer->invoice_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_trip_buyer_list->ListOptions->render("body", "right", $t_trip_buyer_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_trip_buyer->isGridAdd())
		$t_trip_buyer_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_trip_buyer->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_trip_buyer_list->Recordset)
	$t_trip_buyer_list->Recordset->Close();
?>
<?php if (!$t_trip_buyer->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_trip_buyer->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_trip_buyer_list->Pager)) $t_trip_buyer_list->Pager = new PrevNextPager($t_trip_buyer_list->StartRec, $t_trip_buyer_list->DisplayRecs, $t_trip_buyer_list->TotalRecs, $t_trip_buyer_list->AutoHidePager) ?>
<?php if ($t_trip_buyer_list->Pager->RecordCount > 0 && $t_trip_buyer_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_trip_buyer_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_trip_buyer_list->pageUrl() ?>start=<?php echo $t_trip_buyer_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_trip_buyer_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_trip_buyer_list->pageUrl() ?>start=<?php echo $t_trip_buyer_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_trip_buyer_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_trip_buyer_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_trip_buyer_list->pageUrl() ?>start=<?php echo $t_trip_buyer_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_trip_buyer_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_trip_buyer_list->pageUrl() ?>start=<?php echo $t_trip_buyer_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_trip_buyer_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_trip_buyer_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_trip_buyer_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_trip_buyer_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_trip_buyer_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_trip_buyer_list->TotalRecs > 0 && (!$t_trip_buyer_list->AutoHidePageSizeSelector || $t_trip_buyer_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_trip_buyer">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_trip_buyer_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_trip_buyer_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_trip_buyer_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_trip_buyer_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_trip_buyer_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_trip_buyer->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_trip_buyer_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_trip_buyer_list->TotalRecs == 0 && !$t_trip_buyer->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_trip_buyer_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_trip_buyer_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_trip_buyer->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_trip_buyer->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_trip_buyer", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_trip_buyer_list->terminate();
?>