<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_buyer_search = new t_trip_buyer_search();

// Run the page
$t_trip_buyer_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_buyer_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_trip_buyer_search->IsModal) { ?>
var ft_trip_buyersearch = currentAdvancedSearchForm = new ew.Form("ft_trip_buyersearch", "search");
<?php } else { ?>
var ft_trip_buyersearch = currentForm = new ew.Form("ft_trip_buyersearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_trip_buyersearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_buyersearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_buyersearch.lists["x_buyer"] = <?php echo $t_trip_buyer_search->buyer->Lookup->toClientList() ?>;
ft_trip_buyersearch.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_buyer_search->buyer->lookupOptions()) ?>;
ft_trip_buyersearch.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

ft_trip_buyersearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_buyer->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_buyer");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_buyer->buyer->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_invoice_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_buyer->invoice_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_invoice_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_buyer->invoice_date->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_trip_buyer_search->showPageHeader(); ?>
<?php
$t_trip_buyer_search->showMessage();
?>
<form name="ft_trip_buyersearch" id="ft_trip_buyersearch" class="<?php echo $t_trip_buyer_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_buyer_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_buyer_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_buyer">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_trip_buyer_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_buyer->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $t_trip_buyer_search->LeftColumnClass ?>"><span id="elh_t_trip_buyer_id"><?php echo $t_trip_buyer->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $t_trip_buyer_search->RightColumnClass ?>"><div<?php echo $t_trip_buyer->id->cellAttributes() ?>>
			<span id="el_t_trip_buyer_id">
<input type="text" data-table="t_trip_buyer" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($t_trip_buyer->id->getPlaceHolder()) ?>" value="<?php echo $t_trip_buyer->id->EditValue ?>"<?php echo $t_trip_buyer->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_buyer->route_name->Visible) { // route_name ?>
	<div id="r_route_name" class="form-group row">
		<label for="x_route_name" class="<?php echo $t_trip_buyer_search->LeftColumnClass ?>"><span id="elh_t_trip_buyer_route_name"><?php echo $t_trip_buyer->route_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_route_name" id="z_route_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_buyer_search->RightColumnClass ?>"><div<?php echo $t_trip_buyer->route_name->cellAttributes() ?>>
			<span id="el_t_trip_buyer_route_name">
<input type="text" data-table="t_trip_buyer" data-field="x_route_name" name="x_route_name" id="x_route_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_trip_buyer->route_name->getPlaceHolder()) ?>" value="<?php echo $t_trip_buyer->route_name->EditValue ?>"<?php echo $t_trip_buyer->route_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_buyer->buyer->Visible) { // buyer ?>
	<div id="r_buyer" class="form-group row">
		<label class="<?php echo $t_trip_buyer_search->LeftColumnClass ?>"><span id="elh_t_trip_buyer_buyer"><?php echo $t_trip_buyer->buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer" id="z_buyer" value="="></span>
		</label>
		<div class="<?php echo $t_trip_buyer_search->RightColumnClass ?>"><div<?php echo $t_trip_buyer->buyer->cellAttributes() ?>>
			<span id="el_t_trip_buyer_buyer">
<?php
$wrkonchange = "" . trim(@$t_trip_buyer->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_buyer->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($t_trip_buyer->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_buyer->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_buyer->buyer->getPlaceHolder()) ?>"<?php echo $t_trip_buyer->buyer->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_buyer->buyer->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_buyer->buyer->ReadOnly || $t_trip_buyer->buyer->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_buyer" data-field="x_buyer" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_buyer->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($t_trip_buyer->buyer->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_buyersearch.createAutoSuggest({"id":"x_buyer","forceSelect":true});
</script>
<?php echo $t_trip_buyer->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_buyer->delivery_receipt->Visible) { // delivery_receipt ?>
	<div id="r_delivery_receipt" class="form-group row">
		<label class="<?php echo $t_trip_buyer_search->LeftColumnClass ?>"><span id="elh_t_trip_buyer_delivery_receipt"><?php echo $t_trip_buyer->delivery_receipt->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_delivery_receipt" id="z_delivery_receipt" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_buyer_search->RightColumnClass ?>"><div<?php echo $t_trip_buyer->delivery_receipt->cellAttributes() ?>>
			<span id="el_t_trip_buyer_delivery_receipt">
<input type="text" data-table="t_trip_buyer" data-field="x_delivery_receipt" name="x_delivery_receipt" id="x_delivery_receipt" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_trip_buyer->delivery_receipt->getPlaceHolder()) ?>" value="<?php echo $t_trip_buyer->delivery_receipt->EditValue ?>"<?php echo $t_trip_buyer->delivery_receipt->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_buyer->delivery_docket->Visible) { // delivery_docket ?>
	<div id="r_delivery_docket" class="form-group row">
		<label for="x_delivery_docket" class="<?php echo $t_trip_buyer_search->LeftColumnClass ?>"><span id="elh_t_trip_buyer_delivery_docket"><?php echo $t_trip_buyer->delivery_docket->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_delivery_docket" id="z_delivery_docket" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_buyer_search->RightColumnClass ?>"><div<?php echo $t_trip_buyer->delivery_docket->cellAttributes() ?>>
			<span id="el_t_trip_buyer_delivery_docket">
<input type="text" data-table="t_trip_buyer" data-field="x_delivery_docket" name="x_delivery_docket" id="x_delivery_docket" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($t_trip_buyer->delivery_docket->getPlaceHolder()) ?>" value="<?php echo $t_trip_buyer->delivery_docket->EditValue ?>"<?php echo $t_trip_buyer->delivery_docket->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_buyer->invoice_no->Visible) { // invoice_no ?>
	<div id="r_invoice_no" class="form-group row">
		<label for="x_invoice_no" class="<?php echo $t_trip_buyer_search->LeftColumnClass ?>"><span id="elh_t_trip_buyer_invoice_no"><?php echo $t_trip_buyer->invoice_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_invoice_no" id="z_invoice_no" value="="></span>
		</label>
		<div class="<?php echo $t_trip_buyer_search->RightColumnClass ?>"><div<?php echo $t_trip_buyer->invoice_no->cellAttributes() ?>>
			<span id="el_t_trip_buyer_invoice_no">
<input type="text" data-table="t_trip_buyer" data-field="x_invoice_no" name="x_invoice_no" id="x_invoice_no" size="30" placeholder="<?php echo HtmlEncode($t_trip_buyer->invoice_no->getPlaceHolder()) ?>" value="<?php echo $t_trip_buyer->invoice_no->EditValue ?>"<?php echo $t_trip_buyer->invoice_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_buyer->invoice_date->Visible) { // invoice_date ?>
	<div id="r_invoice_date" class="form-group row">
		<label for="x_invoice_date" class="<?php echo $t_trip_buyer_search->LeftColumnClass ?>"><span id="elh_t_trip_buyer_invoice_date"><?php echo $t_trip_buyer->invoice_date->caption() ?></span>
		</label>
		<div class="<?php echo $t_trip_buyer_search->RightColumnClass ?>"><div<?php echo $t_trip_buyer->invoice_date->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_invoice_date" id="z_invoice_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_buyer->invoice_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_trip_buyer_invoice_date">
<input type="text" data-table="t_trip_buyer" data-field="x_invoice_date" name="x_invoice_date" id="x_invoice_date" placeholder="<?php echo HtmlEncode($t_trip_buyer->invoice_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_buyer->invoice_date->EditValue ?>"<?php echo $t_trip_buyer->invoice_date->editAttributes() ?>>
<?php if (!$t_trip_buyer->invoice_date->ReadOnly && !$t_trip_buyer->invoice_date->Disabled && !isset($t_trip_buyer->invoice_date->EditAttrs["readonly"]) && !isset($t_trip_buyer->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_buyersearch", "x_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_invoice_date d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_trip_buyer_invoice_date" class="btw1_invoice_date d-none">
<input type="text" data-table="t_trip_buyer" data-field="x_invoice_date" name="y_invoice_date" id="y_invoice_date" placeholder="<?php echo HtmlEncode($t_trip_buyer->invoice_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_buyer->invoice_date->EditValue2 ?>"<?php echo $t_trip_buyer->invoice_date->editAttributes() ?>>
<?php if (!$t_trip_buyer->invoice_date->ReadOnly && !$t_trip_buyer->invoice_date->Disabled && !isset($t_trip_buyer->invoice_date->EditAttrs["readonly"]) && !isset($t_trip_buyer->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_buyersearch", "y_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_trip_buyer_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_trip_buyer_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_trip_buyer_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_trip_buyer_search->terminate();
?>