<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_buyer_view = new t_trip_buyer_view();

// Run the page
$t_trip_buyer_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_buyer_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_trip_buyer->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_trip_buyerview = currentForm = new ew.Form("ft_trip_buyerview", "view");

// Form_CustomValidate event
ft_trip_buyerview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_buyerview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_buyerview.lists["x_buyer"] = <?php echo $t_trip_buyer_view->buyer->Lookup->toClientList() ?>;
ft_trip_buyerview.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_buyer_view->buyer->lookupOptions()) ?>;
ft_trip_buyerview.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_trip_buyer->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_trip_buyer_view->ExportOptions->render("body") ?>
<?php $t_trip_buyer_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_trip_buyer_view->showPageHeader(); ?>
<?php
$t_trip_buyer_view->showMessage();
?>
<form name="ft_trip_buyerview" id="ft_trip_buyerview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_buyer_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_buyer_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_buyer">
<input type="hidden" name="modal" value="<?php echo (int)$t_trip_buyer_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_trip_buyer->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_trip_buyer_view->TableLeftColumnClass ?>"><span id="elh_t_trip_buyer_id"><?php echo $t_trip_buyer->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_trip_buyer->id->cellAttributes() ?>>
<span id="el_t_trip_buyer_id">
<span<?php echo $t_trip_buyer->id->viewAttributes() ?>>
<?php echo $t_trip_buyer->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_buyer->route_name->Visible) { // route_name ?>
	<tr id="r_route_name">
		<td class="<?php echo $t_trip_buyer_view->TableLeftColumnClass ?>"><span id="elh_t_trip_buyer_route_name"><?php echo $t_trip_buyer->route_name->caption() ?></span></td>
		<td data-name="route_name"<?php echo $t_trip_buyer->route_name->cellAttributes() ?>>
<span id="el_t_trip_buyer_route_name">
<span<?php echo $t_trip_buyer->route_name->viewAttributes() ?>>
<?php echo $t_trip_buyer->route_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_buyer->buyer->Visible) { // buyer ?>
	<tr id="r_buyer">
		<td class="<?php echo $t_trip_buyer_view->TableLeftColumnClass ?>"><span id="elh_t_trip_buyer_buyer"><?php echo $t_trip_buyer->buyer->caption() ?></span></td>
		<td data-name="buyer"<?php echo $t_trip_buyer->buyer->cellAttributes() ?>>
<span id="el_t_trip_buyer_buyer">
<span<?php echo $t_trip_buyer->buyer->viewAttributes() ?>>
<?php echo $t_trip_buyer->buyer->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_buyer->delivery_receipt->Visible) { // delivery_receipt ?>
	<tr id="r_delivery_receipt">
		<td class="<?php echo $t_trip_buyer_view->TableLeftColumnClass ?>"><span id="elh_t_trip_buyer_delivery_receipt"><?php echo $t_trip_buyer->delivery_receipt->caption() ?></span></td>
		<td data-name="delivery_receipt"<?php echo $t_trip_buyer->delivery_receipt->cellAttributes() ?>>
<span id="el_t_trip_buyer_delivery_receipt">
<span>
<?php echo GetFileViewTag($t_trip_buyer->delivery_receipt, $t_trip_buyer->delivery_receipt->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_buyer->delivery_docket->Visible) { // delivery_docket ?>
	<tr id="r_delivery_docket">
		<td class="<?php echo $t_trip_buyer_view->TableLeftColumnClass ?>"><span id="elh_t_trip_buyer_delivery_docket"><?php echo $t_trip_buyer->delivery_docket->caption() ?></span></td>
		<td data-name="delivery_docket"<?php echo $t_trip_buyer->delivery_docket->cellAttributes() ?>>
<span id="el_t_trip_buyer_delivery_docket">
<span<?php echo $t_trip_buyer->delivery_docket->viewAttributes() ?>>
<?php echo $t_trip_buyer->delivery_docket->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_buyer->invoice_no->Visible) { // invoice_no ?>
	<tr id="r_invoice_no">
		<td class="<?php echo $t_trip_buyer_view->TableLeftColumnClass ?>"><span id="elh_t_trip_buyer_invoice_no"><?php echo $t_trip_buyer->invoice_no->caption() ?></span></td>
		<td data-name="invoice_no"<?php echo $t_trip_buyer->invoice_no->cellAttributes() ?>>
<span id="el_t_trip_buyer_invoice_no">
<span<?php echo $t_trip_buyer->invoice_no->viewAttributes() ?>>
<?php echo $t_trip_buyer->invoice_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_buyer->invoice_date->Visible) { // invoice_date ?>
	<tr id="r_invoice_date">
		<td class="<?php echo $t_trip_buyer_view->TableLeftColumnClass ?>"><span id="elh_t_trip_buyer_invoice_date"><?php echo $t_trip_buyer->invoice_date->caption() ?></span></td>
		<td data-name="invoice_date"<?php echo $t_trip_buyer->invoice_date->cellAttributes() ?>>
<span id="el_t_trip_buyer_invoice_date">
<span<?php echo $t_trip_buyer->invoice_date->viewAttributes() ?>>
<?php echo $t_trip_buyer->invoice_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_trip_buyer_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_trip_buyer->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_trip_buyer_view->terminate();
?>