<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_expenses_detailed_search = new t_trip_expenses_detailed_search();

// Run the page
$t_trip_expenses_detailed_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_expenses_detailed_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_trip_expenses_detailed_search->IsModal) { ?>
var ft_trip_expenses_detailedsearch = currentAdvancedSearchForm = new ew.Form("ft_trip_expenses_detailedsearch", "search");
<?php } else { ?>
var ft_trip_expenses_detailedsearch = currentForm = new ew.Form("ft_trip_expenses_detailedsearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_trip_expenses_detailedsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_expenses_detailedsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_expenses_detailedsearch.lists["x_trip"] = <?php echo $t_trip_expenses_detailed_search->trip->Lookup->toClientList() ?>;
ft_trip_expenses_detailedsearch.lists["x_trip"].options = <?php echo JsonEncode($t_trip_expenses_detailed_search->trip->lookupOptions()) ?>;
ft_trip_expenses_detailedsearch.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

ft_trip_expenses_detailedsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_expenses_detailed->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_trip");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_expenses_detailed->trip->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_diesal_by");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_expenses_detailed->diesal_by->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_expenses_detailed->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_OUT");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_expenses_detailed->OUT->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_expenses_detailed->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_trip_expenses_detailed_search->showPageHeader(); ?>
<?php
$t_trip_expenses_detailed_search->showMessage();
?>
<form name="ft_trip_expenses_detailedsearch" id="ft_trip_expenses_detailedsearch" class="<?php echo $t_trip_expenses_detailed_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_expenses_detailed_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_expenses_detailed_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_expenses_detailed">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_trip_expenses_detailed_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_expenses_detailed->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $t_trip_expenses_detailed_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_detailed_id"><?php echo $t_trip_expenses_detailed->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $t_trip_expenses_detailed_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_detailed->id->cellAttributes() ?>>
			<span id="el_t_trip_expenses_detailed_id">
<input type="text" data-table="t_trip_expenses_detailed" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_detailed->id->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_detailed->id->EditValue ?>"<?php echo $t_trip_expenses_detailed->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_detailed->trip->Visible) { // trip ?>
	<div id="r_trip" class="form-group row">
		<label class="<?php echo $t_trip_expenses_detailed_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_detailed_trip"><?php echo $t_trip_expenses_detailed->trip->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_trip" id="z_trip" value="="></span>
		</label>
		<div class="<?php echo $t_trip_expenses_detailed_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_detailed->trip->cellAttributes() ?>>
			<span id="el_t_trip_expenses_detailed_trip">
<?php
$wrkonchange = "" . trim(@$t_trip_expenses_detailed->trip->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_expenses_detailed->trip->EditAttrs["onchange"] = "";
?>
<span id="as_x_trip" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_trip" id="sv_x_trip" value="<?php echo RemoveHtml($t_trip_expenses_detailed->trip->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_detailed->trip->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_expenses_detailed->trip->getPlaceHolder()) ?>"<?php echo $t_trip_expenses_detailed->trip->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_expenses_detailed->trip->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_trip',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_expenses_detailed->trip->ReadOnly || $t_trip_expenses_detailed->trip->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_expenses_detailed" data-field="x_trip" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_expenses_detailed->trip->displayValueSeparatorAttribute() ?>" name="x_trip" id="x_trip" value="<?php echo HtmlEncode($t_trip_expenses_detailed->trip->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_expenses_detailedsearch.createAutoSuggest({"id":"x_trip","forceSelect":true});
</script>
<?php echo $t_trip_expenses_detailed->trip->Lookup->getParamTag("p_x_trip") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_detailed->diesal_by->Visible) { // diesal_by ?>
	<div id="r_diesal_by" class="form-group row">
		<label for="x_diesal_by" class="<?php echo $t_trip_expenses_detailed_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_detailed_diesal_by"><?php echo $t_trip_expenses_detailed->diesal_by->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_diesal_by" id="z_diesal_by" value="="></span>
		</label>
		<div class="<?php echo $t_trip_expenses_detailed_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_detailed->diesal_by->cellAttributes() ?>>
			<span id="el_t_trip_expenses_detailed_diesal_by">
<input type="text" data-table="t_trip_expenses_detailed" data-field="x_diesal_by" name="x_diesal_by" id="x_diesal_by" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_detailed->diesal_by->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_detailed->diesal_by->EditValue ?>"<?php echo $t_trip_expenses_detailed->diesal_by->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_detailed->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $t_trip_expenses_detailed_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_detailed_name"><?php echo $t_trip_expenses_detailed->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_expenses_detailed_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_detailed->name->cellAttributes() ?>>
			<span id="el_t_trip_expenses_detailed_name">
<input type="text" data-table="t_trip_expenses_detailed" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="105" placeholder="<?php echo HtmlEncode($t_trip_expenses_detailed->name->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_detailed->name->EditValue ?>"<?php echo $t_trip_expenses_detailed->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_detailed->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label for="x_ref" class="<?php echo $t_trip_expenses_detailed_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_detailed_ref"><?php echo $t_trip_expenses_detailed->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_expenses_detailed_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_detailed->ref->cellAttributes() ?>>
			<span id="el_t_trip_expenses_detailed_ref">
<input type="text" data-table="t_trip_expenses_detailed" data-field="x_ref" name="x_ref" id="x_ref" size="30" maxlength="105" placeholder="<?php echo HtmlEncode($t_trip_expenses_detailed->ref->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_detailed->ref->EditValue ?>"<?php echo $t_trip_expenses_detailed->ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_detailed->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $t_trip_expenses_detailed_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_detailed_IN"><?php echo $t_trip_expenses_detailed->IN->caption() ?></span>
		</label>
		<div class="<?php echo $t_trip_expenses_detailed_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_detailed->IN->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_IN" id="z_IN" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_expenses_detailed->IN->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_expenses_detailed->IN->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_expenses_detailed->IN->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_expenses_detailed->IN->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_expenses_detailed->IN->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_expenses_detailed->IN->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_expenses_detailed->IN->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_expenses_detailed->IN->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_expenses_detailed->IN->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_trip_expenses_detailed_IN">
<input type="text" data-table="t_trip_expenses_detailed" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_detailed->IN->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_detailed->IN->EditValue ?>"<?php echo $t_trip_expenses_detailed->IN->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_IN d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_trip_expenses_detailed_IN" class="btw1_IN d-none">
<input type="text" data-table="t_trip_expenses_detailed" data-field="x_IN" name="y_IN" id="y_IN" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_detailed->IN->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_detailed->IN->EditValue2 ?>"<?php echo $t_trip_expenses_detailed->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_detailed->OUT->Visible) { // OUT ?>
	<div id="r_OUT" class="form-group row">
		<label for="x_OUT" class="<?php echo $t_trip_expenses_detailed_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_detailed_OUT"><?php echo $t_trip_expenses_detailed->OUT->caption() ?></span>
		</label>
		<div class="<?php echo $t_trip_expenses_detailed_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_detailed->OUT->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_OUT" id="z_OUT" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_expenses_detailed->OUT->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_expenses_detailed->OUT->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_expenses_detailed->OUT->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_expenses_detailed->OUT->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_expenses_detailed->OUT->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_expenses_detailed->OUT->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_expenses_detailed->OUT->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_expenses_detailed->OUT->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_expenses_detailed->OUT->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_trip_expenses_detailed_OUT">
<input type="text" data-table="t_trip_expenses_detailed" data-field="x_OUT" name="x_OUT" id="x_OUT" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_detailed->OUT->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_detailed->OUT->EditValue ?>"<?php echo $t_trip_expenses_detailed->OUT->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_OUT d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_trip_expenses_detailed_OUT" class="btw1_OUT d-none">
<input type="text" data-table="t_trip_expenses_detailed" data-field="x_OUT" name="y_OUT" id="y_OUT" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_detailed->OUT->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_detailed->OUT->EditValue2 ?>"<?php echo $t_trip_expenses_detailed->OUT->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_detailed->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $t_trip_expenses_detailed_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_detailed_dated"><?php echo $t_trip_expenses_detailed->dated->caption() ?></span>
		</label>
		<div class="<?php echo $t_trip_expenses_detailed_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_detailed->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_expenses_detailed->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_expenses_detailed->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_expenses_detailed->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_expenses_detailed->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_expenses_detailed->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_expenses_detailed->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($t_trip_expenses_detailed->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_trip_expenses_detailed_dated">
<input type="text" data-table="t_trip_expenses_detailed" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_trip_expenses_detailed->dated->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_detailed->dated->EditValue ?>"<?php echo $t_trip_expenses_detailed->dated->editAttributes() ?>>
<?php if (!$t_trip_expenses_detailed->dated->ReadOnly && !$t_trip_expenses_detailed->dated->Disabled && !isset($t_trip_expenses_detailed->dated->EditAttrs["readonly"]) && !isset($t_trip_expenses_detailed->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_expenses_detailedsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_trip_expenses_detailed_dated" class="btw1_dated d-none">
<input type="text" data-table="t_trip_expenses_detailed" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($t_trip_expenses_detailed->dated->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_detailed->dated->EditValue2 ?>"<?php echo $t_trip_expenses_detailed->dated->editAttributes() ?>>
<?php if (!$t_trip_expenses_detailed->dated->ReadOnly && !$t_trip_expenses_detailed->dated->Disabled && !isset($t_trip_expenses_detailed->dated->EditAttrs["readonly"]) && !isset($t_trip_expenses_detailed->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_expenses_detailedsearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_detailed->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $t_trip_expenses_detailed_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_detailed_remarks"><?php echo $t_trip_expenses_detailed->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_expenses_detailed_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_detailed->remarks->cellAttributes() ?>>
			<span id="el_t_trip_expenses_detailed_remarks">
<input type="text" data-table="t_trip_expenses_detailed" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_trip_expenses_detailed->remarks->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_detailed->remarks->EditValue ?>"<?php echo $t_trip_expenses_detailed->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_trip_expenses_detailed_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_trip_expenses_detailed_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_trip_expenses_detailed_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_trip_expenses_detailed_search->terminate();
?>