<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_expenses_report_list = new t_trip_expenses_report_list();

// Run the page
$t_trip_expenses_report_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_expenses_report_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_trip_expenses_report->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_trip_expenses_reportlist = currentForm = new ew.Form("ft_trip_expenses_reportlist", "list");
ft_trip_expenses_reportlist.formKeyCountName = '<?php echo $t_trip_expenses_report_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_trip_expenses_reportlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_expenses_reportlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_expenses_reportlist.lists["x_trip"] = <?php echo $t_trip_expenses_report_list->trip->Lookup->toClientList() ?>;
ft_trip_expenses_reportlist.lists["x_trip"].options = <?php echo JsonEncode($t_trip_expenses_report_list->trip->lookupOptions()) ?>;
ft_trip_expenses_reportlist.lists["x_driver"] = <?php echo $t_trip_expenses_report_list->driver->Lookup->toClientList() ?>;
ft_trip_expenses_reportlist.lists["x_driver"].options = <?php echo JsonEncode($t_trip_expenses_report_list->driver->lookupOptions()) ?>;
ft_trip_expenses_reportlist.lists["x_vehicle"] = <?php echo $t_trip_expenses_report_list->vehicle->Lookup->toClientList() ?>;
ft_trip_expenses_reportlist.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_expenses_report_list->vehicle->lookupOptions()) ?>;

// Form object for search
var ft_trip_expenses_reportlistsrch = currentSearchForm = new ew.Form("ft_trip_expenses_reportlistsrch");

// Validate function for search
ft_trip_expenses_reportlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_unload_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_expenses_report->unload_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_expenses_report->Balance->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
ft_trip_expenses_reportlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_expenses_reportlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

ft_trip_expenses_reportlistsrch.filterList = <?php echo $t_trip_expenses_report_list->getFilterList() ?>;

// Init search panel as collapsed
ft_trip_expenses_reportlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_trip_expenses_report->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_trip_expenses_report_list->TotalRecs > 0 && $t_trip_expenses_report_list->ExportOptions->visible()) { ?>
<?php $t_trip_expenses_report_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_expenses_report_list->ImportOptions->visible()) { ?>
<?php $t_trip_expenses_report_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_expenses_report_list->SearchOptions->visible()) { ?>
<?php $t_trip_expenses_report_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_expenses_report_list->FilterOptions->visible()) { ?>
<?php $t_trip_expenses_report_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_trip_expenses_report_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_trip_expenses_report->isExport() && !$t_trip_expenses_report->CurrentAction) { ?>
<form name="ft_trip_expenses_reportlistsrch" id="ft_trip_expenses_reportlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_trip_expenses_report_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_trip_expenses_reportlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_trip_expenses_report">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$t_trip_expenses_report_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$t_trip_expenses_report->RowType = ROWTYPE_SEARCH;

// Render row
$t_trip_expenses_report->resetAttributes();
$t_trip_expenses_report_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($t_trip_expenses_report->unload_date->Visible) { // unload_date ?>
	<div id="xsc_unload_date" class="ew-cell form-group">
		<label for="x_unload_date" class="ew-search-caption ew-label"><?php echo $t_trip_expenses_report->unload_date->caption() ?></label>
		<span class="ew-search-operator"><select name="z_unload_date" id="z_unload_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="t_trip_expenses_report" data-field="x_unload_date" name="x_unload_date" id="x_unload_date" placeholder="<?php echo HtmlEncode($t_trip_expenses_report->unload_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_report->unload_date->EditValue ?>"<?php echo $t_trip_expenses_report->unload_date->editAttributes() ?>>
<?php if (!$t_trip_expenses_report->unload_date->ReadOnly && !$t_trip_expenses_report->unload_date->Disabled && !isset($t_trip_expenses_report->unload_date->EditAttrs["readonly"]) && !isset($t_trip_expenses_report->unload_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_expenses_reportlistsrch", "x_unload_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_unload_date style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_unload_date style="d-none"">
<input type="text" data-table="t_trip_expenses_report" data-field="x_unload_date" name="y_unload_date" id="y_unload_date" placeholder="<?php echo HtmlEncode($t_trip_expenses_report->unload_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_report->unload_date->EditValue2 ?>"<?php echo $t_trip_expenses_report->unload_date->editAttributes() ?>>
<?php if (!$t_trip_expenses_report->unload_date->ReadOnly && !$t_trip_expenses_report->unload_date->Disabled && !isset($t_trip_expenses_report->unload_date->EditAttrs["readonly"]) && !isset($t_trip_expenses_report->unload_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_expenses_reportlistsrch", "y_unload_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_report->Balance->Visible) { // Balance ?>
	<div id="xsc_Balance" class="ew-cell form-group">
		<label for="x_Balance" class="ew-search-caption ew-label"><?php echo $t_trip_expenses_report->Balance->caption() ?></label>
		<span class="ew-search-operator"><select name="z_Balance" id="z_Balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="t_trip_expenses_report" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_report->Balance->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_report->Balance->EditValue ?>"<?php echo $t_trip_expenses_report->Balance->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_Balance style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_Balance style="d-none"">
<input type="text" data-table="t_trip_expenses_report" data-field="x_Balance" name="y_Balance" id="y_Balance" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_report->Balance->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_report->Balance->EditValue2 ?>"<?php echo $t_trip_expenses_report->Balance->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_trip_expenses_report_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_trip_expenses_report_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_trip_expenses_report_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_trip_expenses_report_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_trip_expenses_report_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_trip_expenses_report_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_trip_expenses_report_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_trip_expenses_report_list->showPageHeader(); ?>
<?php
$t_trip_expenses_report_list->showMessage();
?>
<?php if ($t_trip_expenses_report_list->TotalRecs > 0 || $t_trip_expenses_report->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_trip_expenses_report_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_trip_expenses_report">
<?php if (!$t_trip_expenses_report->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_trip_expenses_report->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_trip_expenses_report_list->Pager)) $t_trip_expenses_report_list->Pager = new PrevNextPager($t_trip_expenses_report_list->StartRec, $t_trip_expenses_report_list->DisplayRecs, $t_trip_expenses_report_list->TotalRecs, $t_trip_expenses_report_list->AutoHidePager) ?>
<?php if ($t_trip_expenses_report_list->Pager->RecordCount > 0 && $t_trip_expenses_report_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_trip_expenses_report_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_trip_expenses_report_list->pageUrl() ?>start=<?php echo $t_trip_expenses_report_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_trip_expenses_report_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_trip_expenses_report_list->pageUrl() ?>start=<?php echo $t_trip_expenses_report_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_trip_expenses_report_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_trip_expenses_report_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_trip_expenses_report_list->pageUrl() ?>start=<?php echo $t_trip_expenses_report_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_trip_expenses_report_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_trip_expenses_report_list->pageUrl() ?>start=<?php echo $t_trip_expenses_report_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_trip_expenses_report_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_trip_expenses_report_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_trip_expenses_report_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_trip_expenses_report_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_trip_expenses_report_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_trip_expenses_report_list->TotalRecs > 0 && (!$t_trip_expenses_report_list->AutoHidePageSizeSelector || $t_trip_expenses_report_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_trip_expenses_report">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_trip_expenses_report_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_trip_expenses_report_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_trip_expenses_report_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_trip_expenses_report_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_trip_expenses_report_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_trip_expenses_report->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_trip_expenses_report_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_trip_expenses_reportlist" id="ft_trip_expenses_reportlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_expenses_report_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_expenses_report_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_expenses_report">
<div id="gmp_t_trip_expenses_report" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_trip_expenses_report_list->TotalRecs > 0 || $t_trip_expenses_report->isGridEdit()) { ?>
<table id="tbl_t_trip_expenses_reportlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_trip_expenses_report_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_trip_expenses_report_list->renderListOptions();

// Render list options (header, left)
$t_trip_expenses_report_list->ListOptions->render("header", "left");
?>
<?php if ($t_trip_expenses_report->trip->Visible) { // trip ?>
	<?php if ($t_trip_expenses_report->sortUrl($t_trip_expenses_report->trip) == "") { ?>
		<th data-name="trip" class="<?php echo $t_trip_expenses_report->trip->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_trip" class="t_trip_expenses_report_trip"><div class="ew-table-header-caption"><?php echo $t_trip_expenses_report->trip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="trip" class="<?php echo $t_trip_expenses_report->trip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_expenses_report->SortUrl($t_trip_expenses_report->trip) ?>',2);"><div id="elh_t_trip_expenses_report_trip" class="t_trip_expenses_report_trip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_expenses_report->trip->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_expenses_report->trip->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_expenses_report->trip->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_expenses_report->driver->Visible) { // driver ?>
	<?php if ($t_trip_expenses_report->sortUrl($t_trip_expenses_report->driver) == "") { ?>
		<th data-name="driver" class="<?php echo $t_trip_expenses_report->driver->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_driver" class="t_trip_expenses_report_driver"><div class="ew-table-header-caption"><?php echo $t_trip_expenses_report->driver->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="driver" class="<?php echo $t_trip_expenses_report->driver->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_expenses_report->SortUrl($t_trip_expenses_report->driver) ?>',2);"><div id="elh_t_trip_expenses_report_driver" class="t_trip_expenses_report_driver">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_expenses_report->driver->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_expenses_report->driver->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_expenses_report->driver->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_expenses_report->vehicle->Visible) { // vehicle ?>
	<?php if ($t_trip_expenses_report->sortUrl($t_trip_expenses_report->vehicle) == "") { ?>
		<th data-name="vehicle" class="<?php echo $t_trip_expenses_report->vehicle->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_vehicle" class="t_trip_expenses_report_vehicle"><div class="ew-table-header-caption"><?php echo $t_trip_expenses_report->vehicle->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle" class="<?php echo $t_trip_expenses_report->vehicle->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_expenses_report->SortUrl($t_trip_expenses_report->vehicle) ?>',2);"><div id="elh_t_trip_expenses_report_vehicle" class="t_trip_expenses_report_vehicle">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_expenses_report->vehicle->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_expenses_report->vehicle->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_expenses_report->vehicle->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_expenses_report->unload_date->Visible) { // unload_date ?>
	<?php if ($t_trip_expenses_report->sortUrl($t_trip_expenses_report->unload_date) == "") { ?>
		<th data-name="unload_date" class="<?php echo $t_trip_expenses_report->unload_date->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_unload_date" class="t_trip_expenses_report_unload_date"><div class="ew-table-header-caption"><?php echo $t_trip_expenses_report->unload_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unload_date" class="<?php echo $t_trip_expenses_report->unload_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_expenses_report->SortUrl($t_trip_expenses_report->unload_date) ?>',2);"><div id="elh_t_trip_expenses_report_unload_date" class="t_trip_expenses_report_unload_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_expenses_report->unload_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_expenses_report->unload_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_expenses_report->unload_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_expenses_report->IN->Visible) { // IN ?>
	<?php if ($t_trip_expenses_report->sortUrl($t_trip_expenses_report->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $t_trip_expenses_report->IN->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_IN" class="t_trip_expenses_report_IN"><div class="ew-table-header-caption"><?php echo $t_trip_expenses_report->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $t_trip_expenses_report->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_expenses_report->SortUrl($t_trip_expenses_report->IN) ?>',2);"><div id="elh_t_trip_expenses_report_IN" class="t_trip_expenses_report_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_expenses_report->IN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_expenses_report->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_expenses_report->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_expenses_report->OUT->Visible) { // OUT ?>
	<?php if ($t_trip_expenses_report->sortUrl($t_trip_expenses_report->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $t_trip_expenses_report->OUT->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_OUT" class="t_trip_expenses_report_OUT"><div class="ew-table-header-caption"><?php echo $t_trip_expenses_report->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $t_trip_expenses_report->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_expenses_report->SortUrl($t_trip_expenses_report->OUT) ?>',2);"><div id="elh_t_trip_expenses_report_OUT" class="t_trip_expenses_report_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_expenses_report->OUT->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_expenses_report->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_expenses_report->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_expenses_report->Balance->Visible) { // Balance ?>
	<?php if ($t_trip_expenses_report->sortUrl($t_trip_expenses_report->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $t_trip_expenses_report->Balance->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_Balance" class="t_trip_expenses_report_Balance"><div class="ew-table-header-caption"><?php echo $t_trip_expenses_report->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $t_trip_expenses_report->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_expenses_report->SortUrl($t_trip_expenses_report->Balance) ?>',2);"><div id="elh_t_trip_expenses_report_Balance" class="t_trip_expenses_report_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_expenses_report->Balance->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_expenses_report->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_expenses_report->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_expenses_report->per_km->Visible) { // per_km ?>
	<?php if ($t_trip_expenses_report->sortUrl($t_trip_expenses_report->per_km) == "") { ?>
		<th data-name="per_km" class="<?php echo $t_trip_expenses_report->per_km->headerCellClass() ?>"><div id="elh_t_trip_expenses_report_per_km" class="t_trip_expenses_report_per_km"><div class="ew-table-header-caption"><?php echo $t_trip_expenses_report->per_km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="per_km" class="<?php echo $t_trip_expenses_report->per_km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_expenses_report->SortUrl($t_trip_expenses_report->per_km) ?>',2);"><div id="elh_t_trip_expenses_report_per_km" class="t_trip_expenses_report_per_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_expenses_report->per_km->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_expenses_report->per_km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_expenses_report->per_km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_trip_expenses_report_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_trip_expenses_report->ExportAll && $t_trip_expenses_report->isExport()) {
	$t_trip_expenses_report_list->StopRec = $t_trip_expenses_report_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_trip_expenses_report_list->TotalRecs > $t_trip_expenses_report_list->StartRec + $t_trip_expenses_report_list->DisplayRecs - 1)
		$t_trip_expenses_report_list->StopRec = $t_trip_expenses_report_list->StartRec + $t_trip_expenses_report_list->DisplayRecs - 1;
	else
		$t_trip_expenses_report_list->StopRec = $t_trip_expenses_report_list->TotalRecs;
}
$t_trip_expenses_report_list->RecCnt = $t_trip_expenses_report_list->StartRec - 1;
if ($t_trip_expenses_report_list->Recordset && !$t_trip_expenses_report_list->Recordset->EOF) {
	$t_trip_expenses_report_list->Recordset->moveFirst();
	$selectLimit = $t_trip_expenses_report_list->UseSelectLimit;
	if (!$selectLimit && $t_trip_expenses_report_list->StartRec > 1)
		$t_trip_expenses_report_list->Recordset->move($t_trip_expenses_report_list->StartRec - 1);
} elseif (!$t_trip_expenses_report->AllowAddDeleteRow && $t_trip_expenses_report_list->StopRec == 0) {
	$t_trip_expenses_report_list->StopRec = $t_trip_expenses_report->GridAddRowCount;
}

// Initialize aggregate
$t_trip_expenses_report->RowType = ROWTYPE_AGGREGATEINIT;
$t_trip_expenses_report->resetAttributes();
$t_trip_expenses_report_list->renderRow();
while ($t_trip_expenses_report_list->RecCnt < $t_trip_expenses_report_list->StopRec) {
	$t_trip_expenses_report_list->RecCnt++;
	if ($t_trip_expenses_report_list->RecCnt >= $t_trip_expenses_report_list->StartRec) {
		$t_trip_expenses_report_list->RowCnt++;

		// Set up key count
		$t_trip_expenses_report_list->KeyCount = $t_trip_expenses_report_list->RowIndex;

		// Init row class and style
		$t_trip_expenses_report->resetAttributes();
		$t_trip_expenses_report->CssClass = "";
		if ($t_trip_expenses_report->isGridAdd()) {
		} else {
			$t_trip_expenses_report_list->loadRowValues($t_trip_expenses_report_list->Recordset); // Load row values
		}
		$t_trip_expenses_report->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_trip_expenses_report->RowAttrs = array_merge($t_trip_expenses_report->RowAttrs, array('data-rowindex'=>$t_trip_expenses_report_list->RowCnt, 'id'=>'r' . $t_trip_expenses_report_list->RowCnt . '_t_trip_expenses_report', 'data-rowtype'=>$t_trip_expenses_report->RowType));

		// Render row
		$t_trip_expenses_report_list->renderRow();

		// Render list options
		$t_trip_expenses_report_list->renderListOptions();
?>
	<tr<?php echo $t_trip_expenses_report->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_trip_expenses_report_list->ListOptions->render("body", "left", $t_trip_expenses_report_list->RowCnt);
?>
	<?php if ($t_trip_expenses_report->trip->Visible) { // trip ?>
		<td data-name="trip"<?php echo $t_trip_expenses_report->trip->cellAttributes() ?>>
<span id="el<?php echo $t_trip_expenses_report_list->RowCnt ?>_t_trip_expenses_report_trip" class="t_trip_expenses_report_trip">
<span<?php echo $t_trip_expenses_report->trip->viewAttributes() ?>>
<?php if ((!EmptyString($t_trip_expenses_report->trip->getViewValue())) && $t_trip_expenses_report->trip->linkAttributes() <> "") { ?>
<a<?php echo $t_trip_expenses_report->trip->linkAttributes() ?>><?php echo $t_trip_expenses_report->trip->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_trip_expenses_report->trip->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_expenses_report->driver->Visible) { // driver ?>
		<td data-name="driver"<?php echo $t_trip_expenses_report->driver->cellAttributes() ?>>
<span id="el<?php echo $t_trip_expenses_report_list->RowCnt ?>_t_trip_expenses_report_driver" class="t_trip_expenses_report_driver">
<span<?php echo $t_trip_expenses_report->driver->viewAttributes() ?>>
<?php if ((!EmptyString($t_trip_expenses_report->driver->getViewValue())) && $t_trip_expenses_report->driver->linkAttributes() <> "") { ?>
<a<?php echo $t_trip_expenses_report->driver->linkAttributes() ?>><?php echo $t_trip_expenses_report->driver->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_trip_expenses_report->driver->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_expenses_report->vehicle->Visible) { // vehicle ?>
		<td data-name="vehicle"<?php echo $t_trip_expenses_report->vehicle->cellAttributes() ?>>
<span id="el<?php echo $t_trip_expenses_report_list->RowCnt ?>_t_trip_expenses_report_vehicle" class="t_trip_expenses_report_vehicle">
<span<?php echo $t_trip_expenses_report->vehicle->viewAttributes() ?>>
<?php if ((!EmptyString($t_trip_expenses_report->vehicle->getViewValue())) && $t_trip_expenses_report->vehicle->linkAttributes() <> "") { ?>
<a<?php echo $t_trip_expenses_report->vehicle->linkAttributes() ?>><?php echo $t_trip_expenses_report->vehicle->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_trip_expenses_report->vehicle->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_expenses_report->unload_date->Visible) { // unload_date ?>
		<td data-name="unload_date"<?php echo $t_trip_expenses_report->unload_date->cellAttributes() ?>>
<span id="el<?php echo $t_trip_expenses_report_list->RowCnt ?>_t_trip_expenses_report_unload_date" class="t_trip_expenses_report_unload_date">
<span<?php echo $t_trip_expenses_report->unload_date->viewAttributes() ?>>
<?php echo $t_trip_expenses_report->unload_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_expenses_report->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $t_trip_expenses_report->IN->cellAttributes() ?>>
<span id="el<?php echo $t_trip_expenses_report_list->RowCnt ?>_t_trip_expenses_report_IN" class="t_trip_expenses_report_IN">
<span<?php echo $t_trip_expenses_report->IN->viewAttributes() ?>>
<?php echo $t_trip_expenses_report->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_expenses_report->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $t_trip_expenses_report->OUT->cellAttributes() ?>>
<span id="el<?php echo $t_trip_expenses_report_list->RowCnt ?>_t_trip_expenses_report_OUT" class="t_trip_expenses_report_OUT">
<span<?php echo $t_trip_expenses_report->OUT->viewAttributes() ?>>
<?php echo $t_trip_expenses_report->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_expenses_report->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $t_trip_expenses_report->Balance->cellAttributes() ?>>
<span id="el<?php echo $t_trip_expenses_report_list->RowCnt ?>_t_trip_expenses_report_Balance" class="t_trip_expenses_report_Balance">
<span<?php echo $t_trip_expenses_report->Balance->viewAttributes() ?>>
<?php echo $t_trip_expenses_report->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_expenses_report->per_km->Visible) { // per_km ?>
		<td data-name="per_km"<?php echo $t_trip_expenses_report->per_km->cellAttributes() ?>>
<span id="el<?php echo $t_trip_expenses_report_list->RowCnt ?>_t_trip_expenses_report_per_km" class="t_trip_expenses_report_per_km">
<span<?php echo $t_trip_expenses_report->per_km->viewAttributes() ?>>
<?php echo $t_trip_expenses_report->per_km->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_trip_expenses_report_list->ListOptions->render("body", "right", $t_trip_expenses_report_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_trip_expenses_report->isGridAdd())
		$t_trip_expenses_report_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$t_trip_expenses_report->RowType = ROWTYPE_AGGREGATE;
$t_trip_expenses_report->resetAttributes();
$t_trip_expenses_report_list->renderRow();
?>
<?php if ($t_trip_expenses_report_list->TotalRecs > 0 && !$t_trip_expenses_report->isGridAdd() && !$t_trip_expenses_report->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$t_trip_expenses_report_list->renderListOptions();

// Render list options (footer, left)
$t_trip_expenses_report_list->ListOptions->render("footer", "left");
?>
	<?php if ($t_trip_expenses_report->trip->Visible) { // trip ?>
		<td data-name="trip" class="<?php echo $t_trip_expenses_report->trip->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_trip" class="t_trip_expenses_report_trip">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_trip_expenses_report->driver->Visible) { // driver ?>
		<td data-name="driver" class="<?php echo $t_trip_expenses_report->driver->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_driver" class="t_trip_expenses_report_driver">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_trip_expenses_report->vehicle->Visible) { // vehicle ?>
		<td data-name="vehicle" class="<?php echo $t_trip_expenses_report->vehicle->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_vehicle" class="t_trip_expenses_report_vehicle">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_trip_expenses_report->unload_date->Visible) { // unload_date ?>
		<td data-name="unload_date" class="<?php echo $t_trip_expenses_report->unload_date->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_unload_date" class="t_trip_expenses_report_unload_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_trip_expenses_report->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $t_trip_expenses_report->IN->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_IN" class="t_trip_expenses_report_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $t_trip_expenses_report->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($t_trip_expenses_report->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $t_trip_expenses_report->OUT->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_OUT" class="t_trip_expenses_report_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $t_trip_expenses_report->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($t_trip_expenses_report->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $t_trip_expenses_report->Balance->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_Balance" class="t_trip_expenses_report_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $t_trip_expenses_report->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($t_trip_expenses_report->per_km->Visible) { // per_km ?>
		<td data-name="per_km" class="<?php echo $t_trip_expenses_report->per_km->footerCellClass() ?>"><span id="elf_t_trip_expenses_report_per_km" class="t_trip_expenses_report_per_km">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$t_trip_expenses_report_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_trip_expenses_report->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_trip_expenses_report_list->Recordset)
	$t_trip_expenses_report_list->Recordset->Close();
?>
<?php if (!$t_trip_expenses_report->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_trip_expenses_report->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_trip_expenses_report_list->Pager)) $t_trip_expenses_report_list->Pager = new PrevNextPager($t_trip_expenses_report_list->StartRec, $t_trip_expenses_report_list->DisplayRecs, $t_trip_expenses_report_list->TotalRecs, $t_trip_expenses_report_list->AutoHidePager) ?>
<?php if ($t_trip_expenses_report_list->Pager->RecordCount > 0 && $t_trip_expenses_report_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_trip_expenses_report_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_trip_expenses_report_list->pageUrl() ?>start=<?php echo $t_trip_expenses_report_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_trip_expenses_report_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_trip_expenses_report_list->pageUrl() ?>start=<?php echo $t_trip_expenses_report_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_trip_expenses_report_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_trip_expenses_report_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_trip_expenses_report_list->pageUrl() ?>start=<?php echo $t_trip_expenses_report_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_trip_expenses_report_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_trip_expenses_report_list->pageUrl() ?>start=<?php echo $t_trip_expenses_report_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_trip_expenses_report_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_trip_expenses_report_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_trip_expenses_report_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_trip_expenses_report_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_trip_expenses_report_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_trip_expenses_report_list->TotalRecs > 0 && (!$t_trip_expenses_report_list->AutoHidePageSizeSelector || $t_trip_expenses_report_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_trip_expenses_report">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_trip_expenses_report_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_trip_expenses_report_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_trip_expenses_report_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_trip_expenses_report_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_trip_expenses_report_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_trip_expenses_report->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_trip_expenses_report_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_trip_expenses_report_list->TotalRecs == 0 && !$t_trip_expenses_report->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_trip_expenses_report_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_trip_expenses_report_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_trip_expenses_report->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_trip_expenses_report->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_trip_expenses_report", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_trip_expenses_report_list->terminate();
?>