<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_expenses_report_search = new t_trip_expenses_report_search();

// Run the page
$t_trip_expenses_report_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_expenses_report_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_trip_expenses_report_search->IsModal) { ?>
var ft_trip_expenses_reportsearch = currentAdvancedSearchForm = new ew.Form("ft_trip_expenses_reportsearch", "search");
<?php } else { ?>
var ft_trip_expenses_reportsearch = currentForm = new ew.Form("ft_trip_expenses_reportsearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_trip_expenses_reportsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_expenses_reportsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_expenses_reportsearch.lists["x_trip"] = <?php echo $t_trip_expenses_report_search->trip->Lookup->toClientList() ?>;
ft_trip_expenses_reportsearch.lists["x_trip"].options = <?php echo JsonEncode($t_trip_expenses_report_search->trip->lookupOptions()) ?>;
ft_trip_expenses_reportsearch.lists["x_driver"] = <?php echo $t_trip_expenses_report_search->driver->Lookup->toClientList() ?>;
ft_trip_expenses_reportsearch.lists["x_driver"].options = <?php echo JsonEncode($t_trip_expenses_report_search->driver->lookupOptions()) ?>;
ft_trip_expenses_reportsearch.lists["x_vehicle"] = <?php echo $t_trip_expenses_report_search->vehicle->Lookup->toClientList() ?>;
ft_trip_expenses_reportsearch.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_expenses_report_search->vehicle->lookupOptions()) ?>;

// Form object for search
// Validate function for search

ft_trip_expenses_reportsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_unload_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_expenses_report->unload_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_expenses_report->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_OUT");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_expenses_report->OUT->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_expenses_report->Balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_per_km");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_expenses_report->per_km->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_trip_expenses_report_search->showPageHeader(); ?>
<?php
$t_trip_expenses_report_search->showMessage();
?>
<form name="ft_trip_expenses_reportsearch" id="ft_trip_expenses_reportsearch" class="<?php echo $t_trip_expenses_report_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_expenses_report_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_expenses_report_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_expenses_report">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_trip_expenses_report_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_expenses_report->trip->Visible) { // trip ?>
	<div id="r_trip" class="form-group row">
		<label for="x_trip" class="<?php echo $t_trip_expenses_report_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_trip"><?php echo $t_trip_expenses_report->trip->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_trip" id="z_trip" value="="></span>
		</label>
		<div class="<?php echo $t_trip_expenses_report_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_report->trip->cellAttributes() ?>>
			<span id="el_t_trip_expenses_report_trip">
<input type="text" data-table="t_trip_expenses_report" data-field="x_trip" name="x_trip" id="x_trip" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_report->trip->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_report->trip->EditValue ?>"<?php echo $t_trip_expenses_report->trip->editAttributes() ?>>
<?php echo $t_trip_expenses_report->trip->Lookup->getParamTag("p_x_trip") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_report->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label for="x_driver" class="<?php echo $t_trip_expenses_report_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_driver"><?php echo $t_trip_expenses_report->driver->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_driver" id="z_driver" value="="></span>
		</label>
		<div class="<?php echo $t_trip_expenses_report_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_report->driver->cellAttributes() ?>>
			<span id="el_t_trip_expenses_report_driver">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_expenses_report" data-field="x_driver" data-value-separator="<?php echo $t_trip_expenses_report->driver->displayValueSeparatorAttribute() ?>" id="x_driver" name="x_driver"<?php echo $t_trip_expenses_report->driver->editAttributes() ?>>
		<?php echo $t_trip_expenses_report->driver->selectOptionListHtml("x_driver") ?>
	</select>
</div>
<?php echo $t_trip_expenses_report->driver->Lookup->getParamTag("p_x_driver") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_report->vehicle->Visible) { // vehicle ?>
	<div id="r_vehicle" class="form-group row">
		<label for="x_vehicle" class="<?php echo $t_trip_expenses_report_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_vehicle"><?php echo $t_trip_expenses_report->vehicle->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle" id="z_vehicle" value="="></span>
		</label>
		<div class="<?php echo $t_trip_expenses_report_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_report->vehicle->cellAttributes() ?>>
			<span id="el_t_trip_expenses_report_vehicle">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_expenses_report" data-field="x_vehicle" data-value-separator="<?php echo $t_trip_expenses_report->vehicle->displayValueSeparatorAttribute() ?>" id="x_vehicle" name="x_vehicle"<?php echo $t_trip_expenses_report->vehicle->editAttributes() ?>>
		<?php echo $t_trip_expenses_report->vehicle->selectOptionListHtml("x_vehicle") ?>
	</select>
</div>
<?php echo $t_trip_expenses_report->vehicle->Lookup->getParamTag("p_x_vehicle") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_report->unload_date->Visible) { // unload_date ?>
	<div id="r_unload_date" class="form-group row">
		<label for="x_unload_date" class="<?php echo $t_trip_expenses_report_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_unload_date"><?php echo $t_trip_expenses_report->unload_date->caption() ?></span>
		</label>
		<div class="<?php echo $t_trip_expenses_report_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_report->unload_date->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_unload_date" id="z_unload_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_expenses_report->unload_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_trip_expenses_report_unload_date">
<input type="text" data-table="t_trip_expenses_report" data-field="x_unload_date" name="x_unload_date" id="x_unload_date" placeholder="<?php echo HtmlEncode($t_trip_expenses_report->unload_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_report->unload_date->EditValue ?>"<?php echo $t_trip_expenses_report->unload_date->editAttributes() ?>>
<?php if (!$t_trip_expenses_report->unload_date->ReadOnly && !$t_trip_expenses_report->unload_date->Disabled && !isset($t_trip_expenses_report->unload_date->EditAttrs["readonly"]) && !isset($t_trip_expenses_report->unload_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_expenses_reportsearch", "x_unload_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_unload_date d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_trip_expenses_report_unload_date" class="btw1_unload_date d-none">
<input type="text" data-table="t_trip_expenses_report" data-field="x_unload_date" name="y_unload_date" id="y_unload_date" placeholder="<?php echo HtmlEncode($t_trip_expenses_report->unload_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_report->unload_date->EditValue2 ?>"<?php echo $t_trip_expenses_report->unload_date->editAttributes() ?>>
<?php if (!$t_trip_expenses_report->unload_date->ReadOnly && !$t_trip_expenses_report->unload_date->Disabled && !isset($t_trip_expenses_report->unload_date->EditAttrs["readonly"]) && !isset($t_trip_expenses_report->unload_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_expenses_reportsearch", "y_unload_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_report->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $t_trip_expenses_report_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_IN"><?php echo $t_trip_expenses_report->IN->caption() ?></span>
		</label>
		<div class="<?php echo $t_trip_expenses_report_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_report->IN->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_IN" id="z_IN" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_expenses_report->IN->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_expenses_report->IN->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_expenses_report->IN->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_expenses_report->IN->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_expenses_report->IN->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_expenses_report->IN->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_expenses_report->IN->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_expenses_report->IN->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_expenses_report->IN->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_trip_expenses_report_IN">
<input type="text" data-table="t_trip_expenses_report" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_report->IN->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_report->IN->EditValue ?>"<?php echo $t_trip_expenses_report->IN->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_IN d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_trip_expenses_report_IN" class="btw1_IN d-none">
<input type="text" data-table="t_trip_expenses_report" data-field="x_IN" name="y_IN" id="y_IN" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_report->IN->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_report->IN->EditValue2 ?>"<?php echo $t_trip_expenses_report->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_report->OUT->Visible) { // OUT ?>
	<div id="r_OUT" class="form-group row">
		<label for="x_OUT" class="<?php echo $t_trip_expenses_report_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_OUT"><?php echo $t_trip_expenses_report->OUT->caption() ?></span>
		</label>
		<div class="<?php echo $t_trip_expenses_report_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_report->OUT->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_OUT" id="z_OUT" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_expenses_report->OUT->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_expenses_report->OUT->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_expenses_report->OUT->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_expenses_report->OUT->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_expenses_report->OUT->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_expenses_report->OUT->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_expenses_report->OUT->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_expenses_report->OUT->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_expenses_report->OUT->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_trip_expenses_report_OUT">
<input type="text" data-table="t_trip_expenses_report" data-field="x_OUT" name="x_OUT" id="x_OUT" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_report->OUT->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_report->OUT->EditValue ?>"<?php echo $t_trip_expenses_report->OUT->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_OUT d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_trip_expenses_report_OUT" class="btw1_OUT d-none">
<input type="text" data-table="t_trip_expenses_report" data-field="x_OUT" name="y_OUT" id="y_OUT" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_report->OUT->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_report->OUT->EditValue2 ?>"<?php echo $t_trip_expenses_report->OUT->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_report->Balance->Visible) { // Balance ?>
	<div id="r_Balance" class="form-group row">
		<label for="x_Balance" class="<?php echo $t_trip_expenses_report_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_Balance"><?php echo $t_trip_expenses_report->Balance->caption() ?></span>
		</label>
		<div class="<?php echo $t_trip_expenses_report_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_report->Balance->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_Balance" id="z_Balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_expenses_report->Balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_trip_expenses_report_Balance">
<input type="text" data-table="t_trip_expenses_report" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_report->Balance->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_report->Balance->EditValue ?>"<?php echo $t_trip_expenses_report->Balance->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_Balance d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_trip_expenses_report_Balance" class="btw1_Balance d-none">
<input type="text" data-table="t_trip_expenses_report" data-field="x_Balance" name="y_Balance" id="y_Balance" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_report->Balance->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_report->Balance->EditValue2 ?>"<?php echo $t_trip_expenses_report->Balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_expenses_report->per_km->Visible) { // per_km ?>
	<div id="r_per_km" class="form-group row">
		<label for="x_per_km" class="<?php echo $t_trip_expenses_report_search->LeftColumnClass ?>"><span id="elh_t_trip_expenses_report_per_km"><?php echo $t_trip_expenses_report->per_km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_per_km" id="z_per_km" value="="></span>
		</label>
		<div class="<?php echo $t_trip_expenses_report_search->RightColumnClass ?>"><div<?php echo $t_trip_expenses_report->per_km->cellAttributes() ?>>
			<span id="el_t_trip_expenses_report_per_km">
<input type="text" data-table="t_trip_expenses_report" data-field="x_per_km" name="x_per_km" id="x_per_km" size="30" placeholder="<?php echo HtmlEncode($t_trip_expenses_report->per_km->getPlaceHolder()) ?>" value="<?php echo $t_trip_expenses_report->per_km->EditValue ?>"<?php echo $t_trip_expenses_report->per_km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_trip_expenses_report_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_trip_expenses_report_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_trip_expenses_report_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_trip_expenses_report_search->terminate();
?>