<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_info_d_unload_list = new t_trip_info_d_unload_list();

// Run the page
$t_trip_info_d_unload_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_info_d_unload_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_trip_info_d_unload->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_trip_info_d_unloadlist = currentForm = new ew.Form("ft_trip_info_d_unloadlist", "list");
ft_trip_info_d_unloadlist.formKeyCountName = '<?php echo $t_trip_info_d_unload_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_trip_info_d_unloadlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_info_d_unloadlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_info_d_unloadlist.lists["x_trip_info"] = <?php echo $t_trip_info_d_unload_list->trip_info->Lookup->toClientList() ?>;
ft_trip_info_d_unloadlist.lists["x_trip_info"].options = <?php echo JsonEncode($t_trip_info_d_unload_list->trip_info->lookupOptions()) ?>;
ft_trip_info_d_unloadlist.lists["x_driver"] = <?php echo $t_trip_info_d_unload_list->driver->Lookup->toClientList() ?>;
ft_trip_info_d_unloadlist.lists["x_driver"].options = <?php echo JsonEncode($t_trip_info_d_unload_list->driver->lookupOptions()) ?>;
ft_trip_info_d_unloadlist.lists["x_delivery_pod"] = <?php echo $t_trip_info_d_unload_list->delivery_pod->Lookup->toClientList() ?>;
ft_trip_info_d_unloadlist.lists["x_delivery_pod"].options = <?php echo JsonEncode($t_trip_info_d_unload_list->delivery_pod->options(FALSE, TRUE)) ?>;

// Form object for search
var ft_trip_info_d_unloadlistsrch = currentSearchForm = new ew.Form("ft_trip_info_d_unloadlistsrch");

// Validate function for search
ft_trip_info_d_unloadlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
ft_trip_info_d_unloadlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_info_d_unloadlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_info_d_unloadlistsrch.lists["x_trip_info"] = <?php echo $t_trip_info_d_unload_list->trip_info->Lookup->toClientList() ?>;
ft_trip_info_d_unloadlistsrch.lists["x_trip_info"].options = <?php echo JsonEncode($t_trip_info_d_unload_list->trip_info->lookupOptions()) ?>;

// Filters
ft_trip_info_d_unloadlistsrch.filterList = <?php echo $t_trip_info_d_unload_list->getFilterList() ?>;

// Init search panel as collapsed
ft_trip_info_d_unloadlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_trip_info_d_unload->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_trip_info_d_unload_list->TotalRecs > 0 && $t_trip_info_d_unload_list->ExportOptions->visible()) { ?>
<?php $t_trip_info_d_unload_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_info_d_unload_list->ImportOptions->visible()) { ?>
<?php $t_trip_info_d_unload_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_info_d_unload_list->SearchOptions->visible()) { ?>
<?php $t_trip_info_d_unload_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_info_d_unload_list->FilterOptions->visible()) { ?>
<?php $t_trip_info_d_unload_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_trip_info_d_unload_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_trip_info_d_unload->isExport() && !$t_trip_info_d_unload->CurrentAction) { ?>
<form name="ft_trip_info_d_unloadlistsrch" id="ft_trip_info_d_unloadlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_trip_info_d_unload_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_trip_info_d_unloadlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_trip_info_d_unload">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$t_trip_info_d_unload_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$t_trip_info_d_unload->RowType = ROWTYPE_SEARCH;

// Render row
$t_trip_info_d_unload->resetAttributes();
$t_trip_info_d_unload_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($t_trip_info_d_unload->trip_info->Visible) { // trip_info ?>
	<div id="xsc_trip_info" class="ew-cell form-group">
		<label for="x_trip_info" class="ew-search-caption ew-label"><?php echo $t_trip_info_d_unload->trip_info->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_trip_info" id="z_trip_info" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info_d_unload" data-field="x_trip_info" data-value-separator="<?php echo $t_trip_info_d_unload->trip_info->displayValueSeparatorAttribute() ?>" id="x_trip_info" name="x_trip_info"<?php echo $t_trip_info_d_unload->trip_info->editAttributes() ?>>
		<?php echo $t_trip_info_d_unload->trip_info->selectOptionListHtml("x_trip_info") ?>
	</select>
</div>
<?php echo $t_trip_info_d_unload->trip_info->Lookup->getParamTag("p_x_trip_info") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_trip_info_d_unload_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_trip_info_d_unload_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_trip_info_d_unload_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_trip_info_d_unload_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_trip_info_d_unload_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_trip_info_d_unload_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_trip_info_d_unload_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_trip_info_d_unload_list->showPageHeader(); ?>
<?php
$t_trip_info_d_unload_list->showMessage();
?>
<?php if ($t_trip_info_d_unload_list->TotalRecs > 0 || $t_trip_info_d_unload->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_trip_info_d_unload_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_trip_info_d_unload">
<?php if (!$t_trip_info_d_unload->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_trip_info_d_unload->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_trip_info_d_unload_list->Pager)) $t_trip_info_d_unload_list->Pager = new PrevNextPager($t_trip_info_d_unload_list->StartRec, $t_trip_info_d_unload_list->DisplayRecs, $t_trip_info_d_unload_list->TotalRecs, $t_trip_info_d_unload_list->AutoHidePager) ?>
<?php if ($t_trip_info_d_unload_list->Pager->RecordCount > 0 && $t_trip_info_d_unload_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_trip_info_d_unload_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_trip_info_d_unload_list->pageUrl() ?>start=<?php echo $t_trip_info_d_unload_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_trip_info_d_unload_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_trip_info_d_unload_list->pageUrl() ?>start=<?php echo $t_trip_info_d_unload_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_trip_info_d_unload_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_trip_info_d_unload_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_trip_info_d_unload_list->pageUrl() ?>start=<?php echo $t_trip_info_d_unload_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_trip_info_d_unload_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_trip_info_d_unload_list->pageUrl() ?>start=<?php echo $t_trip_info_d_unload_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_trip_info_d_unload_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_trip_info_d_unload_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_trip_info_d_unload_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_trip_info_d_unload_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_trip_info_d_unload_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_trip_info_d_unload_list->TotalRecs > 0 && (!$t_trip_info_d_unload_list->AutoHidePageSizeSelector || $t_trip_info_d_unload_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_trip_info_d_unload">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_trip_info_d_unload_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_trip_info_d_unload_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_trip_info_d_unload_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_trip_info_d_unload_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_trip_info_d_unload_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_trip_info_d_unload->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_trip_info_d_unload_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_trip_info_d_unloadlist" id="ft_trip_info_d_unloadlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_info_d_unload_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_info_d_unload_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_info_d_unload">
<div id="gmp_t_trip_info_d_unload" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_trip_info_d_unload_list->TotalRecs > 0 || $t_trip_info_d_unload->isGridEdit()) { ?>
<table id="tbl_t_trip_info_d_unloadlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_trip_info_d_unload_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_trip_info_d_unload_list->renderListOptions();

// Render list options (header, left)
$t_trip_info_d_unload_list->ListOptions->render("header", "left");
?>
<?php if ($t_trip_info_d_unload->id->Visible) { // id ?>
	<?php if ($t_trip_info_d_unload->sortUrl($t_trip_info_d_unload->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_trip_info_d_unload->id->headerCellClass() ?>"><div id="elh_t_trip_info_d_unload_id" class="t_trip_info_d_unload_id"><div class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_trip_info_d_unload->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info_d_unload->SortUrl($t_trip_info_d_unload->id) ?>',2);"><div id="elh_t_trip_info_d_unload_id" class="t_trip_info_d_unload_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info_d_unload->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info_d_unload->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info_d_unload->load_date->Visible) { // load_date ?>
	<?php if ($t_trip_info_d_unload->sortUrl($t_trip_info_d_unload->load_date) == "") { ?>
		<th data-name="load_date" class="<?php echo $t_trip_info_d_unload->load_date->headerCellClass() ?>"><div id="elh_t_trip_info_d_unload_load_date" class="t_trip_info_d_unload_load_date"><div class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->load_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="load_date" class="<?php echo $t_trip_info_d_unload->load_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info_d_unload->SortUrl($t_trip_info_d_unload->load_date) ?>',2);"><div id="elh_t_trip_info_d_unload_load_date" class="t_trip_info_d_unload_load_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->load_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info_d_unload->load_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info_d_unload->load_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info_d_unload->trip_info->Visible) { // trip_info ?>
	<?php if ($t_trip_info_d_unload->sortUrl($t_trip_info_d_unload->trip_info) == "") { ?>
		<th data-name="trip_info" class="<?php echo $t_trip_info_d_unload->trip_info->headerCellClass() ?>"><div id="elh_t_trip_info_d_unload_trip_info" class="t_trip_info_d_unload_trip_info"><div class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->trip_info->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="trip_info" class="<?php echo $t_trip_info_d_unload->trip_info->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info_d_unload->SortUrl($t_trip_info_d_unload->trip_info) ?>',2);"><div id="elh_t_trip_info_d_unload_trip_info" class="t_trip_info_d_unload_trip_info">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->trip_info->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info_d_unload->trip_info->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info_d_unload->trip_info->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info_d_unload->driver->Visible) { // driver ?>
	<?php if ($t_trip_info_d_unload->sortUrl($t_trip_info_d_unload->driver) == "") { ?>
		<th data-name="driver" class="<?php echo $t_trip_info_d_unload->driver->headerCellClass() ?>"><div id="elh_t_trip_info_d_unload_driver" class="t_trip_info_d_unload_driver"><div class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->driver->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="driver" class="<?php echo $t_trip_info_d_unload->driver->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info_d_unload->SortUrl($t_trip_info_d_unload->driver) ?>',2);"><div id="elh_t_trip_info_d_unload_driver" class="t_trip_info_d_unload_driver">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->driver->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info_d_unload->driver->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info_d_unload->driver->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info_d_unload->unload_km->Visible) { // unload_km ?>
	<?php if ($t_trip_info_d_unload->sortUrl($t_trip_info_d_unload->unload_km) == "") { ?>
		<th data-name="unload_km" class="<?php echo $t_trip_info_d_unload->unload_km->headerCellClass() ?>"><div id="elh_t_trip_info_d_unload_unload_km" class="t_trip_info_d_unload_unload_km"><div class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->unload_km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unload_km" class="<?php echo $t_trip_info_d_unload->unload_km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info_d_unload->SortUrl($t_trip_info_d_unload->unload_km) ?>',2);"><div id="elh_t_trip_info_d_unload_unload_km" class="t_trip_info_d_unload_unload_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->unload_km->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info_d_unload->unload_km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info_d_unload->unload_km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info_d_unload->load_weight->Visible) { // load_weight ?>
	<?php if ($t_trip_info_d_unload->sortUrl($t_trip_info_d_unload->load_weight) == "") { ?>
		<th data-name="load_weight" class="<?php echo $t_trip_info_d_unload->load_weight->headerCellClass() ?>"><div id="elh_t_trip_info_d_unload_load_weight" class="t_trip_info_d_unload_load_weight"><div class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->load_weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="load_weight" class="<?php echo $t_trip_info_d_unload->load_weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info_d_unload->SortUrl($t_trip_info_d_unload->load_weight) ?>',2);"><div id="elh_t_trip_info_d_unload_load_weight" class="t_trip_info_d_unload_load_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->load_weight->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info_d_unload->load_weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info_d_unload->load_weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info_d_unload->unload_weight->Visible) { // unload_weight ?>
	<?php if ($t_trip_info_d_unload->sortUrl($t_trip_info_d_unload->unload_weight) == "") { ?>
		<th data-name="unload_weight" class="<?php echo $t_trip_info_d_unload->unload_weight->headerCellClass() ?>"><div id="elh_t_trip_info_d_unload_unload_weight" class="t_trip_info_d_unload_unload_weight"><div class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->unload_weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unload_weight" class="<?php echo $t_trip_info_d_unload->unload_weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info_d_unload->SortUrl($t_trip_info_d_unload->unload_weight) ?>',2);"><div id="elh_t_trip_info_d_unload_unload_weight" class="t_trip_info_d_unload_unload_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->unload_weight->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info_d_unload->unload_weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info_d_unload->unload_weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info_d_unload->unload_date->Visible) { // unload_date ?>
	<?php if ($t_trip_info_d_unload->sortUrl($t_trip_info_d_unload->unload_date) == "") { ?>
		<th data-name="unload_date" class="<?php echo $t_trip_info_d_unload->unload_date->headerCellClass() ?>"><div id="elh_t_trip_info_d_unload_unload_date" class="t_trip_info_d_unload_unload_date"><div class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->unload_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unload_date" class="<?php echo $t_trip_info_d_unload->unload_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info_d_unload->SortUrl($t_trip_info_d_unload->unload_date) ?>',2);"><div id="elh_t_trip_info_d_unload_unload_date" class="t_trip_info_d_unload_unload_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->unload_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info_d_unload->unload_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info_d_unload->unload_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info_d_unload->ded_det->Visible) { // ded_det ?>
	<?php if ($t_trip_info_d_unload->sortUrl($t_trip_info_d_unload->ded_det) == "") { ?>
		<th data-name="ded_det" class="<?php echo $t_trip_info_d_unload->ded_det->headerCellClass() ?>"><div id="elh_t_trip_info_d_unload_ded_det" class="t_trip_info_d_unload_ded_det"><div class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->ded_det->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ded_det" class="<?php echo $t_trip_info_d_unload->ded_det->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info_d_unload->SortUrl($t_trip_info_d_unload->ded_det) ?>',2);"><div id="elh_t_trip_info_d_unload_ded_det" class="t_trip_info_d_unload_ded_det">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->ded_det->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info_d_unload->ded_det->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info_d_unload->ded_det->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info_d_unload->ded_det_remarks->Visible) { // ded_det_remarks ?>
	<?php if ($t_trip_info_d_unload->sortUrl($t_trip_info_d_unload->ded_det_remarks) == "") { ?>
		<th data-name="ded_det_remarks" class="<?php echo $t_trip_info_d_unload->ded_det_remarks->headerCellClass() ?>"><div id="elh_t_trip_info_d_unload_ded_det_remarks" class="t_trip_info_d_unload_ded_det_remarks"><div class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->ded_det_remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ded_det_remarks" class="<?php echo $t_trip_info_d_unload->ded_det_remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info_d_unload->SortUrl($t_trip_info_d_unload->ded_det_remarks) ?>',2);"><div id="elh_t_trip_info_d_unload_ded_det_remarks" class="t_trip_info_d_unload_ded_det_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->ded_det_remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info_d_unload->ded_det_remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info_d_unload->ded_det_remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info_d_unload->fasttag_cl_balance->Visible) { // fasttag_cl_balance ?>
	<?php if ($t_trip_info_d_unload->sortUrl($t_trip_info_d_unload->fasttag_cl_balance) == "") { ?>
		<th data-name="fasttag_cl_balance" class="<?php echo $t_trip_info_d_unload->fasttag_cl_balance->headerCellClass() ?>"><div id="elh_t_trip_info_d_unload_fasttag_cl_balance" class="t_trip_info_d_unload_fasttag_cl_balance"><div class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->fasttag_cl_balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fasttag_cl_balance" class="<?php echo $t_trip_info_d_unload->fasttag_cl_balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info_d_unload->SortUrl($t_trip_info_d_unload->fasttag_cl_balance) ?>',2);"><div id="elh_t_trip_info_d_unload_fasttag_cl_balance" class="t_trip_info_d_unload_fasttag_cl_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->fasttag_cl_balance->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info_d_unload->fasttag_cl_balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info_d_unload->fasttag_cl_balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info_d_unload->delivery_receipt->Visible) { // delivery_receipt ?>
	<?php if ($t_trip_info_d_unload->sortUrl($t_trip_info_d_unload->delivery_receipt) == "") { ?>
		<th data-name="delivery_receipt" class="<?php echo $t_trip_info_d_unload->delivery_receipt->headerCellClass() ?>"><div id="elh_t_trip_info_d_unload_delivery_receipt" class="t_trip_info_d_unload_delivery_receipt"><div class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->delivery_receipt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_receipt" class="<?php echo $t_trip_info_d_unload->delivery_receipt->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info_d_unload->SortUrl($t_trip_info_d_unload->delivery_receipt) ?>',2);"><div id="elh_t_trip_info_d_unload_delivery_receipt" class="t_trip_info_d_unload_delivery_receipt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->delivery_receipt->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info_d_unload->delivery_receipt->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info_d_unload->delivery_receipt->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info_d_unload->delivery_pod->Visible) { // delivery_pod ?>
	<?php if ($t_trip_info_d_unload->sortUrl($t_trip_info_d_unload->delivery_pod) == "") { ?>
		<th data-name="delivery_pod" class="<?php echo $t_trip_info_d_unload->delivery_pod->headerCellClass() ?>"><div id="elh_t_trip_info_d_unload_delivery_pod" class="t_trip_info_d_unload_delivery_pod"><div class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->delivery_pod->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_pod" class="<?php echo $t_trip_info_d_unload->delivery_pod->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info_d_unload->SortUrl($t_trip_info_d_unload->delivery_pod) ?>',2);"><div id="elh_t_trip_info_d_unload_delivery_pod" class="t_trip_info_d_unload_delivery_pod">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->delivery_pod->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info_d_unload->delivery_pod->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info_d_unload->delivery_pod->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info_d_unload->datetime->Visible) { // datetime ?>
	<?php if ($t_trip_info_d_unload->sortUrl($t_trip_info_d_unload->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $t_trip_info_d_unload->datetime->headerCellClass() ?>"><div id="elh_t_trip_info_d_unload_datetime" class="t_trip_info_d_unload_datetime"><div class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $t_trip_info_d_unload->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info_d_unload->SortUrl($t_trip_info_d_unload->datetime) ?>',2);"><div id="elh_t_trip_info_d_unload_datetime" class="t_trip_info_d_unload_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info_d_unload->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info_d_unload->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info_d_unload->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_trip_info_d_unload_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_trip_info_d_unload->ExportAll && $t_trip_info_d_unload->isExport()) {
	$t_trip_info_d_unload_list->StopRec = $t_trip_info_d_unload_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_trip_info_d_unload_list->TotalRecs > $t_trip_info_d_unload_list->StartRec + $t_trip_info_d_unload_list->DisplayRecs - 1)
		$t_trip_info_d_unload_list->StopRec = $t_trip_info_d_unload_list->StartRec + $t_trip_info_d_unload_list->DisplayRecs - 1;
	else
		$t_trip_info_d_unload_list->StopRec = $t_trip_info_d_unload_list->TotalRecs;
}
$t_trip_info_d_unload_list->RecCnt = $t_trip_info_d_unload_list->StartRec - 1;
if ($t_trip_info_d_unload_list->Recordset && !$t_trip_info_d_unload_list->Recordset->EOF) {
	$t_trip_info_d_unload_list->Recordset->moveFirst();
	$selectLimit = $t_trip_info_d_unload_list->UseSelectLimit;
	if (!$selectLimit && $t_trip_info_d_unload_list->StartRec > 1)
		$t_trip_info_d_unload_list->Recordset->move($t_trip_info_d_unload_list->StartRec - 1);
} elseif (!$t_trip_info_d_unload->AllowAddDeleteRow && $t_trip_info_d_unload_list->StopRec == 0) {
	$t_trip_info_d_unload_list->StopRec = $t_trip_info_d_unload->GridAddRowCount;
}

// Initialize aggregate
$t_trip_info_d_unload->RowType = ROWTYPE_AGGREGATEINIT;
$t_trip_info_d_unload->resetAttributes();
$t_trip_info_d_unload_list->renderRow();
while ($t_trip_info_d_unload_list->RecCnt < $t_trip_info_d_unload_list->StopRec) {
	$t_trip_info_d_unload_list->RecCnt++;
	if ($t_trip_info_d_unload_list->RecCnt >= $t_trip_info_d_unload_list->StartRec) {
		$t_trip_info_d_unload_list->RowCnt++;

		// Set up key count
		$t_trip_info_d_unload_list->KeyCount = $t_trip_info_d_unload_list->RowIndex;

		// Init row class and style
		$t_trip_info_d_unload->resetAttributes();
		$t_trip_info_d_unload->CssClass = "";
		if ($t_trip_info_d_unload->isGridAdd()) {
		} else {
			$t_trip_info_d_unload_list->loadRowValues($t_trip_info_d_unload_list->Recordset); // Load row values
		}
		$t_trip_info_d_unload->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_trip_info_d_unload->RowAttrs = array_merge($t_trip_info_d_unload->RowAttrs, array('data-rowindex'=>$t_trip_info_d_unload_list->RowCnt, 'id'=>'r' . $t_trip_info_d_unload_list->RowCnt . '_t_trip_info_d_unload', 'data-rowtype'=>$t_trip_info_d_unload->RowType));

		// Render row
		$t_trip_info_d_unload_list->renderRow();

		// Render list options
		$t_trip_info_d_unload_list->renderListOptions();
?>
	<tr<?php echo $t_trip_info_d_unload->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_trip_info_d_unload_list->ListOptions->render("body", "left", $t_trip_info_d_unload_list->RowCnt);
?>
	<?php if ($t_trip_info_d_unload->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_trip_info_d_unload->id->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_d_unload_list->RowCnt ?>_t_trip_info_d_unload_id" class="t_trip_info_d_unload_id">
<span<?php echo $t_trip_info_d_unload->id->viewAttributes() ?>>
<?php echo $t_trip_info_d_unload->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info_d_unload->load_date->Visible) { // load_date ?>
		<td data-name="load_date"<?php echo $t_trip_info_d_unload->load_date->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_d_unload_list->RowCnt ?>_t_trip_info_d_unload_load_date" class="t_trip_info_d_unload_load_date">
<span<?php echo $t_trip_info_d_unload->load_date->viewAttributes() ?>>
<?php echo $t_trip_info_d_unload->load_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info_d_unload->trip_info->Visible) { // trip_info ?>
		<td data-name="trip_info"<?php echo $t_trip_info_d_unload->trip_info->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_d_unload_list->RowCnt ?>_t_trip_info_d_unload_trip_info" class="t_trip_info_d_unload_trip_info">
<span<?php echo $t_trip_info_d_unload->trip_info->viewAttributes() ?>>
<?php echo $t_trip_info_d_unload->trip_info->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info_d_unload->driver->Visible) { // driver ?>
		<td data-name="driver"<?php echo $t_trip_info_d_unload->driver->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_d_unload_list->RowCnt ?>_t_trip_info_d_unload_driver" class="t_trip_info_d_unload_driver">
<span<?php echo $t_trip_info_d_unload->driver->viewAttributes() ?>>
<?php echo $t_trip_info_d_unload->driver->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info_d_unload->unload_km->Visible) { // unload_km ?>
		<td data-name="unload_km"<?php echo $t_trip_info_d_unload->unload_km->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_d_unload_list->RowCnt ?>_t_trip_info_d_unload_unload_km" class="t_trip_info_d_unload_unload_km">
<span<?php echo $t_trip_info_d_unload->unload_km->viewAttributes() ?>>
<?php echo $t_trip_info_d_unload->unload_km->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info_d_unload->load_weight->Visible) { // load_weight ?>
		<td data-name="load_weight"<?php echo $t_trip_info_d_unload->load_weight->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_d_unload_list->RowCnt ?>_t_trip_info_d_unload_load_weight" class="t_trip_info_d_unload_load_weight">
<span<?php echo $t_trip_info_d_unload->load_weight->viewAttributes() ?>>
<?php echo $t_trip_info_d_unload->load_weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info_d_unload->unload_weight->Visible) { // unload_weight ?>
		<td data-name="unload_weight"<?php echo $t_trip_info_d_unload->unload_weight->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_d_unload_list->RowCnt ?>_t_trip_info_d_unload_unload_weight" class="t_trip_info_d_unload_unload_weight">
<span<?php echo $t_trip_info_d_unload->unload_weight->viewAttributes() ?>>
<?php echo $t_trip_info_d_unload->unload_weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info_d_unload->unload_date->Visible) { // unload_date ?>
		<td data-name="unload_date"<?php echo $t_trip_info_d_unload->unload_date->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_d_unload_list->RowCnt ?>_t_trip_info_d_unload_unload_date" class="t_trip_info_d_unload_unload_date">
<span<?php echo $t_trip_info_d_unload->unload_date->viewAttributes() ?>>
<?php echo $t_trip_info_d_unload->unload_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info_d_unload->ded_det->Visible) { // ded_det ?>
		<td data-name="ded_det"<?php echo $t_trip_info_d_unload->ded_det->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_d_unload_list->RowCnt ?>_t_trip_info_d_unload_ded_det" class="t_trip_info_d_unload_ded_det">
<span<?php echo $t_trip_info_d_unload->ded_det->viewAttributes() ?>>
<?php echo $t_trip_info_d_unload->ded_det->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info_d_unload->ded_det_remarks->Visible) { // ded_det_remarks ?>
		<td data-name="ded_det_remarks"<?php echo $t_trip_info_d_unload->ded_det_remarks->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_d_unload_list->RowCnt ?>_t_trip_info_d_unload_ded_det_remarks" class="t_trip_info_d_unload_ded_det_remarks">
<span<?php echo $t_trip_info_d_unload->ded_det_remarks->viewAttributes() ?>>
<?php echo $t_trip_info_d_unload->ded_det_remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info_d_unload->fasttag_cl_balance->Visible) { // fasttag_cl_balance ?>
		<td data-name="fasttag_cl_balance"<?php echo $t_trip_info_d_unload->fasttag_cl_balance->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_d_unload_list->RowCnt ?>_t_trip_info_d_unload_fasttag_cl_balance" class="t_trip_info_d_unload_fasttag_cl_balance">
<span<?php echo $t_trip_info_d_unload->fasttag_cl_balance->viewAttributes() ?>>
<?php echo $t_trip_info_d_unload->fasttag_cl_balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info_d_unload->delivery_receipt->Visible) { // delivery_receipt ?>
		<td data-name="delivery_receipt"<?php echo $t_trip_info_d_unload->delivery_receipt->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_d_unload_list->RowCnt ?>_t_trip_info_d_unload_delivery_receipt" class="t_trip_info_d_unload_delivery_receipt">
<span>
<?php echo GetFileViewTag($t_trip_info_d_unload->delivery_receipt, $t_trip_info_d_unload->delivery_receipt->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info_d_unload->delivery_pod->Visible) { // delivery_pod ?>
		<td data-name="delivery_pod"<?php echo $t_trip_info_d_unload->delivery_pod->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_d_unload_list->RowCnt ?>_t_trip_info_d_unload_delivery_pod" class="t_trip_info_d_unload_delivery_pod">
<span<?php echo $t_trip_info_d_unload->delivery_pod->viewAttributes() ?>>
<?php echo $t_trip_info_d_unload->delivery_pod->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info_d_unload->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $t_trip_info_d_unload->datetime->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_d_unload_list->RowCnt ?>_t_trip_info_d_unload_datetime" class="t_trip_info_d_unload_datetime">
<span<?php echo $t_trip_info_d_unload->datetime->viewAttributes() ?>>
<?php echo $t_trip_info_d_unload->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_trip_info_d_unload_list->ListOptions->render("body", "right", $t_trip_info_d_unload_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_trip_info_d_unload->isGridAdd())
		$t_trip_info_d_unload_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_trip_info_d_unload->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_trip_info_d_unload_list->Recordset)
	$t_trip_info_d_unload_list->Recordset->Close();
?>
<?php if (!$t_trip_info_d_unload->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_trip_info_d_unload->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_trip_info_d_unload_list->Pager)) $t_trip_info_d_unload_list->Pager = new PrevNextPager($t_trip_info_d_unload_list->StartRec, $t_trip_info_d_unload_list->DisplayRecs, $t_trip_info_d_unload_list->TotalRecs, $t_trip_info_d_unload_list->AutoHidePager) ?>
<?php if ($t_trip_info_d_unload_list->Pager->RecordCount > 0 && $t_trip_info_d_unload_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_trip_info_d_unload_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_trip_info_d_unload_list->pageUrl() ?>start=<?php echo $t_trip_info_d_unload_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_trip_info_d_unload_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_trip_info_d_unload_list->pageUrl() ?>start=<?php echo $t_trip_info_d_unload_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_trip_info_d_unload_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_trip_info_d_unload_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_trip_info_d_unload_list->pageUrl() ?>start=<?php echo $t_trip_info_d_unload_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_trip_info_d_unload_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_trip_info_d_unload_list->pageUrl() ?>start=<?php echo $t_trip_info_d_unload_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_trip_info_d_unload_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_trip_info_d_unload_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_trip_info_d_unload_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_trip_info_d_unload_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_trip_info_d_unload_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_trip_info_d_unload_list->TotalRecs > 0 && (!$t_trip_info_d_unload_list->AutoHidePageSizeSelector || $t_trip_info_d_unload_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_trip_info_d_unload">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_trip_info_d_unload_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_trip_info_d_unload_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_trip_info_d_unload_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_trip_info_d_unload_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_trip_info_d_unload_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_trip_info_d_unload->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_trip_info_d_unload_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_trip_info_d_unload_list->TotalRecs == 0 && !$t_trip_info_d_unload->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_trip_info_d_unload_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_trip_info_d_unload_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_trip_info_d_unload->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_trip_info_d_unload->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_trip_info_d_unload", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_trip_info_d_unload_list->terminate();
?>