<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_info_d_edit = new t_trip_info_d_edit();

// Run the page
$t_trip_info_d_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_info_d_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var ft_trip_info_dedit = currentForm = new ew.Form("ft_trip_info_dedit", "edit");

// Validate form
ft_trip_info_dedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_trip_info_d_edit->_route->Required) { ?>
			elm = this.getElements("x" + infix + "__route");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info_d->_route->caption(), $t_trip_info_d->_route->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_d_edit->load_km->Required) { ?>
			elm = this.getElements("x" + infix + "_load_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info_d->load_km->caption(), $t_trip_info_d->load_km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_km");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info_d->load_km->errorMessage()) ?>");
		<?php if ($t_trip_info_d_edit->load_weight->Required) { ?>
			elm = this.getElements("x" + infix + "_load_weight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info_d->load_weight->caption(), $t_trip_info_d->load_weight->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_weight");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info_d->load_weight->errorMessage()) ?>");
		<?php if ($t_trip_info_d_edit->driver->Required) { ?>
			elm = this.getElements("x" + infix + "_driver");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info_d->driver->caption(), $t_trip_info_d->driver->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_d_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info_d->operator->caption(), $t_trip_info_d->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_d_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info_d->datetime->caption(), $t_trip_info_d->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_trip_info_dedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_info_dedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_info_dedit.lists["x__route"] = <?php echo $t_trip_info_d_edit->_route->Lookup->toClientList() ?>;
ft_trip_info_dedit.lists["x__route"].options = <?php echo JsonEncode($t_trip_info_d_edit->_route->lookupOptions()) ?>;
ft_trip_info_dedit.lists["x_driver"] = <?php echo $t_trip_info_d_edit->driver->Lookup->toClientList() ?>;
ft_trip_info_dedit.lists["x_driver"].options = <?php echo JsonEncode($t_trip_info_d_edit->driver->lookupOptions()) ?>;
ft_trip_info_dedit.lists["x_operator"] = <?php echo $t_trip_info_d_edit->operator->Lookup->toClientList() ?>;
ft_trip_info_dedit.lists["x_operator"].options = <?php echo JsonEncode($t_trip_info_d_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_trip_info_d_edit->showPageHeader(); ?>
<?php
$t_trip_info_d_edit->showMessage();
?>
<form name="ft_trip_info_dedit" id="ft_trip_info_dedit" class="<?php echo $t_trip_info_d_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_info_d_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_info_d_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_info_d">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$t_trip_info_d_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_trip_info_d->_route->Visible) { // route ?>
	<div id="r__route" class="form-group row">
		<label id="elh_t_trip_info_d__route" for="x__route" class="<?php echo $t_trip_info_d_edit->LeftColumnClass ?>"><?php echo $t_trip_info_d->_route->caption() ?><?php echo ($t_trip_info_d->_route->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_d_edit->RightColumnClass ?>"><div<?php echo $t_trip_info_d->_route->cellAttributes() ?>>
<span id="el_t_trip_info_d__route">
<span<?php echo $t_trip_info_d->_route->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info_d->_route->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info_d" data-field="x__route" name="x__route" id="x__route" value="<?php echo HtmlEncode($t_trip_info_d->_route->CurrentValue) ?>">
<?php echo $t_trip_info_d->_route->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info_d->load_km->Visible) { // load_km ?>
	<div id="r_load_km" class="form-group row">
		<label id="elh_t_trip_info_d_load_km" for="x_load_km" class="<?php echo $t_trip_info_d_edit->LeftColumnClass ?>"><?php echo $t_trip_info_d->load_km->caption() ?><?php echo ($t_trip_info_d->load_km->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_d_edit->RightColumnClass ?>"><div<?php echo $t_trip_info_d->load_km->cellAttributes() ?>>
<span id="el_t_trip_info_d_load_km">
<input type="text" data-table="t_trip_info_d" data-field="x_load_km" name="x_load_km" id="x_load_km" size="30" placeholder="<?php echo HtmlEncode($t_trip_info_d->load_km->getPlaceHolder()) ?>" value="<?php echo $t_trip_info_d->load_km->EditValue ?>"<?php echo $t_trip_info_d->load_km->editAttributes() ?>>
</span>
<?php echo $t_trip_info_d->load_km->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info_d->load_weight->Visible) { // load_weight ?>
	<div id="r_load_weight" class="form-group row">
		<label id="elh_t_trip_info_d_load_weight" for="x_load_weight" class="<?php echo $t_trip_info_d_edit->LeftColumnClass ?>"><?php echo $t_trip_info_d->load_weight->caption() ?><?php echo ($t_trip_info_d->load_weight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_d_edit->RightColumnClass ?>"><div<?php echo $t_trip_info_d->load_weight->cellAttributes() ?>>
<span id="el_t_trip_info_d_load_weight">
<input type="text" data-table="t_trip_info_d" data-field="x_load_weight" name="x_load_weight" id="x_load_weight" size="30" placeholder="<?php echo HtmlEncode($t_trip_info_d->load_weight->getPlaceHolder()) ?>" value="<?php echo $t_trip_info_d->load_weight->EditValue ?>"<?php echo $t_trip_info_d->load_weight->editAttributes() ?>>
</span>
<?php echo $t_trip_info_d->load_weight->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
	<input type="hidden" data-table="t_trip_info_d" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($t_trip_info_d->id->CurrentValue) ?>">
<?php if (!$t_trip_info_d_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_trip_info_d_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_trip_info_d_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_trip_info_d_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_trip_info_d_edit->terminate();
?>