<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_info_d_search = new t_trip_info_d_search();

// Run the page
$t_trip_info_d_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_info_d_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_trip_info_d_search->IsModal) { ?>
var ft_trip_info_dsearch = currentAdvancedSearchForm = new ew.Form("ft_trip_info_dsearch", "search");
<?php } else { ?>
var ft_trip_info_dsearch = currentForm = new ew.Form("ft_trip_info_dsearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_trip_info_dsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_info_dsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_info_dsearch.lists["x__route"] = <?php echo $t_trip_info_d_search->_route->Lookup->toClientList() ?>;
ft_trip_info_dsearch.lists["x__route"].options = <?php echo JsonEncode($t_trip_info_d_search->_route->lookupOptions()) ?>;
ft_trip_info_dsearch.lists["x_driver"] = <?php echo $t_trip_info_d_search->driver->Lookup->toClientList() ?>;
ft_trip_info_dsearch.lists["x_driver"].options = <?php echo JsonEncode($t_trip_info_d_search->driver->lookupOptions()) ?>;
ft_trip_info_dsearch.lists["x_operator"] = <?php echo $t_trip_info_d_search->operator->Lookup->toClientList() ?>;
ft_trip_info_dsearch.lists["x_operator"].options = <?php echo JsonEncode($t_trip_info_d_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

ft_trip_info_dsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info_d->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_load_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info_d->load_km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_load_weight");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info_d->load_weight->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info_d->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_trip_info_d_search->showPageHeader(); ?>
<?php
$t_trip_info_d_search->showMessage();
?>
<form name="ft_trip_info_dsearch" id="ft_trip_info_dsearch" class="<?php echo $t_trip_info_d_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_info_d_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_info_d_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_info_d">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_trip_info_d_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_info_d->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $t_trip_info_d_search->LeftColumnClass ?>"><span id="elh_t_trip_info_d_id"><?php echo $t_trip_info_d->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_d_search->RightColumnClass ?>"><div<?php echo $t_trip_info_d->id->cellAttributes() ?>>
			<span id="el_t_trip_info_d_id">
<input type="text" data-table="t_trip_info_d" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($t_trip_info_d->id->getPlaceHolder()) ?>" value="<?php echo $t_trip_info_d->id->EditValue ?>"<?php echo $t_trip_info_d->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info_d->_route->Visible) { // route ?>
	<div id="r__route" class="form-group row">
		<label for="x__route" class="<?php echo $t_trip_info_d_search->LeftColumnClass ?>"><span id="elh_t_trip_info_d__route"><?php echo $t_trip_info_d->_route->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__route" id="z__route" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_d_search->RightColumnClass ?>"><div<?php echo $t_trip_info_d->_route->cellAttributes() ?>>
			<span id="el_t_trip_info_d__route">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info_d" data-field="x__route" data-value-separator="<?php echo $t_trip_info_d->_route->displayValueSeparatorAttribute() ?>" id="x__route" name="x__route"<?php echo $t_trip_info_d->_route->editAttributes() ?>>
		<?php echo $t_trip_info_d->_route->selectOptionListHtml("x__route") ?>
	</select>
</div>
<?php echo $t_trip_info_d->_route->Lookup->getParamTag("p_x__route") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info_d->load_km->Visible) { // load_km ?>
	<div id="r_load_km" class="form-group row">
		<label for="x_load_km" class="<?php echo $t_trip_info_d_search->LeftColumnClass ?>"><span id="elh_t_trip_info_d_load_km"><?php echo $t_trip_info_d->load_km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_load_km" id="z_load_km" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_d_search->RightColumnClass ?>"><div<?php echo $t_trip_info_d->load_km->cellAttributes() ?>>
			<span id="el_t_trip_info_d_load_km">
<input type="text" data-table="t_trip_info_d" data-field="x_load_km" name="x_load_km" id="x_load_km" size="30" placeholder="<?php echo HtmlEncode($t_trip_info_d->load_km->getPlaceHolder()) ?>" value="<?php echo $t_trip_info_d->load_km->EditValue ?>"<?php echo $t_trip_info_d->load_km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info_d->load_weight->Visible) { // load_weight ?>
	<div id="r_load_weight" class="form-group row">
		<label for="x_load_weight" class="<?php echo $t_trip_info_d_search->LeftColumnClass ?>"><span id="elh_t_trip_info_d_load_weight"><?php echo $t_trip_info_d->load_weight->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_load_weight" id="z_load_weight" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_d_search->RightColumnClass ?>"><div<?php echo $t_trip_info_d->load_weight->cellAttributes() ?>>
			<span id="el_t_trip_info_d_load_weight">
<input type="text" data-table="t_trip_info_d" data-field="x_load_weight" name="x_load_weight" id="x_load_weight" size="30" placeholder="<?php echo HtmlEncode($t_trip_info_d->load_weight->getPlaceHolder()) ?>" value="<?php echo $t_trip_info_d->load_weight->EditValue ?>"<?php echo $t_trip_info_d->load_weight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info_d->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label for="x_driver" class="<?php echo $t_trip_info_d_search->LeftColumnClass ?>"><span id="elh_t_trip_info_d_driver"><?php echo $t_trip_info_d->driver->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_driver" id="z_driver" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_d_search->RightColumnClass ?>"><div<?php echo $t_trip_info_d->driver->cellAttributes() ?>>
			<span id="el_t_trip_info_d_driver">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info_d" data-field="x_driver" data-value-separator="<?php echo $t_trip_info_d->driver->displayValueSeparatorAttribute() ?>" id="x_driver" name="x_driver"<?php echo $t_trip_info_d->driver->editAttributes() ?>>
		<?php echo $t_trip_info_d->driver->selectOptionListHtml("x_driver") ?>
	</select>
</div>
<?php echo $t_trip_info_d->driver->Lookup->getParamTag("p_x_driver") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info_d->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $t_trip_info_d_search->LeftColumnClass ?>"><span id="elh_t_trip_info_d_operator"><?php echo $t_trip_info_d->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_d_search->RightColumnClass ?>"><div<?php echo $t_trip_info_d->operator->cellAttributes() ?>>
			<span id="el_t_trip_info_d_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info_d" data-field="x_operator" data-value-separator="<?php echo $t_trip_info_d->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $t_trip_info_d->operator->editAttributes() ?>>
		<?php echo $t_trip_info_d->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $t_trip_info_d->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info_d->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $t_trip_info_d_search->LeftColumnClass ?>"><span id="elh_t_trip_info_d_datetime"><?php echo $t_trip_info_d->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_d_search->RightColumnClass ?>"><div<?php echo $t_trip_info_d->datetime->cellAttributes() ?>>
			<span id="el_t_trip_info_d_datetime">
<input type="text" data-table="t_trip_info_d" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($t_trip_info_d->datetime->getPlaceHolder()) ?>" value="<?php echo $t_trip_info_d->datetime->EditValue ?>"<?php echo $t_trip_info_d->datetime->editAttributes() ?>>
<?php if (!$t_trip_info_d->datetime->ReadOnly && !$t_trip_info_d->datetime->Disabled && !isset($t_trip_info_d->datetime->EditAttrs["readonly"]) && !isset($t_trip_info_d->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_info_dsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_trip_info_d_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_trip_info_d_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_trip_info_d_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_trip_info_d_search->terminate();
?>